<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<c:set var="reportId" value="0"></c:set>
<c:set var="reportName" value=""></c:set>
<style>
table {
	font-size: 0.88em;
}

.reportTable {
	padding-bottom: 0px;
}
</style>
<c:if test="${not empty param.reportId}">
	<c:set var="reportId" value="${fn:escapeXml(param.reportId)}"></c:set>
</c:if>
<c:if test="${not empty param.noTitleUpdate}">
	<c:set var="noTitleUpdate" value="${param.noTitleUpdate}"></c:set>
</c:if>
<c:if test="${not empty param.reportName}">
	<c:set var="reportName" value="${fn:escapeXml(param.reportName)}"></c:set>
</c:if>
<c:if test="${not empty param.name}">
	<c:set var="reportName" value="${fn:escapeXml(param.name)}"></c:set>
</c:if>

<div id="reportArea">
	<div id="ng-app" data-ng-app="reports"
		data-ng-controller="reportsCtrl"
		data-ng-init="init('${reportId}', '${reportName}',false,{noTitleUpdate:'${noTitleUpdate}'})">
		<div id="pageDiv" data-ng-controller="pageController"
			class="maskLayer" data-ng-class="{'isMasked':masked}">
			<div class="report-title-view-container">
				<h1 class="page-title" data-ng-bind="customReport.report.customReportName" cv-show-title-tooltip="true" cv-report-customization cv-expression="{{customReport.report.customReportName}}" cv-localize="true"></h1>
				<span class="report-view-list" data-ng-include="'${pageContext.request.contextPath}/reportsplus/views/views.jsp'"></span>
			</div>
			<div id="crdescription" class="crdescription"></div>
			<div class="clear-float"></div>
			<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
		</div>
	</div>
</div>
