<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<ul class="secondary-header secondary-background-color">
		<li class="sub-header" title="General"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}"
			data-ng-click="selectedPropertyCategory='general'"><span
			class="ico ico-cog"></span></li>
		<li class="sub-header" title="Fields"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}"
			data-ng-click="selectedPropertyCategory='fields'"><span
			class="ico ico-form-field"></span></li>
		<li class="sub-header" title="Custom Code"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}"
			data-ng-click="selectedPropertyCategory='customcode'"><span
			class="ico ico-code"></span></li>
		<li class="sub-header" title="Filters"
			data-ng-show="ds && ds.endpoint === 'DATACUBE'"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}"
			data-ng-click="selectedPropertyCategory='filters'"><span
			class="ico ico-funnel"></span></li>
	</ul>
	<div
		data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>
	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message
							key="CustomReport.Properties.Title" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key='CustomReport.Properties.TableName'/>"
							data-ng-model="propData.title.text">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.ID"/>'
						cv-label-title><fmt:message
							key="CustomReport.Properties.ID" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input name="chartid" class="form-control input-sm" type="text"
							data-ng-model="propData.id"
							data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
							data-ng-blur="validateComponentId()"
							data-ng-class="{'pattern-invalid': !propData.id}">
					</div>
					<span
						class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide"
						data-ng-show="!propData.id">*ID should contain
						characters,digits and underscore only.</span>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message
							key="CustomReport.Properties.DataSet" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
							readonly="true" data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='Input Type'>Input Type</label>
					<!-- TODO: Localize -->
					<div class="col-sm-8 noLftRghtPadding">
						<select class="form-control input-sm"
							data-ng-model="propData.inputType">
							<option value="latitudelongitude">Latitude/Longitude</option>
							<!-- TODO: Localize -->
							<option value="code">Country Code</option>
							<!-- TODO: Localize -->
						</select>
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title="Map Type">Map Type</label>
					<!-- TODO: Localize -->
					<div class="col-sm-8 noLftRghtPadding">
						<select class="form-control input-sm"
							data-ng-model="propData.subType">
							<option value="mappoint"
								data-ng-show="propData.inputType==='latitudelongitude'">Symbol
								Map</option>
							<!-- TODO: Localize -->
							<option value="mapbubble">Bubble Map</option>
							<option value="heatmap"
								data-ng-show="propData.inputType==='code'">Heat Map</option>
						</select>
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.DisableInteractivity"/>'><fmt:message
							key="CustomReport.Properties.DisableInteractivity" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.disableInteractivity"
							id="disableInteractivity">
					</div>
				</div>
			</div>
		</div>

		<div data-ng-if="propData.subType==='mapbubble' && propData.inputType === 'code'" class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.labels.show"/>'><fmt:message
							key="CustomReport.Properties.labels.show" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.ShowLabels"
							id="showLabels">
					</div>
				</div>
			</div>
		</div>
		<!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                      data-ng-model="propData.mobile.visible">
                      <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                      <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	</div>
	<div data-ng-show="selectedPropertyCategory==='fields'">
		<!-- Begin "X-Axis" group -->
		<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-click="collapsed['dimension']=!collapsed['dimension']"
			data-ng-init="collapsed['dimension']=false">
			<div class="col-xs-12 noLftRghtPadding">
				<span
					data-ng-class="{'ico ico-chevron-down':!collapsed['dimension'], 'ico ico-chevron-right':collapsed['dimension']}"></span>
				<span>Dimension</span>
			</div>
		</div>
		<div data-ng-class="{'collapsed' : collapsed['dimension']}">
			<div data-ng-if="propData.inputType === 'code' && propData.code">
				<div
					class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
					<div class="fieldHeader"
						data-ng-click="collapsed['dimension_code']=!collapsed['dimension_code']"
						data-ng-init="collapsed['dimension_code']=true">
						<label class="col-lg-9 noLftRghtPadding"> <span>Country
								Code ({{propData.code.name}})</span> <!-- TODO: localize -->
						</label> <span class="pull-right"> <span
							class="ico inner-panel-expand-icon"
							data-ng-class="{'ico ico-chevron-down':!collapsed['dimension_code'], 'ico ico-chevron-right':collapsed['dimension_code']}"></span>
						</span>
					</div>
					<div data-ng-class="{'collapsed' : collapsed['dimension_code']}">
						<div id="pointsToPlot">
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
											key="CustomReport.Properties.MaxPoints" /> </label>
									<div class="col-sm-8 noLftRghtPadding">
										<input id="maxPointTextbox"
											class="fieldPropValue form-control"
											data-ng-model="propData.code.numPointsToDisplay.maxPoints"
											data-ng-readonly="propData.code.numPointsToDisplay.includeAll"
											data-ng-change="redrawComponent(propData.id)" type="text">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
											key="CustomReport.Properties.All" /> <!-- TODO: Localize --></label>
									<div class="col-sm-3 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="propData.code.numPointsToDisplay.includeAll"
											id="includeall_code"
											data-ng-change="redrawComponent(propData.id)">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-if="propData.inputType === 'code' && propData.drilldown">
				<div
					class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
					<div class="fieldHeader"
						data-ng-click="collapsed['dimension_drill']=!collapsed['dimension_drill']"
						data-ng-init="collapsed['dimension_drill']=true">
						<label class="col-lg-9 noLftRghtPadding"> <span>
								State Code ({{propData.drilldown.name}})</span> <!-- TODO: localize -->
						</label> <span class="pull-right"> <span
							class="ico inner-panel-expand-icon"
							data-ng-class="{'ico ico-chevron-down':!collapsed['dimension_drill'], 'ico ico-chevron-right':collapsed['dimension_drill']}"></span>
						</span>
					</div>
					<div data-ng-class="{'collapsed' : collapsed['dimension_drill']}">
						<div id="pointsToPlot">
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
											key="CustomReport.Properties.MaxPoints" /> </label>
									<div class="col-sm-8 noLftRghtPadding">
										<input id="maxPointTextbox"
											class="fieldPropValue form-control"
											data-ng-model="propData.drilldown.numPointsToDisplay.maxPoints"
											data-ng-readonly="propData.drilldown.numPointsToDisplay.includeAll"
											data-ng-change="redrawComponent(propData.id)" type="text">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
											key="CustomReport.Properties.All" /> <!-- TODO: Localize --></label>
									<div class="col-sm-3 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="propData.drilldown.numPointsToDisplay.includeAll"
											id="includeall_drilldown"
											data-ng-change="redrawComponent(propData.id)">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div
				data-ng-if="propData.inputType === 'latitudelongitude' && propData.latitude && propData.longitude">
				<div
					class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
					<div class="fieldHeader"
						data-ng-click="collapsed['dimension_latlon']=!collapsed['dimension_latlon']"
						data-ng-init="collapsed['dimension_latlon']=true">
						<label class="col-lg-9 noLftRghtPadding"> <span>Latitude/Longitude</span>
							<!-- TODO: localize -->
						</label> <span class="pull-right"> <span
							class="ico inner-panel-expand-icon"
							data-ng-class="{'ico ico-chevron-down':!collapsed['dimension_latlon'], 'ico ico-chevron-right':collapsed['dimension_latlon']}"></span>
						</span>
					</div>
					<div data-ng-class="{'collapsed' : collapsed['dimension_latlon']}">
						<div id="pointsToPlot">
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
											key="CustomReport.Properties.MaxPoints" /> <!-- TODO: Localize --></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input id="maxPointTextbox"
											class="fieldPropValue form-control"
											data-ng-model="propData.latitude.numPointsToDisplay.maxPoints"
											data-ng-readonly="propData.latitude.numPointsToDisplay.includeAll"
											data-ng-change="redrawComponent(propData.id)" type="text">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
											key="CustomReport.Properties.All" /> <!-- TODO: Localize --></label>
									<div class="col-sm-3 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="propData.latitude.numPointsToDisplay.includeAll"
											id="includeall_latlon"
											data-ng-change="redrawComponent(propData.id)">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div data-ng-if="propData.inputType === 'code' && propData.pieColumn">
				<div
					class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
					<div class="fieldHeader"
						data-ng-click="collapsed['dimension_pie']=!collapsed['dimension_pie']"
						data-ng-init="collapsed['dimension_pie']=true">
						<label class="col-lg-9 noLftRghtPadding"> <span>
								Drilldown Column ({{propData.pieColumn.name}})</span> <!-- TODO: localize -->
						</label> <span class="pull-right"> <span
							class="ico inner-panel-expand-icon"
							data-ng-class="{'ico ico-chevron-down':!collapsed['dimension_pie'], 'ico ico-chevron-right':collapsed['dimension_pie']}"></span>
						</span>
					</div>
					<div data-ng-class="{'collapsed' : collapsed['dimension_pie']}">
						<div id="pointsToPlot">
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
											key="CustomReport.Properties.MaxPoints" /> </label>
									<div class="col-sm-8 noLftRghtPadding">
										<input id="maxPointTextbox"
											class="fieldPropValue form-control"
											data-ng-model="propData.pieColumn.numPointsToDisplay.maxPoints"
											data-ng-readonly="propData.pieColumn.numPointsToDisplay.includeAll"
											data-ng-change="redrawComponent(propData.id)" type="text">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
											key="CustomReport.Properties.All" /> <!-- TODO: Localize --></label>
									<div class="col-sm-3 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="propData.pieColumn.numPointsToDisplay.includeAll"
											id="includeall_pie"
											data-ng-change="redrawComponent(propData.id)">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin">
								<div class="col-xs-12 noLftRghtPadding">
									<div class="form-group">
										<label
											class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
											title='Custom Groups'> Custom Groups </label>
										<div class="col-sm-5 noLftRghtPadding">
											<div class="pull-left">
												<div class="on-off-switch" style="margin-top: 3px;">
													<input type="checkbox" name="on-off-switch"
														data-ng-model="propData.pieColumn.customGroupsAvailable"
														class="on-off-switch-checkbox" id="customgroup_pieColumn"
														data-ng-click="updateCustomGroupsAvailable(propData.pieColumn)">
													<label class="on-off-switch-label"
														for="customgroup_pieColumn"> <span
														class="on-off-switch-inner"></span> <span
														class="on-off-switch-switch"></span>
													</label>
												</div>
											</div>
											<span
												class="ico ico-pencil pro-btn-algn cursor-pointer pull-right"
												data-ng-click="showAdditionalProperties(propData.pieColumn)"
												data-ng-show="propData.pieColumn.customGroupsAvailable"></span>
										</div>
									</div>
								</div>
							</div>
							<!-- Begin "Series" group -->
							<div class="row noLftRghtMargin"
								data-ng-click="collapsed['series']=!collapsed['series']">
								<div class="col-xs-12 noLftRghtPadding">
									<span
										data-ng-class="{'ico ico-chevron-down':!collapsed['series'], 'ico ico-chevron-right':collapsed['series']}"></span>
									<span><fmt:message
											key="CustomReport.Properties.CustomColors" /></span> <span
										class="pull-right ico ico-plus-circle"
										title="<fmt:message key='CustomReport.Properties.CustomizeSeriesColors'/>"
										data-ng-click="collapsed['series']=false;addCustomSeriesColor($event)"></span>
								</div>
							</div>
							<div data-ng-class="{'collapsed': collapsed['series']}">
								<div class="row noLftRghtMargin seriesLabelRow noLftRghtMargins"
									data-ng-repeat="series in propData.seriesFormatting">
									<div class="form-group">
										<div class="col-sm-9" style="padding-right: 0px">
											<div class="seriesNameDiv">
												<input class="seriesTextField" type="text"
													data-ng-model=series.value> <select
													class="form-control input-sm seriesSelect"
													data-ng-model="series.value">
													<option
														data-ng-repeat="currSeries in propData.currDataSeries"
														data-ng-show="!currSeries.selected"
														data-ng-model="currSeries.value">{{currSeries.value}}</option>
												</select>

											</div>
										</div>
										<div class="col-sm-2 noLftRghtPadding">
											<input class="seriesColor form-control input-sm" type="color"
												data-ng-model="series.color">
										</div>
										<div class="col-sm-1 noLftRghtPadding">
											<span class="ico ico-trash2 pro-dlt-btn"
												data-ng-click="deleteSeries($index)"></span>
										</div>
									</div>

								</div>

							</div>

						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Begin "Custom Code" group -->
	<div data-ng-show="selectedPropertyCategory==='customcode'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<!-- FIXME: Localize -->
				<label> <fmt:message
						key="CustomReport.Properties.TitleExpression" /><br>
				</label> 
				<div class="pull-right">
	                <button class="btn btn-primary btn-xs" data-ng-click="openAceEditor(propData.titleExpression,'javascript',undefined,'propData.titleExpression')">
	                  <span class="glyphicon glyphicon-new-window"></span> <fmt:message key="CustomReport.properties.AddExpression"/>
	                </button>                
	            </div>   
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<label class="col-xs-12 noLftRghtPadding"> <fmt:message
						key="CustomReport.Properties.ToolTip" /><br>
				</label> <span class="col-xs-12 noLftRghtPadding"> <textarea
						data-ng-model="propData.tooltipFormatter"></textarea>
				</span>
			</div>
		</div>


	</div>

	<!-- End "Custom Code"  group -->


	<!-- Begin "Filters" group -->
	<div
		data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">
		<cvfacet config="propData" type="'properties'" page="page"
			filters="propData.filters" filter-mode="'builder'"
			report-mode="reportMode"></cvfacet>
	</div>



</fmt:bundle>