<!-- Note:
	The table header elements here are given an initial width of 30px. This is
	overwritten when the resize directive takes effect, but initially it
	provides stability in default column widths.
-->
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
<tr data-ng-if="!component.showAsSearchResults && reportMode == 'viewer' || reportMode == 'preview'">
	<th data-ng-if="component.enableButtonPanel && component.enableRowSelection" class="columnSelector">
		<input data-ng-model="allRows.selected" id="{{component.id}}_allRows" type="checkbox" data-ng-show="component.enableMultiRowSelection" data-ng-change="allRowsChanged()"><label for="{{component.id}}_allRows" class="checkbox-label">&nbsp;</label>     		
	</th>
	<th ng-repeat="column in component.columns" cv-col-draggable drag="handleDrag" dragdata="{{$index}}" dragImage="{{dragImageId}}"  cv-col-droppable drop="handleDrop" ng-hide="column.hidden || !column.visible" class="sortable {{column.direction}}" data-ng-style="{width:column.width}"
	>
	<div resize-column class="resize-handle"></div>
	<div cv-report-customization cv-show-title-tooltip="true" cv-expression="{{column.displayName}}" cv-localize="true" ng-class="{ 'ac-column-title': appName == 'adminconsole','column-title': appName !== 'adminconsole'}" ng-click="sort(column,$index)"></div>
	<span ng-class="{ 'ui-grid-icon-up-dir': column.direction == 'sorting_asc', 'ui-grid-icon-down-dir': column.direction == 'sorting_desc', 'ui-grid-icon-blank': !column.direction }">&nbsp;</span>
	<div class="ui-grid-menu-button" 
	data-ng-if="(appName == 'adminconsole') && lastVisibleColumnId === column.id">
	<div class="ui-grid-icon-container" ng-click="toggleMenu($event)">
		<i class="ui-grid-icon-menu">&nbsp;</i>
	</div>
	<div class="menu-top-div">
		<!-- ngIf: shown -->
		<div class="ui-grid-menu display-none" id="ac-table-menu-{{component.id}}" >
			<div class="ui-grid-menu-inner">
				<ul class="ui-grid-menu-items">
						<li class="ui-grid-menu-item" data-ng-if="!component.hideFilterOption || component.hideFilterOption != true" data-ng-click="toggleFilters($event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="Filters"/></li>
						<li class="ui-grid-menu-item" data-ng-click="exportToCSV($event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="CustomReport.ExportToCsv"/></li>
						<li class="ui-grid-menu-item" data-ng-click="openAlarmsDialog($event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="CustomReport.TableMenu.ConfigureAnAlert" /></li>
						<li class="ui-grid-menu-item" data-ng-click="showQuickAnalysis($event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="CustomReport.TableMenu.ShowQuickAnalysis"/></li>
						<li class="ui-grid-menu-item compButtons" data-ng-click="makeComponentFullScreen($event)"><i ng-class="icon"></i><span data-ng-if="!isFullScreen"><fmt:message key='CustomReport.Fullscreen'/></span><span data-ng-if="isFullScreen"><fmt:message key='CustomReport.ExitFullscreen'/></span></span></li>
						<%-- <li class="ui-grid-menu-item" data-ng-if="!component.hideViews && selectedView && selectedView.id" data-ng-click="setDefaultView(selectedView,$event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="CustomReport.Views.SetAsDefault"/></li> --%>
						<%-- <li class="ui-grid-menu-item" data-ng-if="!component.hideViews && page.userFilters.length > 0 && isUserFilter(selectedView)" data-ng-click="createTableView('Edit',selectedView.index,$event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="CustomReport.Views.EditView"/></li> --%>
						<%-- <li class="ui-grid-menu-item" data-ng-if="!component.hideViews"  data-ng-click="createTableView('Create',0,$event); toggleMenu($event)"><i ng-class="icon"></i><fmt:message key="CustomReport.Views.CreateView"/></li> --%>
						<%-- <li class="ui-grid-menu-item" data-ng-if="!component.hideViews && page.userFilters.length > 0 && isUserFilter(selectedView)" data-ng-click="confirmDelete(selectedView,$event)"></i><fmt:message key="CustomReport.Views.DeleteView"/></li> --%>						
						<li class="ui-grid-menu-item"><i ng-class="icon"></i> <fmt:message key="CustomReport.Properties.Columns"/>:</li>						
						<li class="ui-grid-menu-item" data-ng-repeat="column in component.columns" data-ng-if="!column.hidden" data-ng-click="toggleColVisibility(column,$event)"><i data-ng-class="{'ui-grid-icon-ok': column.visible,'ui-grid-icon-cancel': !column.visible}"></i><span data-ng-bind="column.displayName"></span></li>
				</ul>
			</div>
		</div>
		<!-- end ngIf: shown -->
	</div>
</div>
</th>


</tr>

<tr data-ng-if="!component.showAsSearchResults && reportMode == 'builder'">
	<th data-ng-if="component.enableButtonPanel && component.enableRowSelection" class="columnSelector">
		<input data-ng-model="allRows.selected" id="{{component.id}}_allRows" type="checkbox" data-ng-show="component.enableMultiRowSelection" data-ng-change="allRowsChanged()"><label for="{{component.id}}_allRows" class="checkbox-label">&nbsp;</label>     		
	</th>
	<th ng-repeat="column in component.columns" ng-hide="column.hidden || !column.visible" data-ng-style="{width:column.width}" cv-col-draggable drag="handleDrag" dragdata="{{$index}}" dragImage="{{dragImageId}}" cv-col-droppable drop="handleDrop"
		ng-click="toggleColumnSelection(column,$index,$event)">
		<div resize-column class="resize-handle"></div>
		<span cv-report-customization cv-show-title-tooltip="true" cv-expression="{{column.displayName}}"  cv-localize="true"></span>
	</th>
	<div class="ui-grid-menu-button" ng-click="toggleMenu()" ui-grid-menu-button="" data-ng-if="appName == 'adminconsole'" >
		<div class="ui-grid-icon-container">
			<i class="ui-grid-icon-menu">&nbsp;</i>
		</div>
		<div ui-grid-menu="" menu-items="menuItems" class="ng-isolate-scope">
	<!-- ngIf: shown -->
			<div class="ui-grid-menu ng-scope" ng-if="shown">
				<div class="ui-grid-menu-mid" ng-show="shownMid">
					<div class="ui-grid-menu-inner">
					</div>
				</div>
			</div>
	<!-- end ngIf: shown -->
		</div>
	</div>
</tr>

<tr id="filterRow_previewTable" ng-if="!component.showAsSearchResults && component.showFilterByDefault">
	<td data-ng-if="component.enableButtonPanel && component.enableRowSelection" class="columnSelector">			
	</td>
	<td ng-repeat="column in filterColumns" ng-hide="column.hidden || !column.visible" class="filter">			
		<input type="text" name="{{name}}" ng-disabled="$filterRow.disabled" ng-model="column.value" ng-enter="filter(column.id,column.value)" class="inLineFilter" data-ng-if="!exportType"/>
		<input type="text" name="{{name}}" ng-disabled="$filterRow.disabled" ng-model="column.value" ng-enter="filter(column.id,column.value)" ng-value="column.value" class="inLineFilter" data-ng-if="exportType"/>
	</td>
</tr>
</fmt:bundle>