// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app
    .directive("chartWrapper",
    function() {
        return {
            restrict : 'E',
            templateUrl : customReports.contextPath + '/reportsplus/ngtable/chartWrapper.jsp',
            scope : {
                columns : '=',
                columnData : '=',
                height : '=',
                parent : '=',
                filters : '=',
                quickChart : '=',
            },
            controller : [
                "$scope",
                "reportService",
                "customReportSvc",
                "$uibModal",
                function($scope, reportService, customReportSvc,$uibModal) {
                    var maxHeight = 649;
                    $scope.initialized = false;
                    $scope.showSecondDimension = false;
                    $scope.chartTypes = [
                        {type: "HorizontalBar", label: "Horizontal Bar"},
                        {type: "VerticalBar", label: "Vertical Bar"},
                        {type: "Line", label: "Line Chart"},
                        {type: "Pie", label: "Pie Chart"},
                        {type: "Donut", label: "Donut"},
                        {type: "TimeSeries", label: "Timeline Chart"}
                    ]
                    $scope.config = {
                        type: {type: "Pie", label: "Pie Chart"},
                        dimension: null,
                        dimension2: null,
                        measure: null,
                        aggrType: 'Count',
                        hasLegend: true,
                    };

                    $scope.reportMode = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.reportMode || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.reportMode;
                    $scope.reportMode = $scope.reportMode === 'builder' ? 'quick' : 'viewer';
                    $scope.page = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.page || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.page;
                    $scope.cacheId = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.cacheId || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.cacheId;
                    $scope.getDSId = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.getDSId || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.getDSId;
                    $scope.viewParams = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.viewParams || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.viewParams;
                    $scope.isPost = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.isPost || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.isPost;
                    $scope.customReport = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.customReport || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.customReport;
                    $scope.dataSet = $scope.$parent.$parent.dataSet;

                    $scope.columns = $scope.columns.filter(column => !column.hidden);

                    $scope.updateHeight = function(height) {
                        if (height > maxHeight) {
                            height = maxHeight;
                        }
                        return height - ($scope.config.type.type === 'Pie' || $scope.config.type.type === 'Donut' ? 240 : 120);
                    }

                    $scope.component = {
                        "isQuickAnalysis": true,
                        "quickChartHeight": $scope.updateHeight($scope.height),
                        "type": "CHART",
                        "dataSet": $scope.dataSet.dataSet,
                        "title": {
                            "text": ""
                        },
                        "parentId" : $scope.parent,
                        "id": $scope.parent + "quickChart",
                        "chartType": $scope.config.type,
                        "isDateTime": false,
                        "xAxisTitle": {
                            "text": ""
                        },
                        "yAxisTitle": {
                            "text": ""
                        },
                        "barWidthAutoOnly": false,
                        "dataSeries": [],
                        "isGrouped": false,
                        "styles": {
                            "defaultChartHeight": 200,
                            "defaultChartWidth": 600,
                            "height": 200,
                            "width": 600,
                            "barColor": "#00cee6",
                            "chartPlotOptions": {
                                "isShowGridlines": true,
                                "isSmoothLines": false,
                                "isShowLineMarkers": true,
                                "autoConvertYValues": true,
                                "isShowLabels": false,
                                "legendPosition": "right",
                                "isShowLegend": true
                            },
                            "barSizeAutoOnly": false
                        },
                        "sorting": [
                            {
                                "direction": "Desc",
                                "sortAxis": "YAxis"
                            }
                        ],
                        "seriesFormatting": [],
                        "mobile": {
                            "visible": "On",
                            "listItemClick": {},
                            "customListLayout": null
                        },
                        "filters": $scope.filters,
                        "orientation": "vertical",
                        "showSearchBar": true,
                        "dimensionDataField": [
                            {
                                "column": '',
                                "title": {
                                    "text": ''
                                },
                                "sortOrder": "NONE",
                                "isNumeric": false,
                                "customGroupsAvailable": false,
                                "numPointsToDisplay": {
                                    "maxPoints": 10,
                                    "includeAll": false
                                },
                                "showMinCount": false,
                            }
                        ],
                        "measureDataField": [
                            {
                                "column": '',
                                "title": {
                                    "text": ''
                                },
                                "aggrType": 'Count',
                                "sortOrder": "DESC",
                                "showNumberOps": true,
                            }
                        ],
                        "multiBars": false,
                        "isGroupBy": true,
                        "showOthers": true,
                        "isComponentLoading": true,
                        "currDataSeries": [],
                        "isChartExist": true
                    }

                    $scope.updateQuickChart = function() {
                    	updateDimensionColumn($scope.config.type.type);
                        if (!$scope.config.type || !$scope.config.dimension || !$scope.config.measure) {
                            $scope.initialized = false;
                        } else {
                            $scope.initialized = true;
                        }

                        $scope.component.isComponentLoading = true;
                    }

                    //translate column display names to be shown in the drop down
            		$scope.columns.map((column)=>{
            			column.displayName = rpt.evalExpression({expression:customReportSvc.checkExpressionToLocalize(column.displayName)});
            		});


                    var updateDimensionColumn = function(chartType){
                    	if(chartType === 'TimeSeries'){
                    		// set the disabled property to false
                    		for(var i = 0; i < $scope.columns.length ; i++){
                    			if($scope.columns[i].type === 'TimeStamp'){
                    				$scope.config.dimension = $scope.columns[i];
                    				break;
                    			}
                    		}
                    	}

                    	if (!$scope.config.measure) {
                            // set the first possibel type to the measure
                    		var aggrType = $scope.config.aggrType;
                    		var column  = $scope.columns[0];
                    		if(['Count','CountDistinct'].indexOf(aggrType) === -1){
	                    		for(var i = 0; i < $scope.columns.length ; i++){
	                    			column = $scope.columns[i];
	                    			if(column.type !== 'String' && column.type !== 'TimeStamp'){
	                    				break;
	                    			}
	                    		}
                    		}
                    		$scope.config.measure = column;
                        }
                    }

                    if ($scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.requestParms) {
                        $scope.$watch('$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.requestParms', function(val) {
                            $scope.updateParams();
                        }, true)
                    } else {
                        $scope.$watch('$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.requestParms', function(val) {
                            $scope.updateParams();
                        }, true)
                    }

                    $scope.updateParams = function() {
                        $scope.initialized = false;
                        var oldParams = $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.requestParms || $scope.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.$parent.requestParms;
                        var newParams = {};
                        for (var key in oldParams) {
                            if (key && key.indexOf('filter') > -1) {
                                var splitted = key.split('.');
                                var newKey = $scope.parent + 'quickChart.' + splitted[1] + '.' + splitted[2];
                                newParams[newKey] = oldParams[key];
                            } else {
                                newParams[key] = oldParams[key];
                            }
                        }

                        $scope.requestParms = newParams;
                        setTimeout(function () {
                            $scope.updateQuickChart();
                        }, 1);
                    };

                    $scope.$watch('component', function(val) {
                        $scope.quickChart = val;
                    })

                    $scope.$watch('height', function(val) {
                        $scope.component.quickChartHeight = $scope.updateHeight(val);
                    })

                    $scope.$watch('config.type', function(val) {
                        $scope.showSecondDimension = val.type === 'VerticalBar' || val.type === 'HorizontalBar';
                        $scope.component.chartType = val.type;
                        $scope.component.styles.chartPlotOptions.isShowLegend = val.type === 'Pie' || val.type === 'Donut';
                        $scope.component.isDateTime = val.type === 'TimeSeries';
                        $scope.component.isTimeGrouping = val.type === 'TimeSeries';
                        $scope.component.sorting.pop();
                        $scope.component.sorting.push({
                            "direction": val.type === 'TimeSeries' ? 'Asc' : 'Desc',
                            "sortAxis": val.type === 'TimeSeries' ? 'XAxis' : 'YAxis',
                        })
                        if(val.type === 'TimeSeries' || val.type === 'Line'){
                        	$scope.component.styles.chartPlotOptions.isSmoothLines = true;
                        }

                        if(val.type === 'Pie' || val.type === 'Donut'){
                        	let measure = $scope.columns.find( column => column.dataField === $scope.component.measureDataField[0].column);
                        	if(measure){
                        		$scope.configMeasureForCounts(measure);
                        	}
                        }

                        if ($scope.component.dimensionDataField.length > 1) {
                            $scope.config.dimension2 = null;
                            $scope.component.dimensionDataField.pop();
                        }
                        $scope.component.yAxisTitle.text = $scope.getYAxisName();
                        $scope.component.xAxisTitle.text = $scope.config.dimension.displayName;
                        $scope.component.quickChartHeight = $scope.updateHeight($scope.height);
                    })

                    $scope.measureFilter = function(column){
                    	var aggrType = $scope.config.aggrType;
                    	if(['Count','CountDistinct'].indexOf(aggrType) === -1 && (column.type === 'String' || column.type === 'TimeStamp')){
                    			return false;
                    	}else{
                    		return true;
                    	}

                    }

                    $scope.dimensionFilter = function(val, index, arr) {
                        if ($scope.config.type.type !== 'TimeSeries') {
                            return true;
                        } else {
                            return val.type === 'TimeStamp';
                        }
                    }

                    $scope.dimension2Filter = function(val, index, arr) {
                        if (!$scope.config.dimension) {
                            return true;
                        } else {
                            return val.dataField !== $scope.config.dimension.dataField;
                        }
                    }

                    $scope.changeDimension = function(val,index) {
                    	index = index || 0;
                        $scope.component.dimensionDataField.splice(1,index);
                        var pushItem = {
                            "column": val.dataField,
                            "title": {
                                "text": val.displayName
                            },
                            "sortOrder": "NONE",
                            "isNumeric": false,
                            "customGroupsAvailable": false,
                            "numPointsToDisplay": {
                                "maxPoints": 10,
                                "includeAll": false
                            },
                            "showMinCount": false,
                            "formatter": val.cellExpression
                        }
                        if (val.type === 'TimeStamp') {
                            pushItem.timeGrouping = 'auto';
                        }

                        if($scope.config.type.type !== 'TimeSeries'){
                        	$scope.component.isTimeGrouping =  false; // sometime this property is not reset causing the chart to fail.
                        }

                        $scope.component.xAxisTitle.text = val.displayName;
                        $scope.component.dimensionDataField[index] = pushItem;
                    }

                    $scope.$watch('config.dimension', function(val) {
                        if (!val) return;
                        if (!$scope.config.measure) {
                            $scope.config.measure = val;
                            $scope.updateQuickChart();
                        }
                        if ($scope.config.dimension2) {
                            $scope.config.dimension2 = null;
                            $scope.component.dimensionDataField.pop();
                            $scope.component.styles.chartPlotOptions.isShowLegend = false;
                        }
                        $scope.changeDimension(val,0);
                    })

                    $scope.$watch('config.dimension2', function(val) {
                        if (!val) {
                            if ($scope.component.dimensionDataField.length > 1) {
                                $scope.component.dimensionDataField.pop();
                                $scope.component.styles.chartPlotOptions.isShowLegend = false;
                            }
                            return;
                        }
                        $scope.changeDimension(val,1);
                        $scope.component.styles.chartPlotOptions.isShowLegend = true;
                    })

                    $scope.showFirstDimension = function(){
                    	if(['Pie','Donut'].indexOf($scope.config.type.type) !== -1 && ['Count','CountDistinct'].indexOf($scope.config.aggrType) !== -1){
                    		return false;
                    	}else {
                    		return true;
                    	}
                    }

                    $scope.isTwoDimensionChart = function(){
                    	return ['Pie','Donut'].indexOf($scope.config.type.type) === -1;
                    }

                    $scope.getMeasureItem = function() {
                        var item = {
                            "column": $scope.config.measure.dataField,
                            "title": {
                                "text": $scope.config.measure.displayName
                            },
                            "aggrType": $scope.config.aggrType,
                            "sortOrder": "DESC",
                            "showNumberOps": true,
                        }
                        if ($scope.config.aggrType !== 'Count') {
                            item['formatter'] = $scope.config.measure.cellExpression;
                        }
                        return item;
                    }

                    $scope.configMeasureForCounts = function(val){
                    	if(($scope.config.type.type === 'Pie' || $scope.config.type.type === 'Donut') && ($scope.config.aggrType === 'Count' || $scope.config.aggrType === 'CountDistinct')){
                        	$scope.component.dimensionDataField = []; // reset dimension data fields.
                        	$scope.changeDimension(val,0);
                        }
                    }

                    $scope.$watch('config.measure', function(val) {
                        if (!val) return;
//                        if (!!val) {
//                            $scope.showNumberOps = _.indexOf(['Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal'], val.type) > -1;
//                            if ($scope.showNumberOps) {
//                                if (_.indexOf(['Sum', 'Avg', 'Min', 'Max'], $scope.config.aggrType) > -1) {
//                                    $scope.config.aggrType = 'Count';
//                                }
//                            }
//                        }
                        $scope.configMeasureForCounts(val);

                        $scope.component.measureDataField.pop();
                        $scope.component.measureDataField.push($scope.getMeasureItem());
                        $scope.component.yAxisTitle.text = $scope.getYAxisName();

                    })

                    customReportSvc.registerCallback("updateChartFields", function(data) {
                    	if(data.id === $scope.component.id){
                    		var column = $scope.columns.find( column => column.id == data.field);
                    		$scope.config.dimension = column;
                    		$scope.config.measure = column;
                    		$scope.updateQuickChart();
                    		$scope.$parent.showQuickAnalysis();
                    	}
                    });

                    $scope.getYAxisName = function() {
                        return $scope.config.aggrType + " of " + $scope.config.measure.displayName;
                    }

                    $scope.$watch('config.aggrType', function(val) {
                        if (!$scope.config.measure || !val) return;
                        $scope.component.measureDataField.pop();
                        $scope.component.measureDataField.push($scope.getMeasureItem())
                        $scope.component.yAxisTitle.text = $scope.getYAxisName();
                    })

                    //
                    var defaultField = $scope.$parent.component.columns[2];
                    if($scope.columnData){
                    	var column = $scope.columns.find( column => column.id == $scope.columnData.field);
                    	if(column){
                    		defaultField = column;
                    	}
                    }
                    $scope.config.dimension = defaultField;
                    $scope.config.measure = defaultField;

                }]

            };
        });

    })();