<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div id="fieldSettingModal" class="modalStyle">
		<div class="modal-header">
            <h3 class="modal-title" id="modal-title"><fmt:message key='CustomReport.FieldSetting.Title'/></h3>
        </div>
        <div class="modal-body" id="modal-body">
           <div class="form-horizontal">
				<div class="form-group">
					<label for="fieldName" class="col-sm-4 control-label"><fmt:message key='CustomReport.FieldSetting.FieldName'/></label>
					<div class="col-sm-8">
						<input type="text" id="fieldName"  data-ng-value="field.column" class="form-control" disabled="">												
					</div>
				</div>
				<div class="form-group">
					<label class="col-sm-4 control-label"><fmt:message key='CustomReport.FieldSetting.SingleValueSelection'/></label>
					<div class="col-sm-8 material-switch">
					   <input id="multiSelect" type="checkbox" class="hidden" data-ng-model="field.showRadioButtons"/> 
		                <label for="multiSelect"></label>
	            	
					</div>
				</div>				

				<div class="form-group">
					<label for="sortValuesBy" class="col-sm-4 control-label"><fmt:message key='CustomReport.FieldSetting.SortValuesBy'/></label>
					<div class="col-sm-8">
						<label class="radio-inline" data-ng-disabled="field.customGroupsAvailable"> <input type="radio" value="Count_{{field.column}}" data-ng-model="field.sort.sortField" data-ng-disabled="field.customGroupsAvailable"><fmt:message key='CustomReport.Count'/>
						</label> 
						<label class="radio-inline" data-ng-disabled="field.customGroupsAvailable"> <input type="radio" value="index" data-ng-model="field.sort.sortField" data-ng-disabled="field.customGroupsAvailable"><fmt:message key='CustomReport.FieldSetting.Value'/>
						</label>
					</div>
				</div> 

				<div class="form-group">
					<label for="sortValuesBy" class="col-sm-4 control-label"><fmt:message key='CustomReport.FieldSetting.SortingOrder'/></label>
					<div class="col-sm-8">
						<label class="radio-inline" data-ng-disabled="field.customGroupsAvailable"> <input type="radio" value="asc" data-ng-model="field.sort.sortDirection" data-ng-disabled="field.customGroupsAvailable"><fmt:message key='CustomReport.FieldSetting.Asc'/>
						</label> 
						<label class="radio-inline" data-ng-disabled="field.customGroupsAvailable"> <input type="radio" value="desc" data-ng-model="field.sort.sortDirection" data-ng-disabled="field.customGroupsAvailable"><fmt:message key='CustomReport.FieldSetting.Desc'/>
						</label>
					</div>
				</div> 

				<div class="form-group">
					<label for="listType" class="col-sm-4 control-label"><fmt:message key='CustomReport.FieldSetting.NoOfVals'/></label>
					<div class="col-sm-6">
						<input data-ng-disabled="field.customGroupsAvailable" type="number" id="noOfValuesToShow" data-ng-model = "field.numPointsToDisplay.maxPoints" class="form-control" min="1">
					</div>
				</div>
				<div class="form-group">
					<label for="listType" class="col-sm-4 control-label"><fmt:message key='CustomReport.FieldSetting.CustomInput'/></label>
					<div class="col-sm-6">
					 	<label class="radio-inline" data-ng-disabled="field.customGroupsAvailable"> <input type="radio" data-ng-value="trueVal" ng-model="field.showComboBox" data-ng-disabled="field.customGroupsAvailable"><fmt:message key='CustomReport.FieldSetting.Combo'/>
						</label>
						<label class="radio-inline" data-ng-disabled="field.customGroupsAvailable"> <input type="radio" data-ng-value="falseVal" ng-model="field.showComboBox" data-ng-disabled="field.customGroupsAvailable"><fmt:message key='CustomReport.FieldSetting.AutoSuggest'/>
						</label>
					</div>
				</div>
			</div>
	    	
        </div>
        <div class="modal-footer">
            <button class="btn btn-primary" type="button" ng-click="ok()"><fmt:message key='Apply'/></button>
            <button class="btn btn-default" type="button" ng-click="cancel()"><fmt:message key='CustomReport.Cancel'/></button>
        </div>
	</div>
</fmt:bundle>