
function convertv1Tov2(url) {
	var urlMap = {
		reportId : 'reportId',
		'previewTable-pageSize' : 'DetailspageSize',
		'previewTable-pageNo' : 'DetailspageNo',
		'previewTable-iSort_Col' : 'dataField',
		'previewTable-sortDir' : 'direction',
		'previewTable-filterClause' : 'DetailswhereClause'
	}

	var tables = {};
	var newParams = [];
	var result = {};
	var previewColumns = [];
	var summaryColumns = [];
	url.split("&").forEach(function(part) {
		var item = part.split("=");
		var paramValue = decodeURIComponent(item[1]);
		if (item[0].indexOf('reviewTable-tableColumns') != -1) {
			previewColumns.push(paramValue);
		} else if (item[0].indexOf('summaryTable-tableColumns') != -1) {
			summaryColumns.push(paramValue);
		} else {
			paramValue = paramValue.replace(/CommCell Name/ig, 'Data Source');
			result[item[0]] = paramValue;
		}
	});

	for ( var key in result) {
		var value = result[key];
		var tableIdAdded = false;
		var tablePrefix = key.substring(0, key.indexOf("-"));
		var tableId = tablePrefix == "previewTable" ? "Details" : "SummaryTable";
		if (key == 'filteredTable-0') {
			var compName = value == "previewTable" ? "Details" : "SummaryTable";
			newParams.push("componentName=" + compName);
		}
		key = key.substring(key.indexOf("-"), key.length);
		if (key == '-iSort_Col') {
			var direction = result[tablePrefix + '-sortDir'];
			value = value.replace(/\s/g, "");
			var sortColumn = direction == "desc" ? "-" + value : value;
			newParams.push(tableId + '.sort=' + sortColumn);
		} else if (key == '-filterClause') {
			var whereClause = [];
			var filterConditions = [];
			value.split(";").forEach(function(val) {
				if (val) {
					var filter = val.split("-LIKE-");
					var filterValue = filter[1];
					if (filterValue == "")
						return;
					newParams.push(tableId + '.filter.' + filter[0].replace(/\s/g, "") + '=' +
							encodeURIComponent(filterValue));
				}
			});
		} else if (key == '-pageSize') {
			newParams.push(tableId + ".pageSize=" + value);
		} else if (urlMap[key]) {
			newParams.push(urlMap[key] + "=" + value);
		} else {
			newParams.push(key + "=" + value);
		}

	}

	newParams.push("Details.oldReportColumns=" + previewColumns.join(","));
	newParams.push("SummaryTable.oldReportColumns=" + summaryColumns.join(","));

	for ( var key1 in tables) {
		var value1 = tables[key1];
		newParams.push(key1 + "=" + JSON.stringify(value1));
	}

	return "/reportsplus/reportViewer.jsp?" + newParams.join("&") + "&fromOldUrl=true";
}
