(function() {
	"use strict";

	var reports = angular.module("reports");

	reports.service('tileBuilderSvc', [
			'$timeout',
			function($timeout) {

				this.initTile = function(customReport) {
					if (customReport.pages[0].body.reportComponents.length == 0) {
						var panelComponent = this.getTileComponent("chartTile");
						var panelId = panelComponent.id;
						var body = customReport.pages[0].body;

						body.reportComponents.push(panelComponent);
						body["filters"] = {
							"builder" : {},
							"viewer" : {}
						};
						body["autoRefreshTime"] = 10;
						body["reportLayout"] = {
							"gridsterOpts" : {
								"columns" : 12
							}
						}
						body.reportLayout[panelId] = this.getBodyLayout();
					}
				}

				this.getBodyLayout = function() {
					var layout = {
						"mobile" : {
							"size" : {
								"x" : 12,
								"y" : 8
							},
							"position" : [ 0, 0 ]
						},
						"tablet" : {
							"size" : {
								"x" : 12,
								"y" : 8
							},
							"position" : [ 0, 0 ]
						},
						"desktop" : {
							"size" : {
								"x" : 7,
								"y" : 17
							},
							"position" : [ 0, 0 ]
						}
					};
					return layout;
				}

				this.getTileComponent = function(type) {
					var panelId = "PanelComponent" + (new Date()).getTime();
					var title = "Tile with chartable outcome";

					if (type === "textTile") {
						title = "Tile with text outcome";
					}

					var panelComponent = {
						"type" : "PANEL",
						"dataSet" : {},
						"title" : {
							text : title
						},
						"id" : panelId,
						"panelComponents" : [],
						"filters" : {
							"builder" : {},
							"viewer" : {}
						}
					};

					if (type === "chartTile") {
						panelComponent.panelComponents.push(this.getChartComponent());
					} else {
						panelComponent.panelComponents.push(this.getTextComponent());
					}

					panelComponent.panelComponents.push(this.getRemarksComponent());
					panelComponent.panelComponents.push(this.getWorkflowComponent());

					return panelComponent;
				}

				this.getChartComponent = function() {
					var chartId = "Chart_" + (new Date()).getTime();
					var comp = {
						"type" : "CHART",
						"tileCompType" : "outcome",
						"dataSet" : {},
						"title" : {
							"text" : "Add dataset column to plot chart"
						},
						"id" : chartId,
						"chartType" : "Pie",
						"isDateTime" : false,
						"xAxisTitle" : {},
						"yAxisTitle" : {},
						"barWidthAutoOnly" : false,
						"dataSeries" : [],
						"isGrouped" : false,
						"styles" : {
							"defaultChartHeight" : 350,
							"defaultChartWidth" : 1000,
							"height" : 350,
							"width" : 1000,
							"chartPlotOptions" : {
								"autoConvertYValues" : true,
								"isShowLabels" : false,
								"legendPosition" : "right",
								"isShowGridlines" : true,
								"isSmoothLines" : false,
								"isShowLineMarkers" : true
							},
							"barColor" : "#00cee6",
							"barSizeAutoOnly" : false
						},
						"sorting" : [ {
							"direction" : "Desc",
							"sortAxis" : "YAxis"
						} ],
						"seriesFormatting" : [],
						"isSelected" : false,
						"isChartExist" : false,
						"orientation" : "vertical",
						"layout" : {},
						"filters" : {
							"builder" : {},
							"viewer" : {}
						}
					}

					comp.layout[chartId] = {
						"desktop" : {
							"position" : {
								"0" : 0,
								"1" : 0
							},
							"size" : {
								"x" : 8,
								"y" : 7
							}
						}
					};

					return comp;
				}

				this.getTextComponent = function() {
					var id = "TextOutcome_" + (new Date()).getTime();
					var comp = {
						"type" : "CUSTOM",
						"tileCompType" : "outcome",
						"title" : {
							"text" : "Add dataset column for outcomes"
						},
						"id" : id,
						"layout" : {},
						"filters" : {
							"builder" : {},
							"viewer" : {}
						},
						"htmlContent" : ":= if (typeof rows !== 'undefined' )  { "
								+ "    return reportsUtil.getTileTextOutcomeHtmlContent(rows) }",

						"isComponentLoading" : false
					}

					comp.layout[id] = {
						"desktop" : {
							"position" : {
								"0" : 0,
								"1" : 0
							},
							"size" : {
								"x" : 8,
								"y" : 4
							}
						}
					};

					return comp;
				}

				this.getRemarksComponent = function() {
					var remarksId = "Remarks_" + (new Date()).getTime();
					var comp = {
						"type" : "CUSTOM",
						"tileCompType" : "remarks",
						"title" : {
							"text" : "Add dataset column to plot remarks"
						},
						"id" : remarksId,
						"layout" : {},
						"filters" : {
							"builder" : {},
							"viewer" : {}
						},
						"htmlContent" : ":= if (typeof rows !== 'undefined') {"
								+ "\n return reportsUtil.getTileRemarksHtmlContent(rows)  }",

						"isComponentLoading" : false
					}

					comp.layout[remarksId] = {
						"desktop" : {
							"position" : {
								"0" : 7,
								"1" : 0
							},
							"size" : {
								"x" : 8,
								"y" : 4
							}
						}
					};
					return comp;
				}

				this.getWorkflowComponent = function() {
					var id = "Workflows_" + (new Date()).getTime();
					var comp = {
						"type" : "CUSTOM",
						"tileCompType" : "workflow",
						"title" : {
							"text" : "Add dataset column for FixIt workflow"
						},
						"id" : id,
						"layout" : {},
						"filters" : {
							"builder" : {},
							"viewer" : {}
						},
						"htmlContent" : ":= \n var html = \'<div class=\"fixItWrapper\"> '"
								+ "\n if (typeof rows !== 'undefined' )  { "
								+ "\n     html += reportsUtil.getTileWorkflowHtmlContent(rows); " + "\n }"
								+ "\n html += \'</div>\'" + "\n return html;",

						"isComponentLoading" : false
					}

					comp.layout[id] = {
						"desktop" : {
							"position" : {
								"0" : 12,
								"1" : 0
							},
							"size" : {
								"x" : 8,
								"y" : 4
							}
						}
					};
					return comp;
				}
			} ]);

})(this);