(function() {
	'use strict';
	var reports = angular.module("reports");
	window.reportEnum = "CustomReports";

	reports.controller('reportViewCtrl', [
			'$scope',
			'reportService',
			'customReportSvc',
			'$modal',
			'$location',
			'$compile',
			function($scope, reportService, customReportSvc, $modal, $location, $compile) {
				var isPreview = customReportSvc.getParameterByName("isPreview", false);

				$scope.init = function() {
					$scope.reportMode = 'viewer';

					if (isPreview) {
						angular.element("#actionsButton").hide();
						angular.element("#reportButton").hide();
					}
				}

				window.addEventListener('beforeunload', function u(e) {
					reportService.clearCache();
				}, false);

				window.onpopstate = function(event) {
					if (event.state) {
						customReportSvc.initUrlParams();
						customReportSvc.triggerCallback("redrawAllComponents");
					}
				};

				angular.element("#editLink").bind("click",
						function(evt) {
							window.location.assign(customReportSvc.getContextPath() +
									"/reportsplus/index.jsp?reportId=" + $scope.reportId);
						});

				angular.element(".exportatserver").bind("click", function(evt) {
					$scope.saveReportAs($(this), reportService, customReportSvc);
				});

				$scope.page = {};

				// the reportComponentsCallbacks will be triggered when ever there is a change in the components. Like add or remove component from the page.
				customReportSvc.registerCallback("reportComponentsCallbacks", function(components) {
					$scope.reportComponents = components;
					$scope.$apply();
				});

				$scope.setReportComponents = function() {
					var showComponents = customReportSvc.getParameterByName('showComponents');
					if (showComponents) {
						var componentIds = window.decodeURIComponent(showComponents).split(",");
						angular.forEach($scope.reportComponents, function(component, index) {
							if (componentIds.indexOf(component.id) == -1) {
								component.hide = true;
							}
						});
						$scope.chartOptions = true;
					}

				}

				// This will be triggered when all the inputs are intialized with ther default values or the values from a bookmarkable url. If we load the components after this call that will load the data appropraitely.
				customReportSvc.registerCallback("allInputsInitialized", function() {
					$scope.reportComponents = $scope.page.body.reportComponents;
					$scope.setReportComponents();
				});

				$scope.customReport = customReportSvc.customReport;
				$scope.reportComponents = [];

				customReportSvc.sharedData.reportMode = "viewer";
				$scope.setActiveComponent = function() {
					customReportSvc.setActiveComponent(this.component);
				};
				customReportSvc.registerCallback("crChangeCallBacks",
						function(cr) {
							$scope.customReport = cr;
							$scope.pages = $scope.customReport.pages;
							$scope.page = customReportSvc.sharedData.currentPage;
							$scope.reportName = cr.report.customReportName;
							$scope.reportId = cr.report.customReportId;

							if (customReports.appName !== 'adminconsole') {
								attachEmailHandler({
									exportFileNamePrefix : $scope.reportName,
									isCustomReport : true
								});
								reportsUtil.scheduleReport({
									exportFileNamePrefix : $scope.reportName,
									isCustomReport : true
								});
							}
							var reportTitle = rpt.translate("RPT_TITLE");
							var reportDescription = rpt.translate("RPT_DESCRIPTION");
							if (isPreview && cr.translations === undefined) {
								reportTitle = cr.report.customReportName;
								reportDescription = cr.reportDescription;
							}

							angular.element("#sectionTitle").text(reportTitle);
							angular.element("#crdescription").html(reportDescription);
							angular.element("#crdescription").prop('title', reportDescription);

							if (typeof $scope.page.body.customStyle !== "undefined" &&
									$scope.page.body.customStyle != null) {
								var styleTag = angular.element('<style></style>');
								styleTag.append($scope.page.body.customStyle);
								$compile(styleTag)($scope);
								angular.element("head").append(styleTag);
							}
							if (typeof $scope.page.body.customJsCode !== "undefined" &&
									$scope.page.body.customJsCode != null) {
								var scriptTag = "<script type='text/javascript'>" + $scope.page.body.customJsCode +
										"</script>";
								angular.element("head").append(scriptTag);
							}

							//when there are inputs in the page wait for all the inputs to be loaded via the trigger call allInputsInitialized above.
							if (!$scope.page.inputs || $scope.page.inputs.length == 0) {
								$scope.reportComponents = $scope.page.body.reportComponents;
								$scope.setReportComponents();
							}

						});

				customReportSvc.registerCallback("allComponentsLoaded", function(cr) {
					$scope.isAlarm = customReportSvc.getParameterByName('isAlarm');
					var exportType = customReportSvc.getParameterByName('exportType');
					if ($scope.isAlarm) {
						var componentName = customReportSvc.getParameterByName('componentName');
						var component = customReportSvc.getComponent(componentName);
						var options = customReportSvc.getDataSetOptions(component, true, true);
						var whereClause = customReportSvc.getParameterByName('whereClause');
						var filePrefix = customReportSvc.getParameterByName('exportedFileName') ||
								$scope.customReport.report.customReportName;
						var dataSet = customReportSvc.getDataSet(component.dataSet.dataSetName);
						var parametersList = customReportSvc.applyInputsToDataSet(dataSet,
								customReportSvc.sharedData.currentPage.inputs);

						reportService.getDataForDataSet(undefined,
								dataSet,
								options.valueFieldsList,
								options.groupByFieldsList,
								-1,
								0,
								options.whereClause,
								options.orderByClause,
								undefined,
								options.havingClause,
								parametersList,
								'csv',
								filePrefix,
								undefined,
								options).then(function(data) {
							console.log("Alert generation succeeeded with the file name : " + data.data);
							/*
							 * var data1 = data.data; if(!data1||data1==""||data1=='null')
							 * alert(localMsg['ExportError']); else{ $("#fileNameToDownload").val(data1);
							 * $("#exportForm").submit(); }
							 */

						});
					} else if (exportType == 'csv') {
						$scope.exportCsv();
					}

				});

				$scope.exportCsv = function() {
					var dataSetsToExport = customReportSvc
							.getDataSetstoExport(customReportSvc.sharedData.currentPage.body.reportComponents);
					var filePrefix = customReportSvc.getParameterByName('exportedFileName') ||
							$scope.customReport.report.customReportName;
					reportService.retrieveCsvData(dataSetsToExport,
							filePrefix,
							'csv',
							$scope.customReport.report.customReportName).then(function(data) {
						console.log("CSV export succeeeded with the file name : " + data.data);
						/*
						 * var data1 = data.data; if(!data1||data1==""||data1=='null')
						 * alert(localMsg['ExportError']); else{ $("#fileNameToDownload").val(data1);
						 * $("#exportForm").submit(); }
						 */
					}, function(xhr, ajaxOptions, thrownError) {
						if (thrownError != 'userAborted') {
							customReportSvc.errorToast(xhr.responseText.trim());//cvUtil.handleError(xhr, ajaxOptions, thrownError);
						}
					});
				};

				$scope.saveReportAs = function(exportEl) {
					var maxWidth = 1200;
					var url = document.URL;
					var exportType = exportEl.attr('id').substring("export".length).toLowerCase();
					url = url + "&exportType=" + exportType + "&allDataSets=true&pageSize=-1&cacheId=" +
							globalVar.cacheId;
					var directDownLoad = exportType == "csv";
					/*
					 * if (exportType == 'csv') { $scope.exportCsv(); return; }
					 */
					var filePrefix = $scope.reportName;
					var widthParam = "&width=" + maxWidth;
					angular.element("#content").mask(localMsg['WaitMsg'] + "&nbsp&nbsp", 0, function() {
						return (exportajaxRequest && exportajaxRequest.abort());
					});
					customReportSvc.DEFAULT_TIMEOUT = 300000;

					var saveAsUrl = customReportSvc.getContextPath() + '/reports/exp.do?orientation=landscape' +
							widthParam + '&exportType=' + exportType;
					var params = {
						url : url,
						filePrefix : filePrefix,
						directDownload : false,
						type : 'report'
					};
					var exportajaxRequest = reportService.saveAs(saveAsUrl, params);

					exportajaxRequest.then(function(data) {
						if (data) {
							var data1 = JSON.parse(data.data);
							angular.element("#content").unmask();
							dataSetUtility.downloadReportFile(data1);
						}

					}, function(error) {
						angular.element("#content").unmask();
						if (error != 'userAborted') {
							customReportSvc.errorToast(error);//cvUtil.handleError(xhr, ajaxOptions, thrownError);
						}
					});

				};

				$scope.encodeScript = function(script) {
					var encodedScript = '';
					if (typeof script !== "undefined" && script != null) {
						for (var i = 0; i < script.length; i++) {
							var j = '\b\t\n\v\f\r"\'\\'.indexOf(script.charAt(i));
							if (j != -1) {
								encodedScript += '\\' + 'btnvfr"\'\\'.substr(j, 1);
							} else if (script.substr(i, 2) == '</') {
								encodedScript += '<\\/';
								i++;
							} else if (!charset.containsChar(script.charAt(i))) {
								if (script.charCodeAt(i) > 255) {
									encodedScript += '\\u' + ('000' + script.charCodeAt(i).toString(16)).right(4);
								} else {
									encodedScript += '\\x' + ('0' + script.charCodeAt(i).toString(16)).right(2);
								}
							} else {
								encodedScript += script.charAt(i);
							}
						}
					}
					return encodedScript;
				};

				$scope.decodeScript = function(encodedScript) {
					var script = '';
					if (typeof encodedScript !== "undefined" && encodedScript != null) {
						try {
							if (!/([^\\]'|\r|\n)/.test(encodedScript)) {
								script = eval("'" + encodedScript + "'");
							}
						} catch (e) {
						}
					}
					return script;
				};
			} ]);
}());

// this is just a function that helps in making the v1 reports with custom workflow events to work. Do no remove this empty function.
function clearCacheNow() {
}
