/**
 * formatters used to render the metrics data
 */

(function(global) {
	'use strict';
	global.cvMetrics = (function() {
		var Bytes = 1;
		var KB = 1024;
		var MB = KB * 1024;
		var GB = MB * 1024;
		var TB = GB * 1024;
		var PB = TB * 1024;
		var EB = PB * 1024;
		var THOUSAND = 1000;
		var MILLION = THOUSAND * THOUSAND;
		var BILLION = MILLION * THOUSAND;
		var TRILLION = BILLION * THOUSAND;

		function getDate(unix, pattern) {
			if (pattern) {
				return moment.unix(parseFloat(unix) + getTimezoneOffset(unix)).format(pattern);
			} else {
				return moment.unix(parseFloat(unix) + getTimezoneOffset(unix));
			}
		}

		function getTimezoneOffset(unix) {
			if (unix) {
				return (new Date(parseFloat(unix) * 1000).getTimezoneOffset() * 60);
			}
			return (new Date().getTimezoneOffset() * 60);
		}


		return {
			format : function(formatters, cellData,row) {
				let self= this;
				formatters.map(formatter => {
					formatter = formatter.replace(/[<>]/g, '');
					cellData = cvMetrics.applyFormat(formatter,cellData,row);
				});
				return cellData;
			},
			getDateConverted : function(unix, pattern) { //Same as getDate; Used for direct calls from report
				if (pattern) {
					return moment.unix(parseFloat(unix) + getTimezoneOffset(unix)).format(pattern);
				} else {
					return moment.unix(parseFloat(unix) + getTimezoneOffset(unix));
				}
			},
			autoConvertFromMB: function(val, acceptNegative) {
				var vNeg = false;
				var retval = '';
				if (acceptNegative && val < 0) {
					vNeg = true;
					val = -val;
				}
				if (val < 0) {
					retval = "N/A";
				} else if (val == 0) {
					retval = "0 Bytes";
				} else if (val < KB) {
					retval = val + " MB";
				} else if (val < MB) {
					retval = cvMetrics.convert(val / KB) + " GB";
				} else if (val < GB) {
					retval = cvMetrics.convert(val / MB) + " TB";
				} else if (val < TB) {
					retval = cvMetrics.convert(val / GB) + " PB";
				} else {
					retval = cvMetrics.convert(val / TB) + " EB";
				}
				if (vNeg) {
					retval = '-' + retval;
				}
				return retval;
			},
			applyMMMDDYYYYNEVER:function(val){
				if (val == null || val == undefined || val === 'null') {
					return "";
				}
				val = parseInt(val, 10);
				if (val == 549755813887) {
					return "N/A";
				} else if (val == -100) {
					return "";
				} else if (val == 549755813886) {
					return "Never";
				} else if (val == -2) {
					return "Nothing to Copy";
				} else if (val == -4) {
					return "History unavailable to estimate time";
				} else if (val == -5) {
					return "Jan 01, 2038"; // Why 2038?
				} else if (val == -6) {
					return "Not Protected"; // Why 2038?
				} else if (val == -7) {
					return "No Jobs";
				}
				return getDate(val, "MMM DD, YYYY");
			},
			applyHealthStatus:function(row,val){
				var images = [ 'question', 'check-circle', 'info', 'warning', 'critical', 'check-circle-bulb' ];
				var healthStatusDesc = encodeURIComponent(row["HealthStatusDescription"]);
				var tokens = val.split('_');

				if (tokens[0] == '1a') {
					tokens[0] = 5;
				}

				var html = "<span class='healthStatus' style='text-align:left'><span class='sprite icon-" +
						images[tokens[0]] + "' alt='" + tokens[1] + "' style='vertical-align: middle' data-healthdesc='" +
						healthStatusDesc + "'></span>";

				var cellVal = tokens[1];

				var urlval = cvUtil.getContextPath()+"/survey/reports/healthparams.jsp#";
				var paramId = row["ParamId"];
				if (paramId != undefined && paramId != "") {
					var hsh = "param" + paramId;
					urlval = urlval + hsh;
				}

				if (typeof exportRequest === "undefined") {
					cellVal = "<a class='disableOnEmbedded' href='" + urlval + "'>" + cellVal + "</a>";
				}

				return html + "<span style='vertical-align: bottom;padding-left:3px;'>" + cellVal + "</span><span>";
			},
			applyDifferenceNA:function(val){
				val = parseFloat(val);
				if (!val) {
					return "N/A";
				}
				return val;
			},
			getCategoryLink:function(o,val){
				if (val) {
					var urlval = window.location.href;
					var category = o.Category;
					urlval = urlval + "&pageName=Page1&input.entity=" + category;
					//TO DO: exportRequest not defined
					if (typeof exportRequest === "undefined") {
						return "<a href='" + urlval + "'>" + val + "</a>";
					} else {
						return val;
					}
				}
				return val;
			},
			applyMMMDDYYYY: function(val){
				if (val == null || val == undefined || val === 'null') {
					return "";
				}
				val = parseInt(val, 10);
				if (val == -50) {
					return "N/A";
				} else if (val == -100) {
					return "";
				} else if (val == -3) {
					return "Never";
				} else if (val == -2) {
					return "Nothing to Copy";
				} else if (val == -4) {
					return "History unavailable to estimate time";
				} else if (val == -5) {
					return "Jan 01, 2038"; // Why 2038?
				} else if (val == -6) {
					return "Not Protected"; // Why 2038?
				} else if (val == -7) {
					return "No Jobs";
				}
				//return moment.unix(val  + (new Date().getTimezoneOffset()*60) ).format("MMM DD, YYYY");
				return getDate(val, "MMM DD, YYYY");
			},
			applyMMMYYYY:function(val){
				val = parseInt(val, 10);
				if (val == -50) {
					return "N/A";
				} else if (val == -100) {
					return "";
				} else if (val == -3) {
					return "Never";
				}

				return getDate(val, "MMM YYYY");
			},
			applyDifferenceMB:function(val){
				if (!val) {
					return "N/A";
				}

				return cvMetrics.autoConvertFromMB(val, true);
			},
			getHexString:function(val){
				if (!val) {
					val = "0";
				}
				var hexString;
				try{
					hexString = parseInt(val).toString(16).toUpperCase();
				}
				catch(error){
					hexString = "N/A";
					console.log("Unable to convert "+val+" to Hex");
				}
				return hexString;
			},
			getPercentValue: function(val) {
				if (val < 0) {
					return "N/A";
				} else if (val > 100) {
					return "100";
				} else {
					return val;
				}

			},
			convert: function(value) {
				var valueStr = value.toString();

				if (valueStr.toLowerCase().indexOf('e') != -1) {
					valueStr = value.toFixed(20);
				} else if (valueStr.indexOf(".") != -1) {
					valueStr = cvMetrics.roundNumber(value, 2);
				}

				return valueStr;
			},
			roundNumber: function(num, dec) {
				var result = Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
				return result;
			},
			getFormatNumberNA : function(val){
				if(!val){
					return;
				}
				val = val.toString();
				var pattern = /(-?\d+)(\d{3})/;
				while (pattern.test(val)) {
					val = val.replace(pattern, "$1,$2");
				}
				return val;
			},
			openCommcellLevelReport:function(row,val){
				let retval = "";
				let url = customReports.contextPath;
				if (customReports.appName === 'adminconsole') {
					url = url + "/#/reportDetails?"
				} else {
					url = url + "/reportsplus/reportViewer.jsp?reportId="
				}
				url +=  rpt.getParameterByNameSafeForUrl('reportId', '-1');
				url += "&commUniId="+row['CommServUniqueId'];
				retval = "<a href='" + url + "'>" + val + "</a>";
				return retval;
			},
			getDWDDMMM : function(val) {
					if (val == null || val == undefined || val === 'null') {
						return "";
					}
					val = parseInt(val, 10);
					if (val == -50) {
						return "N/A";
					} else if (val == -100) {
						return "";
					} else if (val == -3) {
						return "Never";
					}
					//return moment.unix(val  + (new Date().getTimezoneOffset()*60) ).format("dddd (MMM D)");
					return getDate(val, "dddd (MMM D)");
			},
			applyStrikeCountFormatter : function(val) {
					var exportRequest = rpt.getParameterByNameSafeForUrl('exportType', "");
					if (exportRequest == 'csv') {
						return val;
					}
					if (val == 3) {
						return '<div style="padding:0; margin:0;text-align:left">'
								+ '<svg width="29" height="9" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg"><g><ellipse stroke="#000000" fill="#E44C4C" stroke-width="3" cx="4.47954" cy="4.50856" rx="4.2" ry="4.2" stroke-opacity="0" id="svg_2"/><ellipse stroke="#000000" fill="#E44C4C" stroke-width="3" cx="14.47954" cy="4.50856" rx="4.2" ry="4.2" stroke-opacity="0" id="svg_3"/><ellipse stroke="#000000" fill="#E44C4C" stroke-width="3" cx="24.47954" cy="4.50856" rx="4.2" ry="4.2" stroke-opacity="0" id="svg_4"/></g></svg>'
								+ '</div>';
					} else if (val == 2) {
						return '<div style="padding:0; margin:0;text-align:left">'
								+ '<svg width="19" height="9" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg"><g><ellipse id="svg_2" stroke-opacity="0" ry="4.2" rx="4.2" cy="4.50856" cx="4.47954" stroke-width="3" fill="#F69C09" stroke="#000000"/><ellipse id="svg_3" stroke-opacity="0" ry="4.2" rx="4.2" cy="4.50856" cx="14.47954" stroke-width="3" fill="#F69C09" stroke="#000000"/></g></svg>'
								+ '</div>';
					} else if (val == 1) {
						return '<div style="padding:0; margin:0;text-align:left">'
								+ '<svg width="9" height="9" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg"><g><ellipse stroke="#000000" fill="#FFF700" stroke-width="3" cx="4.54015" cy="4.49605" rx="4.2" ry="4.2" stroke-opacity="0" id="svg_2"/></g></svg>'
								+ '</div>';
					} else {
						return val;
					}
			},
			applyJobsAffectedFormatter : function(row) {

				var errorCode = $("<div/>").html(row["ErrorCode"]).text();
				errorCode = $("<div/>").html(errorCode).text();
				var jobs = row["JobsAffected"];
				var ccID = rpt.getParameterByNameSafeForUrl('commUniId', 0);
				var params="";
				if (ccID > 0) {
					params = 'input.commUniId=' + ccID;
				}
				if (rpt.getParameterByNameSafeForUrl('ccGroupId', -1) > 0) {
					params += "&ccGroupId=" + rpt.getParameterByNameSafeForUrl('ccGroupId');
				}
				if (rpt.getParameterByNameSafeForUrl('companyId', 0) > 0) {
					params += "&companyId=" + rpt.getParameterByNameSafeForUrl('companyId');
				}
				var urlval = 'reportViewer.jsp?';
				if(params.length > 0){
					urlval += params + '&reportId=Failed%20Jobs%20in%20last%2024%20hours&Table1605758814042.filter.ErrorCode=' + encodeURIComponent(errorCode) + '%3B';
				}else{
					urlval += 'reportId=Jobs%20Affected%20with%20Error%20Codes&input.errorCode=' + errorCode;
				}
				if (exportRequest) {
					return jobs;
				} else {
					return "<a href='" + urlval + "' target='_blank'>" + jobs + "</a>";
				}
			},
			applyDotStatus: function(val,row){
				/// Dot colors corresponding to status values
				var images = [ "white", "green", "none", "orange", "red" ];
				var svg = '<svg width="20" height="20" xmlns="http://www.w3.org/2000/svg" xmlns:svg="http://www.w3.org/2000/svg"><g><ellipse id="svg_2" stroke-opacity="0" ry="9.7" rx="9.7" cy="10" cx="10" stroke-width="3" fill-opacity="{{OPACITY}}" fill="{{COLOR}}" stroke="#000000"/></g></svg>';
				var colors = ['#FFFFFF', '#75C350', '#000000', '#F69C09', '#E44C4C'];
				var opacity = 1;

				/// Statuses come in the form <1-4>_<StatusString>; anything else
				/// is unknown
				var tokens = val.split('_');
				if (tokens[0] > 4) {
					tokens[0] = 0;
				}

				/// Do not render icons in export
				if (exportRequest == "csv") {
					return tokens[1];
				}

				if (tokens[1] === "Info") {
					tokens[1] = "";
				}

				if (tokens[0] == 2) {
					opacity = 0;
				}

				svg = svg.replace("{{COLOR}}", colors[tokens[0]]).replace("{{OPACITY}}", opacity);

				/// Define rendered cell contents
				var html = "<div style='text-align: center' title='"+ tokens[1] +"'>" + svg + "<span style='display:none'>" + tokens[1] + "</span></div>";

				return html;
			},
			applyNumberNA: function(val) {
				val = parseFloat(val);
				if (val == -2) {
					return "Never Protected";
				} else if (val < 0) {
					return "N/A";
				} else if(val == 0) {
					return "0";
				}
				return cvMetrics.getFormatNumberNA(val);
			},
			applyBooleanRenderer : function(val) {
				var html = "";
				var str = val.toLowerCase();
				if (str == 'yes') {
					html = "<img src='" + cvUtil.getContextPath() +
							"/survey/images/cb_selected.png' alt='Yes' style='vertical-align: middle' title='Yes'>";
				} else if (str == 'no') {
					html = "";
				}
				return html;
			},
			getFormattedDateTimeFromUTC: function(val,pattern) {
				val = parseInt(val, 10);
				if (val <= 0) {
					return " ";
				}
				return getDate(val, pattern);
			},
			applyDateTimeRenderer: function(val) {
				//should check to use the rpt.formatDateAndTime to localization
				return cvMetrics.getFormattedDateTimeFromUTC(val,"MMM D, YYYY hh:mm A");
			},
			applyCommcellStatusRenderer: function(val) {
				var html = "";
				var str = val.toLowerCase();
				if (str == 'enabled') {
					html = '<span title="Enabled" alt="Enabled" class="sprite icon-dot-green"></span>';
				} else if (str == 'disabled') {
					html = '<span title="Disabled" alt="Disabled" class="sprite icon-dot-red"></span>';
				}
				return html;
			},
			getMonthlyJobResultsURL :function(val, div){
					var sd =getDate(val, 'YYYY-MM-DD');
					var mm = moment(sd);
					var edate = mm.endOf("month").unix();
					var ed = moment.unix(parseFloat(edate)).format('YYYY-MM-DD');
					// sd += "T00:00:00Z ";
					// ed += "T23:59:59Z";
					var href = 'reportViewer.jsp?reportId=Daily Backup Jobs'
					href += '&input.DateRange='+encodeURIComponent(sd)+' '+encodeURIComponent(ed);
					// var href = window.location.href;
					// href = href.replace(window.location.search, "");
					// if(ccId != undefined && ccId){
					// 	href = href.replace("operations.jsp", "indcommcellsurvey.jsp");
					// }else{
					// 	href = href.replace("operations.jsp", "CommCellSurvey.jsp");
					// }
					// var str = "?";
					// if(ccId != undefined && ccId) {
					// 	str += "commUniId="+ccId+"&";
					// }
					// str += "surveyId=137&repType=monthly&jobStatus=0&startDate="+sd+"&endDate="+ed;
					// if(cvUtil.getParameter('ccGroupId', -1) > 0){
					// 	str = str + "&ccGroupId=" + cvUtil.getParameter('ccGroupId');
					// }
					// if(cvUtil.getParameter('companyId', 0) > 0){
					// 	str = str + "&companyId=" + cvUtil.getParameter('companyId');
					// }
					// if(cvUtil.getParameter('tenant', '') != ''){
					// 	str = str + "&tenant=" + encodeURIComponent(cvUtil.getParameter('tenant'));
					// }
					// if(div.match(/skipped/i) || div.match(/sj/i))
					// 	str += "&skippedJobs=true";
					// href += str;
					return href;
			},
			getHourlyJobResultsURL : function(val, div){
				// if(params.weekend){
				// 	return;
				// }
				var sd =getDate(val, 'YYYY-MM-DD');
				var href = 'reportViewer.jsp?reportId=Hourly Backup Jobs';
				href += '&input.timeFrame='+sd+" "+sd;
				// var href = window.location.href;
				// href = href.replace(window.location.search, "");
				// if(ccId != undefined && ccId){
				// 	href = href.replace("operations.jsp", "indcommcellsurvey.jsp");
				// }else{
				// 	href = href.replace("operations.jsp", "CommCellSurvey.jsp");
				// }
				// var str = "?";
				// if(ccId != undefined && ccId) {
				// 	str += "commUniId="+ccId+"&";
				// }
				// str += "surveyId=51&repType=hourly&startDate="+sd+"&endDate="+sd;
				// if(cvUtil.getParameter('ccGroupId', -1) > 0){
				// 	str = str + "&ccGroupId=" + cvUtil.getParameter('ccGroupId');
				// }
				// if(cvUtil.getParameter('companyId', 0) > 0){
				// 	str = str + "&companyId=" + cvUtil.getParameter('companyId');
				// }
				// if(cvUtil.getParameter('tenant', '') != ''){
				// 	str = str + "&tenant=" + encodeURIComponent(cvUtil.getParameter('tenant'));
				// }
				// if(div.match(/skipped/i) || div.match(/sj/i))
				// 	str += "&skippedJobs=true";
				// href += str
				return href;
			},
			applyHourRenderer : function(val) {
				if (val == null || val == undefined || val === 'null') {
					return "N/A";
				}
				var hh = val / 60;
				var aa = hh >= 12 ? "PM" : "AM";
				hh = (hh > 12) ? hh - 12 : (hh == 0) ? 12 : hh;
				return hh + ":00 " + aa;
			},
			getJobResultsURL : function(startDate, isDaily = true, jobStatus = 0){
				//Used for 'Daily Backup Jobs' & 'Hourly backup jobs'
				var sd,ed, type="hourly";
				var url = '';
				// var str = "?";
				var commUniId = rpt.getParameterByNameSafeForUrl("commUniId");
				var excludeTranscationLogs = rpt.getParameterByNameSafeForUrl("excludeTranscationLogs", 0);
				// var tenant = encodeURIComponent(cvUtil.getParameterByNameSafeForUrl("tenant", ''));
		
				if(isDaily){
					sd = getDate(startDate, 'YYYY-MM-DD');
					var mm = moment(sd);
					var edate = mm.endOf("day").unix();
					ed = moment.unix((parseFloat(edate))).format('YYYY-MM-DD');
					sd += "T00:00:00Z ";
					ed += "T23:59:59Z";
					type="daily";
				}else{
					sd = startDate+":00:00Z ";
					ed = startDate+":59:59Z";
				}
		
				if(commUniId) {
					// url = cvUtil.getContextPath() + '/survey/reports/indcommcellsurvey.jsp';
					// str += "commUniId="+commUniId+"&";
				} else {
					url = 'reportViewer.jsp?reportId=Activity%20-%20Job%20Details';
				}
				//Check: How is repType used in Job details(below URL)
				url += "&input.jobStatus="+jobStatus+"&input.timeFrame="+sd+" "+ed+"&repType="+type+"&input.excludeTransactionLogJobs="+excludeTranscationLogs;
				// if(tenant != ''){
				// 	str += "&tenant="+tenant;
				// }
				// if(cvUtil.getParameter('ccGroupId', -1) > 0){
				// 	str = str + "&ccGroupId=" + cvUtil.getParameter('ccGroupId');
				// }
				// if(cvUtil.getParameter('companyId', 0) > 0){
				// 	str = str + "&companyId=" + cvUtil.getParameter('companyId');
				// // }
				// url += str;
				return url;
			},		
			applyFormat : function(formatter, cellData, row) {
				switch (formatter) {
				case "SIZEMB":
					return cvMetrics.autoConvertFromMB(cellData);
				case "HEALTH_STATUS":
					return cvMetrics.applyHealthStatus(row,cellData);
				case "DifferenceMB":
					return cvMetrics.applyDifferenceMB(cellData);
				case "MMMDDYYYYNEVER":
					return cvMetrics.applyMMMDDYYYYNEVER(cellData);
				case "DifferenceNA":
					return cvMetrics.applyDifferenceNA(cellData);
				case "percentNA":
					return cvMetrics.getPercentValue(cellData);
				case "CATEGORY_LINK":
					return cvMetrics.getCategoryLink(row,cellData);
				case "MMMYYYY":
					return cvMetrics.applyMMMYYYY(cellData);
				case "MMMDDYYYY":
					return cvMetrics.applyMMMDDYYYY(cellData);
				case "commcellName":
					return cvMetrics.openCommcellLevelReport(row,cellData);
				case "commcellID":
					return cvMetrics.getHexString(cellData);
				case "DOT_STATUS":
					return cvMetrics.applyDotStatus(cellData,row);
				case "FORMATNUMBERNA":
					return cvMetrics.getFormatNumberNA(cellData);
				case "strikeCount":
					return cvMetrics.applyStrikeCountFormatter(cellData);
				case "NumberNA":
					return cvMetrics.applyNumberNA(cellData);
				case "BOOLEAN":
					return cvMetrics.applyBooleanRenderer(cellData);
				case "DATETIME":
					return cvMetrics.applyDateTimeRenderer(cellData);
				case "COMMCELL_STATUS":
					return cvMetrics.applyCommcellStatusRenderer(cellData);
				case "HOURS" :
					return cvMetrics.applyHourRenderer(cellData);
				case "DWDDMMM":
					return cvMetrics.getDWDDMMM(cellData);
				case "commcellID":
				default:
					var handledFormatter=["ALTSORT","HIDDEN","SORTCOLUMN","DONOTSHOW"];
					if(!handledFormatter.includes(formatter)){
						console.log(formatter);
					}
					return cellData;
				}
			}
		}

	}());
	// register as an AMD module
	if (typeof define === 'function' && define.amd) {
		define([], function() {
			return cvMetrics;
		});
	} else {
		// set global
		if (!global.cvMetrics) {
			global.cvMetrics = cvMetrics;
		}
	}

}(window));