<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div class="btn-group-vertical relative-options custom-timerange" data-ng-if="!hideAllRelativeOptions">
	 	<button type="button" class="btn btn-link btn-primary date-range-button" data-ng-class="{'date-range-selected':rValue.selected}" data-ng-repeat="rValue in relativeValues" data-ng-click="updateTimeRangeValue(rValue)">{{rValue.label}}</button>
	</div>
	<div class="custom-timerange relative-options" data-ng-if="showTimeRangeOptions">
		<div class="btn-group relative-radio-options" data-ng-show="showCustomDateOptions">
	        <span class="realtive-radio-option"><input type="radio" name="occurrences" id="Relative" value="Relative" ng-model="$parent.showCustomRelativeOptions" class="radio-option" /><label class="radio-label" for="Relative"><fmt:message key="CustomReport.Table.SelectFilter.Relative"/></label></span>
	        <span class="realtive-radio-option"><input type="radio" name="occurrences" id="Custom" value="Custom" ng-model="$parent.showCustomRelativeOptions" class="radio-option" /><label class="radio-label" for="Custom"><fmt:message key="CustomReport.Table.SelectFilter.Between"/></label></span>
	    </div>

		<div class="custom-relative-options" data-ng-show="$parent.showCustomRelativeOptions === 'Relative'" data-ng-init="calculateRightPosition()">
			<label class="select-label"><select data-ng-model="customRelative.relativeUnit" data-ng-options="o as o for o  in customRelativeUnits" data-ng-change="changeCustomRelativeOptions(customRelative.relativeUnit,customRelative.relativeOption)"></select></label>
			<input type="number" kendo-numeric-text-box k-min="0" class="relative-number" k-ng-model="customRelative.relativeValue" k-options="numericOptions">
			<label class="select-label"><select data-ng-model="customRelative.relativeOption" data-ng-options="o as o for o in customRelativeOptions"></select></label>
		</div>
		<div class="custom-time-range-options" data-ng-show="$parent.showCustomRelativeOptions === 'Custom'" data-ng-init="calculateRightPosition()">
			<div class="custom-timerange from-range" data-ng-if="showTimeRangeOptions">
					<div class="date-label"><fmt:message key="CustomReport.DateRange.FromDate"/></div>
					<div class="date-picker">
						<div uib-datepicker data-ng-model="inputDate.fromDate" ng-click="$event.stopPropagation()" datepicker-options="fromOptions"  class="date-picker" max-date="toDate"></div>
					</div>
					<div class="time-picker"  data-ng-if="input.includeTime">
						<div uib-timepicker data-ng-model="inputDate.fromDate" hour-step="1" minute-step="15" show-meridian="true" show-spinners="true"></div>
					</div>
					<input type="text" class="date-label" data-ng-model="inputDate.fromLabel" readonly>
			</div>
			<div class="custom-timerange to-range" data-ng-if="showTimeRangeOptions">
					<div class="date-label"><fmt:message key="CustomReport.DateRange.ToDate"/></div>
					<div class="date-picker">
						<div uib-datepicker data-ng-model="inputDate.toDate" ng-click="$event.stopPropagation()" datepicker-options="toOptions" min-date="fromDate"></div>
					</div>
					<div class="time-picker" data-ng-if="input.includeTime">
						<div uib-timepicker data-ng-model="inputDate.toDate" hour-step="1" minute-step="15" show-meridian="true" show-spinners="true"></div>
					</div>
					<input type="text" class="date-label" data-ng-model="inputDate.toLabel" readonly>
			</div>
		</div>
	</div>
	<div class="pull-right timerange-buttons action-btn-panel" data-ng-if="showTimeRangeOptions">
		<button class="btn btn-default margin-right-5" ng-click="clearTimeRange()"><fmt:message key="CustomReport.Clear"/></button>
		<button class="btn apply-btn" ng-click="applyCustomRange()"><fmt:message key="Apply"/></button>
	</div>
</fmt:bundle>
