<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<c:set var="builderMode" value = "build"/>
<c:if test="${param.reportId != undefined}">
	<c:set var="builderMode" value = "edit"/>
</c:if>

<c:set var="tileReport" value = "false"/>
<c:if test="${param.tile == true && applicationScope.showTileBuilder == 'true' }">
	<c:set var="tileReport" value = "true"/>
</c:if>

<fmt:bundle basename="localization.ReportsPlusMessages">
	<fmt:message key="Build_New_Report" var="pageTitle" />
	<fmt:message key="Build_New_Report" var="headerTitle" />
	<fmt:message key="Edit_Report" var="headerTitleText" />
	<fmt:message key="Legend.rightPosition" var="rightPosition" />
	<fmt:message key="Legend.bottomPosition" var="bottomPosition" />
	<fmt:message key="Legend.horizontalDirection" var="horzontalDirection" />
	<fmt:message key="Legend.verticalDirection" var="verticalDirection" />
	<fmt:message key="Charts.horizontalBar" var="horizontalBar" />
	<fmt:message key="Charts.verticalBar" var="verticalBar" />
	<fmt:message key="Charts.horizontalStackedBar"
		var="horzontalStackedBar" />
	<fmt:message key="Charts.verticalStackedBar" var="verticalStackedBar" />
	<fmt:message key="Charts.horizontalGroupedBar"
		var="horizontalGroupedBar" />
	<fmt:message key="Charts.verticalGroupedBar" var="verticalGroupedBar" />
	<fmt:message key="Charts.line" var="line" />
	<fmt:message key="Legend.pie" var="pie" />

	<c:set var="breadCrumbValues" value="" />
	<jsp:include page="../common/headerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="webconsole" name="applicationName" />
	<jsp:param value="${builderMode}" name="customReportsMode" />
	<jsp:param value="reportsplus/reportHeader.jsp" name="jsp"/>
	<jsp:param value="Report Builder" name="titleLocalized" />
		<jsp:param value="Report Builder" name="headerTitleLocalized" />
		<jsp:param value="${param.reportId}" name="reportId"/>
		<jsp:param value="false" name="includeCrDescription" />
		<jsp:param value="true" name="includeHistory" />
		<jsp:param value="true" name="changePage" />
		<jsp:param value="true" name="isCustomReports" />
	</jsp:include>


    <!-- Wrapper to assign an AngularJS module -->
	<div id="reportArea" data-ng-app="reportsbuilder" data-ng-controller="reportsCtrl" data-ng-init="init(null, null, true)" data-ng-class="{'isTileReport': ${tileReport == 'true'}}" >
	<div id="handler-app"  data-ng-controller="actionEventCtrl" ></div>
	<div data-ng-controller="pageController as pgc">
	<jsp:include page="titleHeader.jsp" >
		<jsp:param value="true" name="editEnabled" />
	</jsp:include>
	    <!-- Div to stretch white background down behind absolutely positioned div -->
	    <div id="bgDiv" data-sticky-scroll data-sticky-scroll-limit="0"> 	</div>

	    <!-- Wrapper for all three columns -->
	    <div id="colWrapper" class="noSelect" data-sticky-scroll data-sticky-scroll-limit="0">
	        <!-- Container for left data sets column -->
	        <div id="leftCol" data-ng-cloak>


<!-- FIXME: Localize -->
<!-- 	            <div class="colHeader">Data Sets</div> -->
	            <div data-ng-include="'leftPanel/leftPanel.jsp'" class="full-height"></div>
	        </div>


	        <!-- End left data sets column -->


	        <!-- Container for center report builder column -->
	        <div id="centerCol" data-ng-cloak  >
	        	<div class="row" style="margin-right: 1px;">
	            	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-right: 0px">
            			<ul class="m-header primary-background-color" cv-rpt-sortable="customReport.pages">
            				<li class="page-tab center-tab-bg" data-ng-repeat="p in customReport.pages" cv-rpt-sortable-item="$index" data-ng-click="setActivePageByName(p.pageName);setActiveComponent(p, 'page')" data-ng-class="{'page-tab-active': selectedPage.pageName === p.pageName}">
            					<div class="page-title" title="{{p.pageName}}">{{customReport.showPagesAsTabs ? p.pageTitle.text : p.pageName}}</div>
            					<span class="ico ico-cross2 page-tab-icons" data-ng-click="setActivePageByName(p.pageName);deleteCurrentPage()" data-ng-class="{'page-tab-icons-off': selectedPage.pageName != p.pageName}"  title='<fmt:message key="CustomReport.Properties.DeletePageTooltip"/>'></span>
            					<span class="ico ico-wrench page-tab-icons" data-ng-click="setActiveComponent(p, 'page',$event);rightCollapsed=false;toggleRightPanel('properties',true)" data-ng-class="{'page-tab-icons-off': selectedPage.pageName != p.pageName}"  title="<fmt:message key='CustomReport.Properties.Paging'/>"></span>
            				</li>
            				<li class="new-tab" data-ng-click="addPage()" title='<fmt:message key="CustomReport.Properties.AddPageTooltip"/>'>
            					<span class="ico ico-plus-circle"></span>
            				</li>
            			</ul>
            		</div>
            	</div>
	        </div>
	        <!-- End center report builder column -->


	        <!-- Container for right properties column -->
	        <div id="rightCol" class="panel-three primary-background-color">
<!-- FIXME: Localize -->
				<div class="right-panel primary-background-color">
        			<div class="m-header primary-background-color col-lg-6 noLftRghtPadding" data-ng-click="displayProperties.selectedRightPanel='visualization'" data-ng-class="{'m-header-selected': displayProperties.selectedRightPanel==='visualization'}">
	        			<span class="ico ico-chevron-right right-toggle-icon" data-ng-click="toggleRightPanel(undefined,undefined,$event)" title="<fmt:message key='CustomReport.CollapsePanel'/>"></span>
        				<span title="<fmt:message key='CustomReport.Visualization'/>"><fmt:message key="CustomReport.Visualization"/></span>
        			</div>
        			<div class="m-header primary-background-color col-lg-6" data-ng-click="displayProperties.selectedRightPanel='properties'" data-ng-class="{'m-header-selected': displayProperties.selectedRightPanel==='properties'}" title="<fmt:message key='CustomReport.Properties'/>"><fmt:message key='CustomReport.Properties'/></div>
					<div class="right-splitter ui-resizable-handle ui-resizable-w"></div>
					<div class="panel-scroll">
					<div class="row noLftRghtMargin components-panel" data-ng-show="displayProperties.selectedRightPanel==='visualization'">
		            	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12" style="padding-left:5px" data-ng-init="categoryCollapsed={}">
	            			<div>
	            				<div data-ng-show="isTileBuilder" class="row noLftRghtMargin secondary-header property-header" title="Templates">
							        <!-- <span class="ico-chart-growth ico-colors"></span> -->
							        <div class="col-xs-12 noLftRghtPadding" data-ng-click="categoryCollapsed['tileTemplate']=!categoryCollapsed['tileTemplate']" data-ng-init="categoryCollapsed['tileTemplate']=false">
							        	<span data-ng-class="{'ico ico-chevron-down':!categoryCollapsed['tileTemplate'], 'ico ico-chevron-right':categoryCollapsed['tileTemplate']}"></span>
							        	<span>Tile Template</span>
							        </div>
							        <div class="col-xs-12 noLftRghtPadding" data-ng-show="!categoryCollapsed['tileTemplate']">
		        		                <div class="component col-xs-12 col-sm-12 col-md-12 col-lg-12 primary-background-color"
		        	                         x-lvl-draggable="true"
		        	                         data-ng-repeat="comp in components"
		        	                         data-componentType="{{comp.componentType}}"
		        	                         data-type="{{comp.type}}"
		        	                         data-componentdrag="true"
		        							 data-defaultTitle = "{{comp.defaultTitle}}"
		        							 data-ng-class="{'component-selected' :  comp.componentType === activeComponent.type}" data-ng-show="comp.category==='tileTemplate'" title="{{comp.label}}">
		        	                        <div class="componentWrapper">
		        	                            <span class="ico-colors" data-ng-class="comp.sprite"></span>
		        	                            <span class="component-label" data-ng-bind="comp.label"></span>
		        	                            <br>
		        	                        </div>
		        	                    </div>
							        </div>
							    </div>
							    <div class="row noLftRghtMargin secondary-header property-header" title="Chart">
							        <!-- <span class="ico-chart-growth ico-colors"></span> -->
							        <div class="col-xs-12 noLftRghtPadding" data-ng-click="categoryCollapsed['chart']=!categoryCollapsed['chart']" data-ng-init="categoryCollapsed['chart']=false">
							        	<span data-ng-class="{'ico ico-chevron-down':!categoryCollapsed['chart'], 'ico ico-chevron-right':categoryCollapsed['chart']}"></span>
							        	<span><fmt:message key='CustomReport.Chart'/></span>
							        </div>
							        <div class="col-xs-12 noLftRghtPadding" data-ng-show="!categoryCollapsed['chart']">
		        		                <div class="component col-xs-12 col-sm-12 col-md-12 col-lg-12 primary-background-color"
		        	                         x-lvl-draggable="true"
		        	                         data-ng-repeat="comp in components"
		        	                         data-componentType="{{comp.componentType}}"
		        	                         data-type="{{comp.type}}"
		        	                         data-componentdrag="true"
		        							 data-defaultTitle = "{{comp.defaultTitle}}"
		        							 data-ng-class="{'component-selected' : comp.componentType === activeComponent.type ? (comp.componentType==='CHART'?(comp.type===activeComponent.chartType?true:false):true) : false}" data-ng-show="(comp.category==='chart' || (comp.category === 'tileMultiChart' && isTileBuilder))" title="{{comp.label}}">
		        	                        <div class="componentWrapper">
		        	                            <span class="ico-colors" data-ng-class="comp.sprite"></span>
		        	                            <span class="component-label" data-ng-bind="comp.label"></span>
		        	                            <br>
		        	                        </div>
		        	                    </div>
							        </div>
							    </div>
							    <div class="row noLftRghtMargin secondary-header property-header" title="Table" >
							        <!-- <span class="ico-border-all ico-colors"></span> -->
							        <div class="col-xs-12 noLftRghtPadding" data-ng-click="categoryCollapsed['table']=!categoryCollapsed['table']" data-ng-init="categoryCollapsed['table']=false">
							        	<span data-ng-class="{'ico ico-chevron-down':!categoryCollapsed['table'], 'ico ico-chevron-right':categoryCollapsed['table']}"></span>
							        	<span><fmt:message key='CustomReport.Table'/></span>
							        </div>
        					        <div class="col-xs-12 noLftRghtPadding" data-ng-show="!categoryCollapsed['table']">
                		                <div class="component col-xs-12 col-sm-12 col-md-12 col-lg-12 primary-background-color"
                	                         x-lvl-draggable="true"
                	                         data-ng-repeat="comp in components"
                	                         data-componentType="{{comp.componentType}}"
                	                         data-type="{{comp.type}}"
                	                         data-componentdrag="true"
                							 data-defaultTitle = "{{comp.defaultTitle}}"
                							 data-ng-class="{'component-selected' : comp.componentType === activeComponent.type}" data-ng-show="comp.category==='table'" title="{{comp.label}}">
                	                        <div class="componentWrapper">
                	                            <span class="ico-colors" data-ng-class="comp.sprite"></span>
                	                            <span class="component-label" data-ng-bind="comp.label"></span>
                	                            <br>
                	                        </div>
                	                    </div>
        					        </div>
							    </div>
							    <div class="row noLftRghtMargin secondary-header property-header" title="Form" data-ng-show="showFormComponents">
							        <!-- <span class="ico-menu3 ico-colors"></span> -->
							        <div class="col-xs-12 noLftRghtPadding" data-ng-click="categoryCollapsed['form']=!categoryCollapsed['form']" data-ng-init="categoryCollapsed['form']=false">
							        	<span data-ng-class="{'ico ico-chevron-down':!categoryCollapsed['form'], 'ico ico-chevron-right':categoryCollapsed['form']}"></span>
							        	<span><fmt:message key='CustomReport.Form'/></span>
							        </div>
        					        <div class="col-xs-12 noLftRghtPadding" data-ng-show="!categoryCollapsed['form']">
                		                <div class="component col-xs-12 col-sm-12 col-md-12 col-lg-12 primary-background-color"
                	                         x-lvl-draggable="true"
                	                         data-ng-repeat="comp in components"
                	                         data-componentType="{{comp.componentType}}"
                	                         data-type="{{comp.type}}"
                	                         data-componentdrag="true"
                							 data-defaultTitle = "{{comp.defaultTitle}}"
                							 data-ng-class="{'component-selected' : comp.componentType === activeComponent.type}" data-ng-show="comp.category==='form'" title="{{comp.label}}">
                	                        <div class="componentWrapper">
                	                            <span class="ico-colors" data-ng-class="comp.sprite"></span>
                	                            <span class="component-label" data-ng-bind="comp.label"></span>
                	                            <br>
                	                        </div>
                	                    </div>
        					        </div>
							    </div>
							    <div class="row noLftRghtMargin secondary-header property-header" title="Other" >
							        <!-- <span class="ico-list4 ico-colors"></span> -->
							        <div class="col-xs-12 noLftRghtPadding" data-ng-click="categoryCollapsed['other']=!categoryCollapsed['other']" data-ng-init="categoryCollapsed['other']=false">
							        	<span data-ng-class="{'ico ico-chevron-down':!categoryCollapsed['other'], 'ico ico-chevron-right':categoryCollapsed['other']}"></span>
							        	<span><fmt:message key='CustomReport.Other'/></span>
							        </div>
        					        <div class="col-xs-12 noLftRghtPadding" data-ng-show="!categoryCollapsed['other']">
                		                <div class="component col-xs-12 col-sm-12 col-md-12 col-lg-12 primary-background-color"
                	                         x-lvl-draggable="true"
                	                         data-ng-repeat="comp in components"
                	                         data-componentType="{{comp.componentType}}"
                	                         data-type="{{comp.type}}"
                	                         data-componentdrag="true"
                							 data-defaultTitle = "{{comp.defaultTitle}}"
                							 data-ng-class="{'component-selected' : comp.componentType === activeComponent.type}" data-ng-show="comp.category==='other'" title="{{comp.label}}">
                	                        <div class="componentWrapper">
                	                            <span class="ico-colors" data-ng-class="comp.sprite"></span>
                	                            <span class="component-label" data-ng-bind="comp.label"></span>
                	                            <br>
                	                        </div>
                	                    </div>
        					        </div>
							    </div>
							</div>
				            <div id="componentPanel" class="primary-background-color" style="display: none">
				                <div class="component col-xs-4 col-sm-4 col-md-3 col-lg-3 sub-header-icon primary-background-color"
			                         x-lvl-draggable="true"
			                         data-ng-repeat="comp in components"
			                         data-componentType="{{comp.componentType}}"
			                         data-type="{{comp.type}}"
			                         data-componentdrag="true"
									 data-defaultTitle = "{{comp.defaultTitle}}"
									 data-ng-class="{'component-selected' : comp.componentType === activeComponent.type ? (comp.componentType==='CHART'?(comp.type===activeComponent.chartType?true:false):true) : false}" data-ng-show="comp.category===selectedCategory" title="{{comp.label}}">
			                        <div class="componentWrapper">
			                            <span class="ico-colors" data-ng-class="comp.sprite"></span>
			                            <br>
			                        </div>
			                    </div>
				            </div>
		            	</div>
	            	</div>
	            	<div class="row properties" data-ng-show="displayProperties.selectedRightPanel==='properties'">
		            	<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
	            			<div id="propertiesArea" data-ng-controller="propertiesCtrl">
			                     <div data-ng-if="selectedProperties==='report'" data-ng-include="'properties/reportProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='page'" data-ng-include="'properties/pageProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='chart'" data-ng-include="'properties/chartProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='SCATTER'" data-ng-include="'components/scatter/scatterChart.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='table'" data-ng-include="'properties/tableProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='column'" data-ng-include="'properties/columnProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='button'" data-ng-include="'properties/buttonProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='TAG_CLOUD'" data-ng-include="'components/tagcloud/tagcloud.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='HITS'" data-ng-include="'components/hits/hits.properties.jsp'"></div>
								 <div data-ng-if="selectedProperties==='CUSTOM'" data-ng-include="'properties/customHtmlProperties.jsp'"></div>
								 <div data-ng-if="selectedProperties==='LEGEND'" data-ng-include="'properties/legendProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='MAP_v2' || selectedProperties==='MAP'" data-ng-include="'components/map/v2/map.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='SEARCH_BAR'" data-ng-include="'components/searchbar/searchbar.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='DATE_RANGE'" data-ng-include="'components/daterange/daterange.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='KENDO_GRID'" data-ng-include="'components/kendoui/datagrid.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='NEW_TABLE'" data-ng-include="'components/kendoui/newTable.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='KENDO_TREEGRID'" data-ng-include="'components/kendoui/treegrid.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='FACET'" data-ng-include="'components/facet/facet.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='PANEL_HEADER'" data-ng-include="'components/panel-header/panel-header.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='PANEL'" data-ng-include="'components/panel/panel.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='R-GGPlot'" data-ng-include="'components/R/GGPlot/R-GGPlot.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='IFRAME'" data-ng-include="'components/frame/frameProperties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='TABS'" data-ng-include="'components/tabs/tabs.properties.jsp'"></div>
			                     <div data-ng-if="selectedProperties==='TOPOLOGY'" data-ng-include="'components/topology/topology.properties.jsp'"></div>
	                		</div>
		            	</div>
	            	</div>
	            	</div>
	            </div>
	        </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12 panel-one right-panel-toggle" style="display:none;">
        		<div class="later">
        			<div class="rhtpnlseltab" title="Visualization" data-ng-click="toggleRightPanel('visualization')" data-ng-class="{'lft-active-panel-tab': displayProperties.selectedRightPanel==='visualization'}"><fmt:message key='CustomReport.Visualization'/></div>
        			<div class="rhtpnlseltab" title="Properties" data-ng-click="toggleRightPanel('properties')" data-ng-class="{'lft-active-panel-tab': displayProperties.selectedRightPanel==='properties'}"><fmt:message key='CustomReport.Properties'/></div>
        		</div>
        	</div>
	        <!-- End right properties column -->
	    </div>
	    <!-- End column wrapper -->

	    <!--
    	    By keeping this outside of the main column layout, we are
    	    able to keep the scroll bar attached to the main window,
    	    rather than the frame of the div
	    -->
	    <div id="pageDiv">
		      	<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/builderPage.jsp'"></div>
		 </div>

	</div>
	</div>
	<!-- End app wrapper -->

	<script type="text/javascript" nonce="${sessionScope.cspNonce}" >
		var crMode = "builder";
		var isMetricsInstalled = "${applicationScope.METRICS_INSTALLED}";
		var showFilterOptions = "${sessionScope.showFilterOptions}";
	</script>


	<form id="previewForm"  class="hideOnExportFriendly"  method="post" action="${pageContext.request.contextPath}/reportsplus/previewReport.do?includeDrafts=true&isPreview=true" target="PreviewWindow">
		<input id= "previewCustomReport" type="hidden" name="report" />
		<input id= "previewAction" type="hidden" name="action" />
		<input type="hidden" name="isPreview" value=true />
	</form>



</fmt:bundle>
<c:set var="isDcubeEnabledInCustomReports" value="${cvConfig.isDcubeEnabledInCustomReports()}"/>
<jsp:include page="../common/footerV3.jsp">
	<jsp:param value="../common/js/jquery.loadmask.cv.js" name="js"/>
	<jsp:param value="true" name="bootstrapped" />
</jsp:include>