//Closure to isolate scope, as per best practices
(function() {
	"use strict";

	// Get a reference to the reportsBuilder module
	var app = angular.module("reports");

	app
	.directive("topologyChart",
		[
			'customReportSvc',
			'$timeout',
			"dataSource",
			function(customReportSvc, $timeout, $dataSource) {
				return {
					restrict : "AEC",
					scope : false,
					link : function(scope, elem, attr) {

					},
					templateUrl : customReports.contextPath +
					'/reportsplus/components/topology/topology.jsp',
					controller : ['$scope', function($scope) {

            cvUtil.lazyLoad({
                urls : [ '/webconsole/reportsplus/js/visjs/vis.min.js'],
                success : function() {
                    console.log("LazyLoad Working");
                }
            });

						var componentTitleHeight = 53;
						customReportSvc.registerCallback("redrawAllComponents", function(data) {
							$scope.loadComponent();
						});
						var numberTypes = [ "Double", "Float", "Integer", "Long", "Short", "Decimal" ];
						function getTopologyConfig() {
							var config = {};
							return config;
						}
						// backward compatibility.
						if ($scope.component.topologyProps && $scope.component.topologyProps.nodes && $scope.component.topologyProps.nodes.dataSet 
							  && $scope.component.topologyProps.nodes.dataSet.dataSet) {
							$scope.component.topologyProps.nodes.dataSet = $scope.component.topologyProps.nodes.dataSet.dataSet;
						}
						if ($scope.component.topologyProps && $scope.component.topologyProps.edges && $scope.component.topologyProps.edges.dataSet 
							&& $scope.component.topologyProps.edges.dataSet.dataSet) {
							$scope.component.topologyProps.edges.dataSet = $scope.component.topologyProps.edges.dataSet.dataSet;
						}

						$scope.loadComponent = function() {
							$scope.showNoDataDiv = false;
							// show loading on top
							$scope.component.isComponentLoading = true;
							$scope.loadingButton();
							var height = $("li[comp=" + $scope.component.id + "]>div").height() - componentTitleHeight;
							var width = $("li[comp=" + $scope.component.id + "]>div").width();
							$scope.chartConfig = getTopologyConfig();
							if (!$scope.component.topologyProps) {
								$scope.component.topologyProps = {
									nodesId: $scope.component.nodesId.name,
									nodesLabel: $scope.component.nodesLabel.name,
									edgesFrom: $scope.component.edgesFrom.name,
									edgesTo: $scope.component.edgesTo.name,
									width: width,
									height: height
								};
							} else {
								$scope.component.topologyProps.width = width;
								$scope.component.topologyProps.height = height;
							}
							if (!$scope.component.topologyProps.nodes.id || !$scope.component.topologyProps.nodes.label || 
									!$scope.component.topologyProps.edges.from || !$scope.component.topologyProps.edges.to) {
								$scope.component.isComponentLoading = false;
								$scope.showNoDataDiv = true;
								deleteComponent();
								return;
							}
							if (!$scope.component.edgesFrom || ($scope.component.edgesFrom.name !== $scope.component.topologyProps.edges.from)) {
								$scope.component.edgesFrom = $scope.component.topologyProps.edges.from;
							}
							if (!$scope.component.edgesTo || ($scope.component.edgesTo.name !== $scope.component.topologyProps.edges.to)) {
								$scope.component.edgesTo = $scope.component.topologyProps.edges.to
							}
							if (!$scope.component.nodesId || ($scope.component.nodesId.name !== $scope.component.topologyProps.nodes.id)) {
								$scope.component.nodesId = $scope.component.topologyProps.nodes.id
							}
							if (!$scope.component.nodesLabel || ($scope.component.nodesLabel.name !== $scope.component.topologyProps.nodes.label)) {
								$scope.component.nodesLabel = $scope.component.topologyProps.nodes.label;
							}
							var nodesPromise, edgesPromise;
							var edgesDataSet = $scope.getDataSet($scope.component.topologyProps.edges.dataSet.dataSetName, 'name');
							if (!$.isEmptyObject(edgesDataSet) && edgesDataSet.endpoint === 'DATACUBE') {
								var edgesDataField = [];
								var edgesFromColumn = {
									'column' : $scope.component.edgesFrom.name,
									'dataField' : $scope.component.edgesFrom.dataField,
									'sortOrder' : "ASC",
									'aggrType' : 'None'
								};
								var edgesToColumn = {
									'column' : $scope.component.edgesTo.name,
									'dataField' : $scope.component.edgesTo.dataField,
									'sortOrder' : "ASC",
									'aggrType' : 'None'
								};
								edgesDataField.push(edgesFromColumn);
								edgesDataField.push(edgesToColumn);
								var edgesTableParams = {
										columns : edgesDataSet.fields,
										offset : 0,
										limit : limit
								};
								edgesPromise = new Promise(function(resolve, reject) {
									$dataSource.getDataSource(edgesDataSet.endpoint).getMapData({
										dataSet : edgesDataSet,
										componentType : $scope.component.type,
										measureDataField : undefined,
										dimensionDataField : edgesDataField,
										sortOptions : undefined,
										tableParams : edgesTableParams
									}, function(response) {
										if (response) {
											resolve(response);
										} else {
											reject(response);
										}
									});
								})
							} else {
								edgesPromise = $scope.getData(edgesDataSet, false)
							}
							var nodesDataSet = $scope.getDataSet($scope.component.topologyProps.nodes.dataSet.dataSetName, 'name');							
							if (!$.isEmptyObject(nodesDataSet) && nodesDataSet.endpoint === 'DATACUBE') {
								var nodesDataField = [];
							
								var nodesIdColumn = {
									'column' : $scope.component.nodesId.name,
									'dataField' : $scope.component.nodesId.dataField,
									'sortOrder' : "NONE",
									'aggrType' : 'None'
								};
								var nodesLabelColumn = {
									'column' : $scope.component.nodesLabel.name,
									'dataField' : $scope.component.nodesLabel.dataField,
									'sortOrder' : "NONE",
									'aggrType' : 'None'
								};

								nodesDataField.push(nodesIdColumn);
								nodesDataField.push(nodesLabelColumn);

								var nodesTableParams = {
										columns : nodesDataSet.fields,
										offset : 0,
										limit : limit
								};
								// Get Data for Nodes.
								nodesPromise = new Promise(function(resolve, reject) {
									$dataSource.getDataSource(nodesDataSet.endpoint).getMapData({
										dataSet : nodesDataSet,
										componentType : $scope.component.type,
										measureDataField : nodesDataField,
										dimensionDataField : undefined,
										sortOptions : undefined,
										tableParams : nodesTableParams
									}, function(response) {
										if (response) {
											resolve(response);
										} else {
											reject(response);
										}
									});
								})
							} else {
								nodesPromise = $scope.getData(nodesDataSet, true)
							}

							Promise.all([edgesPromise, nodesPromise]).then(function(values) {
								onSuccessGetTopologyData(values)
							});
						}

						if ($scope.component.topologyProps) {
							if ($scope.component.topologyProps.nodes.id && $scope.component.topologyProps.nodes.label && 
									    $scope.component.topologyProps.edges.from && $scope.component.topologyProps.edges.to) {
									$scope.loadComponent();
							}
						}

						var deleteComponent = function() {
							if ($scope.network) {
								$scope.network.destroy();
							}
						}

						var evalExpression = function(expr) {
							return rpt.evalExpression(expr);
						}

						var onSuccessGetTopologyData = function(datas) {
							var edgesData = datas[0];
							var nodesData = datas[1];
							var container = document.getElementById('chart');
							var element = angular.element(container)[0];
							var nodesRows = [];
							nodesData.data.records.map(function (c, idx) {
								var row = {};
								nodesData.data.columns.map(function (col, colIdx) {
									row[col.name] = c[colIdx];
								})
								nodesRows.push(row);
							})
							var edgesRows = [];
							edgesData.data.records.map(function (c, idx) {
								var row = {};
								edgesData.data.columns.map(function (col, colIdx) {
									row[col.name] = c[colIdx];
								})
								edgesRows.push(row);
							})
							
							$scope.masked = !(nodesData.data.records.length > 0);
							$scope.nodes = new vis.DataSet(
								nodesRows.map(function (node, idx) {
									var nodeData = {
										id: node[$scope.component.nodesId.name],
										label: node[$scope.component.nodesLabel.name],
										font: {
											multi: true,
										}
									}
									if ($scope.component.topologyProps.nodes.labelExpr) {
										nodeData['label'] = evalExpression({
											expression: $scope.component.topologyProps.nodes.labelExpr,
											nodeRows: nodesRows,
											row: node,
										});
									}
									if ($scope.component.topologyProps.nodes.color) {
										nodeData['color'] = evalExpression({
											expression: $scope.component.topologyProps.nodes.color,
											nodeRows: nodesRows,
											row: node,
										});
									}
									if ($scope.component.topologyProps.nodes.size) {
										nodeData['value'] = evalExpression({
											expression: $scope.component.topologyProps.nodes.size,
											nodeRows: nodesRows,
											row: node,
										});
									}
									if ($scope.component.topologyProps.nodes.tooltip) {
										nodeData['title'] = evalExpression({
											expression: $scope.component.topologyProps.nodes.tooltip,
											nodeRows: nodesRows,
											row: node,
										});
									}
									if ($scope.component.topologyProps.nodes.shape) {
										nodeData['shape'] = evalExpression({
											expression: $scope.component.topologyProps.nodes.shape,
											nodeRows: nodesRows,
											row: node,
										});
									}
									if ($scope.component.topologyProps.nodes.image) {
										var imageUrl = evalExpression({
											expression: $scope.component.topologyProps.nodes.image,
											nodeRows: nodesRows,
											row: node,
										});
										if (!imageUrl) {
											// console.log('ignoring image');
										} else {
											nodeData['shape'] = 'image';
											nodeData['image'] = imageUrl;
										}
									}
									return nodeData;
								})
							)
							$scope.edges = new vis.DataSet(
								edgesRows.map(function (edge, idx) {
									var edgeData = {
										from: edge[$scope.component.edgesFrom.name],
										to: edge[$scope.component.edgesTo.name],
										font: {
											multi: true,
										}
									}
									if ($scope.component.topologyProps.edges.labelExpr) {
										edgeData['label'] = evalExpression({
											expression: $scope.component.topologyProps.edges.labelExpr,
											edgeRows: edgesRows,
											row: edge,
										});
									}
									if ($scope.component.topologyProps.edges.arrows) {
										var arrowEnd = false;
										var arrowStart = false;
										switch(evalExpression({
											expression: $scope.component.topologyProps.edges.arrows,
											edgeRows: edgesRows,
											row: edge,
										})) {
											case 'right':
												arrowEnd = true;
												break;
											case 'left':
												arrowStart = true;
												break;
											case 'both':
												arrowEnd = true;
												arrowStart = true;
												break;
											default:
												break;
										}
										if (arrowStart) {
											if (!edgeData.arrows) {
												edgeData.arrows = {};
											}
											edgeData.arrows.from = arrowStart;
										}
										if (arrowEnd) {
											if (!edgeData.arrows) {
												edgeData.arrows = {};
											}
											edgeData.arrows.to = arrowEnd;
										}
									}
									return edgeData
								})
							)

							if (!$scope.nodes || !$scope.edges) {
								return;
							}

							var data = {
								nodes: $scope.nodes,
								edges: $scope.edges
							}

							// check if width is 0 
							if (!$scope.component.topologyProps.width) {
								$scope.component.topologyProps.width =  $("li[comp=" + $scope.component.id + "]>div").width();
							}

							var options = {
								height: $scope.component.topologyProps.height + 'px',
								width: $scope.component.topologyProps.width + 'px',
								// nodes: 
							}

							$scope.network = new vis.Network(element, data, options);
							$scope.showNoDataDiv = false;
							$scope.component.isComponentLoading = false;
						}

						$scope.$watch('dataSetUpdated', function (updatedDataset) {
							if (!updatedDataset) {
								return;
							}
							if ($scope.component.topologyProps) {
								if ($scope.component.topologyProps.nodes && 
										$scope.component.topologyProps.nodes.dataSet.dataSetName == updatedDataset.dataSet.originalDataSetName) {
											$scope.component.topologyProps.nodes.dataSet = updatedDataset.dataSet;
											$scope.loadComponent();
								} else if ($scope.component.topologyProps.edges &&
									$scope.component.topologyProps.edges.dataSet.dataSetName == updatedDataset.dataSet.originalDataSetName) {
										$scope.component.topologyProps.edges.dataSet = updatedDataset.dataSet;
										$scope.loadComponent();
								}
							}
						})

						$scope.reloadComponent = function(refreshCache) {
							$scope.loadComponent();
						};

						$scope.dropped = function(dragEl, dropEl) {
							var source = document.getElementById(dragEl);
							if ($scope.reportMode == "viewer") {
								return;
							}

							if (!$scope.component.isSelected) {
								customReportSvc.errorToast('Select the component to add a column.');
								return;
							}

							var dest = document.getElementById(dropEl);
							var src = document.getElementById(dragEl);
							var drag = angular.element(src);
							var drop = angular.element(dest);
							var dropType = drop.data('droptype');

							var columnName = drag.attr("data-name");
							var columnType = drag.attr("data-type");
							var origType = drag.attr("data-origtype");
							var dataField = drag.attr("data-datafield");
							var dataSetEntity = drag.data("datasetentity");
							var dataSetName = dataSetEntity.dataSetName;
							
							if (!$scope.component.topologyProps) {
								$scope.component.topologyProps = {
									nodes: {
										shape: 'ellipse'
									},
									edges: {
										arrowStart: false,
										arrowEnd: false,
									}
								};
							}

							if (_.contains(['nodesId', 'nodesLabel'], dropType)) {
								if (!$scope.component.topologyProps.nodes.dataSet) {
									$scope.associateDataSetToTopology(dataSetEntity, true);
								} else if ($scope.component.topologyProps.nodes.dataSet.dataSetName !== dataSetName) {
									alert('Mismatched data sets for nodes');
									return;
								}
							} else {
								if (!$scope.component.topologyProps.edges.dataSet) {
									$scope.associateDataSetToTopology(dataSetEntity, false);
								} else if ($scope.component.topologyProps.edges.dataSet.dataSetName !== dataSetName) {
									alert('Mismatched data sets for edges');
									return;
								}
							}

							// if ((drop.data('droptype') == "nodes" || drop.data('droptype') == "edges") && !$scope.isNumberColumn(columnType)) {
							// 	customReportSvc.errorToast("Please drop a field of type Double, Float, Integer, Long, Short or Decimal");
							// 	return;
							// }

							var column = {
								name : columnName,
								dataField : dataField,
								type : columnType,
							};
							
							if (drop.data('droptype') == "nodesId") {
								$scope.component.nodesId = column;
								$scope.component.topologyProps.nodes.id = column;
							} else if (drop.data('droptype') == "nodesLabel") {
								$scope.component.nodesLabel = column;
								$scope.component.topologyProps.nodes.label = column;
							} else if (drop.data('droptype') == "edgesFrom") {
								$scope.component.edgesFrom = column;
								$scope.component.topologyProps.edges.from = column;
							} else if (drop.data('droptype') == "edgesTo") {
								$scope.component.edgesTo = column;
								$scope.component.topologyProps.edges.to = column;
							}

							$scope.loadComponent();
							$scope.$apply();
						};

						$scope.deleteColumn = function(type, field) {
							if (type === 'nodes') {
								if (field === 'id') {
									$scope.component.nodesId = undefined;
									$scope.component.topologyProps.nodes.id = undefined;
								} else if (field === 'label') {
									$scope.component.nodesLabel = undefined;
									$scope.component.topologyProps.nodes.label = undefined;
								}
							} else if (type === 'edges') {
								if (field === 'from') {
									$scope.component.edgesFrom = undefined;
									$scope.component.topologyProps.edges.from = undefined;
								} else if (field === 'to') {
									$scope.component.edgesTo = undefined;
									$scope.component.topologyProps.edges.to = undefined;
								}
							}
							$scope.loadComponent();
						}

						 $scope.isNumberColumn = function(type) {
							 return numberTypes.indexOf(type) != -1;
						 }

						 customReportSvc.registerCallback("updateChart", function() {
								$scope.loadComponent();
						 }, $scope.component.id);

						 customReportSvc.registerCallback("refreshComponent", function(componentId) {
							 if ($scope.component.id === componentId) {
								 $scope.loadComponent();
							 }
						 }, $scope.component.id);

						 var resizeTopology = function() {
							$scope.component.topologyProps.height = $("li[comp=" + $scope.component.id + "]>div").height();
							if ($scope.reportMode == 'builder') {
								$scope.component.topologyProps.height = $scope.component.topologyProps.height - componentTitleHeight;
							}
							$scope.component.topologyProps.width = $("li[comp=" + $scope.component.id + "]>div").width();
							var options = {
								height: $scope.component.topologyProps.height + 'px',
								width: $scope.component.topologyProps.width + 'px'
							};
							$scope.network.setOptions(options);
							$scope.network.fit({nodes: $scope.nodes.map(function (node) {return node.id})});
						 }

						 $scope.$on('resize', function(sizes, gridster) {
							 if (gridster && gridster.length > 1) {
								 var componentResizedScope = angular
								 .element(gridster[1]).scope();
								 var component = componentResizedScope.$parent.component;
								 var currentCompId = component.id;
								 if ($scope.component.id == currentCompId) {
									 if (component.chartType === 'topology' && $scope.chartConfig) {
										 	$timeout(function() {
												resizeTopology()
										 }, 50);
									 }
								 }
							 }
						 });

						$scope.$on('chartRedraw', function(e, componentId) {
						 	if ($scope.chartConfig && typeof $scope.chartConfig.getHighcharts === 'function' &&
						 			$scope.isLayoutAvailable && $scope.component.id == componentId && $scope.component.chartType === 'scatter') {
						 		$timeout(function(){
									resizeTopology();	 					 
						 		});
							 }
						 });

						$scope.$on('gridsterItemWidthChanged', function(event, isLeftPanelToggle, componentId) {
							if ($scope.chartConfig) {
								$timeout(function() {
									if (!isLeftPanelToggle && $scope.component.id == componentId &&
										$scope.component.chartType === 'topology') {
										resizeTopology();
									}
								}, 1);
							}
						 });

					 }]
				 }
			 } ]);

})();
