<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
    <li class="sub-header" title="Filters" data-ng-show="ds && ds.endpoint === 'DATACUBE'" data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" data-ng-click="selectedPropertyCategory='filters'">
        <span class="ico ico-funnel"></span>
    </li>
</ul>

<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">    
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.title.text"
                       type="text"
                       placeholder="<fmt:message key="CustomReport.Properties.ComponentName"/>">
                </div>
            </div>                  
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input name="chartid" class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">                
                </div>
                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>
            </div> 
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
                   readonly="true"
                   data-ng-model="propData.dataSet.dataSetName">
                </div>
            </div> 
        </div>
    </div>  
<!-- End "General" group -->

<!-- Begin "Look and Feel" group -->
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Alignment"/>'><fmt:message key="CustomReport.Properties.Alignment"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <select  class="form-control fieldPropValue input-sm" data-ng-model="propData.tagCloudProp.alignment" data-ng-change="updateChart()">                        
                        <option value="Random"><fmt:message key="CustomReport.Random"/></option>
                        <option value="Horizontal"><fmt:message key="Horizontal"/></option>
                        <option value="Vertical"><fmt:message key="Vertical"/></option>
                    </select>
                </div>
            </div>                                    
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.FontScale"/>'> <fmt:message key="CustomReport.Properties.FontScale"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input type="number" class="fieldPropValue form-contorl input-sm" data-ng-model="propData.tagCloudProp.fontScale" data-ng-blur="updateChart()"/>
                </div>
            </div>                                
        </div>
    </div>
     <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['otherProperties']=!collapsed['otherProperties']" data-ng-show="propData.dimensionDataField.length>0">
        <div class="col-xs-12 noLftRghtPadding">
            <span data-ng-class="{'ico ico-chevron-down':!collapsed['otherProperties'], 'ico ico-chevron-right':collapsed['otherProperties']}"></span>
            <span>Custom Groups</span>           
        </div>
    </div>    
     <div data-ng-class="{'collapsed': collapsed['otherProperties']}" data-ng-show="propData.dimensionDataField.length>0">
         <div class="row noLftRghtMargin" data-ng-repeat="dimension in propData.dimensionDataField">
             <div class="row noLftRghtMargin">
                 <div class="col-xs-12">
                     <div class="form-group">
                         <label class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding" title='{{dimension.column}}'>                                
                             {{dimension.column}}
                         </label>
                         <div class="col-sm-5 noLftRghtPadding">                     
                             <span class="pull-left" style="margin-top: 3px">                                    
                                 <input type="checkbox" cv-toggle-switch data-ng-model="dimension.customGroupsAvailable" id="customgroup{{$index}}" data-ng-click="updateCustomGroupsAvailable(dimension)">
                             </span>                                
                             <span class="ico ico-pencil pro-btn-algn cursor-pointer pull-right" data-ng-click="showAdditionalProperties(dimension)" data-ng-show="dimension.customGroupsAvailable"></span>
                         </div>
                     </div>                        
                 </div>
             </div>
         </div>
     </div>  
     <!--  End "Look and Feel" group -->
     <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>      
	<entity-security data-item="propData"></entity-security>
</div>


<!-- Begin "Y-axis" group -->
<div data-ng-show="selectedPropertyCategory==='fields'">
    <div class="row noLftRghtMargin secondary-header property-header" data-ng-click="collapsed['measure']=!collapsed['measure']">
       <div class="col-xs-12 noLftRghtPadding">
           <span class="ico" data-ng-class="{'ico-chevron-down':!collapsed['measure'], 'ico-chevron-right':collapsed['measure']}" style="margin-right:5px"></span>
           <span>Measure</span>
       </div>
   </div>
    <div data-ng-if="propData.measureDataField && propData.measureDataField.length!=0" data-ng-class="{'collapsed': collapsed['measure']}">        
        <div data-ng-repeat="measure in propData.measureDataField">
            <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
                <div class="fieldHeader"  data-ng-click="collapsed['measure'+$index]=!collapsed['measure'+$index]">                
                    <label  class="col-lg-9 noLftRghtPadding">
                       <span data-ng-if="measure.aggrType!='None'">{{measure.aggrType}}(</span>{{measure.column}}<span data-ng-if="measure.aggrType!='None'">)</span>
                    </label>
                   <span class="pull-right">
                        <span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed['measure'+$index], 'ico-chevron-right':collapsed['measure'+$index]}" style="margin-right:5px"></span>
                        <span class="ico ico-trash2 inner-panel-expand-icon" title="Remove Measure" data-ng-click="deleteMeasure($index)" ></span>
                    </span>                                     
               </div>
               <div data-ng-class="{'collapsed': collapsed['measure'+$index]}">
                   <div class="row noLftRghtMargin" data-ng-if="propData.measureDataField.length>1">                    
                        <div class="col-xs-12 noLftRghtPadding">
                            <div class="form-group">
                                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.LegendLabel"/>'><fmt:message key="CustomReport.Properties.LegendLabel"/></label>
                                <div class="col-sm-8 noLftRghtPadding">
                                    <input class="fieldTitleText form-control input-sm" data-ng-model="measure.title.text" data-ng-blur="updateChart()" type="text">
                                </div>
                            </div>                                                      
                         </div>
                    </div>
                     <div id="measureAggregate">
                        <div class="form-group">
                            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Aggregate"/>'> <fmt:message key="CustomReport.Properties.Aggregate"/></label>
                            <div class="col-sm-8 noLftRghtPadding">
                                <select  class="fieldPropValue input-sm" data-ng-model="measure.aggrType" data-ng-change="updateChart()">
                                    <option  data-ng-if="measure.showNumberOps" value="None"><fmt:message key="CustomReport.None"/></option>
                                    <option value="Count"><fmt:message key="CustomReport.Count"/></option>
                                    <option value="CountDistinct"><fmt:message key="CustomReport.Distinct"/></option>
                                    <option data-ng-if="measure.showNumberOps" value="Sum"><fmt:message key="CustomReport.Sum"/></option>
                                    <option data-ng-if="measure.showNumberOps" value="Avg"><fmt:message key="CustomReport.Avg"/></option>
                                    <option data-ng-if="measure.showNumberOps"  value="Min"><fmt:message key="CustomReport.Min"/></option>
                                    <option data-ng-if="measure.showNumberOps" value="Max"><fmt:message key="CustomReport.Max"/></option>
                                </select>
                            </div>
                        </div>                                              
                    </div>	     
                </div>
    </div>
</div>
</div>
</div>

<!-- Begin "Filters" group -->
<div data-ng-show="ds && ds.endpoint === 'DATACUBE' && selectedPropertyCategory==='filters'">        
    <cvfacet config="propData" type="'properties'" page="page" filters="propData.filters" filter-mode="'builder'" report-mode="reportMode"></cvfacet>
</div>
<!-- FIXME: Localize -->
<!-- <a id="resetButton" class="mainBtn" data-ng-click="resetDefault()">
    <fmt:message key="CustomReport.Properties.ResetToDefault"/>
</a> -->

</fmt:bundle>