(function(){
	"use strict";

	angular
		.module("reports")
		.controller("tagCloudCtrl", tagCloudCtrl);

	tagCloudCtrl.$inject = ['$scope', 'reportService', 'customReportSvc', 'dataSource', '$timeout'];

	function tagCloudCtrl($scope, reportService, customReportSvc, dataSource, $timeout) {

		/* TODO need to check what this code is doing and move it to some common place
		* as it is not related to a particular component
		*/
		var exportType = customReportSvc.getParameterByName("exportType");
        var readme = customReportSvc.getParameterByName("readme");
        $scope.setChildScope($scope);
        var isExport = false;
        if (exportType || readme === "true")
            isExport = true;

        if ($scope.component.name && !$scope.component.id) {
            $scope.component.id = angular.copy($scope.component.name);
            $scope.component.name = undefined;
        }
        customReportSvc.setDefaultStyles($scope.component);	// to set default style for a component

        $scope.component.tagcloudconfig = getTagCloudConfig();

        $scope.reloadComponent = function (refreshCache) {
			$scope.getChartData(refreshCache);
		};	

		$scope.getWords = function() {
            var options = {};
            options.dataSet = $scope.dataSet;
            options.componentType = $scope.component.type;
            options.dimensionDataField = $scope.component.dimensionDataField;
            options.measureDataField = $scope.component.measureDataField;
            options.sortOpts = $scope.component.sorting ? $scope.component.sorting[0] : undefined; 
			options.filters = $scope.component.filters && $scope.component.filters['builder'] ? $scope.component.filters['builder'][$scope.dataSet.dataSet.dataSetName]
					: {};
			options.inputParams = customReportSvc.applyInputsToDataSet($scope.dataSet, $scope.page.inputs)
            if (!$scope.dataservice) {
                if ($scope.dataSet)
                    $scope.dataservice = dataSource.getDataSource($scope.dataSet.endpoint);
            }
            if ($scope.dataservice) {
    		    $scope.dataservice.getChartData(options, function(resp){
		        onSuccessGetChartDataForDataSet(resp);
		    });
            }
		};	

        $scope.deleteColumn = function(list, index) {
            //$scope.processing = false;
            list.splice(index, 1);
        };

        $scope.dropped = function(dragEl, dropEl) {
            // Because the handler jumps "outside" of angular, updates must be
            // made in an $applied scope

            var dest = document.getElementById(dropEl);
            var src = document.getElementById(dragEl);

            var drag = angular.element(src);
            var drop = angular.element(dest);
            var columnName = drag.attr("data-name");
            if (columnName == "allColumns") {
                customReportSvc.errorToast('All Fields cannot be used to draw a tag cloud.');
                return;
            }

            var dataSetEntity = drag.data("datasetentity");
            var dataSetName = drag.parent().parent().data("datasetname");
            var isMulti = false;
            if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
                $scope.associateDataSetToComponent(dataSetEntity);
            } else if ($scope.component.dataSet.dataSetName != dataSetName) {
                alert("Mismatched data Sets");
                return;
            }

            // initialize the data field if not already not set
            if (!$scope.component.dimensionDataField) {
                $scope.component.dimensionDataField = [];
            }
            if (!$scope.component.measureDataField) {
                $scope.component.measureDataField = [];
            }

            if (drop.data('droptype') == "xAxis") {

                // if a field is already added to dimension, it can have multiple fields only if there is single/no measure fields, also duplicates are not allowed
                // more than two dimensions cannot be plotted
                // more than one dimension cannot be plotted in a pie chart
           		if($scope.component.dimensionDataField.indexOf(drag.attr("data-name"))!=-1
                    || $scope.component.measureDataField.length > 1){
                    //TODO show proper message that multiple dimension fields cannot be added
                    return;
                }


                var dimension = { 'column': drag.attr("data-name"), 'title': { 'text': drag.attr("data-name") }, sortOrder: 'NONE', isNumeric: false };
                dimension.numPointsToDisplay = {};
                dimension.numPointsToDisplay.maxPoints = $scope.component.dimensionDataField.length == 0 ? 15 : 10;
                dimension.numPointsToDisplay.includeAll = false;
                $scope.component.dimensionDataField.push(dimension);
                // add the default measure same as dimension if there is none
                // Do not add the date field automatically to the Y-Axis for TimeSeries charts
                if ($scope.component.measureDataField.length == 0 && $scope.component.dimensionDataField.length == 1) {
                    // to avoid loading the graph twice
                    $scope.firstDrop = true;
                    var measure = { 'column': drag.attr("data-name"), 'title': { 'text': drag.attr("data-name") }, 'aggrType': 'Count', sortOrder: 'DESC' };
                    $scope.component.measureDataField.push(measure);

                    var arr = ['Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal'];
                    if (arr.indexOf(drag.data('type')) != -1)
                        measure.showNumberOps = true;
                }

            } else if (drop.data('droptype') == "yAxis") {

                // if a field is already added to measure, it can have multiple fields only if there is single/no dimension fields, also duplicates are not allowed
                // more than one dimension cannot be plotted in a pie chart
	            if($scope.component.measureDataField.indexOf(drag.attr("data-name"))!=-1
	                    || ($scope.component.dimensionDataField.length > 1 && $scope.component.measureDataField.length==1)){
	                    //TODO show proper message that multiple measure fields cannot be added
	                    return;
	            }
            	if ($scope.component.measureDataField.length>1)
            		return;

                var measure = { 'column': drag.attr("data-name"), 'title': { 'text': drag.attr("data-name") }, 'aggrType': 'Count', sortOrder: 'DESC' };
                if ($scope.component.measureDataField.length > 0) {
                    measure.aggrType = $scope.component.measureDataField[0].aggrType;
                }                

                $scope.component.measureDataField.push(measure);                
                var arr = ['Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal'];
                if (arr.indexOf(drag.data('type')) != -1)
                    measure.showNumberOps = true;
            }
            $scope.$apply();
        };

        $scope.$watchCollection('component.dimensionDataField', function() {            
            if (!$scope.componentLoaded || $scope.processing)
                return;
            $scope.drawTagCloud(); 
            
        }, true);

        $scope.$watchCollection('component.measureDataField', function() {
            if ($scope.firstDrop) {
                $scope.firstDrop = false;
                return;
            }
            if (!$scope.componentLoaded || $scope.processing)
                return;

            if ($scope.activeComponent == null || $scope.activeComponent == $scope.component) {
                if (!$scope.component.measureDataField) {
                    $scope.disableYDrop = false;
                }                
                $scope.drawTagCloud();
            }

        }, true);

        customReportSvc.registerCallback("updateChart", function() {            
                $scope.drawTagCloud();
        }, $scope.component.id);

        customReportSvc.registerCallback("refreshComponent", function(componentId) {
            if ($scope.component.id === componentId) {
                $scope.drawTagCloud();
            }
        }, $scope.component.id);
        $scope.drawTagCloud = function(isAutoRefresh) {
            var component = $scope.component;               
            if (!$scope.component.tagCloudProp) {
                $scope.component.tagCloudProp = { 
                    alignment: 'Random',
                    fontScale: 1
                };
            }                
            $scope.tagcloudconfig = getTagCloudConfig();            
            $scope.tagcloudconfig.alignment = $scope.component.tagCloudProp.alignment;
            $scope.tagcloudconfig.fontScale = $scope.component.tagCloudProp.fontScale;
                        
            var isValid = false;
            if(component.dimensionDataField && component.measureDataField
                && component.dimensionDataField.length!=0 && component.measureDataField.length!=0){
                isValid = true;
            }

            if (component.measureDataField && component.measureDataField.length!=0)
                isValid = true;            
            if (isValid == true) {
               $scope.component.isComponentLoading = true;    
                if (!$scope.isFullScreen && !isAutoRefresh)
                    $scope.loadingButton();
                $scope.getWords(component);
            } else {
                $scope.component.isChartExist = false;
                if (!$scope.componentLoaded) {
                    $timeout(function() { 
                    	$scope.componentLoaded = true;
                    });
                }	        	
            }
            $scope.component.isChartExist = true;            
        };

        $scope.wordSelected = function(word) {
            var dimension = $scope.component.dimensionDataField[0];
            var filterVal = word;
            var selectedGroups = undefined;
            if (typeof dimension.groups != 'undefined' && dimension.groups.length > 0) {                
                selectedGroups = [];
                angular.forEach(dimension.groups, function(group) {
                    if (group.groupName === filterVal) {                        
                        selectedGroups.push(group);                        
                        return;
                    }
                });
                filterVal = selectedGroups;                
            }
            $scope.addFilters(dimension.column, filterVal, $scope.component, true, true, selectedGroups, undefined, 'viewer', 'include', true);
        };

        $scope.aggregateSelectionChanged = function() {
            $scope.drawTagCloud();
        }

        $scope.init = function() {
            $scope.isDcubeEnabledInCustomReports = isDcubeEnabledInCustomReports;
            $scope.drawTagCloud();
		}


		$scope.init();
		$scope.$on('resize', function(sizes, gridster) {
            if(gridster && gridster.length > 1) {
                var componentResizedScope = angular.element(gridster[1]).scope();
                var currentCompId = componentResizedScope.$parent.component.id;
                if($scope.component.id == currentCompId) {
                        $scope.tagcloudconfig.width = $(gridster[1]).width();
                        $scope.tagcloudconfig.height = $(gridster[1]).height();
                }
            }
        });

        $scope.$on('gridsterItemWidthChanged', function(event, isLeftPanelToggle, componentId) {
            if (!isLeftPanelToggle && $scope.component.id==componentId) {
                 $scope.tagcloudconfig.width = $("li[comp="+ $scope.component.id +"]>div").width();
                 $scope.tagcloudconfig.height = $("li[comp="+ $scope.component.id +"]>div").height() - 150;
            }
            else if (isLeftPanelToggle) {
                $scope.tagcloudconfig.width = $("li[comp="+ $scope.component.id +"]>div").width();
            }                           
        });

		var onSuccessGetChartDataForDataSet = function(result) {
                var response = result.data;
                var chartData;
                $timeout(function(){
                	$scope.tagcloudconfig.words = response.records;                 	
                	$scope.componentLoaded = true;
                    $scope.component.isComponentLoading = false;
                });                
        };

       function getTagCloudConfig() {
	       var tagCloudConfig = {
	           fill: "d3.scale.category20()",
	           attr: {
	               transform: "translate(150,150)",
	           },
	           words: [],
	           font: "sans-serif",
	           width: $scope.gridster.curColWidth*2,
	           height: $scope.gridster.curRowHeight*8,
               onSelect: $scope.wordSelected               
	       };
	       return tagCloudConfig;
	    }

        customReportSvc.registerCallback("redrawAllComponents", function(data, isAutoRefresh) {
            $scope.drawTagCloud(isAutoRefresh);
        });

	}

})();
