<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

<ul class="secondary-header secondary-background-color">
    <li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
        <span class="ico ico-cog"></span>
    </li>
    <li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
        <span class="ico ico-form-field"></span>
    </li>
</ul>

<!-- Begin "General" group -->
<div data-ng-show="selectedPropertyCategory==='general'">        
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                       data-ng-model="propData.title.text"
                       type="text"
                       placeholder="<fmt:message key="CustomReport.Properties.ComponentName"/>">
                </div>
            </div>                  
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input name="chartid" class="form-control input-sm"
                   type="text"                   
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/" data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">                
                </div>
                <span class="inline-validation-error col-lg-12 noLftRghtPadding ng-hide" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>
            </div> 
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
                   readonly="true"
                   data-ng-model="propData.dataSet.dataSetName">
                </div>
            </div> 
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message key="CustomReport.Properties.HideHeader"/></label>
                <div class="col-sm-3 noLftRghtPadding">                    
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideHeader" id="hideheader">                        
                </div>
            </div>            
        </div>
    </div>
    <div class="row noLftRghtMargin">
        <div class="col-xs-12">
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.HideBorder"/>'><fmt:message key="CustomReport.Properties.HideBorder"/></label>
                <div class="col-sm-3 noLftRghtPadding">                    
                        <input type="checkbox" cv-toggle-switch data-ng-model="propData.hideborder" id="hideborder">                        
                </div>
            </div>            
        </div>
    </div>
    <!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                        data-ng-model="propData.mobile.visible">
                        <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                        <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
</div>

<!-- Begin "Field" group -->
<div data-ng-show="selectedPropertyCategory==='fields'"  data-ng-if="propData.searchFields && propData.searchFields.length!=0">
    <div data-ng-repeat="field in propData.searchFields" data-ng-init="collapsed['field'+$index] = true">
        <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel" data-ng-hide="field.column === 'ALL_FIELDS'">
            <div class="fieldHeader" data-ng-click="collapsed['field'+$index]=!collapsed['field'+$index]">
                <label class="col-lg-8 noLftRghtPadding" title="{{field.column}}">
                   <span cv-report-customization cv-expression="{{field.displayName}}" cv-localize="true" ></span>
                </label>
                <label class="col-lg-2 noLftRghtPadding" title="{{field.column}}">
	                <span data-ng-click="propData.searchFields.splice($index,1)" class="ico ico-trash2 pull-right" title='<fmt:message key="DeleteField"/>'></span>
                </label>
                 <span class="pull-right">
                 	<span class="ico inner-panel-expand-icon" data-ng-class="{'ico-chevron-down':!collapsed['field'+$index], 'ico-chevron-right':collapsed['field'+$index]}" style="margin-right:5px"></span>
                 </span>
                                                   
           </div>
            <div data-ng-class="{'collapsed': collapsed['field'+$index]}">
     	 		<div class="row">
		          <div class="col-xs-12">
		            <div class="form-group">
		                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisplayName"/>'><fmt:message key="CustomReport.Properties.DisplayName"/></label>
		                <div class="col-sm-8 noLftRghtPadding">
		                    <input class="form-control input-sm" type="text" placeholder="<fmt:message key='CustomReport.Properties.DisplayName'/>" data-ng-model="field.displayName">
		                </div>
		            </div>
		          </div>
		        </div>
		        <div class="row">
		          <div class="col-xs-12">
		            <div class="form-group">
		                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DisplayName"/>'><fmt:message key="DataSet.Preview.Fields.FieldName"/></label>
		                <div class="col-sm-8 noLftRghtPadding">
		                    <input class="form-control input-sm" type="text" readonly="true" data-ng-model="field.column">
		                </div>
		            </div>
		          </div>
		        </div>
      		</div>
        </div>
    </div>       
</div>
<div data-ng-show="selectedPropertyCategory==='fields'"  data-ng-if="(!propData.searchFields || propData.searchFields.length === 0) && propData.allColumns">    
    <div class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
        <div class="fieldHeader">
            <label class="col-lg-8 noLftRghtPadding" title="ALL">
               <span>ALL</span>
            </label>
            <label class="col-lg-2 noLftRghtPadding" title="{{field.column}}">
                <span data-ng-click="propData.allColumns=false" class="ico ico-trash2 pull-right" title='<fmt:message key="DeleteField"/>'></span>
            </label>             
       </div>        
    </div>
</div>
<!-- End "Field" group -->


<!-- <a id="resetButton" class="mainBtn" data-ng-click="resetDefault()">
    <fmt:message key="CustomReport.Properties.ResetToDefault"/>
</a> -->

</fmt:bundle>