(function() {
	'use strict';

	var reports = angular.module('reports');

	reports.controller('restApiCtrl', [
			'$scope',
			function($scope) {
				$scope.restApiUrl = '';
				var dsParams = {};
				angular.copy($scope.dataSetParams, dsParams);
				dsParams.operation = 'data';
				dsParams.dsId = $scope.getDSId($scope.dataSet);
				try {
					$scope.restApi = dataSetUtility.getUrlForDataComponent($scope.component,
							$scope.dataSet,
							$scope.page,
							dsParams,
							$scope.mergedParams,
							false,
							false,
							true);
					$scope.restApiUrl = window.location.origin + customReports.contextPath + "/api/cr/" +
							decodeURIComponent($scope.restApi);
				} catch (err) {
					console.error(err);
				}
				$scope.copyRestApiUrlToClipboard = function() {
					var el = document.createElement('textarea');
					el.value = window.location.origin + customReports.contextPath + "/api/cr/" + $scope.restApi;
					document.body.appendChild(el);
					el.select();
					document.execCommand('copy');
					document.body.removeChild(el);
					cvUtil.toast(cvUtil.cvLocalize('Copied_To_ClipBoard'), 1000, null, false);
				};

			} ]);

}());