(function() {
	angular.module("reports").directive("cvPanelComponent",
			function() {
				return {
					restrict : 'AEC',
					templateUrl : customReports.contextPath + '/reportsplus/components/panel/panel.jsp',
					controller : [
							'$scope',
							'customReportSvc',
							function($scope, customReportSvc) {
								$scope.panelComponentIndex = $scope.$index;
								if ($scope.component.mobileBreakPoint) {
									$scope.gridsterOpts.mobileBreakPoint = $scope.component.mobileBreakPoint;
								}
								$scope.dropped = function(dragEl, dropEl, event) {
									// Because the handler jumps "outside" of angular, updates must be
									// made in an $applied scope									
									var dest = document.getElementById(dropEl);
									var src = document.getElementById(dragEl);
									var drag = angular.element(src);
									var type = drag.data("type");
									var compType = drag.data("componenttype");
									var compDefaultTitle = drag.data("defaulttitle");
									var comp = {};
									comp.type = compType;
									comp.dataSet = {};
									comp.title = {
										text : ""
									};
									$scope.gridsterOpts.mobileBreakPoint = 300;
									comp = customReportSvc.getComponentDefintion(comp,
											type,
											$scope.reportComponents.length,
											$scope.gridsterOpts.rows,
											$scope.gridsterOpts.columns,
											true);
									if (!comp) {
										alert('Invalid Component type');
										return;
									}
									var position = $scope.calculateItemPosition(event);
									$scope.component.layout = $scope.component.layout || [];
									$scope.component.layout[comp.id] = customReportSvc.getGridAttributes(comp,
											position,
											3,
											3,
											$scope.deviceType);

									$scope.component.panelComponents.push(comp);
									$scope.setActiveComponent(comp);
									$scope.$apply();
									event.stopPropagation();
								}

								$scope.deleteComponent = function(index) {
									console.log(index)
								}

							} ]

				};
			});
})();