<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
   <div id="{{component.id}}" class="full-height map-component">
      <div ng-controller="mapCtrl" class="full-height">
         <div class="pivotOptions" style="overflow: auto"
            data-ng-show="reportMode == 'builder' && (component.type === 'MAP_v2' || component.type === 'MAP')">
            <fieldset class="axisColumnDrop ng-isolate-scope"
               data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
               x-lvl-drop-target="true" data-droptype="cc"
               x-on-drop="dropped(dragEl, dropEl)"
               data-ng-show="component.inputType==='cc'">
               <legend class="fieldsetLegend ng-binding">Drop Country Code                  
               </legend>
               <div class="chartColumns groupingCol"
                  data-ng-class="{'hidden':component.countrycode == undefined }">
                  <label>({{component.countrycode.id}})<span
                     class="deleteColumn" data-ng-click="deleteColumn('cc')">&times;</span></label>
               </div>
            </fieldset>
            
            <fieldset class="axisColumnDrop ng-isolate-scope"
               data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
               x-lvl-drop-target="true" data-droptype="latitude"
               x-on-drop="dropped(dragEl, dropEl)"
               data-ng-show="component.inputType==='latlon'">
               <legend class="fieldsetLegend ng-binding">Drop Latitude
                  Column
               </legend>
               <div class="chartColumns groupingCol"
                  data-ng-class="{'hidden':component.latitude == undefined }">
                  <label>({{component.latitude.id}})<span
                     class="deleteColumn" data-ng-click="deleteColumn('latitude')">&times;</span></label>
               </div>
            </fieldset>
            <fieldset class="axisColumnDrop ng-isolate-scope"
               data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
               x-lvl-drop-target="true" data-droptype="longitude"
               x-on-drop="dropped(dragEl, dropEl)"
               data-ng-show="component.inputType==='latlon'">
               <legend class="fieldsetLegend ng-binding">Drop Longitude
                  Column
               </legend>
               <div class="chartColumns groupingCol"
                  data-ng-class="{'hidden':component.longitude == undefined}">
                  <label>({{component.longitude.id}})<span
                     class="deleteColumn" data-ng-click="deleteColumn('longitude')">&times;</span></label>
               </div>
            </fieldset>

            <fieldset class="axisColumnDrop ng-isolate-scope"
               data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
               x-lvl-drop-target="true" data-droptype="category"
               x-on-drop="dropped(dragEl, dropEl)"
               data-ng-show="component.inputType==='cc' || component.enableHtmlClusters">
               <legend class="fieldsetLegend ng-binding">Drop Category Column                  
               </legend>
               <div class="chartColumns groupingCol"
                  data-ng-class="{'hidden':component.categoryColumn == undefined }">
                  <label>({{component.categoryColumn.id}})<span
                     class="deleteColumn" data-ng-click="deleteColumn('category')">&times;</span></label>
               </div>
            </fieldset>

            <fieldset class="axisColumnDrop ng-isolate-scope"
               data-ng-class="{'disableColumnDrop':  !component.isSelected || disablePivotRow}"
               x-lvl-drop-target="true" x-on-drop="dropped(dragEl, dropEl)">
               <legend class="fieldsetLegend ng-binding">Drop Data Columns</legend>
               <div data-ng-repeat="column in component.columns"
                  class="chartColumns groupingCol">
                  <label>
                     <!-- for 0th index, we have watch in the controller, 
                        so do not call loadComponent when index is 0 -->
                     <select data-ng-model="column.aggrType"
                        data-ng-change="$index>0 ? loadComponent() : return;"
                        class="colNoBorder"
                        data-ng-disabled="($index>0 && component.columns[0].aggrType==='None') || component.enableHtmlClusters">
                        <option value="None" data-ng-show="$index==0 && !component.categoryColumn">
                           <fmt:message
                              key="CustomReport.None" />
                        </option>
                        <option value="Count">
                           <fmt:message
                              key="CustomReport.Count" />
                        </option>
                        <option value="CountDistinct">
                           <fmt:message
                              key="CustomReport.Distinct" />
                        </option>
                        <option data-ng-if="column.showNumberOps" value="Sum">
                           <fmt:message
                              key="CustomReport.Sum" />
                        </option>
                        <option data-ng-if="column.showNumberOps" value="Avg">
                           <fmt:message
                              key="CustomReport.Avg" />
                        </option>
                        <option data-ng-if="column.showNumberOps" value="Min">
                           <fmt:message
                              key="CustomReport.Min" />
                        </option>
                        <option data-ng-if="column.showNumberOps" value="Max">
                           <fmt:message
                              key="CustomReport.Max" />
                        </option>
                     </select>
                     ({{column.id}})
                  </label>
                  <span class="deleteColumn" data-ng-click="deleteColumn($index)">&times;</span>
               </div>
            </fieldset>
         </div>
         <div class="noChartDiv" data-ng-show="showNoDataDiv"
            data-ng-click="setActiveComponent()">
            <label data-ng-show="showNoDataDiv">
               <fmt:message
                  key="CustomReport.NoDataAvailable" />
            </label>
         </div>
         <div class="noChartDiv" data-ng-show="showErrorDiv">
            <label data-ng-show="showErrorDiv">
               <fmt:message
                  key="CustomReport.ErrorLoadingMap" />
            </label>
         </div>
         <div id="cvmap_{{component.id}}" class="map full-height" data-ng-hide="showNoDataDiv"></div>         
         <!-- 53px is for component title outerHeight -->
      </div>
   </div>
</fmt:bundle>