(function() {
	"use strict";

	angular.module("reports").controller("kendoTreeGridCtrl", kendoTreeGridCtrl);

	kendoTreeGridCtrl.$inject = [ '$scope', 'reportService', 'customReportSvc', 'dataSource', '$timeout' ];

	function kendoTreeGridCtrl($scope, reportService, customReportSvc, $dataSource, $timeout) {

		var numTypes = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
		$scope.columnDefinitionById = {};
		$scope.kendoColumns = [];
		$scope.kendoTreeModel = {};
		$scope.kendoGroupConfig = {};
		$scope.kendoTreeOptions = {};
		$scope.kendoDataSource = null;
		$scope.setChildScope($scope);
		$scope.gridDataInitialized  = false;
		$scope.rowIndex= 0;
		//this is for computational purpose; talk to Chandan and decide how it has to be stored
		$scope.parentAggrMap = {};

		customReportSvc.setDefaultStyles($scope.component); // to set default

		function _getPrefix(selValue, incr) {
			var prefix = selValue ? selValue : null;
			var level = 0, str = prefix;
			if (prefix !== null) {
				try {
					var idx = prefix.indexOf(prefix.match(/\/|\\/g)[0]);
					level = parseInt(prefix.substr(0, idx));
					str = prefix.substr(idx);
				} catch (e) {
				}
				if (incr === undefined) {
					incr = 1;
				}
				prefix = (level + incr) + str;
			} else {
				prefix = "0";
			}
			return prefix + "\\"; //this will only work if the separator is \
		}

		function _getLastPartObj(str) {
			if($scope.component.getNonAggregationdata) {
				let level = 0;
				let value = "";
				if (str) {
					str +="";
					const paths = str.split("/").filter(s => s !== "");
					paths.forEach(p => { 
						const idx = p.indexOf("_");
						const levelPart = parseInt(p.substr(0, idx));
						if(!isNaN(levelPart)) {
							value = p.substr(idx + 1);
							level++;
						} else
							value += "/" + p;
					});
					level--;
				}
				return {
					level,
					value
				}
			} else {
				var objToReturn = {
					level : 0,
					value : ""
				};
				if (str) {
					var lastPart = str.substr(str.lastIndexOf("/") + 1);
					var idx = lastPart.indexOf("_");
	
					objToReturn.level = parseInt(lastPart.substr(0, idx));
					objToReturn.value = lastPart.substr(idx + 1);
				}
				return objToReturn;
			}		
		}
		function _getNextSLevelField(prefix, selValue) {
			return prefix + (selValue ? _getLastPartObj(selValue).level + 1 : 0);
		}

		function _getValWithoutPrefix(selValue) {
			var retValue = selValue ? selValue : null;
			if (retValue !== null) {
				try {
					/*
					 * in case of filer, input: 2\\filername\foldername, output: \\filername\foldername in
					 * case of disk, input: 2\e:\f1\file.ext, output: e:\f1\file.ext
					 */
					var sep = retValue.match(/\/|\\\\|\\/g)[0];
					if (sep) {
						var idx = retValue.indexOf(sep);
						retValue = retValue.substr(idx + (sep !== "\\" ? 0 : 1));
					}
				} catch (e) {
				}
			} else {
				retValue = "0";
			}
			return retValue;
		}

		function _getFilters(selValue, prefix, isMetaDataReq, records) {
			var fArr = {}, fName;
			if (selValue) {
				if ($scope.component.hDataField.isUseSLevel) {
					/*
					 * For node: /0_C:/1_Users/2_Downloads ************* filter query array is : [{ columnId :
					 * "slevel_Url_0", fValue : "C:"}, { columnId : "slevel_Url_1", fValue : "Users"},{
					 * columnId : "slevel_Url_2", fValue : "Downloads"}]
					 */
					var parts = selValue.split("/");
					for (var i = 1; i < parts.length; i++) {
						fName = prefix + (i - 1);
						fArr[fName] = {};
						fArr[fName].tableFilters = [ {
							filters : [ {
								field : fName,
								operator : "eq",
								value : parts[i].substr(parts[i].indexOf("_") + 1),
							} ],
							logic : "and"
						} ];
					}
					if (isMetaDataReq && records && records.length > 0) {
						fName = prefix + (i - 1);
						fArr[fName] = {};

						var filters = [];
						angular.forEach(records, function(record) {
							filters.push({
								field : fName,
								operator : "eq",
								value : record.value
							});
						});
						fArr[fName].tableFilters = [ {
							filters : filters,
							logic : "or"
						} ];

						fArr[prefix + i] = {};
						fArr[prefix + i].tableFilters = [ {
							filters : [ {
								field : prefix + i,
								operator : "isempty",
								value : "",
							} ],
							logic : "and"
						} ];
					}
				} else {
					fArr[$scope.component.hDataField.dataField] = {};
					fArr[$scope.component.hDataField.dataField].include = selValue;
					fArr[$scope.component.hDataField.dataField].exclude = _getPrefix(selValue, 2) + "*";
				}
			} else if (isMetaDataReq) {
				fArr[prefix + 1] = {};
				fArr[prefix + 1].tableFilters = [ {
					filters : [ {
						field : prefix + 1,
						operator : "isempty",
						value : "",
					} ],
					logic : "and"
				} ];
			} else {
				//root node
				if ($scope.component.timeFilterField) {
					$scope.requestedAt = moment().subtract(30, 'seconds');
				}
			}
			if ($scope.requestedAt) {
				fArr[$scope.component.timeFilterField] = {
					'daterange' : {
						'from' : "*",
						'to' : $scope.requestedAt
					}
				};
			}
			return fArr;
		}

		function _getCellExpForColumn(cName) {
			var cObj;
			angular.forEach($scope.component.columns, function(eachCol) {
				if (eachCol.dataField === cName) {
					cObj = eachCol;
					return;
				}
			});
			if (cObj) {
				return cObj.cellExpression || $scope.component.allCellExpression;
			}
			return null;
		}

		$scope.prepareTreeData = function(resp, paramsData, metaDataResp) {
			var treeData = [], mMap = {};
			var hField = $scope.component.hDataField;
			var totalNodes = resp.totalRecordCount;
			var records = resp.data.groups;
			var selNodeId = paramsData.id;
			var offset = paramsData.offset ? paramsData.offset : 0;
			var isLoadMore = (offset + records.length) < totalNodes;
			if (!$.isEmptyObject(metaDataResp) && !$.isEmptyObject(metaDataResp.records)) {
				var mArr = metaDataResp.records;
				var mBy = $scope.component.hDataField.mapBy;
				if (hField.isUseSLevel) {
					mBy = records[0].field;
				}
				angular.forEach(mArr, function(obj, i) {
					mMap[obj[mBy]] = obj;
				});
				//console.log(mMap);
			}
			try {
				angular
						.forEach(records,
								function(obj, i) {
									var tObj = $.extend({}, mMap.hasOwnProperty(obj.value) ? mMap[obj.value]
											: mMap[_getValWithoutPrefix(obj.value)]);

									if (hField.isUseSLevel) {
										//Example of each tree node's key is : 0_C:/1_Users/2_Downloads
										tObj[hField.dataField] = (selNodeId ? (selNodeId + "/" + (_getLastPartObj(selNodeId).level + 1))
												: "/0") +
												"_" + obj.value;
									} else {
										tObj[obj.field] = obj.value;
									}
									tObj.parentId = selNodeId ? selNodeId : null;

									angular.forEach(obj.aggregates, function(aggObj, key) {
										//TODO: you need to lookup with aggrType; not always first key
										if (key === hField.aggrOpts.aggrColName) {
											tObj.aggrVal = aggObj[Object.keys(aggObj)[0]];
										}
										if (!tObj.hasOwnProperty(key)) {
											tObj[key] = aggObj[Object.keys(aggObj)[0]];
										}
									});
									if (!$.isEmptyObject(obj.items)) {
										angular.forEach(obj.items, function(eachItem, ii) {
											if(eachItem.aggregates && eachItem.aggregates[eachItem.field]) {
												//take the first aggregate available
												var aggrMap = eachItem.aggregates[eachItem.field];
												var keys = Object.keys(aggrMap);
												tObj[eachItem.value] = keys.length > 0 ? aggrMap[keys[0]] : eachItem.count;
											}
											else {
											tObj[eachItem.value] = eachItem.count;
											}
										});
									}

									if (tObj.parentId === null) {
										tObj.percentage = 1;
									} else {
										tObj.percentage = tObj.aggrVal === 0 ? 0
												: (tObj.aggrVal / $scope.parentAggrMap[selNodeId]);
									}
									//If iconColumn is available, then let us decide what is the leaf node by checking the value
									if (hField.iconColumn) {
										tObj.isLeafNode = tObj[hField.iconColumn] == hField.iconColumnVal;
									}

									//hack for file system treesize
									//subtract 1 from IsFolder count as it counts itself
									//a folder will be marked as empty when sum(IsFile + IsFolder) = 0
									if (tObj.hasOwnProperty("IsFolder")) {
										tObj.IsFolder = (tObj.IsFolder > 0 && mMap.hasOwnProperty(obj.value)) ? (tObj.IsFolder - 1)
												: tObj.IsFolder;
									}
									if(!tObj.hasOwnProperty("IsFolder") && !tObj.hasOwnProperty("IsFile"))
									{
										obj.count = tObj.aggrVal;
									}
									else
									{
										obj.count = (tObj.hasOwnProperty("IsFolder") ? tObj.IsFolder : 0) +
											(tObj.hasOwnProperty("IsFile") ? tObj.IsFile : 0);
									}
									tObj.hasChildren = obj.count > 0 && !tObj.isLeafNode;
									treeData.push(tObj);
								});
				if (isLoadMore && hField.isUseSLevel) {
					var lmObj = {
						hasChildren : false,
						parentId : selNodeId,
						isLoadMoreLink : true,
						offset : offset + hField.numChildren
					};
					lmObj[hField.dataField] = selNodeId + "_loadMore";
					treeData.push(lmObj);
				}
			} catch (e) {
				console.log(e);
			}
			//console.log(treeData);
			return treeData;
		};

		$scope.createKendoTree = function() {
			if ($scope.component.columns.length === 0) {
				$timeout(function() {
					$scope.componentLoaded = true;
					$scope.component.isComponentLoading = false;
				});

				return;
			}

			if (!$scope.dataservice) {
				if ($scope.dataSet) {
					$scope.dataservice = $dataSource.getDataSource($scope.dataSet.endpoint);
				}
			}

			$scope.kendoDataSource = new kendo.data.TreeListDataSource({
				serverSorting : true,
				sort : $scope.component.sorting,
				transport : {
					read : function(params) {
						$scope.component.sorting = params.data.sort;
						$scope.getData(params);
					}
				},
				schema : {
					model : $scope.kendoTreeModel,
					data : function(resp) {
						return resp.data.records;
					},
					total : function(response) {
						var totalRecordCount = 0;
						if (response.hasOwnProperty("totalRecordCount")) {
							totalRecordCount = response.totalRecordCount;
						}
						return totalRecordCount;
					},
				}
			});

			$scope.kendoTreeOptions = {
				dataSource : $scope.kendoDataSource,
				filterable : false,
				sortable : {
					mode : "single",
					allowUnsort : true
				},
				selectable : $scope.component.enableRowSelection ? true : false,
				resizable : true,
				reorderable : true,
				columnMenu : false,
				columns : $scope.kendoColumns,
				//getting into recursion; need to check n add
				//columnHide : $scope.onColumnShowHide,
				//columnShow : $scope.onColumnShowHide,
				expand : $scope.onNodeExpand,
				dataBound : function(e) {
					let self = this;
					$("#" + $scope.component.id).off("click", "span.tree-node").on("click",
							"span.tree-node",
							function(e) {
								var row = $(this).parent().parent(); //tr node
								var model = $scope.kendoTree.dataSource.getByUid(row.data("uid"));
								if (row.has(".k-i-collapse").length) {
									$scope.kendoTree.collapse(row);
								} else {
									$scope.parentAggrMap[model[$scope.component.hDataField.dataField]] = model.aggrVal;
									$scope.kendoTree.expand(row); //this is not triggering expand event
								}
							});
					$("#" + $scope.component.id).off("click", "span.loadMoreLink").on("click",
							"span.loadMoreLink",
							function(e) {
								$scope.onLoadMoreClick($(this).data("parentid"), $(this).data("offset"));
							});
					if(!$scope.gridDataInitialized && $scope.component.rowFormatter && $scope.component.rowFormatter.action === "ShowPreview" 
						&& $scope.component.rowFormatter.previewComponentId && $scope.isCustomHtmlCompPresent($scope.component.rowFormatter.previewComponentId))
					 	this.select($("tr",this.tbody).first());
					 $scope.gridDataInitialized= true;

					 $timeout(function() {
					 	if($scope.component.enableRowSelection)
			 				$("tr",self.tbody).addClass("cursor-pointer");
			 		},200);

					if($scope.exportType) {
						if(this.dataSource.at($scope.rowIndex) !== undefined) {
							//skip the child nodes(files) and expand the folders
							while(this.dataSource.at($scope.rowIndex) !== undefined && !this.dataSource.at($scope.rowIndex).hasChildren) {
								$scope.rowIndex++;
							}
							if(this.dataSource.at($scope.rowIndex) !== undefined) {
								const row = this.dataSource.at($scope.rowIndex++);
								$scope.parentAggrMap[row[$scope.component.hDataField.dataField]] = row.aggrVal;
								this.expand(row);
							} 							
						} else
							$scope.rowIndex=0;
					}
				},
				
				change : function (e) {
					let tableData = $scope.kendoDataSource._data,rowIndex = 0,
					$selRow = this.select();
					$selRow.removeClass("k-state-selected");					
					for(let indx = 0 ; indx < tableData.length ; indx++ ) {
						if(tableData[indx].uid === $selRow.data("uid")) {
							rowIndex = indx;
							break;
						}
					}
					$scope.handleTableRowSelection(e,rowIndex,undefined,$selRow);
				},
				
			};

			if ($scope.component.hDataField.isUseSLevel) {
				var fName = $scope.dataservice.getActualFieldName({dataSet : $scope.dataSet,
						fieldName : $scope.component.hDataField.dataField});				
				$scope.sLevelPrefix = fName.substr(0, fName
							.lastIndexOf("_") + 1);				
			}

		};

		function _getNextSLevelFieldFn(prefix, selValue) {
			if(selValue) {
				const parts = selValue.split("/").filter(part => part !== "" && part !== "0_");
				let count = 0;
				parts.forEach(p => {
					count += p.split("\\").filter(part => part !== "" && part !== "0_").length;
				});
				return prefix + count;
			} else
				return prefix +  0;
		}

		function _fillFilterObj(filtersObj,fName, value) {
			filtersObj[fName] = {};
			filtersObj[fName].tableFilters = [{
				filters : [{
					field : fName,
					operator : "eq",
					value : value,
				}],
				logic : "and"
			}];
		}

		function _getFiltersFn(selValue, prefix) {
			let filters ={};
			if (selValue) {				
			/*
				* For node: /0_C:/1_Users/2_Downloads ************* filter query array is : [{ columnId :
				* "slevel_Url_0", fValue : "C:"}, { columnId : "slevel_Url_1", fValue : "Users"},{
				* columnId : "slevel_Url_2", fValue : "Downloads"}]
				*/
				var parts = selValue.split("/").filter(part => part !== "" && part !== "0_");
				let currentLevel = 0;
				for (var i = 0; i < parts.length; i++) {
					let part = parts[i];
					const idx = part.indexOf("_");
					const levelPart = part.substr(0, idx);
					if(!isNaN(parseInt(levelPart))) 
						part = part.substr(idx + 1);
					if(currentLevel === 0) {
						part = part.split("\\").filter(p => p !== "" && p !== "0_");	
						part.forEach(val => {
							_fillFilterObj(filters, prefix + currentLevel, val);
							currentLevel++;
						});
					} else {
						_fillFilterObj(filters, prefix + currentLevel, part);
						currentLevel++;
					}
					
				}
				filters[prefix + currentLevel] = {};
				filters[prefix + currentLevel].tableFilters = [ {
					filters : [ {
						field : prefix + currentLevel,
						operator : "isnotempty",
						value : "",
					} ],
					logic : "and"
				} ];	
				currentLevel++;
				filters[prefix + currentLevel] = {};
				filters[prefix + currentLevel].tableFilters = [ {
					filters : [ {
						field : prefix + currentLevel,
						operator : "isempty",
						value : "",
					} ],
					logic : "and"
				} ];		
			} else {
				filters[prefix + 1] = {};
				filters[prefix + 1].tableFilters = [ {
					filters : [ {
						field : prefix + 1,
						operator : "isempty",
						value : "",
					} ],
					logic : "and"
				} ];
			} 
			return filters;
		}

		$scope.prepareTreeDataFn = (resp, paramsData) =>{
			var treeData = [], mMap = {};
			var hField = $scope.component.hDataField;
			var totalNodes = resp.totalRecordCount;
			var records = resp.records;
			var selNodeId = paramsData.id;
			var offset = paramsData.offset ? paramsData.offset : 0;
			var isLoadMore = (offset + records.length) < totalNodes;
			const groupingField = _getNextSLevelFieldFn($scope.sLevelPrefix, paramsData.id);
			if (Array.isArray(records) && records.length > 0) {
				let mapBy = groupingField;	
				angular.forEach(records, function(obj, i) {
					mMap[obj[mapBy]] = obj;
				});
			}
			if(!$scope.parentAggrMap[selNodeId]) {
				const totalNodes = records.reduce((tot, data) => {
					return tot + (data[$scope.component.aggregationField] || 0);
				},0);

				if(totalNodes !== 0)
					$scope.parentAggrMap[selNodeId] = totalNodes;
			}
			try {
				angular
						.forEach(records,
								function(obj) {
									const groupValue = obj[groupingField];
									var tObj = $.extend({}, mMap.hasOwnProperty(groupValue) ? mMap[groupValue]
											: mMap[_getValWithoutPrefix(groupValue)]);
									//Example of each tree node's key is : 0_C:/1_Users/2_Downloads
									tObj[hField.dataField] = (selNodeId ? (selNodeId + "/" + (_getLastPartObj(selNodeId).level + 1))
												: "/0") +
												"_" + groupValue;
									tObj.parentId = selNodeId ? selNodeId : null;
									tObj.aggrVal = tObj[$scope.component.aggregationField] || 0;
									
									if (tObj.parentId === null) {
										tObj.percentage = 1;
									} else {
										tObj.percentage = tObj.aggrVal === 0 ? 0
												: (tObj.aggrVal / $scope.parentAggrMap[selNodeId]);
									}
									//If iconColumn is available, then let us decide what is the leaf node by checking the value
									if (hField.iconColumn && tObj.isLeafNode === undefined) {
										tObj.isLeafNode = tObj[hField.iconColumn] == hField.iconColumnVal;
									}
									
									obj.count = (tObj[$scope.component.folderCountField] || 0) + (
										tObj[$scope.component.filesCountField] || 0);
									
									tObj.hasChildren = tObj.parentId === null || (obj.count > 0 && !tObj.isLeafNode);
									treeData.push(tObj);
								});
				if (isLoadMore && hField.isUseSLevel) {
					var lmObj = {
						hasChildren : false,
						parentId : selNodeId,
						isLoadMoreLink : true,
						offset : offset + hField.numChildren
					};
					lmObj[hField.dataField] = selNodeId + "_loadMore";
					treeData.push(lmObj);
				}
			} catch (e) {
				console.log(e);
			}
			//console.log(treeData);
			return treeData;
		}
		$scope.getDataForNonAggrColumns = (params) => {
			$scope.component.isComponentLoading = true;

			if (!$scope.isFullScreen && !params.data.isAutoRefresh) { //why not full screen?
				$scope.loadingButton();
			}			

			function callbackFn(resp) {
				$scope.prevRowUID = undefined;
				if(!resp.data)
					resp.data = {};
				resp.data.records = $scope.prepareTreeDataFn(resp, params.data);
				params.success(resp);
				$timeout(function() {
					$scope.componentLoaded = true;
					$scope.component.isComponentLoading = false;
				});
			}
			
			if ($scope.dataservice) {
				//get the URL sorted by Asc order to know the source path
				let searchParams;
				let filters = {};
				if(!params.data.id) {
					searchParams= {
						columns : [{
							dataField : "Url"
						}],
						sort : [{
							columnId : "Url",
							direction : "asc"
						}],
						offset : 0,
						limit : 1
					}
				} else {
					searchParams = {
						columns : [],
						offset : params.data.offset || 0,
						limit : $scope.component.hDataField.numChildren || 20
					};			
		
					//go over columns, get the ones with custom group set and push them to dimensionDataField
					//also get the ones with aggregation, and push it to measureDataField
		
					angular.forEach($scope.component.columns, function(col) {
						searchParams.columns.push({
							dataField : col.dataField
						});
					});
					const issortParam = Array.isArray($scope.component.sorting) && $scope.component.sorting.length > 0;
					const sortField =  issortParam ? $scope.component.sorting[0].field : "IsFolder";
					const direction = issortParam ? $scope.component.sorting[0].dir : "Asc";
					searchParams.sort = [{
						columnId : sortField,
						direction : direction
					}];
					if ($scope.component.hDataField.isUseSLevel) {
						searchParams.columns.push({
							dataField : _getNextSLevelFieldFn($scope.sLevelPrefix, params.data.id)
						});
					}

					filters = _getFiltersFn(params.data.id, $scope.sLevelPrefix);
				}
				
				$dataSource.getDataSource($scope.dataSet.endpoint).getTableData({
					dataSet : $scope.dataSet,
					componentType : $scope.component.type,
					tableParams : searchParams,
					filters,
					inputParams : customReportSvc.applyInputsToDataSet($scope.dataSet, $scope.page.inputs)
				},
						function(resp) {
							if(!params.data.id && resp.records.length > 0) {
								let splitChar = "\\";
								let Url = resp.records[0].Url.split(splitChar);
								if(Url.length === 1) {
									splitChar = "/";
									Url = Url[0].split(splitChar).filter(u => u !== "");
								}
									
								if(Url.length !== 1) {
									Url.pop();
									Url = Url.join(splitChar);
								} else
									Url = Url[0];
								resp.records[0]["slevel_Url_0"] = Url;
								resp.records[0].isLeafNode = false;
							} 
							callbackFn(resp);
						});
			}
		}

		$scope.getData = function(params) {
			//This property is only set for citadel treegrid component.. making duplicate change to avoid regression for SP20
			//TODO : make proper changes for SP25
			if($scope.component.getNonAggregationdata) {
				$scope.getDataForNonAggrColumns(params);
				return;
			}

			$scope.component.isComponentLoading = true;

			if (!$scope.isFullScreen && !params.data.isAutoRefresh) { //why not full screen?
				$scope.loadingButton();
			}

			var options = {};
			var tableParams = {
				columns : [ {
					dataField : $scope.component.hDataField.dataField
				} ]
			};
			options.dataSet = $scope.dataSet;
			options.componentType = $scope.component.type;
			if ($scope.component.hDataField.isUseSLevel) {
				options.dimensionDataField = [ {
					column : _getNextSLevelField($scope.sLevelPrefix, params.data.id),
					numPointsToDisplay : {
						maxPoints : $scope.component.hDataField.numChildren,
						offset : params.data.offset ? params.data.offset : 0
					},
				} ];
				if (!$.isEmptyObject($scope.component.sorting) &&
						$scope.component.hDataField.dataField === $scope.component.sorting[0].field) {
					options.sortOptions = {
						sortAxis : "XAxis",
						columnId : $scope.component.sorting[0].field,
						direction : $scope.component.sorting[0].dir
					};
				}
			} else {
				options.dimensionDataField = [ {
					column : $scope.component.hDataField.dataField,
					prefix : _getPrefix(params.data.id),
					numPointsToDisplay : {
						includeAll : true
					}
				} ];
			}
			options.measureDataField = [];

			//go over columns, get the ones with custom group set and push them to dimensionDataField
			//also get the ones with aggregation, and push it to measureDataField

			angular.forEach($scope.component.columns, function(col, index) {
				if (col.customGroupsAvailable && col.groups) {					
					options.dimensionDataField.push(col);
				}
				if (col.aggrType) {
					if (col.aggrType !== 'None') {
						if (!$.isEmptyObject($scope.component.sorting) &&
								col.dataField === $scope.component.sorting[0].field) {
							col.sortOrder = $scope.component.sorting[0].dir;
						} else {
							delete col.sortOrder;
						}
						options.measureDataField.push(col);
					} else {
						tableParams.columns.push({
							dataField : col.dataField
						});
					}
				}
			});
			if ($scope.component.hDataField.isUseSLevel) {
				tableParams.columns.push({
					dataField : _getNextSLevelField($scope.sLevelPrefix, params.data.id)
				});
			}

			options.constructGroupStructure = true;
			function callback(resp, metaDataResp) {
				$scope.prevRowUID = undefined;
				resp.data.records = $scope.prepareTreeData(resp, params.data, metaDataResp);
				params.success(resp);
				$timeout(function() {
					$scope.componentLoaded = true;
					$scope.component.isComponentLoading = false;
				});
			}
			if ($scope.component.hDataField.isUseSLevel) {
				options.filters = _getFilters(params.data.id, $scope.sLevelPrefix, false);
			}
			let customFilterQuery = $scope.component.customFilterQuery
			if(customFilterQuery && customFilterQuery.trim().startsWith(":=")) {
				customFilterQuery =  customReportSvc.evalExpression(customFilterQuery);
			}			
			options.customFilterQuery = customFilterQuery ? customFilterQuery : {};
			if ($scope.dataservice) {
				$scope.dataservice.getChartData(options, function(resp) {
					//console.log(resp);
					if (resp && resp.data && !$.isEmptyObject(resp.data.groups) &&
							!$.isEmptyObject(tableParams.columns) && tableParams.columns.length > 1) {
						tableParams.limit = resp.data.groups.length + 1; //because the folder is also counted
						tableParams.isExact = false;
						tableParams.customFilterQuery = customFilterQuery;
						$dataSource.getDataSource($scope.dataSet.endpoint).getTableData({
							dataSet : $scope.dataSet,
							componentType : $scope.component.type,
							tableParams : tableParams,
							filters : $scope.component.hDataField.isUseSLevel ? _getFilters(params.data.id,
									$scope.sLevelPrefix,
									true,
									resp.data.groups) : _getFilters(params.data.id),
							inputParams : customReportSvc.applyInputsToDataSet($scope.dataSet, $scope.page.inputs)
						},
								function(metaDataResp) {
									//console.log(metaDataResp);
									callback(resp, metaDataResp);
								});
					} else {
						callback(resp);
					}
				});
			}
		};

		$scope.onColumnShowHide = function(e) {
			if (e && e.column.field) {
				var cObj = undefined;
				angular.forEach($scope.component.columns, function(eachCol) {
					if (eachCol.dataField === e.column.field) {
						cObj = eachCol;
						return;
					}
				});
				if (cObj) {
					cObj.hidden = false;
				}
			}
		};

		$scope.onNodeExpand = function(e) {
			if (e && e.model) {
				$scope.parentAggrMap[e.model[$scope.component.hDataField.dataField]] = e.model.aggrVal;
			}
		};

		$scope.onLoadMoreClick = function(id, offset) {
			var params = {
				data : {
					id : id,
					offset : offset
				},
				success : function(resp) {
					$scope.kendoTree.dataSource.remove($scope.kendoTree.dataSource.get(id + "_loadMore"));
					angular.forEach(resp.data.records, function(record) {
						$scope.kendoTree.dataSource._data.push(record);
					});
				}
			};
			$scope.getData(params);
		};

		$scope.onSelection = function() {
			//allowing only one selection for now
			//not saving the filters in builder
			var selRow = this.dataItem(this.select());
			var fObj = {};
			var hField = $scope.component.hDataField.dataField;
			fObj[hField] = {};
			fObj[hField].include = [ selRow[hField] ];
			var options = {
				dataSet : $scope.dataSet,
				filters : fObj,
				isExact : true
			};
			$dataSource.getDataSource(options.dataSet.endpoint).applyFilters(options, function(isSuccess) {
			});
			customReportSvc.triggerCallback("redrawOtherComponents", $scope.component.id);
		};

		$scope.dropped = function(dragEl, dropEl) {
			if ($scope.reportMode === "viewer") {
				return;
			}

			if (!$scope.component.isSelected) {
				customReportSvc.errorToast('Select the component to add a column.');
				return;
			}
			var dest = document.getElementById(dropEl);
			var src = document.getElementById(dragEl);

			var drag = angular.element(src);
			var drop = angular.element(dest);

			var columnName = drag.attr("data-name");
			var columnType = drag.attr("data-type");
			var origType = drag.attr("data-origtype");
			var dataField = drag.attr("data-datafield");
			var dataSetEntity = drag.data("datasetentity");
			var dataSetName = dataSetEntity.dataSetName;

			if (!$scope.component.dataSet || !$scope.component.dataSet.dataSetName) {
				$scope.associateDataSetToComponent(dataSetEntity);
			} else if ($scope.component.dataSet.dataSetName !== dataSetName) {
				alert("Mismatched data Sets");
				return;
			}
			var colObj = {
				name : columnName,
				dataField : dataField,
				type : columnType,
				origType : origType
			};

			if (!$scope.component.hDataField) {
				var isUseSLevel = false;
				var hDataField = $dataSource.getDataSource($scope.dataSet.endpoint).getSLevelField({
					dataSet : $scope.dataSet,
					fieldName : columnName
				});
				if (hDataField === null) {
					hDataField = $dataSource.getDataSource($scope.dataSet.endpoint).getHierarchicalField({
						dataSet : $scope.dataSet,
						fieldName : columnName
					});
				} else {
					isUseSLevel = true;
				}
				if (hDataField === null) {
					customReportSvc.errorToast('Please drop a field with hierachical nature.');
					return;
				}
				//update colObj with _path field name
				colObj.name = colObj.dataField = hDataField;
				colObj.displayName = columnName;

				$scope.component.hDataField = $scope.getBasicColumnDef(colObj);
				if (isUseSLevel) {
					$scope.component.hDataField.isUseSLevel = isUseSLevel;
				}
				$scope.component.hDataField.isShowAggr = true;
				$scope.component.hDataField.aggrOpts = {
					showAsPercentage : true,
					decimalPoints : 0,
					aggrColName : colObj.dataField
				};
				$scope.component.hDataField.isShowIcon = false;
				$scope.component.hDataField.numChildren = 20;
			}

			$scope.addColumn(colObj);

			$scope.updateKendoModel();
			$scope.$apply();

		};

		$scope.updateKendoModel = function() {
			var kendoCols = [];
			angular.forEach($scope.component.columns, function(col, index) {
				var column = {};
				if (col.customGroupsAvailable && col.groups) {
					var groups = $.extend([], col.groups);
					if(col.includeUngrouped && col.ungroupedLabel !== "")
					{
						groups.push({
							"groupName" : col.ungroupedLabel
						});
					}
					angular.forEach(groups, function(eachGroup, ii) {
						var cObj = {};
						cObj.field = cObj.title = eachGroup.groupName;
						cObj.template = function(row) {
							if (col.cellExpression){
								return customReportSvc.getFormattedValue(row[cObj.field], col.cellExpression);
							}
							return row[cObj.field];
						};
						cObj.sortable = false;
						kendoCols.push(cObj);
					});
				}
				column.field = col.dataField;
				column.title = col.displayName || col.dataField;
				column.hidden = col.hidden;
				var cellExp = _getCellExpForColumn(col.dataField);
				if (col.aggrType && col.aggrType !== 'None') {
					column.attributes = {
						"class" : "text-right"
					};
					column.headerAttributes = {
						style : "text-align: right"
					};
				}
				if (col.dataField === $scope.component.hDataField.dataField) {
					column.template = function(row) {
						if (row.isLoadMoreLink) {
							return "<span class='loadMoreLink' data-parentid='" + row.parentId + "' data-offset=" +
									row.offset + ">Show more...</span>";
						}
						var hField = $scope.component.hDataField;
						var fmtVal = row[hField.dataField];
						if ($scope.component.hDataField.isUseSLevel) {
							fmtVal = _getLastPartObj(fmtVal).value;
						} else {
							var prefix = _getPrefix(row.parentId);
							if (fmtVal && prefix) {
								fmtVal = fmtVal.substr(fmtVal.indexOf(prefix) + prefix.length);
							}
						}
						fmtVal = "<span class='tree-node " + (!row.isLeafNode ? "tree-folder" : "") + "'>" + fmtVal +
								"</span>";
						var iconHtml = "";
						if (hField.isShowIcon) {
							//hardcoding the glyphicon for folder and file right now
							iconHtml = "<span class='tree-icon " +
									(row.isLeafNode ? "glyphicon glyphicon-file tree-file-icon"
											: "glyphicon glyphicon-folder-open tree-folder-icon") + "'></span>";
						}
						if (hField.isShowAggr && hField.aggrOpts) {
							var agg = row.aggrVal;
							if (hField.aggrOpts.showAsPercentage) {
								agg = (row.percentage * 100).toFixed(hField.aggrOpts.decimalPoints) + "%";
							} else if (hField.dataField !== hField.aggrOpts.aggrColName) {
								if(row.uid !== $scope.prevRowUID) {
									$scope.prevRowUID = row.uid;
									$scope.rowIndex = $scope.kendoDataSource._data.indexOf(row);
								}
								var aggrDispVal = customReportSvc.getFormattedValue(agg,
										_getCellExpForColumn(hField.aggrOpts.aggrColName),
										row, $scope.rowIndex, undefined, hField, $scope.dataSet);
								agg = aggrDispVal ? aggrDispVal : agg;
							}
							fmtVal = "<span class='tree-aggr'>[" + agg + "]</span>" + fmtVal;
						}
						return iconHtml + fmtVal;
					};
					kendoCols.push(column);
					var cObj = {};
					cObj.field = "aggrVal";
					cObj.title = "% of parent";
					cObj.template = function(row) {
						if (row.isLoadMoreLink) {
							return "";
						}
						var w = (row.percentage * 100).toFixed($scope.component.hDataField.aggrOpts.decimalPoints) +
								"%";
						return "<div class='tree-percentage-outer'><div class='tree-percentage' style='width:" + w +
								"'>" + w + "</div></div>";
					};
					cObj.sortable = false;
					kendoCols.push(cObj);
				} else {
					column.template = function(row) {
						if (row.isLoadMoreLink) {
							return "";
						}
						var cellData = row[column.field];
						if (cellData === undefined) {
							return "";
						}
						var fmtVal = cellData;
						if(!cellExp) 
							cellExp = _getCellExpForColumn(column.field);
						
						if (cellExp && cellExp !== null) {
							if(row.uid !== $scope.prevRowUID) {
								$scope.prevRowUID = row.uid;
								$scope.rowIndex = $scope.kendoDataSource._data.indexOf(row);
							}
							fmtVal = customReportSvc.getFormattedValue(cellData, cellExp, row, $scope.rowIndex, undefined, column, $scope.dataSet);
							row[column.field+'_formatted'] = fmtVal;

						}
						let title = fmtVal;
						//model object from Kendo grid is of type Observable and Array.isArray wouldn't work
						//so checking .length
						if (typeof fmtVal === 'object' && fmtVal.length) {
							title = fmtVal.join("\n");
							fmtVal = fmtVal.join("<br/>");
						}
						return "<span class='gridcell-div' title='" + title + "'>" + fmtVal + "</span>";
					};
					kendoCols.push(column);
				}

			});
			$scope.kendoColumns = kendoCols;
			if ($scope.component.hDataField) {
				$scope.kendoTreeModel = {
					id : $scope.component.hDataField.dataField
				};
				if (typeof $scope.component.hDataField.numChildren === "undefined") {
					$scope.component.hDataField.numChildren = 20;//default value
				}
			}
		};

		$scope.$watchCollection('kendoColumns', function() {
			if (!$scope.componentLoaded || $scope.processing) {
				return;
			}
			$scope.createKendoTree();

		}, true);

		customReportSvc.registerCallback("updateChart", function(isRedrawOnly) {
			if (isRedrawOnly) {
				$scope.kendoTree.refresh();
			} else {
				$scope.kendoTree.dataSource.read();
			}
		}, $scope.component.id);

		//when formatters are applied; template has to be changed, so update the model
		customReportSvc.registerCallback("refreshTableData", function() {
			$scope.updateKendoModel();
		});

		customReportSvc.registerCallback("refreshComponent", function() {
			$scope.kendoTree.dataSource.read();
		});

		customReportSvc.registerCallback("reInitializeTable", function() {
			$scope.updateKendoModel();
		});

		customReportSvc.registerCallback("redrawAllComponents", function(compId, isAutoRefresh) {
			$scope.kendoTree.dataSource.read({isAutoRefresh});
		});

		customReportSvc.registerCallback("redrawOtherComponents", function(srcCompId) {
			if ($scope.component.id !== srcCompId) {
				$scope.kendoTree.dataSource.read();
			}
		});

		customReportSvc.registerCallback("hiddenColumn", function(index) {
			if ($scope.component.columns[index].hidden) {
				$scope.kendoTree.hideColumn($scope.component.columns[index].dataField);
			} else {
				$scope.kendoTree.showColumn($scope.component.columns[index].dataField);
			}
		});

		$scope.init = function() {
			$scope.updateKendoModel();
			$scope.createKendoTree();
		};

		//TODO: need to move the duplicate code to common place

		$scope.addColumn = function(colObj) {
			colObj = $scope.getBasicColumnDef(colObj);
			var aggrType = colObj.dataField === $scope.component.hDataField.dataField ? "Count" : "CountDistinct";
			if (numTypes.indexOf(colObj.type) > -1) {
				colObj.showNumberOps = true;
				//default
				aggrType = "Sum";
			}
			colObj.aggrType = aggrType;
			//colObj.sortOrder = "desc";
			colObj.column = colObj.dataField; //colObj is directly used as measureDataField which expects the field name in "column" property
			$scope.component.columns.push(colObj);
		};

		customReportSvc.registerCallback("columnRemoved", function(col) {
			if ($scope.component.id === col.componentId) {
				col.componentId = undefined;

				var columnIndex = $scope.getColumnIndexByID(col.id);
				if ($scope.component.allColumns) {
					col.hidden = true;
				} else {
					$scope.component.columns.splice(columnIndex, 1);
				}
				if ($scope.component.columns.length == 0) {
					$scope.component.dataSet = undefined;
					$($scope.component.id).empty();
				}
				$scope.setActiveComponent($scope.component);
				$scope.updateKendoModel();
			}
		});

		$scope.getColumnIndexByID = function(colId) {
			for (var i = 0; i < $scope.component.columns.length; i++) {
				if (colId.toLowerCase() == $scope.component.columns[i].id.toLowerCase()) {
					return i;
				}
			}
		};

		$scope.getBasicColumnDef = function(col) {
			var column = {
				dataField : col.name,
				displayName : col.name,
				id : $scope.generateColumnId(col.dataField),
				type : col.type,
				origType : col.hasOwnProperty("origType") ? col.origType : "",
				visible : true,
				hidden : false,
				aggrType : 'None',
				componentId : $scope.component.id,
			};
			if ($scope.reportMode === "preview" && $scope.component.columns.length > 9) {
				column.visible = false;
			}
			$scope.columnDefinitionById[column.id] = column;
			return column;
		};

		$scope.generateColumnId = function(dataField) {
			var id = dataField.replace(/\s/g, "");
			var orginalId = dataField.replace(/\s/g, "");
			var i = 1;
			while (id in $scope.columnDefinitionById) {
				id = orginalId + i;
				i++;
			}
			return id;
		};

		$scope.init();
	}
})();
