<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<div class="view-area select-filter-wrapper select-string-filter-wrapper">
		<div class="select-wrapper panel panel-primary ng-scope">
			<div class="input-search-wrapper panel-heading">
				<div  class="searchtext-wrapper">
							<span class="glyphicon glyphicon-search" aria-hidden="true"></span>
							<input type="text" class="search-box" placeholder="<fmt:message key="CustomReport.Search" /> {{fieldDisplayname}}" data-ng-model="search" data-ng-keyup="handleSearch(search)" autofocus="autofocus" />
							<span data-ng-show="searching" class="glyphicon glyphicon-refresh glyphicon-refresh-animate search-loading" aria-hidden="true"></span>
							<span data-ng-show="search.length > 0 && !input.searching" aria-hidden="true" class="clear-search-text" data-ng-click="search='';handleSearch(search);" title="Clear filter">&times;</span>
				</div>
			</div>
			<div class="select-all-wrapper">
				<label data-ng-if="viewSelected && selected.options.length>0" class="selected-label"><fmt:message key="CustomReport.MultiSelect.Selected"/></label>
				<div class="pull-right" >
					<label for="{{field}}-all" ><fmt:message key="CustomReport.MultiSelect.SelectAll"/></label>
					<div id="{{field}}-all" class="cv-material-toggle cv-toggle" data-ng-class="{'enabled':(allSelected), 'isOff':(!allSelected)}" title="<fmt:message key="CustomReport.MultiSelect.SelectAllToolTip"/>">
						<div class="cv-material-toggle-bar" data-ng-click="handleSelectAll(true)" ></div>
						<div class="cv-material-toggle-round" data-ng-click="handleSelectAll(true)"></div>
						</div>
				</div>
			</div>
			<div class="select-options multi-select" >
				<div class="multi-select-option-panel-right">
					<div class="multi-select-option" data-ng-repeat="option in options" title="{{option['label_tooltip'] || option['label']}}">
						<input id="{{field}}-cv-multi-option-{{$index}}" type="checkbox" checklist-value="option" checklist-model="selected.options" data-ng-click="updateSelection(option,checked)">
						<label for="{{field}}-cv-multi-option-{{$index}}"><a class="link-text" data-ng-click="updateSelection(option)"  ng-bind-html="option['label'] === '' ? 'Blank' : option['label']"></a><span class="multi-select-option-count">({{option.count}})</span></label>
					</div>
				</div>
			</div>
			<div class="record-info">
				<div class="load-more-link" data-ng-if="showLoadMore"><a class="btn-link" data-ng-click="getNextPage()"><fmt:message key="CustomReport.MultiSelect.LoadMore"/></a></div>
				<div class="pull-right">
					<button class="btn btn-primary" data-ng-click="handleSelectFilter()"><fmt:message key="CustomReport.Ok"/></button>
					<button type="button" class="btn" data-ng-click="clearSelectFilter()"><fmt:message key="CustomReport.Clear"/></button>
				</div>
			</div>

		</div>
	</div>
</fmt:bundle>