// Closure to isolate scope, as per best practices
(function() {
	// Get a reference to the reportsBuilder module
	var reports = angular.module("reports");

	reports
			.directive("selectFilter",
					function() {
						return {
							restrict : 'E',
							templateUrl : function(element, attrs) {
								return customReports.contextPath +
										'/reportsplus/components/kendoui/templates/filters/' + attrs.fieldType +
										'Filter.jsp'
							},
							replace : true,
							scope : {
								field : '@field',
								fieldType : '@fieldType',
								colType : '@colType',
								filterValue : '@filterValue',
								fieldDisplayname : '@fieldDisplayname',
								cellFilter : '@cellFilter',
								colSizeFormat : '@colSizeFormat'
							},
							controller : [
									"$scope",
									"reportService",
									"$uibModal",
									"customReportSvc",
									"$timeout",
									function($scope, reportService, $uibModal, customReportSvc, $timeout) {
										$scope.offset = 0;
										$scope.options = [];
										$scope.searchText = '';
										$scope.showLoadMore = false;
										$scope.searching = false;

										$scope.selected = {
											options : []
										};

										if ($scope.colType === "Decimal" || $scope.colType === "Double" ||
												$scope.fieldType === "size") {
											$scope.numericOptions = {
												decimals : 2,
												round : false,
												restrictDecimals : false
											}
										} else {
											$scope.numericOptions = {
												format : "0",
												decimals : 0
											}
										}

										$scope.allSelected = false;
										var operatorToSignMap = {
											"contains" : "",
											"eq" : "=",
											"neq" : "!=",
											"gte" : ">=",
											"gt" : ">",
											"lte" : "<=",
											"lt" : "<",
											"btw" : "",
											"last" : ">-",
											"next" : "<-"
										};

										var signToOperatorMap = {
											"" : "contains",
											"=" : "eq",
											"!=" : "neq",
											">=" : "gte",
											">" : "gt",
											"<=" : "lte",
											"<" : "lt"
										};

										$scope.relativeOperators = [ {
											id : 'm',
											value : "Minutes"
										}, {
											id : 'h',
											value : "Hours"
										}, {
											id : 'd',
											value : "Days"
										}, {
											id : 'w',
											value : "Weeks"
										}, {
											id : 'M',
											value : "Months"
										}, {
											id : 'y',
											value : "Years"
										} ];

										$scope.relativeSizeOperators = [ {
											rank : 0,
											id : 'bytes',
											value : "Bytes"
										}, {
											rank : 1,
											id : 'kb',
											value : "KB"
										}, {
											rank : 2,
											id : 'mb',
											value : "MB"
										}, {
											rank : 3,
											id : 'gb',
											value : "GB"
										}, {
											rank : 4,
											id : 'tb',
											value : "TB"
										}, {
											rank : 5,
											id : 'pb',
											value : "PB"
										} ];

										$scope.filter = {
											field : $scope.field,
											value : "",
											operator : $scope.fieldType === "number" ? "eq" : "relative",
											fieldType : $scope.fieldType,
											relativeOption : "d"
										}

										$scope.filter.operator = "eq";

										$scope.resetSizeOptions = function() {
											$scope.filter.operator = "lt";
											$scope.filter.relativeOption = 'gb';

											updateSizerealtiveOption('relativeFromOption', 'gb');
											updateSizerealtiveOption('relativeToOption', 'gb');
										}

										var updateSizerealtiveOption = function(option, type) {
											$scope.filter[option] = _.find($scope.relativeSizeOperators, {
												id : type
											});
										}

										$scope.resetSizeOptions();

										$scope.initSizeFilter = function() {
											if (!$scope.filterValue.startsWith('>=')) {
												let relativeOptionLength = $scope.filterValue.length - 2;
												$scope.filter.operator = signToOperatorMap[$scope.filterValue
														.substring(0, 1)]; // get the operator
												$scope.filter.value = parseInt($scope.filterValue.substring(1,
														relativeOptionLength)); // value
												$scope.filter.relativeOption = $scope.filterValue
														.substring(relativeOptionLength); // relative option kb|gb|tb
											} else {
												$scope.filter.operator = "between";

												if ($scope.filterValue.indexOf("&&") !== -1) {
													var y = $scope.filterValue.split("&&");
													let fromValue = y[0];
													let toValue = y[1];
													$scope.filter.from = parseInt(fromValue.substring(2));
													$scope.filter.to = parseInt(toValue.substring(2));
													updateSizerealtiveOption('relativeFromOption', fromValue
															.substring(fromValue.length - 2));
													updateSizerealtiveOption('relativeToOption', toValue
															.substring(toValue.length - 2));

												} else if ($scope.filterValue.startsWith(">=")) {
													$scope.filter.from = parseInt($scope.filterValue.substring(2));
													updateSizerealtiveOption('relativeFromOption', $scope.filterValue
															.substring($scope.filterValue.length - 2));

												} else if ($scope.filterValue.startsWith("<=")) {

													$scope.filter.to = parseInt($scope.filterValue.substring(1));
													updateSizerealtiveOption('relativeToOption', $scope.filterValue
															.substring($scope.filterValue.length - 2));
												}
											}
										}

										$scope.initNumberFilter = function() {
											if ($scope.filterValue.startsWith('=')) {
												$scope.filter.value = parseInt($scope.filterValue.substring(1));
											} else {
												$scope.filter.operator = "between";
												if ($scope.filterValue.indexOf("&&") !== -1) {
													var y = $scope.filterValue.split("&&");
													$scope.filter.from = parseInt(y[0].substring(2));
													$scope.filter.to = parseInt(y[1].substring(2));
												} else if ($scope.filterValue.startsWith(">=")) {
													$scope.filter.from = parseInt($scope.filterValue.substring(2));
												} else if ($scope.filterValue.startsWith("<=")) {
													$scope.filter.to = parseInt($scope.filterValue.substring(1));
												}
											}
										}

										var updateSizeValue = function() {

											if ($scope.filter.operator !== "between" &&
													typeof $scope.filter.value === "number") {
												let operator = operatorToSignMap[$scope.filter.operator];
												selectFilter.value = operator + $scope.filter.value +
														$scope.filter.relativeOption;
											} else {
												if (typeof $scope.filter.from === "number") {
													selectFilter.value = '>=' + $scope.filter.from +
															$scope.filter.relativeFromOption.id;
												}

												if (typeof $scope.filter.from === "number" &&
														typeof $scope.filter.to === "number") {
													selectFilter.value = selectFilter.value + " &&<=" +
															$scope.filter.to + $scope.filter.relativeToOption.id;
												}

												if (typeof $scope.filter.from !== "number" &&
														typeof $scope.filter.to === "number") {
													selectFilter.value = '<=' + $scope.filter.to +
															$scope.filter.relativeToOption.id;
												}
											}
										}

										//						$scope.initSizeFilter = function() {
										//							if (!$scope.filterValue.startsWith('>=')) {
										//								$scope.filter.value = parseInt($scope.filterValue.substring(1));
										//
										//								$scope.filter.relativeOption = $scope.filterValue.substring(0, 1);
										//							} else {
										//								$scope.filter.operator = "between";
										//								if ($scope.filterValue.indexOf("&&") !== -1) {
										//									var y = $scope.filterValue.split("&&");
										//									$scope.filter.from = parseInt(y[0].substring(2));
										//									$scope.filter.to = parseInt(y[1].substring(2));
										//								} else if ($scope.filterValue.startsWith(">=")) {
										//									$scope.filter.from = parseInt($scope.filterValue.substring(2));
										//								} else if ($scope.filterValue.startsWith("<=")) {
										//									$scope.filter.to = parseInt($scope.filterValue.substring(1));
										//								}
										//							}
										//						}

										$scope.initDateFilter = function() {
											if ($scope.filterValue.startsWith('>-')) {
												$scope.filter.operator = "relative";
												$scope.filter.value = parseInt($scope.filterValue.substring(2,
														$scope.filterValue.length - 1));
												$scope.filter.relativeOption = $scope.filterValue
														.substring($scope.filterValue.length - 1,
																$scope.filterValue.length);
											} else {
												$scope.filter.operator = "between";
												if ($scope.$parent.dataSet &&
														$scope.$parent.dataSet.endpoint === "DATACUBE" &&
														!$scope.$parent.useCREApiForSolr) {
													$scope.filterValue = JSON
															.parse(decodeURIComponent($scope.filterValue));
													if (!$.isEmptyObject($scope.filterValue)) {
														$scope.filter.from = new Date($scope.filterValue.from);
														$scope.filter.to = new Date($scope.filterValue.to);
													}

												} else {
													if ($scope.filterValue.indexOf("&&") !== -1) {
														var y = $scope.filterValue.split("&&");
														$scope.filter.from = new Date(y[0].substring(2));
														$scope.filter.to = new Date(y[1].substring(2));
													} else if ($scope.filterValue.startsWith(">=")) {
														$scope.filter.from = new Date($scope.filterValue.substring(2));
													} else if ($scope.filterValue.startsWith("<=")) {
														$scope.filter.to = new Date($scope.filterValue.substring(1));
													}
												}
											}
										}

										$scope.filterInitialized = false;
										$scope.initStringFilter = function() {
											$scope.filterInitialized = true;
											if ($scope.filterValue === "$all$") {
												$scope.handleSelectAll();
											} else {
												$scope.filterValue = $scope.filterValue.split(",");
												$scope.selected.options = _.filter($scope.options, function(element) {
													if ($scope.filterValue.indexOf(element.value) !== -1) {
														$scope.valueSelected = true;
														return element;
													}
												});
											}
										}

										$scope.getNextPage = function() {
											$scope.offset = $scope.offset + 100;
											$scope.initDataForStringFilter(true);
										}

										var promise = '';
										$scope.handleSearch = function(search) {
											if (promise) {
												$timeout.cancel(promise);
											}

											if (!search && $scope.allSelected) {
												$scope.allSelected = false;
											}
											promise = $timeout(function() {
												var searchText = '';
												$scope.offset = 0;
												if (search) {
													var column = $scope.$parent.getColumnById($scope.field);
													var labelField = "[" + column.dataField + "]"; //data fields having spaces in it require wrapping in square brackets.
													searchText = dataSetUtility.getNewFilter(search,
															labelField,
															'string',
															true);
												}
												$scope.searching = true;
												$scope.readDataForString(function(data) {
													$scope.searching = false;
													$scope.options = data.data.records;
													//$scope.initStringFilter();
													$scope.$apply();
												}, searchText);
											}, 500);
										}

										$scope.readDataForString = function(callBack, searchText) {
											$scope.$parent.loadDistinctdataForColumn($scope.field, {
												type : 'select',
												pageSize : 100,
												offset : $scope.offset,
												searchText : searchText
											}, "Count", true).then(callBack);
										}

										$scope.initDataForStringFilter = function(merge) {
											$scope
													.readDataForString(function(data) {
														if (merge) {
															$scope.options = $scope.options.concat(data.data.records);
															if ($scope.allSelected) {
																angular.copy($scope.options, $scope.selected.options);
															}
														} else {
															$scope.options = data.data.records;
														}
														$scope.showLoadMore = data.data.totalRecordCount > data.data.recordsCount;
														if ($scope.options.length === data.data.totalRecordCount) {
															$scope.showLoadMore = false;
														}
														if (!$scope.filterInitialized && $scope.filterValue) {
															$scope.initStringFilter();
														}
														$scope.$apply();
													});
										}

										if ($scope.fieldType === "string") {
											$scope.initDataForStringFilter();
										}

										if ($scope.filterValue) {
											if ($scope.fieldType === "number") {
												$scope.initNumberFilter();
											} else if ($scope.fieldType === "date") {
												$scope.initDateFilter();
											} else if ($scope.fieldType === "size") {
												$scope.initSizeFilter()
											}
										}

										var selectFilter = {
											field : $scope.field,
											type : "select",
											value : ""
										}

										$scope.fromOptions = {
											showWeeks : false,
											minDate : null,
											maxDate : new Date()
										};
										$scope.toOptions = {
											showWeeks : false,
											minDate : new Date(),
											maxDate : null

										};
										$scope.updateft = function() { //update min-date of filter.to
											$scope.toOptions.minDate = $scope.filter.from;
											if ($scope.filter.to.getTime() < $scope.filter.from.getTime()) {
												$scope.filter.to = $scope.filter.from
											}
										}
										var updateNumberValue = function() {
											if ($scope.filter.operator === "eq" &&
													typeof $scope.filter.value === "number") {
												selectFilter.value = '=' + $scope.filter.value;
											} else {
												if (typeof $scope.filter.from === "number") {
													selectFilter.value = '>=' + $scope.filter.from;
												}

												if (typeof $scope.filter.from === "number" &&
														typeof $scope.filter.to === "number") {
													selectFilter.value = selectFilter.value + "&&<=" + $scope.filter.to;
												}

												if (typeof $scope.filter.from !== "number" &&
														typeof $scope.filter.to === "number") {
													selectFilter.value = '<=' + $scope.filter.to;
												}
											}
										}

										var updateDateValue = function() {
											if ($scope.filter.operator === "relative" && $scope.filter.value) {
												selectFilter.value = ">-" + $scope.filter.value +
														$scope.filter.relativeOption;
											} else {
												if ($scope.$parent.dataSet &&
														$scope.$parent.dataSet.endpoint === "DATACUBE" &&
														!$scope.$parent.useCREApiForSolr) {
													selectFilter.value = {
														from : $scope.filter.from,
														to : $scope.filter.to
													};
												} else {
													if ($scope.filter.from) {
														selectFilter.value = '>=' +
																$scope.filter.from.toISOString().split('.')[0] + 'Z';
													}

													if ($scope.filter.from && $scope.filter.to) {
														selectFilter.value = selectFilter.value + "&&<=" +
																$scope.filter.to.toISOString().split('.')[0] + 'Z'
														1000;
													}

													if (!$scope.filter.from && $scope.filter.to) {
														selectFilter.value = '<=' +
																$scope.filter.to.toISOString().split('.')[0] + 'Z'
													}
												}
											}
										}

										$scope.handleSelectAll = function(update) {
											$scope.allSelected = !$scope.allSelected;
											if ($scope.allSelected) {
												$scope.selected.options = angular.copy($scope.options, []);
											} else {
												$scope.selected.options = []
											}
										}

										$scope.updateSelection = function(option, checked) {
											if (typeof checked !== "undefined") {
												if ($scope.selected.options.length === $scope.options.length) {
													$scope.handleSelectAll();
												} else if ($scope.allSelected) {
													$scope.allSelected = false;
												}
											} else {
												$scope.allSelected = false;
												$scope.selected.options = [];
												$scope.selected.options.push(option);
												updateStringValue();
												$scope.$parent.applyFilter(selectFilter);
											}
										}

										var updateStringValue = function() {
											if (!$scope.search && $scope.allSelected) {
												selectFilter.value = "$all$";
											} else {
												selectFilter.value = _.map($scope.selected.options, 'value');
												//selectFilter.value = JSON.stringify(selectFilter.value);
											}
										}

										var updateSizeValue = function() {

											if ($scope.filter.operator !== "between" &&
													typeof $scope.filter.value === "number") {
												let operator = operatorToSignMap[$scope.filter.operator];
												selectFilter.value = operator + $scope.filter.value +
														$scope.filter.relativeOption;
											} else {
												if (typeof $scope.filter.from === "number") {
													selectFilter.value = '>=' + $scope.filter.from +
															$scope.filter.relativeFromOption.id;
												}

												if (typeof $scope.filter.from === "number" &&
														typeof $scope.filter.to === "number") {
													selectFilter.value = selectFilter.value + "&&<=" +
															$scope.filter.to + $scope.filter.relativeToOption.id;
												}

												if (typeof $scope.filter.from !== "number" &&
														typeof $scope.filter.to === "number") {
													selectFilter.value = '<=' + $scope.filter.to +
															$scope.filter.relativeToOption.id;
												}
											}
										}

										var convertTargetToSourceSize = function(filter, valueProperty, sizeProperty) {
											let value = filter[valueProperty];
											let sourceSizeType = _.get(filter, sizeProperty); // user selected size in the filter.

											// if column source type is not in bytes than we should convert the target to source bytes.
											if ($scope.colSizeFormat !== "bytes") {
												// convert target value to bytes from the target size.
												let targetSizeType = $scope.colSizeFormat; // col size can be anything other than bytes.

												// we need to convert the user selected size into the column size format for the filter to work in the backend
												value = cvFormatters.formatSize(value, {
													target : targetSizeType.toUpperCase(),
													source : sourceSizeType.toUpperCase(),
													tofixed : 2
												});
												value = value.split(" ")[0]; // only send the value and not the unit.
												sourceSizeType = ""; // do not send size, so that backend does not convert into bytes.
											}

											return value + sourceSizeType;
										}

										var updateFilterValue = function() {
											selectFilter.value = "";
											$scope.showErrorMessage = false;
											if ($scope.fieldType === "number") {
												updateNumberValue();
											} else if ($scope.fieldType === "date") {
												updateDateValue();
											} else if ($scope.fieldType === "string") {
												updateStringValue();
											} else if ($scope.fieldType === "size") {
												updateSizeValue();
											}
										}

										$scope.showErrorMessage = false;
										$scope.handleSelectFilter = function() {
											if ($scope.filter.to < $scope.filter.from) {
												$scope.showInvalidTimeMessage = true;
												return;
											}

											if ($scope.fieldType === "size" &&
													$scope.filter.operator === "between" &&
													($scope.filter.relativeToOption.rank < $scope.filter.relativeFromOption.rank)) {
												$scope.showInvalidSizeErrorMessage = true;
												return;
											}

											$scope.showInvalidTimeMessage = false;
											$scope.filterApplied = $scope.filter.value ? true : false;
											updateFilterValue();
											if (!selectFilter.value) {
												$scope.showErrorMessage = true;
												return;
											}
											$scope.$parent.applyFilter(selectFilter);
										}

										$scope.clearSelectFilter = function() {
											$scope.selected.options = [];
											$scope.filter = {
												field : $scope.field,
												value : $scope.filterValue,
												fieldType : $scope.fieldType,
												operator : $scope.filter.operator,
												from : "",
												to : "",
												value : "",
												relativeOption : "d"
											}
											// in case user clicks  reset filter we need to clear this when menu opens next time;
											$scope.allSelected = false;
											$scope.resetSizeOptions();
											$scope.$parent.clearFilter(selectFilter);
										}

										customReportSvc.registerCallback("clearColumnFilter", function(columnId) {
											if (columnId === $scope.field) {
												$scope.clearSelectFilter();
											}
										}, $scope.field);

										customReportSvc.registerCallback("reinitalizeStringFilter", function(columnId) {
											if (columnId === $scope.field) {
												$scope.initDataForStringFilter(false);
											}
										}, $scope.field);

									} ]

						};
					});

})();
