<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">

	<ul class="secondary-header secondary-background-color">
		<li class="sub-header" title="General"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}"
			data-ng-click="selectedPropertyCategory='general'"><span
			class="ico ico-cog"></span></li>
		<li class="sub-header" title="Fields"
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}"
			data-ng-click="selectedPropertyCategory='fields'"><span
			class="ico ico-form-field"></span></li>
		<li class="sub-header" title="Filters" data-ng-show="propData.isDataCubeDataSet" 
			data-ng-class="{'sub-header-active': selectedPropertyCategory==='filters'}" 
			data-ng-click="selectedPropertyCategory='filters'">
			<span class="ico ico-funnel"></span>
		</li>
		<!--     <li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
        <span class="ico ico-code"></span>
    </li> -->
	</ul>

	<div
		data-ng-include="'${pageContext.request.contextPath}/reportsplus/properties/miscProperties.jsp'"></div>

	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message
							key="CustomReport.Properties.Title" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm"
							data-ng-model="propData.title.text" type="text"
							placeholder="<fmt:message key='CustomReport.Properties.ChartName'/>">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message
							key="CustomReport.Properties.ID" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							data-ng-model="propData.id"
							data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
							data-ng-blur="validateComponentId()"
							data-ng-class="{'pattern-invalid': !propData.id}">
					</div>
					<span class="inline-validation-error" data-ng-show="!propData.id">*ID
						should contain characters,digits and underscore only.</span>
					<!-- localize -->
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message
							key="CustomReport.Properties.DataSet" /></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm" type="text"
							placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
							readonly="true" data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						for="showBasicFilter" title='<fmt:message key="CustomReport.Properties.showSimpleFilter"/>'><fmt:message
							key="CustomReport.Properties.showSimpleFilter" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.showOnlyBasicFilter" id="showBasicFilter">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.HideHeader"/>'><fmt:message
							key="CustomReport.Properties.HideHeader" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.hideHeader" id="hideheader">
					</div>
				</div>
			</div>
		</div>
		
		<div class="row noLftRghtMargin" data-ng-if="!propData.showOnlyBasicFilter">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='Hide Basic/Advanced Filter Link'>Hide
						Basic/Advanced Filter Link</label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.hidefilterlink" id="hidefilterlink">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin" data-ng-if="!propData.showOnlyBasicFilter">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='Hide CheckBoxes'>Hide CheckBoxes</label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.hideCheckBox" id="hideCheckBox">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='Hide CheckBoxes'>Hide Collapse</label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.hideCollapse" id="hideCollapse">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='<fmt:message key="CustomReport.Properties.ApplyOnSelect"/>'><fmt:message
							key="CustomReport.Properties.ApplyOnSelect" /></label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.applyOnSelect" id="applyOnSelect">
					</div>
				</div>
			</div>
		</div>

		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						cv-label-title>Orientation</label>
					<!--TODO localize -->
					<div class="col-sm-8 noLftRghtPadding">
						<select class="form-control input-sm"
							data-ng-model="propData.orientation">
							<option value="horizontal">Horizontal</option>
							<!--TODO localize -->
							<option value="vertical">Vertical</option>
							<!--TODO localize -->
						</select>
					</div>
				</div>
				<label> </label>
			</div>
		</div>
		<div class="row noLftRghtMargin" data-ng-if="!propData.showOnlyBasicFilter">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-9 control-label noLftRghtPadding"
						title='Show Bars'>Show Bars</label>
					<div class="col-sm-3 noLftRghtPadding">
						<input type="checkbox" cv-toggle-switch
							data-ng-model="propData.showBars" id="showBars">
					</div>
				</div>
			</div>
		</div>		

		<div data-ng-if="propData.showBars" class="row noLftRghtMargin">
			<div class="col-xs-12">
				<div class="form-group">
					<label
						class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
						title='Bar Color'>Bar Color <!--TODO Localize --></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm seriesColor noLftRghtPadding"
							type="color" data-ng-model="propData.barColor">
					</div>
				</div>
			</div>
		</div>
		<!-- Mobile Visible Option -->
		<div class="col-xs-12"
			data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
			<div class="form-group">
				<label
					class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding"
					title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message
						key="CustomReport.Properties.Mobile.Visible" /></label>
				<div class="col-sm-4 noLftRghtPadding">
					<select class="form-control input-sm"
						data-ng-model="propData.mobile.visible">
						<option value="On"><fmt:message key="CustomReport.Yes" /></option>
						<option value="Off"><fmt:message key="CustomReport.No" /></option>
					</select>
				</div>
			</div>
		</div>
		<entity-security data-item="propData"></entity-security>
	</div>

	<!-- Begin "Field" group -->
	<div data-ng-show="selectedPropertyCategory==='fields'">
		<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-click="collapsed['field']=!collapsed['field']"
			data-ng-if="propData.filterDataField && propData.filterDataField['viewer']">
			<div class="col-xs-12 noLftRghtPadding">
				<span
					data-ng-class="{'ico ico-chevron-down':collapsed['field'], 'ico ico-chevron-right':!collapsed['field']}"></span>
				<span>Fields</span>
			</div>
		</div>
		<div
			data-ng-if="propData.filterDataField && propData.filterDataField['viewer']"
			data-ng-class="{'collapsed': !collapsed['field']}">
			<div
				data-ng-repeat="(dataSetName, filterObj) in propData.filterDataField['viewer']">
				<div
					data-ng-repeat="field in propData.filterDataField['viewer'][dataSetName]['fields'] | filter: {isVisible:true}">
					<div
						class="row noLftRghtMargin fieldPanel secondary-header inner-panel">
						<div class="fieldHeader"
							data-ng-click="collapsed['field'+$index]=!collapsed['field'+$index]">
							<label class="col-lg-9 noLftRghtPadding" title=""> <span>{{field.column}}</span>
							</label> <span class="pull-right"> <span
								class="ico inner-panel-expand-icon"
								data-ng-class="{'ico-chevron-down':!collapsed['field'+$index], 'ico-chevron-right':collapsed['field'+$index]}"></span>
								<span class="ico inner-panel-expand-icon ico-trash2"
								title="Remove field"
								data-ng-click="deleteFilterDimension(dataSetName, 'viewer', $index)"></span>
							</span>
						</div>
						<div data-ng-class="{'collapsed' : collapsed['field' + $index]}">
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										cv-label-title>Display Name<!-- TODO: Localize --></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input type="text" class="form-control input-sm"
											data-ng-model="field.displayName" placeholder="Display Name">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin" data-ng-if="!propData.showOnlyBasicFilter">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										cv-label-title>Dimension Column Header<!-- TODO: Localize --></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input type="text" class="form-control input-sm"
											data-ng-model="field.dimensionColumnHeader"
											placeholder="Dimension Column Header">
									</div>
								</div>
							</div>
							<div class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='Icon Html'>Icon Html</label>
									<div class="col-sm-8 noLftRghtPadding">
										<textarea data-ng-model="field.iconHtml"></textarea>

									</div>

								</div>
							</div>
							<div data-ng-if="!propData.isDateRange(field, dataSetName)"
								class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.MaxPoints"/>'><fmt:message
											key="CustomReport.Properties.MaxPoints" /> </label>
									<div class="col-sm-8 noLftRghtPadding">
										<input class="fieldPropValue form-control maxPointTextbox"
											data-ng-model="field.numPointsToDisplay.maxPoints"
											data-ng-readonly="field.numPointsToDisplay.includeAll"
											data-ng-change="redrawComponent(propData.id)" type="text">
									</div>
								</div>
							</div>
							<div data-ng-if="!propData.isDateRange(field, dataSetName)"
								class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.All"/>'><fmt:message
											key="CustomReport.Properties.All" /></label>
									<div class="col-sm-4 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="field.numPointsToDisplay.includeAll"
											id="includeall_{{dataSetName+'_'+$index}}"
											data-ng-change="redrawComponent(propData.id)">

									</div>
								</div>
							</div>
							<div data-ng-if="!propData.isDateRange(field, dataSetName)"
								class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.ShowRadioBtns"/>'><fmt:message
											key="CustomReport.Properties.ShowRadioBtns" /></label>
									<div class="col-sm-4 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="field.showRadioButtons"
											id="showRadioBtns_{{dataSetName+'_'+$index}}"
											data-ng-change="redrawComponent(propData.id)">

									</div>
								</div>
							</div>


							<div
								data-ng-if="!propData.showOnlyBasicFilter && !propData.isDateRange(field, dataSetName)"
								class="row noLftRghtMargin">

								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding"
										title='<fmt:message
											key="CustomReport.Properties.ShowSearchBar" />'><fmt:message
											key="CustomReport.Properties.ShowSearchBar" /></label>
									<div class="col-sm-4 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="field.showSearchBar"
											id="showSearchBar_{{dataSetName+'_'+$index}}">
									</div>
								</div>

							</div>

							<div data-ng-if="!propData.isDateRange(field, dataSetName) && propData.isDataCubeDataSet"
								class="row noLftRghtMargin">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding"
										title='<fmt:message key="CustomReport.Properties.ShowEmptyValue"/>'><fmt:message
											key="CustomReport.Properties.ShowEmptyValue" /></label>
									<div class="col-sm-4 noLftRghtPadding">
										<input type="checkbox" cv-toggle-switch
											data-ng-model="field.showEmptyValues"
											id="showEmptyValues{{dataSetName+'_'+$index}}"
											data-ng-change="redrawComponent(propData.id)">

									</div>
								</div>
							</div>
							<div data-ng-if="!propData.isDateRange(field, dataSetName) && field.showEmptyValues && propData.isDataCubeDataSet"
								class="row noLftRghtMargin">
								<div class="form-group">
									<label
									class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding"
									title='<fmt:message key="CustomReport.Properties.EmptyValLabel"/>'><fmt:message key="CustomReport.Properties.EmptyValLabel"/></label>
									<div class="col-sm-8 noLftRghtPadding">
										<input type="text" class="form-control input-sm"
											data-ng-model="field.emptyValueLabel" 
											placeholder='<fmt:message key="CustomReport.Properties.EmptyValLabel"/>'
											data-ng-blur="redrawComponent(propData.id)">
									</div>
								</div>
							</div>

							<div class="row formatter-option">
								<div class="col-xs-12">
									<div class="form-group">
										<label
											class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
											title='Formatter'> Formatter <!-- TODO: localize -->
										</label>
										<div class="col-sm-5 noLftRghtPadding">
											<span class="pull-right"> <span
												class="label label-info cursor-pointer"
												data-ng-click="showFormatterOptions(field,'formatter')">{{getFormatterType(field.formatter)}}</span>
											</span>
										</div>
									</div>
								</div>
							</div>
							<div data-ng-if="!propData.isDateRange(field, dataSetName)"
								data-ng-repeat="measure in field.measureDataFields">
								<div
									class="row noLftRghtMargin fieldPanel secondary-header inner-panel"
									style="margin-right: 0px; margin-left: 0px;">
									<div class="fieldHeader"
										data-ng-click="collapsed['measure'+$index]=!collapsed['measure'+$index]">
										<label class="col-lg-9 noLftRghtPadding" title=""> <span>{{measure.column}}</span>
										</label> <span class="pull-right"> <span
											class="ico inner-panel-expand-icon"
											data-ng-class="{'ico-chevron-down':!collapsed['measure'+$index], 'ico-chevron-right':collapsed['measure'+$index]}"></span>
											<span class="ico inner-panel-expand-icon ico-trash2"
											title="Remove field"
											data-ng-click="deleteFilterMeasure(field, $index);redrawComponent(propData.id)"></span>
										</span>
									</div>
									<div
										data-ng-class="{'collapsed' : collapsed['measure' + $index]}">

										<div>
											<label class="col-lg-9 control-label noLftRghtPadding"
												title='Aggregate'> Aggregate <!-- TODO: localize -->
											</label> <span
												data-ng-hide="propData.showOnlyBasicFilter && measure.aggrTypes.length >= 1"
												class="pull-right ico ico-plus-circle addAggrIcon"
												title="Add Aggregate"
												data-ng-click="addAggregate(measure,-1,'')"></span>


										</div>

										<div class="row ng-scope noLftRghtMargin"
											data-ng-repeat="aggrType in measure.aggrTypes">

											<div class="col-md-12 form-group noLftRghtPadding">
												<select data-ng-model="aggrType"
													data-ng-if="measure.showNumberOps"
													data-ng-change="addAggregate(measure,$index,aggrType);"
													class="col-md-4 noLftRghtPadding">
													<option
														ng-repeat="aggr in aggrTypesForNumber | filterDuplicateAggregates:measure.aggrTypes:aggrType"
														value="{{aggr}}" ng-selected="aggr === aggrType">{{aggr}}</option>
												</select> <select data-ng-model="aggrType"
													data-ng-if="!measure.showNumberOps"
													data-ng-change="addAggregate(measure,$index,aggrType);"
													class="col-md-4 noLftRghtPadding">
													<option
														ng-repeat="aggr in aggrTypesForString | filterDuplicateAggregates:measure.aggrTypes:aggrType"
														value="{{aggr}}" ng-selected="aggr === aggrType">{{aggr}}</option>
												</select> <input
													class="col-md-6 noLftRghtPadding measureDisplayNameInput margin-left-5"
													type="text"
													data-ng-change="propData.refreshFilterPanelHeader(dataSetName,field.column,measure.aggrDisplayNames[$index],measure.column,measure.aggrTypes[$index])"
													data-ng-model="measure.aggrDisplayNames[$index]"> <span
													class="ico ico-trash2 pro-dlt-btn col-md-2 noLftRghtPadding margin-left-5"
													data-ng-click="deleteAggregate(measure,$index);redrawComponent(propData.id)">
												</span>

											</div>
										</div>
										<!-- end ngRepeat: sort in propData.sorting -->


									</div>
								</div>
							</div>
							<div
								data-ng-if="!propData.showOnlyBasicFilter && !propData.isDateRange(field, dataSetName)"
								class="row noLftRghtMargin">
								<button type="button" class="btn btn-primary btn-sm"
									data-ng-click="showFieldsFromDataSet(dataSetName)">Add
									Measure</button>
							</div>
							<div class="row noLftRghtMargin">
								<select class="form-control input-sm"
									data-ng-model="selectedMeasureField"
									data-ng-change="addMeasureToFilterPanel(selectedMeasureField, field)"
									data-ng-show="showMeasureDropDown"
									data-ng-options="measureField.dataField for measureField in ds.fields">
									<option value="" disabled>Select Field</option>
								</select>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
			<div class="row noLftRghtMargin secondary-header property-header"
			data-ng-click="collapsed['otherProperties']=!collapsed['otherProperties']"
			data-ng-show="propData.filterDataField && propData.filterDataField['viewer']">
				<div class="col-xs-12 noLftRghtPadding">
					<span
						data-ng-class="{'ico ico-chevron-down':!collapsed['otherProperties'], 'ico ico-chevron-right':collapsed['otherProperties']}"></span>
					<span>Custom Groups</span>
				</div>
			</div>
			<div data-ng-class="{'collapsed': collapsed['otherProperties']}"
				data-ng-show="propData.filterDataField && propData.filterDataField['viewer']">
				<div
					data-ng-repeat="(dataSetName, filterObj) in propData.filterDataField['viewer']">
					<div class="row noLftRghtMargin"
						data-ng-repeat="field in propData.filterDataField['viewer'][dataSetName]['fields'] | filter: {isVisible:true}">
						<div class="row noLftRghtMargin">
							<div class="col-xs-12">
								<div class="form-group">
									<label
										class="col-xs-12 col-sm-12 col-md-12 col-lg-7 control-label noLftRghtPadding"
										title='{{field.column}}'> {{field.column}} </label>
									<div class="col-sm-5 noLftRghtPadding">
										<span class="pull-left margin-top-3"> <input
											type="checkbox" cv-toggle-switch
											data-ng-model="field.customGroupsAvailable"
											id="customgroup{{$index}}"
											data-ng-click="updateCustomGroupsAvailable(field)">
										</span> <span
											class="ico ico-pencil pro-btn-algn cursor-pointer pull-right"
											data-ng-click="showAdditionalProperties(field, dataSetName)"
											data-ng-show="field.customGroupsAvailable"></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- End "General" group -->
		<!-- Begin "Filters" group -->
		<div data-ng-show="selectedPropertyCategory==='filters'">
			<div class="row noLftRghtMargin">
				<div class="col-xs-12">
					<label class="col-xs-12 noLftRghtPadding">
						<fmt:message
							key="CustomReport.Properties.CustomFilterQuery"/><br>
					</label>
					<span class="col-xs-12 noLftRghtPadding">
						<textarea  data-ng-model="propData.customFilterQuery" data-ng-blur="redrawComponent(propData.id)"></textarea>
					</span>
				</div>
			</div>
		</div>
		<!-- End "Filter" group -->
		<!-- Begin "FormatOptons" group -->
		<!-- <div data-ng-show="selectedPropertyCategory==='customcode'">
			<div class="row noLftRghtMargin">
				<div class="col-xs-12">
					<label class="col-xs-12 noLftRghtPadding"> <fmt:message
							key="CustomReport.Properties.PointExpression" /><br>
					</label> <span class="col-xs-12 noLftRghtPadding"> <textarea
							data-ng-model="propData.onClick"
							data-ng-blur="redrawComponent(propData.id)"></textarea>
					</span>
				</div>

			</div>
		</div> -->

		<!-- <a id="resetButton" class="mainBtn" data-ng-click="resetDefault()">
    <fmt:message key="CustomReport.Properties.ResetToDefault"/>
</a> -->
</fmt:bundle>