<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.ReportsPlusMessages">
	<div ng-controller="facetCtrl" class="full-height facet-panel"
		data-ng-class="{'facet-property-panel' : type != 'component'}">
		<div class="fields-drop" data-ng-show="showDropMessage()"
			data-ng-class="{'property-fields-drop' : type != 'component'}">
			Drop fields here</div>
		<div
			data-ng-class="{'overlay' : isFieldDragging, 'property-overlay' : type != 'component'}"
			data-ng-show="isFieldDragging" x-lvl-drop-target="true"
			x-on-drop="dropped(dragEl, dropEl)">
			<!-- <span>Drop fields here</span>			 -->
		</div>
		<div data-ng-show="showFacetModal && field" id="filter-modal">
			<div class="filterBtnWraper" data-ng-if="!config.applyOnSelect">
				<button type="button" class="btn btn-default btn-sm pull-left"
					data-ng-click="clearComponentFilters(undefined, dataSetName,undefined,undefined,true)"
					data-ng-show="showFilterClearOption(undefined, dataSetName)">Clear</button>
				<button type="button" class="btn btn-primary btn-sm"
					data-ng-click="applyFacetFilter(undefined, undefined, undefined, undefined, dataSetName, true)">Apply</button>
			</div>
			<div
				data-ng-style="!field.showSearchBar ? {'height' : '40px'} : {'height' : '76px'}"
				data-ng-class="{'blueBckgrndStyle' : config.showOnlyBasicFilter && config.orientation === 'horizontal', 'headerStyle' : config.showOnlyBasicFilter && config.orientation === 'vertical'}"
				class="panel-heading row noLftRghtMargin">
				<div class="filter-panel-header-title">
					<div data-ng-if="field.iconHtml" class="facet-icon-wrappper"
						data-ng-bind-html="field.iconHtml"></div>

					<label class="panel-title" data-ng-bind-html="field.displayName" title={{field.displayName}}></label><span
						data-ng-if="tempDatasetObj[dataSetName][field.column] && tempDatasetObj[dataSetName][field.column].numBuckets"
						class="panel-filter-count padding-left-5">&nbsp;({{tempDatasetObj[dataSetName][field.column].numBuckets}})</span>
					<span class="noLftRghtPadding filter-panel-btns pull-right">
						<a data-ng-if="!(config.showOnlyBasicFilter && config.orientation === 'horizontal') && showFilterClearOption(field, dataSetName)" class="cursor-pointer padding-left-5" data-ng-click="clearComponentFilters(field, dataSetName,undefined,undefined,undefined,$event)">Clear</a>
						<span class="glyphicon glyphicon-trash cursor-pointer padding-left-5"
							data-ng-click="deleteFilterField(fieldObj, fieldIndex, dataSetName)"
							data-ng-show="reportMode === 'builder'"></span>
					</span>

				</div>

				<div
					data-ng-if="field.showSearchBar && field.filterType !== 'advanced'"
					class="row noLftRghtMargin">
					<div class="col-md-12 col-lg-12 searchBarElm">
						<div class="k-textbox k-space-right filter-Panel-searchBar">
							<input type="text" name="" class="input"
								data-ng-model="tempDatasetObj[dataSetName][field.column].searchFields"
								class="k-textbox"
								data-ng-keyup="!field.numPointsToDisplay.includeAll && doFacetSearch(dataSetName, field, tempDatasetObj[dataSetName][field.column].searchFields)">
							<span class="glyphicon glyphicon-search glyphicon-search-align">&nbsp;</span>
						</div>
					</div>
				</div>
			</div>

			<div data-ng-if="!config.isDateRange(field, dataSetName) || (field.customGroupsAvailable && field.groups.length > 0)">
				<div class="basic-filtering"
					data-ng-show="field.filterType==='basic'">
					<div class="selectAllDiv" data-ng-if="data[dataSetName][field.column].length > 0 && !field.showRadioButtons && config.showOnlyBasicFilter && config.orientation === 'horizontal'">
						<label for="selectAll" title="<fmt:message key='CustomReport.MultiSelect.SelectAll'/>"><fmt:message key='CustomReport.MultiSelect.SelectAll'/></label>
						<div class="pull-right">
							<div class="cv-material-toggle cv-toggle" data-ng-class="{'enabled':(field.selectAll), 'isOff':(!field.selectAll)}">
								<div class="cv-material-toggle-bar"  data-ng-click="clearComponentFilters(field, dataSetName);field.selectAll=!field.selectAll;"></div>
								<div class="cv-material-toggle-round" data-ng-click="clearComponentFilters(field, dataSetName);field.selectAll=!field.selectAll;"></div>
							</div>
						</div>
					</div>
					<table data-ng-init="currentPage=1" id="{{dataSetName+'_'+field.column+'_'+$index}}"
						class="table-responsive facet-table" width="100%" cellpadding="0"
						cellpadding="0" border="0" data-ng-class="config.showOnlyBasicFilter && config.orientation === 'horizontal' ? 'scrollBarStyle heightCss' : ''" data-ng-style="config.showOnlyBasicFilter && config.orientation === 'horizontal' && appName === 'adminconsole'? {'padding-bottom': '10px'} :''">
						<thead data-ng-if="!config.showOnlyBasicFilter">
							<tr class="all-values">
								<th
									id="{{dataSetName+'_'+field.column+'_'+$index+'_fieldName'}}"
									data-ng-class="{'sorting_desc': field.sort.sortDirection==='desc' && field.sort.sortField== 'index','sorting_asc': field.sort.sortDirection==='asc' && field.sort.sortField== 'index'}"
									class="checkbox"
									data-ng-style="config.hideCheckBox?{'padding-left':'0px'}:''">
									<div data-ng-click="applySorting(field, undefined, aggrType)">
										<input class="noleftMargin customChkBx"
											data-ng-if="!config.hideCheckBox && !field.showRadioButtons && !field.customGroupsAvailable"
											type="checkbox" data-ng-model="field.selectAll"
											class="" id="all{{$index}}"><label
											data-ng-class="field.showRadioButtons ? 'facet-column-header noLftRghtPadding' : 'facet-column-header'"
											ng-attr-title="{{field.dimensionColumnHeader}}" data-ng-click="clearComponentFilters(field, dataSetName,undefined,undefined,undefined,$event);field.selectAll=!field.selectAll;">{{field.dimensionColumnHeader}}&nbsp;&nbsp;</label>
									</div>
								</th>
								<th
									data-ng-if="field.measureDataFields.length > 1"
									id="{{dataSetName+'_'+measureObj.aggrType+'_'+measureObj.measure+'_'+$index}}"
									data-ng-class="{'sorting_desc': field.sort.sortDirection==='desc' && field.sort.sortField== (measureObj.aggrType+'_'+measureObj.measure),'sorting_asc': field.sort.sortDirection==='asc' && field.sort.sortField== (measureObj.aggrType+'_'+measureObj.measure)}"
									data-ng-repeat="measureObj in tempDatasetObj[dataSetName][field.column]"
									data-ng-click="applySorting(field, measureObj.measure, measureObj.aggrType)">
									<label class="noLftRghtPadding"
									ng-attr-title="{{measureObj.displayName}}">{{measureObj.displayName}}&nbsp;&nbsp;</label>

								</th>
							</tr>
						</thead>
						<tbody data-ng-class="!(config.showOnlyBasicFilter  && config.orientation === 'horizontal') ? 'scrollBarStyle' : ''"   infinite-scroll="(field.numPointsToDisplay.includeAll || config.showOnlyBasicFilter) && (currentPage=data[dataSetName][field.column].length > (currentPage + tempDatasetObj[dataSetName][field.column].maxPoints) ? currentPage+1 : currentPage)"
						infinite-scroll-distance="3" infinite-scroll-parent="true" data-ng-style="config.showOnlyBasicFilter? {'max-height' : '270px'} : {'height' : '270px'}">
							<tr data-ng-if="field.numPointsToDisplay.maxPoints > 0 && data[dataSetName][field.column].length === 0"><td class="noDataElm" >No data to display</td></tr>
							<tr
								data-ng-repeat="facet in data[dataSetName][field.column] | filterByGroups : this : dataSetName : field | filter: config.showOnlyBasicFilter ? '' : tempDatasetObj[dataSetName][field.column].searchFields | limitTo: (field.showComboBox ? tempDatasetObj[dataSetName][field.column].maxPoints :currentPage*tempDatasetObj[dataSetName][field.column].maxPoints)" data-ng-class="!(config.showOnlyBasicFilter  && config.orientation === 'horizontal') ? 'fillAvailableWidth' : ''">
								<td class="checkbox"
									data-ng-style="config.hideCheckBox?{'padding-left':'0px'}:''">
									<input class="noleftMargin customChkBx" data-ng-if="!config.hideCheckBox"
									type="{{tempDatasetObj[dataSetName][field.column].inputBtnType}}"
									value="{{facet.isSelected}}"
									data-ng-checked="getterSetterFn"
									ng-init="getterSetterFn = getModelValForInput(field,facet,dataSetName)"
									data-ng-model="getterSetterFn"
									ng-model-options="{getterSetter: true}"
									data-ng-change="tempDatasetObj[dataSetName][field.column].searchFields='';applyFacetFilter(facet, field, undefined, undefined, dataSetName)"
									class="" id="{{field.column}}_check{{facet.val + '_' + $index}}"> <label
									data-ng-class="field.showRadioButtons ? 'padding-lft-2 checkbox-label no-left-padding' : 'checkbox-label no-left-padding'"
									for="{{field.column}}_check{{facet.val + '_' + $index}}"><span
										id="facetDimentionVal" ng-attr-title="{{getFormattedValue(facet.val,
													field, dataSetName)}}" data-ng-bind-html="getFormattedValue(facet.val,
													field, dataSetName)" class="filter-val-width"></span><span

										data-ng-if="!config.showBars && field.measureDataFields.length === 1 && field.measureDataFields[0].aggrTypes.length > 0 && field.measureDataFields[0].aggrTypes[0] !== ''"
										class="facetCount" data-ng-init="measureObj=tempDatasetObj[dataSetName][field.column][0]">&nbsp&nbsp({{formatNumberToString(measureObj.aggrType
													=='Count'?facet.count:facet[measureObj.aggrType + '_' +
													measureObj.measure])}})</span></label>

								</td>
								<td data-ng-if="field.measureDataFields.length > 1 || config.showBars"
									data-ng-repeat="measureObj in tempDatasetObj[dataSetName][field.column]"
									data-ng-click="applySorting(field, measureObj.measure, measureObj.aggrType)">
									<span class="col-sm-12 noLftRghtPadding">
										<span data-ng-class="config.showBars?'col-sm-5' : 'col-sm-12'" class="noLftPadding"
											data-ng-style="!config.showBars?{'text-align':'center'}:{'text-align':'right'}">{{formatNumberToString(measureObj.aggrType
											=='Count'?facet.count:facet[measureObj.aggrType + '_' +
											measureObj.measure])}}</span>
										<span  class="noLftRghtPadding col-sm-7" data-ng-if="config.showBars"><div class="facet-bar " data-ng-style="{'height' : '10px','width':getBarWidth(measureObj.aggrType=='Count'?facet.count:facet[measureObj.aggrType + '_' + measureObj.measure],measureObj.aggrType=='Count'?tempDatasetObj[dataSetName][field.column]['max_count']:tempDatasetObj[dataSetName][field.column]['max_'+measureObj.aggrType + '_' + measureObj.measure]),'background-color':config.barColor}"></div></span>
									</span>

								</td>
							</tr>
						</tbody>
					</table>
					<div class="autoSuggestElm"
						data-ng-if="config.showOnlyBasicFilter && data[dataSetName][field.column].length !== 0 && (field.showNumberOps || (!field.customGroupsAvailable && (field.showComboBox ? tempDatasetObj[dataSetName][field.column].maxPoints : (field.numPointsToDisplay.includeAll ? (currentPage*tempDatasetObj[dataSetName][field.column].maxPoints) : data[dataSetName][field.column].length)) < tempDatasetObj[dataSetName][field.column].numBuckets))"
						data-ng-style="appName === 'adminconsole'? {'margin-top': '-2px'} :''">
						<input data-ng-if="!field.showComboBox"
							placeholder="{{field.showNumberOps ? 'e.g. >= val': 'Filter'}}"
							typeahead-wait-ms="200"
							data-ng-keyup="(field.showNumberOps&& $event.keyCode == 13) ? applyFacetFilter(tempDatasetObj[dataSetName][field.column].searchFields, field, false, undefined, dataSetName):(!field.showNumberOps ? doFacetSearch(dataSetName, field, tempDatasetObj[dataSetName][field.column].searchFields, this) : null)"
							type="text"
							data-ng-model="tempDatasetObj[dataSetName][field.column].searchFields"
							uib-typeahead="facet.val for facet in suggestionList[dataSetName][field.column] | filter:$viewValue"
							typeahead-loading="loadingLocations"
							typeahead-no-results="noResults"
							class="form-control autoSuggestInput"
							typeahead-on-select="addSelectedItemTofilter(dataSetName,field,$item)">
						<select data-ng-init="facet.val=''" data-ng-model="facet.val"
							data-ng-if="field.showComboBox"
							data-ng-change="addSelectedItemTofilter(dataSetName,field,facet)"
							class="form-control">
							<option value="" data-ng-disabled="true">Select</option>
							<option ng-repeat="facet in data[dataSetName][field.column] | byRange: tempDatasetObj[dataSetName][field.column].maxPoints"
								value="{{facet.val}}">{{facet.val}}</option>
						</select>

					</div>
				</div>
				<div
					data-ng-class="{'marginForAdvacedFiltering':field.showSearchBar}"
					class="advanced-filtering panel-body"
					data-ng-show="field.filterType==='advanced'" data-ng-style="config.showOnlyBasicFilter? {'max-height' : '306px'} : {'height' : '306px'}">
					<div data-ng-repeat="advancedFilter in field.advancedFilters">
						<div class="margin-bottom-10" style="color: black;">Show
							items with value that:</div>
						<!-- TODO localize -->
						<div class="margin-bottom-10">
							<select class="form-control"
								data-ng-model="advancedFilter.filters[0].operator">
								<option value="isempty" data-ng-if="!field.showNumberOps">Is
									Empty</option>
								<option value="isnotempty" data-ng-if="!field.showNumberOps">Is
									Not Empty</option>
								<option value="contains" data-ng-if="!field.showNumberOps">contains</option>
								<option value="doesnotcontain" data-ng-if="!field.showNumberOps">does
									not contain</option>
								<option value="startswith" data-ng-if="!field.showNumberOps">starts
									with</option>
								<option value="doesnotstartswith"
									data-ng-if="!field.showNumberOps">does not starts with</option>
								<option value="less" data-ng-if="field.showNumberOps">is
									less than</option>
								<option value="leq" data-ng-if="field.showNumberOps">is
									less than or equal to</option>
								<option value="greater" data-ng-if="field.showNumberOps">is
									greater than</option>
								<option value="geq" data-ng-if="field.showNumberOps">is
									greater than or equal to</option>
								<option value="eq">is equal to</option>
								<option value="neq">is not equal to</option>
							</select>
						</div>
						<div class="margin-bottom-10">
							<input type="text" class="form-control"
								data-ng-model="advancedFilter.filters[0].value">
						</div>
						<div class="margin-bottom-10">
							<div class="radio">
								<label> <input type="radio"
									data-ng-click="advancedFilter.logic='and'"
									data-ng-checked="advancedFilter.logic==='and'"> AND
								</label> <label> <input type="radio"
									data-ng-click="advancedFilter.logic='or'"
									data-ng-checked="advancedFilter.logic==='or'"> OR
								</label>
							</div>
						</div>
						<div class="margin-bottom-10">
							<select class="form-control"
								data-ng-model="advancedFilter.filters[1].operator">
								<option value="isempty" data-ng-if="!field.showNumberOps">Is
									Empty</option>
								<option value="isnotempty" data-ng-if="!field.showNumberOps">Is
									Not Empty</option>
								<option value="contains" data-ng-if="!field.showNumberOps">contains</option>
								<option value="doesnotcontain" data-ng-if="!field.showNumberOps">does
									not contain</option>
								<option value="startswith" data-ng-if="!field.showNumberOps">starts
									with</option>
								<option value="doesnotstartswith"
									data-ng-if="!field.showNumberOps">does not starts with</option>
								<option value="less" data-ng-if="field.showNumberOps">is
									less than</option>
								<option value="leq" data-ng-if="field.showNumberOps">is
									less than or equal to</option>
								<option value="greater" data-ng-if="field.showNumberOps">is
									greater than</option>
								<option value="geq" data-ng-if="field.showNumberOps">is
									greater than or equal to</option>
								<option value="eq">is equal to</option>
								<option value="neq">is not equal to</option>
							</select>
						</div>
						<div class="margin-bottom-10">
							<input type="text" class="form-control"
								data-ng-model="advancedFilter.filters[1].value">
						</div>
						<div data-ng-if="config.applyOnSelect" class="margin-bottom-10"
							style="text-align: right;">
							<button type="button" class="btn btn-primary btn-sm"
								data-ng-click="applyFacetFilter(undefined, field, true, $index, dataSetName)">Apply
								Filter</button>
						</div>
					</div>
				</div>
				<div data-ng-if="!config.showOnlyBasicFilter && !field.customGroupsAvailable" class="panel-footer"
					data-ng-class="{'collapsed':parentObj.collapsed[$index]}">
					<a class="cursor-pointer pull-left"
						data-ng-click="field.numPointsToDisplay.includeAll =! field.numPointsToDisplay.includeAll;showFacet();"
						data-ng-show="!field.numPointsToDisplay.includeAll">Show All</a> <a
						data-ng-if="!config.hideCheckBox && !config.hidefilterlink"
						class="cursor-pointer pull-right"
						data-ng-click="field.filterType = field.filterType === 'advanced' ? 'basic' : 'advanced'">{{field.filterType
						=== 'advanced' ? 'Basic Filtering' : 'Advanced Filtering'}}</a>
				</div>
			</div>
			<div data-ng-if="config.isDateRange(field, dataSetName)"
				data-ng-class="{'collapsed':parentObj.collapsed[$index]}">
				<div class="panel-body" data-ng-style="config.showOnlyBasicFilter? {'max-height' : '306px'} : {'height' : '306px'}">
					<div class="date-range">
						<div
							class="date-range-element input-group"
							cv-date-time-range-picker
							component="dateRangeFields[field.column]"
							data-show-relative="false">
							<input type="daterange" class="dateRangeInput form-control"
								placeholder="Filter by range"><span
								ng-click="showCalender($event)"
								class="glyphicon glyphicon-calendar input-group-addon" data-ng-style="config.orientation === 'horizontal' ? {'width' : 'auto'}: ''"></span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="facet-panes">
			<div
				data-ng-repeat="(dataSetName, fieldObj) in filterDataField[filterMode]">
				<div class="filterBtnWraper"
					data-ng-if="!config.collapseAllFacets && config.applyOnSelect == false && fieldObj.fields.length > 0">
					<button type="button" class="btn btn-default btn-sm pull-left"
						data-ng-click="clearComponentFilters(undefined, dataSetName,undefined,undefined,true)"
						data-ng-show="showFilterClearOption(undefined, dataSetName)">Clear</button>
					<button type="button" class="btn btn-primary btn-sm applyBtn"
						data-ng-click="applyFacetFilter(undefined, undefined, undefined, undefined, dataSetName, true)">Apply</button>
				</div>
				<div class="panel panel-default"
					data-ng-class="{'noBorder' : (config.collapseAllFacets && config.showOnlyBasicFilter && config.orientation === 'horizontal'),'noLeftBorder' : (config.orientation === 'horizontal' && $index > 0),'noTopBorder' : ((!config.hideHeader || reportMode === 'builder') || (config.orientation === 'vertical' && config.hideHeader && $index > 0))}"
					data-ng-repeat="field in fieldObj.fields | filter: (type == 'component') ? {isVisible:true} : ''"
					data-ng-init="currentPage=1" data-ng-style="config.orientation === 'vertical' ? {'width': '100%'} : {'width' :'auto'}">
					<div
						data-ng-style="!config.collapseAllFacets  && (field.showSearchBar ? {'height' : '76px'} : {'height' : '40px'})"
						class="panel-heading filter-panel-heading row noLftRghtMargin"
						data-ng-class="{'cursor-pointer blue-text-color': !config.showOnlyBasicFilter && config.collapseAllFacets,'headerStyle' : config.showOnlyBasicFilter && !config.collapseAllFacets,
						'defaultHeaderStyle' : config.collapseAllFacets && config.showOnlyBasicFilter && !showFilterClearOption(field,dataSetName) && config.orientation === 'horizontal','blueHeaderStyle' : config.collapseAllFacets && config.showOnlyBasicFilter && showFilterClearOption(field,dataSetName) && config.orientation === 'horizontal'}"
						data-ng-click="config.collapseAllFacets && showFacetInModal(fieldObj,field,dataSetName,$index+1,$event)">
						<div data-ng-class="{'cursor-pointer' : config.collapseAllFacets}" class="filter-panel-header-title" data-ng-click="!config.hideCollapse && !config.collapseAllFacets && (parentObj.collapsed[$index]=!parentObj.collapsed[$index])">
							<span
								data-ng-if="!config.hideCollapse && !config.collapseAllFacets"
								class="collapseIconStyle cursor-pointer glyphicon"
								data-ng-class="{'glyphicon-chevron-up' : parentObj.collapsed[$index],'glyphicon-chevron-down' : !parentObj.collapsed[$index]}"></span>
							<div data-ng-if="field.iconHtml" class="facet-icon-wrappper"
								data-ng-bind-html="field.iconHtml"></div>

							<label data-ng-if="!config.collapseAllFacets" class="panel-title" data-ng-bind-html="field.displayName" title={{field.displayName}}></label><span
								data-ng-if="config.collapseAllFacets"
								data-ng-bind-html="getFilteredValue(field,dataSetName)" ng-attr-title="{{getFilteredValue(field,dataSetName)}}" class="filterValueStyle" data-ng-style="!config.showOnlyBasicFilter ? {'font-size' : '16px'} : ''"></span><span
								class="panel-filter-count padding-left-5"
								data-ng-if="!config.collapseAllFacets && tempDatasetObj[dataSetName][field.column] && tempDatasetObj[dataSetName][field.column].numBuckets">&nbsp;({{tempDatasetObj[dataSetName][field.column].numBuckets}})</span>
							<span data-ng-if="!config.collapseAllFacets"
								class="noLftRghtPadding filter-panel-btns pull-right">
								<a data-ng-class="{'k-icon k-i-close-circle icoStyle' : config.showOnlyBasicFilter}" class="cursor-pointer padding-left-5"
									data-ng-click="clearComponentFilters(field, dataSetName,undefined,undefined,undefined,$event)"
									data-ng-show="showFilterClearOption(field, dataSetName)">{{config.showOnlyBasicFilter ? '' :'Clear'}}</a>

								<span class="glyphicon glyphicon-wrench cursor-pointer fieldSettingIcon padding-left-5"
									data-ng-click="openFieldSetting(field, dataSetName,$event)"
									data-ng-if="config.showFilterSetting && (!config.isDateRange(field,dataSetName) || field.customGroupsAvailable)"></span>

								<span class="glyphicon glyphicon-trash cursor-pointer padding-left-5"
									data-ng-click="deleteFilterField(fieldObj, $index, dataSetName)"
									data-ng-show="reportMode === 'builder'"></span>
							</span>
							<span data-ng-class="showFilterClearOption(field,dataSetName) ? 'k-icon k-i-close-circle icoStyle' : 'caret'"
								data-ng-click="showFilterClearOption(field,dataSetName) && clearComponentFilters(field, dataSetName,undefined,undefined,undefined,$event)"
								data-ng-if="config.collapseAllFacets && config.showOnlyBasicFilter && config.orientation === 'horizontal'"></span>
						</div>



						<div
							data-ng-if="!config.collapseAllFacets && !parentObj.collapsed[$index] && field.showSearchBar && field.filterType !== 'advanced' && !config.showOnlyBasicFilter"
							class="row noLftRghtMargin">
							<div class="col-md-12 col-lg-12 searchBarElm">
								<div class="k-textbox k-space-right filter-Panel-searchBar">
									<input type="text" name="" class="input"
										data-ng-model="tempDatasetObj[dataSetName][field.column].searchFields"
										class="k-textbox filter-searchbar-input"
										data-ng-keyup="!field.numPointsToDisplay.includeAll && doFacetSearch(dataSetName, field, tempDatasetObj[dataSetName][field.column].searchFields)">
									<span class="glyphicon glyphicon-search glyphicon-search-align">&nbsp;</span>
								</div>
							</div>
						</div>
					</div>



					<div data-ng-if="!config.isDateRange(field, dataSetName) || (field.customGroupsAvailable && field.groups.length > 0)"
						data-ng-class="{'collapsed':(parentObj.collapsed[$index] || config.collapseAllFacets)}">
						<div class="basic-filtering"
							data-ng-show="field.filterType==='basic'">
							<table id="{{dataSetName+'_'+field.column+'_'+$index}}"
								class="table-responsive facet-table" width="100%"
								cellpadding="0" cellpadding="0" border="0">
								<thead data-ng-if="!config.showOnlyBasicFilter" class="fullWidth">
									<tr data-ng-if="!config.collapseAllFacets" class="all-values">
										<th
											id="{{dataSetName+'_'+field.column+'_'+$index+'_fieldName'}}"
											data-ng-class="{'sorting_desc': field.sort.sortDirection==='desc' && field.sort.sortField== 'index','sorting_asc': field.sort.sortDirection==='asc' && field.sort.sortField== 'index'}"
											class="checkbox"
											data-ng-style="config.hideCheckBox?{'padding-left':'0px'}:''">
											<div data-ng-click="applySorting(field, undefined, aggrType)">
												<input
													data-ng-if="!config.hideCheckBox && !field.showRadioButtons && !field.customGroupsAvailable"
													type="checkbox" data-ng-model="field.selectAll"

													class="customChkBx noleftMargin" id="all{{$index}}"> <label
													data-ng-class="field.showRadioButtons ? 'facet-column-header noLftRghtPadding' : 'facet-column-header'"
													ng-attr-title="{{field.dimensionColumnHeader}}" data-ng-click="clearComponentFilters(field, dataSetName,undefined,undefined,undefined,$event);field.selectAll=!field.selectAll;">{{field.dimensionColumnHeader}}&nbsp;&nbsp;</label>

											</div>

										</th>
										<th
											data-ng-if="field.measureDataFields.length > 1" id="{{dataSetName+'_'+measureObj.aggrType+'_'+measureObj.measure+'_'+$index}}"
											data-ng-class="{'sorting_desc': field.sort.sortDirection==='desc' && field.sort.sortField== (measureObj.aggrType+'_'+measureObj.measure),'sorting_asc': field.sort.sortDirection==='asc' && field.sort.sortField== (measureObj.aggrType+'_'+measureObj.measure)}"
											data-ng-repeat="measureObj in tempDatasetObj[dataSetName][field.column]"
											data-ng-click="applySorting(field, measureObj.measure, measureObj.aggrType)">

											<label class="noLftRghtPadding"
											ng-attr-title="{{measureObj.displayName}}">{{measureObj.displayName}}&nbsp;&nbsp;</label>
										</th>
									</tr>
								</thead>
								<tbody
									infinite-scroll="field.numPointsToDisplay.includeAll && (currentPage=data[dataSetName][field.column].length > (currentPage + tempDatasetObj[dataSetName][field.column].maxPoints) ? currentPage+1 : currentPage)"
									infinite-scroll-distance="1" infinite-scroll-container="'#'+field.column+'_facet_table'" id="{{field.column}}_facet_table" class="facet-table-body scrollBarStyle" data-ng-style="config.showOnlyBasicFilter? {'max-height' : '270px'} : {'height' : '270px'}">
									<tr data-ng-if="field.numPointsToDisplay.maxPoints > 0 && data[dataSetName][field.column].length === 0"><td class="noDataElm" ><fmt:message key='CustomReport.NoDataMsg'/></td></tr>
									<tr
										data-ng-repeat="facet in data[dataSetName][field.column] | filter: config.showOnlyBasicFilter ? '' : tempDatasetObj[dataSetName][field.column].searchFields | limitTo: (field.showComboBox ? tempDatasetObj[dataSetName][field.column].maxPoints :currentPage*tempDatasetObj[dataSetName][field.column].maxPoints)" class="fullWidth">
										<td class="checkbox"
											data-ng-style="config.hideCheckBox?{'padding-left':'0px'}:''">
											<input data-ng-if="!config.hideCheckBox"
											type="{{tempDatasetObj[dataSetName][field.column].inputBtnType}}"
											value="{{facet.isSelected}}"
											data-ng-checked="getterSetterFn"
											ng-init="getterSetterFn = getModelValForInput(field,facet,dataSetName)"
											data-ng-model="getterSetterFn"
											ng-model-options="{getterSetter: true}"
											data-ng-change="tempDatasetObj[dataSetName][field.column].searchFields='';applyFacetFilter(facet, field, undefined, undefined, dataSetName)"
											class="noleftMargin customChkBx" id="{{field.column}}_check{{facet.val + '_' + $index}}">
											<label
											data-ng-class="field.showRadioButtons ? 'padding-lft-2 checkbox-label no-left-padding' : 'checkbox-label no-left-padding'"
											for="{{field.column}}_check{{facet.val +'_'+ $index}}"><span
												id="facetDimentionVal" ng-attr-title="{{getFormattedValue(facet.val,
													field, dataSetName)}}"  data-ng-bind-html="getFormattedValue(facet.val,
													field, dataSetName)" class="max-width-100"></span><span

												data-ng-if="!config.showBars && field.measureDataFields.length === 1 && field.measureDataFields[0].aggrTypes.length > 0 &&field.measureDataFields[0].aggrTypes[0] !== ''" class="facetCount" data-ng-init="measureObj=tempDatasetObj[dataSetName][field.column][0]">&nbsp&nbsp({{formatNumberToString(measureObj.aggrType
													=='Count'?facet.count:facet[measureObj.aggrType + '_' +
													measureObj.measure])}})</span></label>
										</td>

										<td data-ng-if="field.measureDataFields.length > 1 || config.showBars"
											data-ng-repeat="measureObj in tempDatasetObj[dataSetName][field.column]"
											data-ng-click="applySorting(field, measureObj.measure, measureObj.aggrType)">
											<span class="col-sm-12 noLftRghtPadding">
												<span data-ng-class="config.showBars?'col-sm-5' : 'col-sm-12'" class="noLftPadding"
													data-ng-style="!config.showBars?{'text-align':'center'}:{'text-align':'right'}">{{formatNumberToString(measureObj.aggrType
													=='Count'?facet.count:facet[measureObj.aggrType + '_' +
													measureObj.measure])}}</span>
												<span  class="noLftRghtPadding col-sm-7" data-ng-if="config.showBars"><div class="facet-bar" data-ng-style="{'height' : '10px','width':getBarWidth(measureObj.aggrType=='Count'?facet.count:facet[measureObj.aggrType + '_' + measureObj.measure],measureObj.aggrType=='Count'?tempDatasetObj[dataSetName][field.column]['max_count']:tempDatasetObj[dataSetName][field.column]['max_'+measureObj.aggrType + '_' + measureObj.measure]),'background-color':config.barColor}"></div></span>
											</span>

										</td>
									</tr>
								</tbody>
							</table>
							<div class="autoSuggestElm"
								data-ng-if="config.showOnlyBasicFilter && data[dataSetName][field.column].length !== 0  && (field.showNumberOps || (!field.customGroupsAvailable && (field.showComboBox ? tempDatasetObj[dataSetName][field.column].maxPoints : (field.numPointsToDisplay.includeAll ? (currentPage*tempDatasetObj[dataSetName][field.column].maxPoints) : data[dataSetName][field.column].length)) < tempDatasetObj[dataSetName][field.column].numBuckets))" data-ng-style="appName === 'adminconsole'? {'margin-top': '-2px'} :''">
								<input data-ng-if="!field.showComboBox"
									placeholder="{{field.showNumberOps ? 'e.g. >= val': 'Filter'}}"
									typeahead-wait-ms="200"
									data-ng-keyup="(field.showNumberOps&& $event.keyCode == 13) ? applyFacetFilter(tempDatasetObj[dataSetName][field.column].searchFields, field, false, undefined, dataSetName):(!field.showNumberOps ? doFacetSearch(dataSetName, field, tempDatasetObj[dataSetName][field.column].searchFields,this) : null)"
									type="text"
									data-ng-model="tempDatasetObj[dataSetName][field.column].searchFields"
									uib-typeahead="facet.val for facet in suggestionList[dataSetName][field.column] | filter:$viewValue"
									typeahead-loading="loadingLocations"
									typeahead-no-results="noResults"
									class="form-control autoSuggestInput"
									typeahead-on-select="addSelectedItemTofilter(dataSetName,field,$item)">
								<select data-ng-init="facet.val=''" data-ng-model="facet.val"
									data-ng-if="field.showComboBox"
									data-ng-change="addSelectedItemTofilter(dataSetName,field,facet);"
									class="form-control">
									<option value="" data-ng-disabled="true">Select</option>
									<option ng-repeat="facet in data[dataSetName][field.column] | byRange: tempDatasetObj[dataSetName][field.column].maxPoints"
										value="{{facet.val}}">{{facet.val}}</option>
								</select>

							</div>

						</div>


						<div
							data-ng-class="{'marginForAdvacedFiltering':field.showSearchBar}"
							class="advanced-filtering panel-body"
							data-ng-show="field.filterType==='advanced'" data-ng-style="config.showOnlyBasicFilter? {'max-height' : '306px'} : {'height' : '306px'}">
							<div data-ng-repeat="advancedFilter in field.advancedFilters">
								<div class="margin-bottom-10" style="color: black;">Show
									items with value that:</div>
								<!-- TODO localize -->
								<div class="margin-bottom-10">
									<select class="form-control"
										data-ng-model="advancedFilter.filters[0].operator">
										<option value="isempty" data-ng-if="!field.showNumberOps">Is
											Empty</option>
										<option value="isnotempty" data-ng-if="!field.showNumberOps">Is
											Not Empty</option>
										<option value="contains" data-ng-if="!field.showNumberOps">contains</option>
										<option value="doesnotcontain"
											data-ng-if="!field.showNumberOps">does not contain</option>
										<option value="startswith" data-ng-if="!field.showNumberOps">starts
											with</option>
										<option value="doesnotstartswith"
											data-ng-if="!field.showNumberOps">does not starts
											with</option>
										<option value="less" data-ng-if="field.showNumberOps">is
											less than</option>
										<option value="leq" data-ng-if="field.showNumberOps">is
											less than or equal to</option>
										<option value="greater" data-ng-if="field.showNumberOps">is
											greater than</option>
										<option value="geq" data-ng-if="field.showNumberOps">is
											greater than or equal to</option>
										<option value="eq">is equal to</option>
										<option value="neq">is not equal to</option>
									</select>
								</div>
								<div class="margin-bottom-10">
									<input type="text" class="form-control"
										data-ng-model="advancedFilter.filters[0].value">
								</div>
								<div class="margin-bottom-10">
									<div class="radio">
										<label> <input type="radio"
											data-ng-click="advancedFilter.logic='and'"
											data-ng-checked="advancedFilter.logic==='and'"> AND
										</label> <label> <input type="radio"
											data-ng-click="advancedFilter.logic='or'"
											data-ng-checked="advancedFilter.logic==='or'"> OR
										</label>
									</div>
								</div>
								<div class="margin-bottom-10">
									<select class="form-control"
										data-ng-model="advancedFilter.filters[1].operator">
										<option value="isempty" data-ng-if="!field.showNumberOps">Is
											Empty</option>
										<option value="isnotempty" data-ng-if="!field.showNumberOps">Is
											Not Empty</option>
										<option value="contains" data-ng-if="!field.showNumberOps">contains</option>
										<option value="doesnotcontain"
											data-ng-if="!field.showNumberOps">does not contain</option>
										<option value="startswith" data-ng-if="!field.showNumberOps">starts
											with</option>
										<option value="doesnotstartswith"
											data-ng-if="!field.showNumberOps">does not starts
											with</option>
										<option value="less" data-ng-if="field.showNumberOps">is
											less than</option>
										<option value="leq" data-ng-if="field.showNumberOps">is
											less than or equal to</option>
										<option value="greater" data-ng-if="field.showNumberOps">is
											greater than</option>
										<option value="geq" data-ng-if="field.showNumberOps">is
											greater than or equal to</option>
										<option value="eq">is equal to</option>
										<option value="neq">is not equal to</option>
									</select>
								</div>
								<div class="margin-bottom-10">
									<input type="text" class="form-control"
										data-ng-model="advancedFilter.filters[1].value">
								</div>
								<div data-ng-if="config.applyOnSelect != false"
									class="margin-bottom-10" style="text-align: right;">
									<button type="button" class="btn btn-primary btn-sm"
										data-ng-click="applyFacetFilter(undefined, field, true, $index, dataSetName)">Apply
										Filter</button>
								</div>
							</div>
						</div>
						<div data-ng-if="!config.showOnlyBasicFilter && !field.customGroupsAvailable " class="panel-footer"
							data-ng-class="{'collapsed':parentObj.collapsed[$index]}">
							<a class="cursor-pointer pull-left"
								data-ng-click="field.numPointsToDisplay.includeAll =! field.numPointsToDisplay.includeAll;showFacet();"
								data-ng-show="!field.numPointsToDisplay.includeAll">Show All</a>
							<a data-ng-if="!config.hideCheckBox && !config.hidefilterlink"
								class="cursor-pointer pull-right"
								data-ng-click="field.filterType = field.filterType === 'advanced' ? 'basic' : 'advanced'">{{field.filterType
								=== 'advanced' ? 'Basic Filtering' : 'Advanced Filtering'}}</a>
						</div>
					</div>

					<div data-ng-if="config.isDateRange(field, dataSetName)"
						data-ng-class="{'collapsed':(parentObj.collapsed[$index] || config.collapseAllFacets)}">
						<div class="panel-body" data-ng-style="config.showOnlyBasicFilter? {'max-height' : '306px'} : {'height' : '306px'}">
							<div class="date-range">
								<div
									class="date-range-element input-group"
									cv-date-time-range-picker
									component="dateRangeFields[field.column]"
									data-show-relative="false">
									<input type="daterange"	class="dateRangeInput form-control" placeholder="Filter by range"><span
										ng-click="showCalender($event)"
										class="glyphicon glyphicon-calendar input-group-addon" data-ng-style="config.orientation === 'horizontal' ? {'width' : 'auto'}: ''"></span>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>

		</div>
	</div>
</fmt:bundle>
