<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.ReportsPlusMessages">
	<ul class="secondary-header secondary-background-color">
		<li class="sub-header" title="General" data-ng-class="{'sub-header-active': selectedPropertyCategory==='general'}" data-ng-click="selectedPropertyCategory='general'">
			<span class="ico ico-cog"></span>
		</li>
		<li class="sub-header" title="Fields" data-ng-class="{'sub-header-active': selectedPropertyCategory==='fields'}" data-ng-click="selectedPropertyCategory='fields'">
			<span class="ico ico-form-field"></span>
		</li>
		<li class="sub-header" title="Custom Code" data-ng-class="{'sub-header-active': selectedPropertyCategory==='customcode'}" data-ng-click="selectedPropertyCategory='customcode'">
			<span class="ico ico-code"></span>
		</li>
	</ul>

	<!-- Begin "General" group -->
	<div data-ng-show="selectedPropertyCategory==='general'">
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
	<!-- FIXME: Localize -->
				<div class="form-group">
					<label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Title"/>'><fmt:message key="CustomReport.Properties.Title"/></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm"
						   data-ng-model="propData.title.text"
						   type="text"
						   placeholder="<fmt:message key="CustomReport.Properties.ComponentName"/>">
					</div>
				</div>
			</div>
		</div>
		<div class="row noLftRghtMargin">
        <div class="col-xs-12">
<!-- FIXME: Localize -->
            <div class="form-group">
                <label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.ID"/>'><fmt:message key="CustomReport.Properties.ID"/></label>
                <div class="col-sm-8 noLftRghtPadding">
                    <input class="form-control input-sm"
                   type="text"
                   data-ng-model="propData.id" data-ng-pattern="/^[A-Za-z0-9_]{1,}$/"
                   data-ng-blur="validateComponentId()" data-ng-class="{'pattern-invalid': !propData.id}">
                  <span class="inline-validation-error" data-ng-show="!propData.id">*ID should contain characters,digits and underscore only.</span>  <!-- localize -->
                </div>
            </div>
        </div>
    </div>
		<div class="row noLftRghtMargin">
			<div class="col-xs-12">
	<!-- FIXME: Localize -->
				<div class="form-group">
					<label class="col-xs-12 col-sm-12 col-md-12 col-lg-4 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.DataSet"/>'><fmt:message key="CustomReport.Properties.DataSet"/></label>
					<div class="col-sm-8 noLftRghtPadding">
						<input class="form-control input-sm"
					   type="text"
					   placeholder="<fmt:message key='CustomReport.Properties.DataSetName'/>"
					   readonly="true"
					   data-ng-model="propData.dataSet.dataSetName">
					</div>
				</div>
			</div>
		</div>
		<!-- Mobile Visible Option -->
    <div class="col-xs-12" data-ng-if="cv.additionalSettings.Console.enableMobileOptions">
        <div class="form-group">
            <label class="col-xs-12 col-sm-12 col-md-12 col-lg-8 control-label noLftRghtPadding" title='<fmt:message key="CustomReport.Properties.Mobile.Visible"/>'><fmt:message key="CustomReport.Properties.Mobile.Visible"/></label>
            <div class="col-sm-4 noLftRghtPadding">                    
                    <select class="form-control input-sm"
                      data-ng-model="propData.mobile.visible">
                      <option value="On"><fmt:message key="CustomReport.Yes"/></option>
                      <option value="Off"><fmt:message key="CustomReport.No"/></option>
                    </select>                    
            </div>
        </div>            
    </div>
	<entity-security data-item="propData"></entity-security>
	</div>

	
<!-- 
	<div data-ng-show="selectedPropertyCategory==='customcode'">
		 <div class="row noLftRghtMargin">
			<div class="col-xs-12">
				<label class="col-xs-12 noLftRghtPadding">
					<fmt:message key="CustomReport.Properties.PointExpression"/><br>
				</label>
				<span class="col-xs-12 noLftRghtPadding">
					<textarea  data-ng-model="propData.onClick" data-ng-blur="redrawComponent(propData.id)"></textarea>
				</span>
			</div>

		</div>
	</div>
	 -->
</fmt:bundle>