import { TaskDetailsList, DaysToRun, TaskInfo, Task, SubTaskInfo, SubTask, TaskOperationType, SubTaskType, Pattern, FreqType, CVTimeZone, JobOption, AdminOption, ReportOption, RptCommonOptions, ReportType, WebReportOption, TaskType } from '../js/models/TMMsg';
import { commonConstants } from '../js/constants.js';
(function() {
	'use strict';

	var reports = angular.module("reports");

	reports.controller('alarmsCtrl', [
			'$scope',
			'$rootScope',
			'$uibModal',
			'customReportSvc',
			'reportService',
			function($scope, $rootScope, $uibModal, customReportSvc, reportService) {
				// BEGIN: declarations

				$scope.editCriteriaSet = false;
				$scope.alertTitlePrefix = localMsg['configure_alert'];
				$scope.isWebConsole = (customReports.appName == 'webconsole');

				$scope.accordions = {
						notifications : {
							isOpen : false,
							error : null
						},
						schedules: {
							isOpen : false,
							error : null
						}
				};

				$scope.alertSeverityOptions = [ {
					id : "INFORMATION",
					label : cvUtil.cvLocalize('InfoStatus')
				}, {
					id : "WARNING",
					label : cvUtil.cvLocalize('WarningStatus')
				}, {
					id : "CRITICAL",
					label : cvUtil.cvLocalize('CriticalStatus')
				} ];
				$scope.alertFreqOptions = [ {
					id : "DAILY",
					label : cvUtil.cvLocalize('CustomReport_Daily')
				}, {
					id : "WEEKLY",
					label : cvUtil.cvLocalize('CustomReport_Weekly')
				}, {
					id : "MONTHLY",
					label : cvUtil.cvLocalize('CustomReport_Monthly')
				} ];
				$scope.weekdays = [ {
					id : "daysToRun0",
					label : cvUtil.cvLocalize('monday')
				}, {
					id : "daysToRun1",
					label : cvUtil.cvLocalize('tuesday')
				}, {
					id : "daysToRun2",
					label : cvUtil.cvLocalize('wednesday')
				}, {
					id : "daysToRun3",
					label : cvUtil.cvLocalize('thursday')
				}, {
					id : "daysToRun4",
					label : cvUtil.cvLocalize('friday')
				}, {
					id : "daysToRun5",
					label : cvUtil.cvLocalize('saturday')
				}, {
					id : "daysToRun6",
					label : cvUtil.cvLocalize('sunday')
				} ];
				$scope.weeksOfMonth = [ {
					id : "First",
					label : cvUtil.cvLocalize('First')
				}, {
					id : "Last",
					label : cvUtil.cvLocalize('Last')
				}, {
					id : "Second",
					label : cvUtil.cvLocalize('Second')
				}, {
					id : "Third",
					label : cvUtil.cvLocalize('Third')
				}, {
					id : "Fourth",
					label : cvUtil.cvLocalize('Fourth')
				} ];
				$scope.daysOfWeek = [ {
					id : "Weekday",
					label : cvUtil.cvLocalize('Weekday')
				}, {
					id : "Weekend_Day",
					label : cvUtil.cvLocalize('Weekend')
				}, {
					id : "Monday",
					label : cvUtil.cvLocalize('monday')
				}, {
					id : "Tuesday",
					label : cvUtil.cvLocalize('tuesday')
				}, {
					id : "Wednesday",
				}, {
					id : "Thursday",
					label : cvUtil.cvLocalize('thursday')
				}, {
					id : "Friday",
					label : cvUtil.cvLocalize('friday')
				}, {
					id : "Saturday",
					label : cvUtil.cvLocalize('saturday')
				}, {
					id : "Sunday",
					label : cvUtil.cvLocalize('sunday')
				} ];

				$scope.isOrOptions = [ {
					id : 'and',
					label : cvUtil.cvLocalize('all')
				}, {
					id : 'or',
					label : cvUtil.cvLocalize('any')
				} ];

				$scope.alarmColList = [];

				$scope.operatorToDescMatch = {
					"=" : " equal to ",
					"!=" : " Not Equal To ",
					">" : " more than ",
					"<" : " less than ",
					"isempty" : " Is Empty ",
					"notempty" : " Not Empty ",
					" NOT LIKE " : " Not Contains ",
					"like" : " contains ",
					"inLast" : " in last ",
					"beyondLast" : " beyond last ",
					"inNext" : " within next ",
					"beyondNext" : " beyond next "
				}

				$scope.descToOperatorMatch = {
					" equal to " : "=",
					" Not Equal To " : "!=",
					" more than " : ">",
					" less than " : "<",
					" Is Empty " : "isempty",
					" Not Empty " : "notempty",
					" Not Contains " : " NOT LIKE ",
					" contains " : "like",
					" in last " : "inLast",
					" beyond last " : "beyondLast",
					" within next " : "inNext",
					" beyond next " : "beyondNext"
				}

				/* -- adinng value options aka condtional statements like Equal to , less than etc */
				$scope.stringOptions = [ {
					"id" : '=',
					"label" : cvUtil.cvLocalize('equal_to')
				}, {
					"id" : "!=",
					"label" : cvUtil.cvLocalize('not_equal_to')
				}, {
					"id" : "like",
					"label" : cvUtil.cvLocalize('contains')
				}, {
					"id" : " NOT LIKE ",
					"label" : cvUtil.cvLocalize('not_contains')
				}, {
					"id" : "isempty",
					"label" : cvUtil.cvLocalize('is_empty')
				}, {
					"id" : "notempty",
					"label" : cvUtil.cvLocalize('not_empty')
				} ];
				$scope.dateOptions = [ {
					"id" : 'inLast',
					"label" : cvUtil.cvLocalize('in_last')
				}, {
					"id" : 'beyondLast',
					"label" : cvUtil.cvLocalize('beyond_last')
				}, {
					"id" : 'inNext',
					"label" : cvUtil.cvLocalize('in_next')
				}, {
					"id" : 'beyondNext',
					"label" : cvUtil.cvLocalize('beyond_next')
				} ];

				$scope.relativeOperators = [ 'inLast', 'beyondLast', 'inNext', 'beyondNext' ];

				$scope.relativeOptions = [ {
					"id" : 's',
					"label" : cvUtil.cvLocalize('seconds')
				}, {
					"id" : 'm',
					"label" : cvUtil.cvLocalize('minutes')
				}, {
					"id" : 'h',
					"label" : cvUtil.cvLocalize('hours')
				}, {
					"id" : 'd',
					"label" : cvUtil.cvLocalize('days')
				}, {
					"id" : 'w',
					"label" : cvUtil.cvLocalize('weeks')
				}, {
					"id" : 'M',
					"label" : cvUtil.cvLocalize('months')
				}, {
					"id" : 'y',
					"label" : cvUtil.cvLocalize('years')
				} ];

				$scope.relativeOptionsToDescMatch = {
					"seconds" : "s",
					"minutes" : "m",
					"hours" : "h",
					"days" : "d",
					"weeks" : "w",
					"months" : "M",
					"years" : "y"
				}

				$scope.numberOptions = [ {
					"id" : '=',
					"label" : cvUtil.cvLocalize('equal_to')
				}, {
					"id" : '!=',
					"label" : cvUtil.cvLocalize('not_equal_to')
				}, {
					"id" : '<',
					"label" : cvUtil.cvLocalize('less_than')
				}, {
					"id" : '>',
					"label" : cvUtil.cvLocalize('more_than')
				} ];

				/* -- Adding Notifications */
				$scope.notifications = [ {
					id : 'EMAIL',
					domId : 'emailAlertCB',
					selected : false,
					label : cvUtil.cvLocalize('Email')
				}, {
					id : 'LIVEFEEDS',
					domId : 'consoleAlertCB',
					selected : false,
					label : cvUtil.cvLocalize('ConsoleAlerts')
				}, {
					id : 'APPLOG',
					domId : 'eventViewerCB',
					selected : false,
					label : cvUtil.cvLocalize('WindowsEventViewer')
				}, {
					id : 'SNMP',
					domId : 'snmpCB',
					selected : false,
					label : cvUtil.cvLocalize('SNMPTraps')
				}, {
					id : 'SCOM',
					domId : 'scomCB',
					selected : false,
					label : cvUtil.cvLocalize('SCOMAlert')
				} ];
				$scope.selectedNotifications = [];
				$scope.conditions = [];


				// END: declarations

				// BEGIN: functions on scope

				$scope.removeAlarmIdFromUrl = function(alarmId) {
					var urlParameters = window.location.search;
					if (urlParameters) {
						if(urlParameters.indexOf("&alarmId") > -1){
							urlParameters = urlParameters.replace("&alarmId=" + alarmId, "");
						} else if(urlParameters.indexOf("?alarmId") > -1){
							if(urlParameters.split("&").length  > 1 && urlParameters.split("&")[1].trim().length > 0){
								urlParameters = urlParameters.replace("alarmId=" + alarmId+"&", "");
							}else{
								var uri = location.toString();
								urlParameters = uri.substring(0, uri.indexOf("?"));
							}
						}
						history.replaceState(null, document.title, urlParameters);
					}
				};

				/* -- adding value options a.ka condtional statements like Equal to , less than etc */
				$scope.setValueOption = function(condition, isEditCriteria) {
					var valueOptions = [];
					var type = "String";
					var columnName = condition.columnName;
					var col;
					var firstCol;
					if (!isEditCriteria) {
						condition.operator = '';
						condition.type = '';
						condition.displayName = '';
					}
					angular.forEach($scope.alarmColList, function(column, key) {

						//keeping first column details in case the previously selected criteria not found, we can select the first one.
						if (key == 0) {
							firstCol = column;
						}
						/*
						 * @MR 204669 - for edit criteria support we have column title, show we were looking
						 * at mDataProp (displayName) while re-creating conditions, but while changing
						 * conditions in the column list, we have used column.name property to validate.
						 */
						if ((isEditCriteria && columnName == column.mDataProp) ||
								(!isEditCriteria && columnName == column.name)) {
							type = column.type;
							col = column;
							condition.columnName = column.name; //setting  columnName =  name which require to preselect the dropdown option.
							firstCol = undefined;
							return true;
						}

					});

					if (!col) {
						col = firstCol;
						type = firstCol.type;
						condition.columnName = firstCol.name
					}

					if (type == "String") {
						valueOptions = $scope.stringOptions;
					} else if (type == "Time" || type == "TimeStamp") {
						valueOptions = $scope.dateOptions;
						condition.relativeTimeValue = condition.relativeTimeValue || 'd';
					} else {
						valueOptions = $scope.numberOptions;
					}
					condition.valueOptions = valueOptions;
					if (!condition.operator || firstCol) {
						condition.operator = valueOptions[0].id;
					}

					if (isEditCriteria) {
						$scope.checkIfApplicable(condition);
						if (condition.notapplicable) {
							condition.value = ''; //reset the value is notapplicable
						}
					}

					condition.type = type;
					condition.displayName = col.title;
				};

				$scope.updateConditionsWithColumnType= function() {
					if ($scope.conditions) {
						var columnsMap = {};
						$scope.columns.forEach(function(col){
							columnsMap[col.id] = col;
						});
						$scope.alarmColList.forEach(function(col){
							var column = columnsMap[col.name];
							if (column) {
								col.type = column.type;
								col.mDataProp = column.id;
							}
						});
						$scope.conditions.forEach(function(condition){
							$scope.setValueOption(condition, true);
						});
					}
				};

				$scope.addCondition = function(preFillObj) {

					//validate the existing previous condition before adding a new one.
					if ($scope.conditions.length > 0 && !preFillObj) {
						if (!$scope.validateCondition($scope.conditions[$scope.conditions.length - 1])) {
							return;
						} else {
							$scope.alarm.error = "";
						}
					}

					if ($scope.conditions.length == 0 ||
							$scope.conditions[$scope.conditions.length - 1].notapplicable ||
							$scope.conditions[$scope.conditions.length - 1].value !== "") {
						var column;
						for (var i = 0; i < $scope.columns.length; i++) {
							column = $scope.columns[i];
							if (column.hidden) {
								continue;
							}

							if (column.visible) {
								break;
							}
						}
						var condition = {
							columnName : column.id,
							operator : '',
							value : '',
							valueOptions : {},
							type : ''
						};
						var isEditCriteria = false;
						if (preFillObj) {
							if (preFillObj.columnName) {
								condition.columnName = preFillObj.columnName;
								isEditCriteria = true;
							}
							if (preFillObj.conditionOperator) {
								condition.operator = preFillObj.conditionOperator;
							}
							if (preFillObj.value) {
								condition.value = preFillObj.value;
							}

							if (preFillObj.relativeTimeValue) {
								condition.relativeTimeValue = preFillObj.relativeTimeValue;
							}
						}

						$scope.setValueOption(condition, isEditCriteria)
						$scope.conditions.push(condition);
					}
				};

				$scope.testCriteria = function() {
					if ($scope.conditions.length > 0) {
						if (!$scope.validateCondition($scope.conditions[$scope.conditions.length - 1])) {
							return;
						} else {
							$scope.alarm.error = "";
						}
					}

					if (customReports.appName === 'adminconsole') {
						$scope.testCriteriaInAdminConsole();
					} else {
						var isHealthAlert = false;
						var relativeUrl = window.location.pathname.replace(customReportSvc.getContextPath(), "");
						var alarmURL = "";
						if (customReports.appName === 'adminconsole') {


						} else {
							if (window.location.search === "") {
								alarmURL = relativeUrl + "?exportType=csv&isAlarm=true&pageSize=-1&pageNo=1&componentName=" +
								$scope.component.id + "&" + $scope.getwhereClause() + "&isOr=" + $scope.alarm.isOrValue;
							} else {
								alarmURL = relativeUrl + window.location.search +
								"&exportType=csv&isAlarm=true&pageSize=-1&pageNo=1&componentName=" +
								$scope.component.id + "&" + $scope.getwhereClause() + "&isOr=" + $scope.alarm.isOrValue;
							}
						}

						if ($scope.dataSet && $scope.dataSet.dataSet.dataSetId) {
							alarmURL += "&alarmDataSetName=" + $scope.dataSet.dataSet.dataSetId;
						}

						if (alarmURL.indexOf('reportsplus') !== -1) {
							alarmURL = alarmURL.replace("reportViewer.jsp", "reportInclude.jsp");
							alarmURL = alarmURL.replace('&exportType=csv&isAlarm=true', '');
							alarmURL = alarmURL + "&showComponents=" + $scope.component.id + "&avoidClientScripts=true";
						}

						if (alarmURL.indexOf('health.jsp') !== -1) {
							alarmURL = alarmURL.replace("health.jsp", "healthDashboardAlarm.jsp");
							alarmURL += "&tileId=" + $scope.tileData.tileId;
							isHealthAlert = true;
						}

						var testCriteriaConditionString = [];
						var join = $scope.alarm.isOrValue;
						var conditionString = "";
						angular.forEach($scope.conditions, function(condition, i) {
							var value = {
								"filteredColumn" : condition.displayName,
								"oper" : $scope.operatorToDescMatch[condition.operator],
								"search" : isHealthAlert ? $scope.getValue(parseInt(condition.value)) : condition.value
							};

							if (i === $scope.conditions.length - 1) {
								join = "";
							}

							conditionString = encodeURIComponent(value.filteredColumn) + " value " + value.oper +
									encodeURIComponent(value.search) + " " + join;

							if (isHealthAlert) {
								alarmURL += "&tileStatus=" + condition.value;
								conditionString = $scope.tileData.tileName + " " + conditionString;
							}

							testCriteriaConditionString.push(conditionString);

						});
						var critStr = escape(JSON.stringify(testCriteriaConditionString));
						$('form[name="testAlertCriteria"] [name="testCriteria"]').val(critStr);
						$('form[name="testAlertCriteria"] [name="reportName"]').val($scope.reportName);
						$('form[name="testAlertCriteria"] [name="testurl"]').val(alarmURL);
						$('form[name="testAlertCriteria"] [name="gridId"]').val($scope.component.id);
						$('form[name="testAlertCriteria"]').submit();
					}
				};

				$scope.removeCondition = function(index) {
					if ($scope.conditions.length > 1) {
						$scope.conditions.splice(index, 1);
					}
				};

				$scope.checkIfApplicable = function(condition, column) {
					if (condition.operator == 'isempty' || condition.operator == 'notempty') {
						condition.notapplicable = true;
						condition.placeholdertext = 'Not Applicable';
					} else {
						condition.notapplicable = false;
						condition.placeholdertext = '';
					}

				};

				$scope.getValue = function(value) {
					switch (value) {
					case 4:
						return cvUtil.cvLocalize('CriticalStatus')
					case 3:
						return cvUtil.cvLocalize('WarningStatus')
					case 2:
						return cvUtil.cvLocalize('GoodStatus')
					}
					return "";
				};

				$scope.getAlarmType = function(value) {
					switch (value) {
					case 0:
						return "HEALTH";
					case 1:
						return "GENERAL";

					}
					return "GENERAL";
				};

				$scope.setHourMinAmPm = function(time, fieldId) {
					if (typeof time != 'number' || !fieldId) {
						return;
					}

					var hours = Math.floor(time / 3600);
					var minutes = Math.floor((time % 3600) / 60);
					var ampm = hours >= 12 ? '12' : '0';
					hours = hours % 12;
					hours = hours ? hours : 12; // the hour '0' should be '12'

					if (minutes < 10) {
						minutes = "0" + minutes;
					}
					if (fieldId == "activeStartTime") {
						$scope.alarm.ampm = String(ampm);
						$scope.alarm.minute = String(minutes);
						$scope.alarm.hour = String(hours);
					} else if (fieldId == "activeEndTime") {
						$scope.alarm.endTimeAMPM = String(ampm);
						$scope.alarm.endTimeMinute = String(minutes);
						$scope.alarm.endTimeHour = String(hours);
					}

				};

				$scope.populateAlarmDialogFreqField = function(scheduleData) {
					$scope.alarm.freqType = scheduleData.freqType;
					$scope.alarm.activeStartTime = scheduleData.activeStartTime;

					if (typeof scheduleData.activeStartTime == 'number') {
						$scope.setHourMinAmPm(scheduleData.activeStartTime, "activeStartTime");
					}

					if (scheduleData.timezone) {
						$scope.alarm.timezone = String(scheduleData.timezone);
					}

					if ($scope.alarm.freqType == "DAILY") {
						if (scheduleData.repeatNHoursInterval && scheduleData.repeatNHoursInterval > 0) {
							$scope.alarm.everyNHoursSpinner = (Math.floor(scheduleData.repeatNHoursInterval / 3600));
							$scope.alarm.everyNMinsSpinner = ((scheduleData.repeatNHoursInterval / 60) % 60);
							$scope.alarm.repeatEveryNHours = true;
							if (typeof scheduleData.activeEndTimeNHours == 'number') {
								$scope.alarm.activeEndTime = scheduleData.activeEndTimeNHour;
								$scope.setHourMinAmPm(scheduleData.activeEndTimeNHours, "activeEndTime");
							}
						}
					} else if ($scope.alarm.freqType == "WEEKLY") {
						var selectedWeekDays = [];
						angular.forEach(scheduleData.daysToRun, function(value, key) {
							if (value && $scope.weekdays[key]) {
								selectedWeekDays.push($scope.weekdays[key].id);
							}
						});
						$scope.alarm.weekDays = selectedWeekDays;
					} else if ($scope.alarm.freqType == "MONTHLY") {
						if (scheduleData.weekOfMonth && scheduleData.dayOfWeek) {
							$scope.alarm.monthSelector = "daySelector";
							$scope.alarm.weekOfMonth = scheduleData.weekOfMonth; //$scope.weeksOfMonth[0].id;
							$scope.alarm.dayOfWeek = scheduleData.dayOfWeek; //$scope.daysOfWeek[0].id;
						} else if (scheduleData.dateOfMonth) {
							$scope.alarm.dayOfMonth = scheduleData.dateOfMonth;
							$scope.alarm.monthSelector = "dateSelector";
							$scope.alarm.weekOfMonth = $scope.weeksOfMonth[0].id;
							$scope.alarm.dayOfWeek = $scope.daysOfWeek[0].id;
						} else {
							$scope.alarm.weekOfMonth = $scope.weeksOfMonth[0].id;
							$scope.alarm.dayOfWeek = $scope.daysOfWeek[0].id;
							$scope.alarm.monthSelector = "daySelector";
						}

					}

					$scope.alarm.scheduleTaskID = scheduleData.taskId;
					$scope.alarm.loadingScheduleDetails = false;
				};

				$scope.getwhereClause = function() {
					var whereClause = [];
					var operator = "";
					var finalConditions = {};
					var joinCondition = $scope.alarm.isOrValue === "and" ? "&&" : "||";
					var conditionValue = "";
					angular.forEach($scope.conditions, function(condition, i) {
						operator = condition.operator;

						if (condition.operator == 'like') {
							operator = "";
						} else if (condition.operator.trim() == 'NOT LIKE') {
							operator = "notlike ";
						} else if (condition.operator.trim() == 'isempty') {
							operator = "=";
							condition.value = '""';
						} else if (condition.operator.trim() == 'notempty') {
							operator = "!=";
							condition.value = '""';
						} else if (condition.operator.trim() == 'inLast') {
							operator = ">-";
						} else if (condition.operator.trim() == 'beyondLast') {
							operator = "<-";
						} else if (condition.operator.trim() == 'inNext') {
							operator = ">0" + condition.relativeTimeValue + " && <";
						} else if (condition.operator.trim() == 'beyondNext') {
							operator = ">";
						}

						conditionValue = operator + condition.value;
						if (condition.type === "Time" || condition.type === "TimeStamp") {
							conditionValue = conditionValue + condition.relativeTimeValue;
						}
						if (finalConditions[condition.columnName]) {
							finalConditions[condition.columnName] = finalConditions[condition.columnName] + " " +
									joinCondition + " " + conditionValue;
						} else {
							finalConditions[condition.columnName] = conditionValue;
						}

						//var cond = encodeURIComponent($scope.component.id+".filter."+condition.columnName)+"="+encodeURIComponent(operator+condition.value);
					});

					angular.forEach(finalConditions, function(value, key) {
						var urlKey = $scope.component.id + ".filter." + key;
						whereClause.push(encodeURIComponent(urlKey) + "=" + encodeURIComponent(value));
					})

					return whereClause.join("&");
				};

				$scope.getAlarmUrl = function() {
					var relativeUrl = window.location.pathname.replace(customReportSvc.getContextPath(), "");
					var urlParameters = window.location.search;
					var alarmUrl = "";

					if (customReports.appName === 'adminconsole') {
						var params = {
								reportId: $scope.reportId,
								componentName: $scope.component.id,
								isOr: $scope.alarm.isOrValue
						};
						alarmUrl = getAlertURLForAdminConsole(params) + '&' +  $scope.getwhereClause();
					} else {
						if ($scope.editCriteriaSet) {
							urlParameters = urlParameters.replace("&alarmId=" + $scope.alarm.alarmId, "").replace("alarmId=" + $scope.alarm.alarmId, "");
						}
						if (urlParameters === "") {
							alarmUrl = relativeUrl + "?exportType=csv&isAlarm=true&pageSize=-1&pageNo=1&componentName=" +
							$scope.component.id + "&" + $scope.getwhereClause() + "&isOr=" + $scope.alarm.isOrValue;
						} else {
							alarmUrl = relativeUrl + urlParameters +
							"&exportType=csv&isAlarm=true&pageSize=-1&pageNo=1&componentName=" +
							$scope.component.id + "&" + $scope.getwhereClause() + "&isOr=" + $scope.alarm.isOrValue;
						}
					}

					if ($scope.dataSet && $scope.dataSet.dataSet.dataSetId) {
						alarmUrl += "&alarmDataSetName=" + $scope.dataSet.dataSet.dataSetId;
					}

					if (alarmUrl.indexOf('health.jsp') !== -1) {
						alarmUrl = alarmUrl.replace("health.jsp", "healthDashboardAlarm.jsp");
						alarmUrl += "&tileId=" + $scope.tileData.tileId;
						angular.forEach($scope.conditions, function(condition, i) {
							alarmUrl += "&tileStatus=" + condition.value;
						});
					}

					return window.encodeURIComponent(alarmUrl);
				};

				$scope.changeAlarmFreq = function() {

					if ($scope.alarm.freqType == "DAILY") {
						$scope.alarm.daysToRun = undefined;
						$scope.alarm.dayOfMonth = undefined;
						$scope.alarm.weekOfMonth = undefined;
					} else if ($scope.alarm.freqType == "WEEKLY") {
						$scope.alarm.dayOfMonth = undefined;
						$scope.alarm.weekOfMonth = undefined;
						$scope.alarm.dayOfMonth = undefined;
					} else if ($scope.alarm.freqType == "MONTHLY") {
						$scope.alarm.daysToRun = undefined;
						$scope.alarm.weekOfMonth = $scope.weeksOfMonth[0].id;
						$scope.alarm.dayOfWeek = $scope.daysOfWeek[0].id;
						$scope.alarm.monthSelector = "daySelector";
					}
				};

				$scope.getHour = function(fieldId) {
					var ampm = (fieldId === "activeEndTime") ? parseInt($scope.alarm.endTimeAMPM)
							: parseInt($scope.alarm.ampm);
					var hour = ((fieldId === "activeEndTime") ? Number($scope.alarm.endTimeHour)
							: Number($scope.alarm.hour)) +
							ampm;
					if (hour == 12) {
						return 0; //12 am
					}
					if (hour == 24) {
						return 12; //12 pm
					}
					return hour;
				};

				$scope.getTime = function(fieldId) {

					var minute = (fieldId && fieldId == "activeEndTime") ? $scope.alarm.endTimeMinute
							: $scope.alarm.minute;
					return $scope.getHour(fieldId) * 3600 + parseInt(minute) * 60;
				};

				$scope.buildGeneralDesciption = function() {
					var description = [];
					var joinCondition = $scope.alarm.isOrValue === "and" ? " and " : " or ";
					var url = window.location.pathname;
					var isHealthAlert = url.indexOf("health.jsp") != -1;

					angular.forEach($scope.conditions, function(condition, i) {
						var desc = {
							"filteredColumn" : condition.displayName,
							"oper" : $scope.operatorToDescMatch[condition.operator],
							"search" : isHealthAlert ? $scope.getValue(parseInt(condition.value)) : condition.value,
							"join" : joinCondition
						};
						if (condition.type === "Time" || condition.type === "TimeStamp") {
							let relativeOption = $scope.relativeOptions.find(row => row.id === condition.relativeTimeValue);
							desc.search = desc.search + " " + relativeOption.label;
						}
						description.push(desc);
					});
					return JSON.stringify(description);
				};

				$scope.isNumberColumn = function(type) {
					var arr = [ 'Double', 'Float', 'Integer', 'Long', 'Short', 'Decimal' ];
					return arr.indexOf(type) != -1 ? true : false;
				};

				$scope.validateCondition = function(condition) {
					var isValidCondition = true;
					condition.invalid = undefined;
					if (condition.value) {
						if ($scope.isNumberColumn(condition.type) && isNaN(condition.value)) {
							isValidCondition = false;
							condition.invalid = true;
							$scope.alarm.error = localMsg['alert_error_enter_numeric_value'];
						}

					} else {
						if (!condition.notapplicable) {
							isValidCondition = false;
							condition.invalid = true;
							$scope.alarm.error = localMsg['alert_error_enter_text_value'];
						}
					}

					return isValidCondition;

				};

				$scope.validateAlarm = function() {
					var isValidAlarm = true;

					clearAccordionErrors.call($scope.accordions);
					$scope.alarm.error = '';

					var minutes = parseInt($scope.alarm.minute);
					if (isNaN(minutes) || minutes > 59) {
						isValidAlarm = false;
						$scope.alarm.error = localMsg['schedule_error_invalid_time'];
						$scope.alarm.invalidMinutes = true;
						return;
					} else {
						$scope.alarm.invalidMinutes = undefined;
					}

					if ($scope.alarm.repeatEveryNHours) {
						var nHours = parseInt($scope.alarm.everyNHoursSpinner);
						var nMins = parseInt($scope.alarm.everyNMinsSpinner);
						if (isNaN(nHours) || nHours > 24) {
							isValidAlarm = false;
							showAccordionError.call($scope.accordions.schedules, localMsg['schedule_repeat_invalid_hours']);
							$scope.alarm.invalidRepeatHours = true;
							return;
						} else {
							$scope.alarm.invalidRepeatHours = undefined;
						}

						if (isNaN(nMins) || nMins > 59) {
							isValidAlarm = false;
							showAccordionError.call($scope.accordions.schedules, localMsg['schedule_repeat_invalid_mins']);
							$scope.alarm.invalidRepeatMinutes = true;
							return;
						} else {
							$scope.alarm.invalidRepeatMinutes = undefined;
						}

						if ((nHours == 0 && nMins == 0)) {
							isValidAlarm = false;
							showAccordionError.call($scope.accordions.schedules, localMsg['schedule_repeat_invalid_hours_mins']);
							$scope.alarm.invalidRepeatHours = true;
							$scope.alarm.invalidRepeatMinutes = true;
						} else {
							$scope.alarm.invalidRepeatHours = undefined;
							$scope.alarm.invalidRepeatMinutes = undefined;
						}

						if (!isValidAlarm) {
							return;
						}
					}
					if ($scope.alarm.freqType == "MONTHLY" && $scope.alarm.monthSelector == "dateSelector") {
						var day = parseInt($scope.alarm.dayOfMonth);
						if (isNaN(day) || minutes > 31) {
							isValidAlarm = false;
							$scope.alarm.error = localMsg['schedule_error_invalid_day'];
							$scope.alarm.invalidDay = true;
							return;
						} else {
							$scope.alarm.invalidDay = undefined;
						}

					}

					angular.forEach($scope.conditions, function(condition) {
						isValidAlarm = $scope.validateCondition(condition);
					});

					if (!isValidAlarm) {
						return;
					}
					if ($scope.alarm.notificationsSelected.length == 0) {
						isValidAlarm = false;
						showAccordionError.call($scope.accordions.notifications, "Select one or more notification options");
					}

					if ($scope.alarm.notificationsSelected.indexOf("EMAIL") != -1) {
						if ($scope.alarm.email) {

							if (!validateEmail($scope.alarm.email)) {
								isValidAlarm = false;
								$scope.alarm.invalidEmail = true;
								showAccordionError.call($scope.accordions.notifications, cvUtil.cvLocalize('invalid_email'));
							} else {
								$scope.alarm.invalidEmail = false;
							}
							if ($scope.alarm.emailCc && !validateEmail($scope.alarm.emailCc)) {
								isValidAlarm = false;
								$scope.alarm.invalidEmailCc = true;
								showAccordionError.call($scope.accordions.notifications, cvUtil.cvLocalize('invalid_email'));
							} else {
								$scope.alarm.invalidEmailBcc = false;
							}
							if ($scope.alarm.emailBcc && !validateEmail($scope.alarm.emailBcc)) {
								isValidAlarm = false;
								$scope.alarm.invalidEmailBcc = true;
								showAccordionError.call($scope.accordions.notifications, cvUtil.cvLocalize('invalid_email'));
							} else {
								$scope.alarm.invalidEmailBcc = false;
							}
						} else {
							isValidAlarm = false;
							showAccordionError.call($scope.accordions.notifications, cvUtil.cvLocalize('invalid_email'));
							$scope.alarm.invalidEmail = true;
						}
					}

					return isValidAlarm;
				};

				$scope.processWeekDays = function() {
					for (var i = 0; i < $scope.alarm.weekDays.length; i++) {
						$scope.alarm[$scope.alarm.weekDays[i]] = true;
					}

				};

				$scope.addAlarm = function(alarmForm) {
					if (!$scope.validateAlarm()) {
						return;
					}

					$scope.alarm.columnJson = window.encodeURIComponent(JSON.stringify($scope.alarmColList));
					$scope.alarm.alarmColList = $scope.alarmColList;
					if (!$scope.editCriteriaSet) {
						var reportUrl = window.location.href;
						$scope.alarm.reportURL = reportUrl;//window.location.origin + window.location.pathname + ($.trim(reportUrl).length > 0 ? "?" + reportUrl : "");
					}

					$scope.alarm.description = $scope.buildGeneralDesciption();
					$scope.alarm.isOr = ($scope.alarm.isOrValue === "and") ? false : true;
					if (!$scope.acEditAlert) {
						$scope.alarm.alarmURL = $scope.getAlarmUrl();
					} else {
						let alarmObj = getAlarmURLAsObject($scope.alarm.alarmURL);
						let url = getAlarmURLFromObject(alarmObj, $scope.component.id, $scope.conditions);
						if (url) {
							$scope.alarm.alarmURL = url;
						}
					}
					if ($scope.alarm.notificationsSelected) {
						$scope.alarm.notificationsSelected = $scope.alarm.notificationsSelected.join(",");
					}
					$scope.alarm.templateDescriptionSNMP = $scope.alarm.templateDescriptionSNMP.replace(/</gi, "##lt;")
							.replace(/>/gi, "##gt;");
					$scope.alarm.activeStartTime = $scope.getTime();
					if ($scope.alarm.freqType == "WEEKLY") {
						$scope.processWeekDays();
					} else if ($scope.alarm.freqType == "DAILY") {
						if ($scope.alarm.repeatEveryNHours) {
							$scope.alarm.activeEndTime = $scope.getTime("activeEndTime");
						} else {
							$scope.alarm.everyNHoursSpinner = 0;
							$scope.alarm.everyNMinsSpinner = 0;
						}

					}
					var alertSuccessMessage = localMsg['Alert_Creation_Success'];
					var alertFailureMessage = localMsg['Alert_Creation_Failed'];
					if ($scope.editCriteriaSet) {
						$scope.removeAlarmIdFromUrl($scope.alarm.alarmId);
						alertSuccessMessage = localMsg['Alert_Modification_Success'];
						alertFailureMessage = localMsg['Alert_Modification_Failed'];

					}

					function successCallback(retData) {
						var data = retData.data;
						if (!data) {
							// response coming directly from WS
							// for admin console reports.
							data = retData;
						}
						if (typeof data == 'object') {
							if (!!data.errorMsg) {
								customReportSvc.errorToast(alertFailureMessage + ', ' + data.errorMsg);
							} else {
								customReportSvc.toast(alertSuccessMessage);
								if ($scope.acEditAlert) {
									$rootScope.$emit('reloadAlert', true);
								}
							}
						} else {
							customReportSvc.errorToast(alertFailureMessage + ', ' + data);
						}
					}

					function errorCallback(data) {
						customReportSvc.errorToast(alertFailureMessage);
					}

					if (customReports.appName === 'adminconsole') {
						let alarmReq = getAlarmRequestForServer($scope.alarm);
						reportService.saveAlarmWS(alarmReq).then(successCallback, errorCallback);
					} else {
						$scope.alarm.alarmName=encodeURIComponent($scope.alarm.alarmName);
						reportService.saveAlarm($scope.alarm).then(successCallback, errorCallback);
					}

					$scope.$close();

				};

				$scope.testCriteriaInAdminConsole = function() {
					var alarmUrl = '';
					if ($scope.acEditAlert) {
						let alarmObj = getAlarmURLAsObject($scope.alarm.alarmURL);
						alarmUrl = convertToACTestCriteriaURL(getAlarmURLFromObject(alarmObj, $scope.component.id, $scope.conditions));
					} else {
						alarmUrl = convertToACTestCriteriaURL($scope.getAlarmUrl());
					}

					if (alarmUrl) {
						var testCriteriaId = "test-criteria-" + Date.now();

						alarmUrl += '&testCriteriaId=' + testCriteriaId;

						$uibModal
								.open({
									templateUrl : appUtil.appRoot + 'reportsplus/alarms/testCriteriaModal.jsp',
									backdrop : 'static',
									windowClass : 'small-size test-criteria-dialog-holder',
									controller : [
											'$scope',
											'$rootScope',
											'$uibModalInstance',
											function($scope, $rootScope, $uibModalInstance) {

												$scope.data = null;
												$scope.error = null;
												$scope.metaText = null;
												$scope.testCriteriaId = testCriteriaId;

												$rootScope
													.$on(testCriteriaId,
														function (e, message) {
															if (message && message.columns &&
																message.data) {
																$scope.data = message;
																if (message.data.length > 0) {
																	$('.test-criteria-dialog-holder').addClass('test-criteria-dialog');
																}
																if (message.meta && message.meta.limit) {
																	if (message.data.length > 0) {
																		$scope.metaText = cvUtil.cvLocalize('topNRowsShown', message.meta.limit);
																	}
																}

															} else {
																$scope.error = cvUtil.cvLocalize('errorLoadingTestCriteria');
															}
														});

												$scope.isLoading = function() {
													return !($scope.data || $scope.error);
												};

												$scope.cancel = function() {
													$uibModalInstance.dismiss();
												};

												(function loadIframe() {
													setTimeout(function() {
														var finalLink = alarmUrl;
														var iframeDOM = document.createElement("iframe");
														iframeDOM.setAttribute("style", "display:none;");
														document.getElementById(testCriteriaId).appendChild(iframeDOM);
														iframeDOM.src = finalLink;
													},
															100);
												})();

											} ]
								});

					}
				};

				// END: functions on scope


				// BEGIN: Other private functions

				function showAccordionError(errorMessage) { // call with .call($scope.accordions.ACCORDION_NAME)
					if (errorMessage) {
						this.isOpen = true;
						this.error = errorMessage;
					}
				}

				function clearAccordionErrors() { // call with .call($scope.accordions)
					var accordions = this;
					Object.keys(this).forEach(function(key) {
						accordions[key].error = '';
					});
				}

				function validateEmail(emails) {
					emails = emails.trim();
					if (!!emails) {
						emails = emails.replace(/[\s,;]+/g, ';'); //replace all whitespaces, comma and semicolons with a single semicolon
						var emailList = _.filter(emails.split(';'), function(p) { return !!p; });
						if (emailList == null) {
							emailList = [];
							emailList.push(emails);
						}
						var emailPattern = /^[^@;,\s]+@[^@;,\s]+\.[^@;,\s]+$/; //basic validation - restrict @, comma, semicolon and any white space
						var results = _.filter(emailList, function(value) {
							if (value) {
								value = $.trim(value);
								return value.match(emailPattern);
							}
						});

						if (results && results.length == emailList.length) {
							return true;
						}
					}
					return false;
				}

				function getAlertURLForAdminConsole(params) {
					var search = location.hash.substring(location.hash.indexOf('?') + 1);
					var urlParams = JSON.parse('{"' + decodeURI(search).replace(/"/g, '\\"').replace(/&/g, '","').replace(/=/g,'":"') + '"}')

					// remove unnecessary params.
					delete urlParams['alarmId'];
					delete urlParams['app'];

					var url = '/reportsplus/reportViewer.jsp' + '?exportType=csv&pageSize=-1&isdminconsoleReport=true&isAlarm=true&pageNo=1';

					var totalParams = angular.merge(urlParams, params);

					var str = '';
					for (var key in totalParams) {
					    str += '&' + key + '=' + encodeURIComponent(totalParams[key]);
					}

					url = url + str;

					return url;
				}

				function getCSRegionalSettings() {
					reportService.getCSRegionalSettings().then(function(data) {
						if (!!data && !!data.data) {
							data = data.data;
							$scope.timezones = _.get(data, 'timeZonesList.timezones', []);
						}
					}, function(error) {
						console.error(error);
					});
				}

				function init() {

					var succFn = function (data) {
						var scheduleData = null;
						if ($scope.acEditAlert) {
							if (!!data) {
								let taskDetailsList = data;
								$scope.alarm.taskDetailsList = taskDetailsList;

								scheduleData = convertTaskToSchedule(data);
								$scope.alarm.timezone = _($scope.timezones).filter(tz => tz.TimeZoneID === scheduleData.timezone);
							}
						} else if (data.aaData && data.aaData.length) {
							if (!angular.isUndefined(data.aaData)) {
								scheduleData = data.aaData[0];
							}
						}

						if (scheduleData) {
							$scope.populateAlarmDialogFreqField(scheduleData);
						} else {
							$scope.alarm.loadingScheduleDetails = false;
						}
					};

					var errFn = function (e) {
						$scope.alarm.loadingScheduleDetails = false;
						var errorMessage = "Unable to find schedule details for alarmId [" + $scope.alarm.alarmId +
							"], Error Message :" + e;
						console.error(errorMessage);
					};

					if ($scope.acEditAlert) {
						var alarmObj = getAlarmURLAsObject($scope.alarmDetails.alarmURL);
						var columns = getAllColumns($scope.customReport, alarmObj);
						$scope.component = {
							id: alarmObj.componentName,
							columns: columns
						};
						if (isColumnProcessingRequired(columns)) {
							$scope.isColumnInfoLoading = true;
							getColumnInfoFromDataSet($scope.customReport, alarmObj, $scope.component).then(function(data){
								$scope.isColumnInfoLoading = false;
								var dataSetColumns = _.get(data,'data.columns');
								if (dataSetColumns) {
									processColumns(columns, dataSetColumns);
									$scope.updateConditionsWithColumnType();
								} else {
									customReportSvc.errorToast(cvUtil.cvLocalize('Error_Loading_Alert_Column_Info'));
								}
							}, function() {
								$scope.isColumnInfoLoading = false;
								customReportSvc.errorToast(cvUtil.cvLocalize('Error_Loading_Alert_Column_Info'));
							});
						}
						$scope.alarmDetails.name = $scope.alarmDetails.alarmName;
						$scope.alarmDetails.emailBcc = $scope.alarmDetails.bccEmail;
						$scope.alarmDetails.emailCc = $scope.alarmDetails.ccEmail;
						$scope.alarmDetails.report = $scope.alarmDetails.reportName;
					}
					if ($scope.alarmDetails && $scope.alarmDetails.editCriteriaSet) {
						$scope.editCriteriaSet = $scope.alarmDetails.editCriteriaSet;
						$scope.removeAlarmIdFromUrl($scope.alarmDetails.alarmId);
					} else {
						$scope.alarmDetails = undefined;
					}
					$scope.columns = $scope.component.columns;
					$scope.reportName = $scope.customReport.report.customReportName;
					$scope.alarmName = "Alert for " + $scope.reportName;
					$scope.isPublicMetricsCloud = isPublicMetricsCloud == "true" ? true : false;
					$scope.CS_TIMEZONE_STR = CS_TIMEZONE_STR;
					$scope.defaultSNMPText = localMsg['General_Alarms_SNMP_DefaultText'];
					$scope.Alarms_SNMP_Note = localMsg['Alarms_SNMP_Note'];
					$scope.defaultEmailHeader = localMsg['Custom_Email_Header_Text'];

					//support for i.e I.E does not support the window.location.origin
					if (!window.location.origin) {
						window.location.origin = window.location.protocol + "//" + window.location.host;
					}

					$scope.reportId = $scope.customReport.report.customReportId;

					if (typeof emailSuggestion == "undefined") {
						setTimeout(function () {
							cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/reports/js/emailSuggestion.js", null);
						}, 1000);
					} else {
						setTimeout(function () {
							emailSuggestion.initializeEmailSuggestion();
						}, 1000);
					}

					angular.forEach($scope.columns, function (column, key) {
						if (column.visible && !column.hidden) {
							var alarmCol = {};
							alarmCol.dataType = column.type;
							alarmCol.index = key;
							alarmCol.inputVal = "";
							$scope.translate
							if ($scope.translate) {
								alarmCol.mDataProp = $scope.translate(column.displayName);
							} else {
								alarmCol.mDataProp = column.displayName;
							}
							alarmCol.name = column.id;
							alarmCol.operator = "";
							alarmCol.renderer = "";
							if ($scope.translate) {
								alarmCol.title = $scope.translate(column.displayName);
							} else {
								alarmCol.title = column.displayName;
							}
							alarmCol.type = column.type;
							alarmCol.value = "";
							alarmCol.visible = true;
							alarmCol.valueOptions = "";//$scope.setValueOption(column.type);
							$scope.alarmColList.push(alarmCol);

							$scope.defaultSNMPText += ", " + column.displayName + " : $" + column.displayName + "$ ";
						}
					});

					$scope.alarm = {
							action: "CREATE",
							alarmName: $scope.alarmName,
							alarmType: "GENERAL",
							alarmURL: "",
							columnJson: "",
							alarmColList: [],
							commUniId: customReportSvc.getParameterByName("commUniId", 0),
							description: "Description",
							email: "",
							exportType: "CSV",
							filePrefix: "Alert",
							manageURL: window.location.origin + customReportSvc.getContextPath() +
							"/reports/reports.jsp?report=alarmsSettings",
							notificationsSelected: ["EMAIL"],
							reportEnum: "CustomReports",
							reportName: $scope.reportName,
							reportType: "1",
							reportURL: "",
							reportUniqId: $scope.reportId,
							templateDescriptionSNMP: $scope.defaultSNMPText,
							emailHeader: $scope.defaultEmailHeader,
							severity: "INFORMATION",
							isOr: false,
							freqType: "DAILY",
							ampm: "0",
							minute: "00",
							hour: "8",
							endTimeAMPM: "12",
							endTimeMinute: "55",
							endTimeHour: "11",
							everyNHoursSpinner: 8,
							everyNMinsSpinner: 0,
							timezone: 0,
							isOrValue: 'and'
					};

					if (!angular.isUndefined(defaultTimeZoneId)) {
						$scope.alarm.timezone = defaultTimeZoneId;
					}

					if (!$scope.editCriteriaSet) {
						$scope.addCondition();
					}

					if ($scope.editCriteriaSet) {
						$scope.alertTitlePrefix = localMsg['edit_alert'];
						$scope.alarm.alarmName = $scope.alarmDetails.name;
						$scope.alarm.action = "EDIT";
						$scope.alarm.alarmType = $scope.getAlarmType($scope.alarmDetails.type);
						$scope.alarm.alarmURL = $scope.alarmDetails.alarmURL;
						$scope.alarm.commUniId = ($scope.alarmDetails.commUniId) ? ($scope.alarmDetails.commUniId) : 0;
						$scope.alarm.description = $scope.alarmDetails.description;
						$scope.alarm.email = $scope.alarmDetails.email;
						$scope.alarm.emailCc = $scope.alarmDetails.emailCc;
						$scope.alarm.emailBcc = $scope.alarmDetails.emailBcc;
						$scope.alarm.notificationsSelected = $scope.alarmDetails.notificationTypes.split(",");
						$scope.alarm.reportEnum = $scope.alarmDetails.reportEnum;
						$scope.alarm.reportName = $scope.alarmDetails.report;
						$scope.alarm.reportType = $scope.alarmDetails.type;
						$scope.alarm.reportURL = $scope.alarmDetails.reportURL;
						$scope.alarm.reportUniqId = $scope.alarmDetails.reportUniqId;
						$scope.alarm.severity = $scope.alarmDetails.alertSeverity;
						$scope.alarm.alertStatus = $scope.alarmDetails.status;
						$scope.alarm.loadingScheduleDetails = true;
						$scope.alarm.alarmId = $scope.alarmDetails.alarmId;
						$scope.alarm.isOr = $scope.alarmDetails.isOr;
						$scope.alarm.tileStatus = (!!$scope.alarmDetails.tileStatus) ? $scope.alarmDetails.tileStatus : "4";
						if ($scope.alarmDetails.SNMPDescription) {
							$scope.alarm.templateDescriptionSNMP = $scope.alarmDetails.SNMPDescription.replace(/##lt;/gi, '<').replace(/##gt;/gi, '>');
						}
						if ($scope.alarmDetails.headerTemplate) {
							$scope.alarm.emailHeader = $scope.alarmDetails.headerTemplate;
						}
						if ($scope.acEditAlert) {
							$scope.alarm.severity = getKeysForValues(commonConstants.alertSeverity, $scope.alarmDetails.alertSeverity)[0];
						}
						$scope.alarmDetails = undefined;

						var url = window.location.pathname;
						var isHealthAlert = url.indexOf("health.jsp") != -1;

						var existingCriteria = $.parseHTML($scope.alarm.description);
						if (!!$scope.isTileAlert && isHealthAlert) {
							$scope.addCondition();
							if ($scope.conditions && $scope.conditions.length > 0) {
								$scope.conditions[0].value = $scope.alarm.tileStatus;
							}
							if (!!$scope.alarm.tileStatus) {
								delete $scope.alarm.tileStatus;
							}

						} else if (existingCriteria) {
							var isOrValue;
							angular.forEach(existingCriteria, function (idx, li) {
								var obj = {};
								if (idx.childElementCount >= 4) {
									obj.columnName = idx.childNodes[0].textContent.trim();
									obj.conditionOperator = $scope.descToOperatorMatch[idx.childNodes[2].textContent];
									obj.value = idx.childNodes[3].textContent.trim();
									if ($scope.relativeOperators.indexOf(obj.conditionOperator) !== -1) {
										var objVals = obj.value.split(" ");
										obj.value = objVals[0];
										obj.relativeTimeValue = $scope.relativeOptionsToDescMatch[objVals[1]];
									}
									$scope.addCondition(obj);
									if (!isOrValue && idx.childNodes.length >= 5) {
										isOrValue = idx.childNodes[4].textContent.trim();
									}
								}
							});
							if (isOrValue) {
								$scope.alarm.isOrValue = isOrValue;
								if (isOrValue == "and") {
									$scope.alarm.isOr = false;
								} else if (isOrValue == "or") {
									$scope.alarm.isOr = true;
								}
							}
						}
						var param = {};
						param.alarmId = $scope.alarm.alarmId;

						let promise = new Promise(function(resolve, reject) {
							getCSRegionalSettings();
							resolve(null);
						});
						promise.then(function() {
							if ($scope.acEditAlert) {
								reportService.getAlarmScheduleDetailsFromWS(param.alarmId).then(succFn, errFn);
							} else {
								reportService.getScheduleDetails(param).then(succFn,errFn);
							}
						});

					} else {
						getCSRegionalSettings();
					}

					$scope.$watch('alarm.monthSelector', function () {
						if ($scope.alarm.monthSelector == "dateSelector") {
							$("#alarmsDialog").find("#dateSpinner").prop('disabled', false);

							$("#alarmsDialog").find("#weekOfMonth").prop('disabled', true);
							$("#alarmsDialog").find("#dayOfWeek").prop('disabled', true);
						} else {
							$("#alarmsDialog").find("#dateSpinner").prop('disabled', true);

							$("#alarmsDialog").find("#weekOfMonth").prop('disabled', false);
							$("#alarmsDialog").find("#dayOfWeek").prop('disabled', false);
						}
					});

					if (!$scope.editCriteriaSet) {
						$scope.alarm.email = cv.loggedInUserSmtp;
					}
				}

				function getKeysForValues(object, values) {
					var retval = [];
					if (values) {
						if (!angular.isArray(values)) {
							values = [values];
						}
						_.mapKeys(object, function(value, key) {
							if (values.indexOf(value) > -1) {
								retval.push(key);
							}
						});
					}
					return retval;
				}

				function getAlarmURLAsObject(alarmURL) {
					if (alarmURL) {
						var decoded = decodeURIComponent(alarmURL);
						decoded = decoded.substring(decoded.indexOf('?') + 1);
						var obj = JSON.parse('{"' + decodeURI(decoded).replace(/"/g, '\\"').replace(/&/g, '","').replace(/=/g,'":"') + '"}')
						if (obj) {
							return obj;
						}
					}
					return null;
				}

				function convertToACTestCriteriaURL(alarmURL) {
					var url = null;
					if (alarmURL) {
						var decoded = decodeURIComponent(alarmURL);
						url = customReportSvc.getContextPath() + '/#/reportDetails?' + decoded.substring(decoded.indexOf('?') + 1);
					}
					return url;
				}

				function applyConditionChanges(alarmObj, componentId, conditions) {
					var HIDE = '.hide';
					var SHOW = '.show';
					if (componentId && conditions) {
						var hiddenVals = alarmObj[componentId + HIDE] ? alarmObj[componentId + HIDE]
								.split('%2C') : [];
						var shownVals = alarmObj[componentId + SHOW] ? alarmObj[componentId + SHOW]
								.split('%2C') : [];
						var conditionsColumns = conditions.map(function(el) {
							return el.columnName;
						});
						conditionsColumns.forEach(function(colName) {
							if (hiddenVals.indexOf(colName) != -1) {
								hiddenVals = hiddenVals.filter(function(val) {
									return val != colName;
								});

								if (shownVals.indexOf(colName) == -1) { // Just a check to ensure that the columnName is not inserted twice
									shownVals.push(colName);
								}
							}
						});

						if (hiddenVals.length > 0) {
							alarmObj[componentId + HIDE] = hiddenVals.join('%2C');
						} else {
							delete alarmObj[componentId + HIDE];
						}
						if (shownVals.length > 0) {
							alarmObj[componentId + SHOW] = shownVals.join('%2C');
						} else {
							delete alarmObj[componentId + SHOW];
						}

						var filterColumnKeys = Object.keys(alarmObj).filter( function(e) {
								return e.indexOf(componentId + '.filter') > -1;
							});
						filterColumnKeys.forEach(function(val) {
							delete alarmObj[val];
						});

					}

					return alarmObj;
				}

				function getAlarmURLFromObject(alarmObj, componentId, conditions) { // Use this only in edit criteria
					if (alarmObj) {
						if (componentId && conditions) {
							alarmObj = applyConditionChanges(alarmObj, componentId, conditions);
						} else {
							console.error('Component information OR conditions were not passed. Could not apply conditions');
						}
						var params = Object.keys(alarmObj).map(function(k) {
							return k + '=' + alarmObj[k];
						}).reduce(function(accumulator, item) {
							return accumulator + '&' + item;
						});
						var url = '/reportsplus/reportViewer.jsp?' + params + '&' + $scope.getwhereClause();
						return encodeURIComponent(url);
					}
					return null;
				}

				function isColumnProcessingRequired(columns) {
					if (!columns) {
						return true;
					} else {
						if(columns.length === 0){
							return true;
						}
						for (var i = 0; i < columns.length; i++) {
							if (!columns[i].type) {
								return true;
							}
						}
					}

					return false;
				}

				function getAllColumns(customReport, alarmObj) {
					var page = getReportPage(customReport, alarmObj);
					var body;
					if (page) {
						body = JSON.parse(page.body);
					}
					if (body) {
						var comps = body.reportComponents.filter(function(comp) {
							return comp.id == alarmObj.componentName;
						});
						if (comps.length) {
							var comp = comps[0];
							return comp.columns.filter(function (col) {
								// exclude system hidden columns anyway.
								return !col.hidden;
							});
						}
					}
					return [];
				}

				function getReportPage(customReport, alarmObj) {
					if (alarmObj && customReport) {
						if (alarmObj.pageName) {
							var page = _.find(customReport.pages, function(o) {
								return o.pageName == alarmObj.pageName;
							});
							return page;
						} else if (customReport.pages && customReport.pages.length > 0) {
							return customReport.pages[0];
						}
					}
					return null;
				}

				function getColumnInfoFromDataSet(customReport, alarmObj, component) {
					var page = getReportPage(customReport, alarmObj);
					if (page) {
						var dataSet = getDataSetFromPage(page, component.id);
						return getFieldsForDataSet(customReport, dataSet, page, component)
					}
					return null;
				}

				function getDataSetFromPage(page, componentId) {
					var body = JSON.parse(page.body);
					if (body && componentId) {
						if (body.reportComponents) {
							var component = body.reportComponents.filter(function(el) {
								return el.id = componentId;
							});
							if (component.length) {
								var dataSetGuid = _.get(component[0],'dataSet.dataSetGuid');
								if (dataSetGuid) {
									var dataSetsList = _.get(page, 'dataSets.dataSet');
									var resDataSet = dataSetsList.filter(function(el) {
										return _.get(el,'dataSet.dataSetGuid') == dataSetGuid;
									});
									if (resDataSet.length) {
										return resDataSet[0];
									}
								}
							}
						}
					}
					return null;
				}

				function getDataSetID(customReport, dataSet) {
					return typeof customReport.guid !== "undefined" ? customReport.guid + ":" + dataSet.guid : dataSet.guid ;
				}

				function getFieldsForDataSet(customReport, dataSet, page, component){
					var dataSetParams = {
						reportMode : "viewer",
						componentName : "Preview Table",
						dsId : getDataSetID(customReport,dataSet),
						operation : "fields",
						builderVersion : customReport.builderVersion,
						isPreview : false,
						limit : 2,
						offset : 0,
						exportType : null,
						exportedFileName : null,
						rawData : dataSet && dataSet.endpoint == "HTTP" ? true : false,
						cacheId: customReportSvc.generateUUID()
					};
					var dataUrl = dataSetUtility.getUrlForDataComponent(component,
							dataSet,
							page,
							dataSetParams,
							{});

					return reportService.getDataForDataSetViaProxy(dataUrl);

				}

				function processColumns(existingColumns, dataSetColumns) {
					var dataSetColumnsByDataField = {};
					dataSetColumns.forEach(function(col) {
						dataSetColumnsByDataField[col.dataField] = col;
					});
					existingColumns.forEach(function(col){
						if (dataSetColumnsByDataField[col.dataField]) {
							col.type = dataSetColumnsByDataField[col.dataField].type;
						}
					});
				};

				function getAlarmRequestForServer(alarm) {
					const userId = parseInt(cv.loggedInUserId);

					var req = {
						alarmProps: {

						}
					};

					var props = req.alarmProps;

					if (alarm.action == 'EDIT' && !!alarm.alarmId) {
						req.action = commonConstants.alarmAction.EDIT;
						props.alarmId = alarm.alarmId;
					} else {
						req.action = commonConstants.alarmAction.CREATE;
					}

					req.commUniId = 0;
					req.webServerClientId = 0;
					req.alarmProps = props;
					props.SNMPDescription = alarm.templateDescriptionSNMP;
					props.alarmName = alarm.alarmName;
					props.alarmURL = alarm.alarmURL;
					props.alertSeverity = alarm.severity;
					props.description = buildDescriptionText(alarm);
					props.email = alarm.email;
					props.ccEmail = alarm.emailCc;
					props.bccEmail = alarm.emailBcc;
					props.headerTemplate = alarm.emailHeader;
					props.isOr = alarm.isOr;
					props.reportEnum = 'CustomReports';
					props.reportName = alarm.reportName;
					props.reportURL = alarm.reportURL;
					props.manageURL = window.location.origin + cvUtil.getContextPath() + "/#/reportAlerts";
					props.reportUniqId = '' + alarm.reportUniqId;
					props.type = commonConstants.alarmType.GENERAL;
					props.userId = userId;
					props.alarmColList = alarm.alarmColList;

					props.version = 1;				// always 1.
					// not used fields
					props.paramValue = null;
					props.alarmOperationType = 0;
					props.alertCriteriaIdForTile = 0;
					props.ccGroupId = 0;
					props.companyId = 0;
					props.templateId = 0;
					props.tileID = 0;
					props.isTileAlert = false;

					props.notificationTypesSelected = _.map(alarm.notificationsSelected.split(','), item => commonConstants.notificationType[item.trim()]);
					props.alarmColList = alarm.alarmColList;

					let taskDetailsList = getScheduleInfo(alarm);

					props.scheduleInfo = JSON.stringify(taskDetailsList);
					return req;
				}

				function getScheduleInfo(alarm) {
					const userId = parseInt(cv.loggedInUserId);
					const startTime = parseInt(alarm.activeStartTime);
					const timeZoneID = commonConstants.CSTimeZoneId.CS_TZ;
					const reportId = alarm.reportUniqId;
					let taskDetailsList = new TaskDetailsList();
					if (alarm.taskDetailsList) {
						taskDetailsList = alarm.taskDetailsList;
					}
					let taskInfo = _.get(taskDetailsList, 'taskDetail[0]', null);
					let subTaskInfo = _.get(taskInfo, 'subTasks[0]', null);

					// The below two conditions becomes true when there is not schedule information in the alert or the alert is being created.
					if (taskInfo == null) {
						taskInfo = new TaskInfo();

						taskInfo.task = new Task();
						taskInfo.task.ownerId = userId;
						taskInfo.task.ownerName = cv.loggedInUserName;
						taskInfo.task.taskType = TaskType.SCHEDULE;
						taskInfo.subTasks = [];
					}
					// The ScheduleMetricsAlerts REST API returns GetTaskListResp response that has a field 'taskDetail' instead of 'taskDetails'
					// Reinitializing the TaskDetailsList with correct field name.
					taskDetailsList.taskDetails = [];
					taskDetailsList.taskDetails.push(taskInfo);

					if (subTaskInfo == null) {
						subTaskInfo = new SubTaskInfo();
						taskInfo.subTasks.push(subTaskInfo);

						subTaskInfo.subTask = new SubTask();
						subTaskInfo.subTask.operationType = TaskOperationType.CUSTOM_QUERY_EXEC;
						subTaskInfo.subTask.subTaskType = SubTaskType.ADMIN;

						subTaskInfo.options = new JobOption();
						subTaskInfo.options.adminOpts = new AdminOption();
						subTaskInfo.options.adminOpts.reportOption = new ReportOption();
						subTaskInfo.options.adminOpts.reportOption.commonOpt = new RptCommonOptions();
						subTaskInfo.options.adminOpts.reportOption.commonOpt.reportType = ReportType.WEB_REPORT;
						subTaskInfo.options.adminOpts.reportOption.webReportOption = new WebReportOption();
						subTaskInfo.options.adminOpts.reportOption.webReportOption.reportId = '' + reportId;
						subTaskInfo.options.adminOpts.reportOption.webReportOption.reportType = 'CustomReports';
					}

					// updating pattern properties in both create and edit modes.
					subTaskInfo.pattern = new Pattern();
					subTaskInfo.pattern.daysToRun = new DaysToRun();
					subTaskInfo.pattern.freq_recurrence_factor = 1;
					subTaskInfo.pattern.freq_type = FreqType.One_Time;
					subTaskInfo.pattern.freq_interval = 1;
					subTaskInfo.pattern.timeZone = new CVTimeZone();
					subTaskInfo.pattern.timeZone.TimeZoneID = parseInt(timeZoneID);
					subTaskInfo.pattern.active_start_time = startTime;

					if (!!alarm.timezone) {
						subTaskInfo.pattern.timeZone.TimeZoneID = parseInt(alarm.timezone);
					}

					if (alarm.freqType.toLowerCase() === 'daily') {
						subTaskInfo.pattern.freq_type = FreqType.Daily;
						subTaskInfo.pattern.freq_interval = 1;
						if (alarm.repeatEveryNHours) {
							var endTimeHour = parseInt(alarm.endTimeHour);
							var endTimeAMPM = parseInt(alarm.endTimeAMPM);
							var endTimeMinute = parseInt(alarm.endTimeMinute);
							var everyNHoursSpinner = parseInt(alarm.everyNHoursSpinner);
							var everyNMinsSpinner = parseInt(alarm.everyNMinsSpinner);
							if (isNaN(endTimeHour)) {
								console.error("endTimeHour is NaN");
								endTimeHour = 0;
							}
							if (isNaN(endTimeAMPM)) {
								console.error("endTimeAMPM is NaN");
								endTimeAMPM = 0;
							}
							if (isNaN(endTimeMinute)) {
								console.error("endTimeMinute is NaN");
								endTimeMinute = 0;
							}
							if (isNaN(everyNHoursSpinner)) {
								console.error("everyNHoursSpinner is NaN");
								everyNHoursSpinner = 0;
							}
							if (isNaN(everyNMinsSpinner)) {
								console.error("everyNMinsSpinner is NaN");
								everyNMinsSpinner = 0;
							}

							var hours = endTimeHour + endTimeAMPM ;
							if (endTimeHour == 12) {
								hours = endTimeAMPM; // 0 for midnight, 12 for noon
							}
							var activeEndTime = hours * 3600 + endTimeMinute * 60;
							subTaskInfo.pattern.active_end_time = activeEndTime;
                            subTaskInfo.pattern.freq_subday_interval = everyNHoursSpinner * 3600 + everyNMinsSpinner * 60;
						}
					} else if (alarm.freqType.toLowerCase() === 'weekly') {
						subTaskInfo.pattern.freq_type = FreqType.Weekly;
						let freqInterval = 0;
						_(alarm.weekDays).forEach(function (token) {
							let day = token.substr(token.indexOf('daysToRun') + 'daysToRun'.length);
							freqInterval = freqInterval | commonConstants.MONDAY_TO_SUNDAY[parseInt(day)];
						});

						subTaskInfo.pattern.freq_interval = freqInterval;

						if (((freqInterval & commonConstants.DAYMASK_MONDAY) << 0) == commonConstants.DAYMASK_MONDAY) {
							subTaskInfo.pattern.daysToRun.Monday = true;
						}
						if (((freqInterval & commonConstants.DAYMASK_TUESDAY) << 0) == commonConstants.DAYMASK_TUESDAY) {
							subTaskInfo.pattern.daysToRun.Tuesday = true;
						}
						if (((freqInterval & commonConstants.DAYMASK_WEDNESDAY) << 0) == commonConstants.DAYMASK_WEDNESDAY) {
							subTaskInfo.pattern.daysToRun.Wednesday = true;
						}
						if (((freqInterval & commonConstants.DAYMASK_THURSDAY) << 0) == commonConstants.DAYMASK_THURSDAY) {
							subTaskInfo.pattern.daysToRun.Thursday = true;
						}
						if (((freqInterval & commonConstants.DAYMASK_FRIDAY) << 0) == commonConstants.DAYMASK_FRIDAY) {
							subTaskInfo.pattern.daysToRun.Friday = true;
						}
						if (((freqInterval & commonConstants.DAYMASK_SATURDAY) << 0) == commonConstants.DAYMASK_SATURDAY) {
							subTaskInfo.pattern.daysToRun.Saturday = true;
						}
						if (((freqInterval & commonConstants.DAYMASK_SUNDAY) << 0) == commonConstants.DAYMASK_SUNDAY) {
							subTaskInfo.pattern.daysToRun.Sunday = true;
						}

					} else if (alarm.freqType.toLowerCase() === 'monthly') {
						if (alarm.monthSelector == 'dateSelector') {
							subTaskInfo.pattern.freq_type = FreqType.Monthly;
							subTaskInfo.pattern.freq_interval = alarm.dayOfMonth;
							subTaskInfo.pattern.daysToRun.onDayNumber = alarm.dayOfMonth;
						} else if (alarm.monthSelector == 'daySelector') {
							subTaskInfo.pattern.freq_type = FreqType.Monthly_Relative;
							subTaskInfo.pattern.freq_relative_interval = commonConstants.weekOfMonth[alarm.weekOfMonth];
                            subTaskInfo.pattern.freq_interval = commonConstants.day[alarm.dayOfWeek];
                            subTaskInfo.pattern.daysToRun.week = subTaskInfo.pattern.freq_relative_interval;
							subTaskInfo.pattern.daysToRun.day = subTaskInfo.pattern.freq_interval;
						}
					}
					return taskDetailsList;
				}

				function buildDescriptionText(alarm) {
					if (alarm.action == 'EDIT' && !alarm.description) {
						return null;
					}
					var tmpl = '<li class=\"gen-alarm-row\"><b> {{filterColumn}}</b><label> {{value}} </label><em>{{oper}}</em><b>{{search}}</b>{{join}}</li>';
					var descriptionText = '';

					var arr = JSON.parse(alarm.description);
					_.forEach(arr, function (condition, index, collection) {
						var filterColumn = condition['filteredColumn'];
						var oper = condition['oper'];
						var search = condition['search'];
						var join = condition['join'];

						var value = cvUtil.cvLocalize('value');
						if ((collection.length == 1) || (index == (collection.length - 1))) {
							join = '';
						}
						descriptionText = descriptionText + tmpl.replace('{{filterColumn}}', filterColumn)
							.replace('{{value}}', 'value')
							.replace('{{oper}}', oper)
							.replace('{{search}}', search)
							.replace('{{join}}', join);

					});

					return descriptionText;

				}

				function convertTaskToSchedule(taskDetailsList) {
					var retval = {};
					if (taskDetailsList) {
						let taskInfo = _.get(taskDetailsList, 'taskDetail[0]');
						var task = _.get(taskInfo, 'task'); //taskInfo.task;
						retval.taskId = _.get(task, 'taskId'); //task.taskId;
						retval.disabled = _.get(); // task.taskFlags.disabled;
						retval.owner = task.ownerName;

						if(taskInfo && taskInfo.subTasks) {
							var subTaskInfo = taskInfo.subTasks[0];
							var subTask = subTaskInfo.subTask;
							var pattern = subTaskInfo.pattern;
							var reportOption = _.get(subTaskInfo, 'options.adminOpts.reportOption', {});
							var commonOpt = reportOption.commonOpt;
							var webReportOpt = reportOption.webReportOption;

							retval.subTaskId = subTask.subTaskId;
							retval.description = subTask.subTaskName;

							retval.timezone = _.get(pattern, 'timeZone.TimeZoneID');

							var type = pattern.freq_type;
							var activeStartTime = pattern.active_start_time;
							var activeEndTimeNHours = pattern.active_end_time;
							var repeatNHoursInterval = pattern.freq_subday_interval;
							var dateOfMonth = pattern.freq_interval;
							var repeatNmonths = pattern.freq_recurrence_factor;
							var freqRelativeInterval = pattern.freq_relative_interval;
							var freqInterval = pattern.freq_interval;
							var freqRecurrenceFactor = pattern.freq_recurrence_factor;


							if (type == FreqType.Daily) {
								retval.freqType = 'DAILY';
								retval.activeStartTime = activeStartTime;
								retval.activeEndTimeNHours = activeEndTimeNHours;
								retval.repeatNHoursInterval = repeatNHoursInterval;
								retval.daysToRun = null;
							} else if (type == FreqType.Weekly) {
								retval.freqType = 'WEEKLY';
								retval.activeStartTime = activeStartTime;
								retval.daysToRun = weeklyFreqInterval_XMLToWc(freqInterval);
							} else if (type == FreqType.Monthly) {
								retval.freqType = 'MONTHLY';
								retval.activeStartTime = activeStartTime;
								retval.dateOfMonth = dateOfMonth;
								retval.repeatNFrequencey = repeatNmonths;
							} else {
								//retval.freqType = 'MONTHLY_RELATIVE';
								retval.activeStartTime = activeStartTime;
								retval.dayOfWeek = getDayEnum(freqInterval);
								retval.weekOfMonth = getWeekEnum(freqRelativeInterval);
								retval.repeatNFrequencey = freqRecurrenceFactor;
								retval.freqType = 'MONTHLY';
							}
						}
					} else {
						console.log('Schedule information not found');
					}

					return retval;
				}

				function weeklyFreqInterval_XMLToWc(dayMask) {
					var daysToRun = [];

					for (var i = 0; i < 7; i++) {
						daysToRun[i] = (dayMask & commonConstants.MONDAY_TO_SUNDAY[i]) == commonConstants.MONDAY_TO_SUNDAY[i];
					}
					return daysToRun;
				}

				function getDayEnum(val) {
					for (var d in commonConstants.day) {
						if (commonConstants.day[d] == val) {
							return d;
						}
					}
					console.error('Could not find day enum');
					return null;
				}

				function getWeekEnum(value) {
					for (var w in commonConstants.weekOfMonth) {
						if (commonConstants.weekOfMonth[w] == value) {
							return w;
						}
					}
					console.error('Could not find week enum');
					return null;
				}


				// END: Other private functions

				init();

			} ]);

}());