<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:bundle basename="localization.recordsMessages">
	<span class="sectiontitle vw-page-title"><fmt:message key="Records_Management_Head" /></span>
	<table id="recordTable"
		class="table table-condensed table-striped dt-responsive nowrap vw-data-table">
		<thead>
			<tr id="recordTableHeaderRow">
				<th class="col-name"
					data-title="<fmt:message key='tableColumn.name' />"><fmt:message
						key="tableColumn.name" /></th>
				<th class="col-description"
					data-title="<fmt:message key='tableColumn.description' />"><fmt:message
						key="tableColumn.description" /></th>
				<th class="col-retention"
					data-title="<fmt:message key='tableColumn.retention' />"><fmt:message
						key="tableColumn.retention" /></th>
				<th class="col-actions"
					data-title="<fmt:message key='tableColumn.actions' />"><fmt:message
						key="tableColumn.actions" /></th>
			</tr>
		</thead>
		<tbody id="recordTableBody">
		</tbody>
	</table>
	<div class="AddNewItem">
		<a id="addRecord"
			class="addNewItemA addRecord vw-btn vw-btn-secondary" href="#"
			data-toggle="modal" data-target="#addRecordModal"> <span
			class="addWF"><img src="../summary/img/add_16px.png">&nbsp;<fmt:message
					key="record.add" /></span>
		</a>
	</div>
	<!-- Modal -->
	<div class="modal fade" id="addRecordModal" tabindex="-1" role="dialog"
		aria-labelledby="myModalLabel" data-backdrop="static">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="tabbable">

					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
						<h4 class="modal-title">
							<fmt:message key="record.add" />
						</h4>
						<ul class="nav nav-tabs hidden">
							<li class="active"><a href="#addRecordTab" data-toggle="tab"><fmt:message
										key="record.add" /></a></li>
							<li><a href="#createPropertyTab" data-toggle="tab"><fmt:message
										key="property.create" /></a></li>
						</ul>
					</div>
					<div class="modal-body">
						<div class="tab-content">
							<div class="tab-pane active" id="addRecordTab">
								<jsp:include page="/records/addNewRecord.jsp" />
							</div>
							<div class="tab-pane" id="createPropertyTab">
								<jsp:include page="../customproperties/addNewProperty.jsp" />
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script nonce="${sessionScope.cspNonce}" src="js/recordsSummary.js"></script>
</fmt:bundle>
