<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="f" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<link rel="stylesheet"
	href="${pageContext.request.contextPath}/browse/css/dataPane.css?${applicationScope.BUILD_TS}" />
<c:set var="eSourcePage" value="${fn:escapeXml(param.sourcePage)}" />
<c:set var="ebreadCrumbValues"
	value="${fn:escapeXml(param.breadCrumbValues)}" />
<c:set var="eheaderTitle" value="${fn:escapeXml(param.headerTitle)}" />
<c:set var="esearchContext" value="${fn:escapeXml(param.searchContext)}" />
<c:set var="ehideSearchBox" value="${fn:escapeXml(param.hideSearchBox)}" />
<c:set var="esecHeadertopRightButtonHolder"
	value="${fn:escapeXml(param.secHeadertopRightButtonHolder)}" />
<fmt:bundle basename="localization.recordsMessages">
	<div class="sechead dynamicDropDown row">
		<c:if test="${ebreadCrumbValues != null && ebreadCrumbValues != ''}">
			<ul id='breadcrumbMain' class='breadcrumbMain vw-breadcrumbs vw-small vw-col-sm-12'>
				<!-- <li class='smartlinkMain withSeparatorMain vw-breadcrumb-with-separator'><a class='smartLinkMain'  href='${pageContext.request.contextPath}/applications'><f:message key="My_Apps_Header" /></a><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg></li> -->
				<c:set var="str" value='${ebreadCrumbValues}' />
				<c:forEach var="item" items="${fn:split(str, ',')}" varStatus="loop">
					<c:set var="itemSubs" value="${fn:split(item, ':')}" />
					<li class='smartlinkMain withSeparatorMain vw-breadcrumb-with-separator'><a
						class='smartLinkMain' href='../${itemSubs[1]}'>${itemSubs[0]}</a><svg xmlns="http://www.w3.org/2000/svg" width="5" height="8" viewBox="0 0 5 8" class="vw-breadcrumb-arrow hidden"><path d="M0,8V6L3,4,0,2V0L5,4Z"/></svg></li>
				</c:forEach>

			</ul>
		</c:if>
		<div class="col-xs-12">
			<button class="vw-btn vw-btn-default delete-record pull-right" data-toggle="modal"
				data-target="#deleteConfModal"><img src="../clientDetails/img/delete.gif">
				<fmt:message key="Delete" />
			</button>
			<c:choose>
				<c:when test="${eSourcePage == 'clientDetails'}">
					<div id="secTitleDiv">
						<span id="sectionTitle" class="sectiontitle vw-page-title"> <span
							id="changeNameTitle" class="changeNameTitleClass vw-change-name"> <span
								id="changeName" tabindex="0">${eheaderTitle}</span> <input type="text"
								id="changeFolderNameTextBox" class="hidden"
								value="${eheaderTitle}">
						</span>
						</span>
					</div>
				</c:when>
				<c:when test="${eSourcePage == 'sync'}">
					<div id="secTitleDiv">
						<f:bundle basename="localization.SyncMessages">
							<f:message key="sync.label.filterText" var="filterText" />
						</f:bundle>

						<span id="sectionTitle" class="sectiontitle"> <c:choose>
								<c:when test="${requestScope.NEW_FOLDER!=0}">
									<span id="changeNameTitle" class="changeNameTitleClass"><span
										id="changeName" data-id="0" tabindex="0"></span><input type="text"
										id="changeFolderNameTextBox" class="noName" value=""></span>
									<a id="showFilters" class="okSaveButton">${filterText}</a>
								</c:when>
								<c:otherwise>
									<span id="changeNameTitle" class="changeNameTitleClass"><span
										id="changeName" data-id="${requestScope.FOLDER_ID}" tabindex="0">${requestScope.FOLDER_NAME}</span><input
										type="text" id="changeFolderNameTextBox"
										class="noName invisible" value=""></span>
									<a id="showFilters" class="okSaveButton">${filterText}</a>
								</c:otherwise>
							</c:choose>
						</span>
					</div>
				</c:when>
				<c:when test="${eSourcePage == 'browse'}">
					<!-- Moved to inside Buttons holder div -->
				</c:when>
				<c:otherwise>
					<div id="secTitleDiv">
						<span id="sectionTitle" class="sectiontitle">${eheaderTitle}</span>
					</div>
				</c:otherwise>
			</c:choose>
		</div>
	</div>
	<!-- Modal -->
	<div id="deleteConfModal" class="modal fade" role="dialog">
		<div class="modal-dialog">

			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title">Delete Record</h4>
				</div>
				<div class="modal-body">
					<h5 class="confirmDeleteMsg"></h5>
				</div>
				<div class="modal-footer">
					<button type="button" class="vw-btn vw-btn-default" data-dismiss="modal">Cancel</button>
					<button type="button" class="vw-btn btn-danger" id="deleteRecord"
						data-dismiss="modal">
						<fmt:message key="Delete" />
					</button>
				</div>
			</div>

		</div>
	</div>
</fmt:bundle>
