<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.recordsMessages">
	<div id="addNewRecordDialog">
		<div id="addRecordWizard" class="swMain">
			<ul>
				<li><a href="#step-1"> <label class="stepNumber">1</label>
						<span class="stepDesc"> <fmt:message key="record" />
					</span>
				</a></li>
				<li><a href="#step-2"> <label class="stepNumber">2</label>
						<span class="stepDesc"> <fmt:message key="folders" />
					</span>
				</a></li>
				<li><a href="#step-3"> <label class="stepNumber">3</label>
						<span class="stepDesc"> <fmt:message key="Properties" />
					</span>
				</a></li>
				<li><a href="#step-4"> <label class="stepNumber">4</label>
						<span class="stepDesc"> <fmt:message key="retention" />
					</span>
				</a></li>
			</ul>

			<div id="step-1">
				<form class="form-horizontal">
					<div class="form-group">
						<label for="recordname" class="control-label col-sm-4"><fmt:message key="record.name" />:</label>
						<div class="col-sm-8">
							<input class="input_field_14em form-control input-sm" type="text" placeholder="<fmt:message key='record.input.name' />" name="recordname" id="recordname">
						</div>
					</div>
					<div class="form-group">
						<label for="recorddescription" class="control-label col-sm-4"><fmt:message key="record.description" />:</label>
						<div class="col-sm-8">
							<textarea cols="18" rows="3" class="input_field_12em form-control input-sm"
								name="recorddescription"
								placeholder="<fmt:message key='record.input.description' />"
								id="recorddescription"></textarea>
						</div>
					</div>
				</form>
			</div>
			<div id="step-2">
				<form class="form-horizontal">
					<div class="form-group">
						<label for="foldername" class="control-label col-sm-4"><fmt:message key="folder.name" />:</label>
						<div class="col-sm-8">
							<input class="input_field_14em form-control input-sm" type="text"
						placeholder="<fmt:message key='folder.input.name' />"
						name="foldername" id="foldername">
						</div>
					</div>
					<div class="form-group">
						<label for="folderpath" class="control-label col-sm-4"><fmt:message
							key="folder.path" />:</label>
						<div class="col-sm-8">
							<textarea cols="18" rows="3" class="input_field_12em form-control input-sm"
								name="folderpath"
								placeholder="<fmt:message key='folder.input.path' />"
								id="folderpath"></textarea>
						</div>
					</div>
				</form>
			</div>
			<div id="step-3">
				<form class="form-horizontal">
						<div class="form-group">
							<label for="propertytype" class="control-label col-sm-4"><fmt:message key="property.name" />:</label>
							<div class="col-sm-8">
								<select id="propertyList" class="form-control input-sm"></select>
							</div>
						</div>
						<div class="form-group">
							<label for="propertyvalue" class="control-label col-sm-4"><fmt:message
								key="property.value" />:</label>
							<div class="col-sm-8">
								<input class="input_field_14em form-control input-sm"
								type="text" name="propertyvalue"
								placeholder="<fmt:message key='property.input.value' />"
								id="propertyvalue">
							</div>
						</div>
						<div class="form-group">
							<div class="col-sm-8 col-sm-push-4">
								<button id="addPropertyButton" class="vw-btn vw-btn-primary btn-sm"
									type="button">
									<fmt:message key="Add" />
								</button>
							</div>
						</div>
						<hr class="vw-dark">
						<ul id="addPropertyList"></ul>
						<div class="form-group">
							<a href="#createPropertyTab" data-toggle="tab">
								<button id="createCustomProperty" class="vw-btn btn-link float-right pull-right"
									type="button">
									<fmt:message key="property.create" />
								</button>
							</a>
						</div>
				</form>
			</div>
			<div id="step-4">
				<form class="form-horizontal">
					<div class="form-group">
						<label for="retention" class="control-label col-sm-4"><fmt:message
								key="retention" />:</label>
						<div class="col-sm-8">
							<div class="row">
								<div class="col-lg-1 radio inline">
									<input type="radio" name="retentionVal" value="0" checked>
								</div>
								<div class="col-lg-10 radio inline">
									<fmt:message key="Forever" />
								</div>
							</div>
							<div class="row">
								<div class="col-lg-1 radio inline">
									<input type="radio" name="retentionVal" value="1">
								</div>
								<div class="col-lg-8">
									<input placeholder="<fmt:message key='retention.input' />"
										min=1 name="retention" id="retention" type="number">
								</div>
								<div class="col-lg-2 radio inline">
									<fmt:message key='Days' />
								</div>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
	<script nonce="${sessionScope.cspNonce}" src="js/wizardValidation.js"></script>
</fmt:bundle>