<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<link rel="stylesheet" type="text/css" href="../common/thirdParty/selectize/css/selectize.css"/>
<fmt:bundle basename="localization.recordsMessages">
	<span class="sectiontitle vw-page-title"><fmt:message key="Custom_Properties" /></span>
	<table id="propertiesTable"
		class="table table-condensed table-striped dt-responsive nowrap vw-data-table">
		<thead>
			<tr id="propertiesTableHeaderRow">
				<th class="col-name"
					data-title="<fmt:message key='tableColumn.name' />"><fmt:message
						key="tableColumn.name" /></th>
				<th class="col-description"
					data-title="<fmt:message key='tableColumn.description' />"><fmt:message
						key="tableColumn.description" /></th>
				<th class="col-datatype"
					data-title="<fmt:message key='tableColumn.datatype' />"><fmt:message
						key="tableColumn.datatype" /></th>
				<th class="col-defaultval"
					data-title="<fmt:message key='tableColumn.defaultval' />"><fmt:message
						key="tableColumn.defaultval" /></th>
				<th class="col-actions"
					data-title="<fmt:message key='tableColumn.actions' />"><fmt:message
						key="tableColumn.actions" /></th>
			</tr>
		</thead>
		<tbody id="recordTableBody">
		</tbody>
	</table>
	<div class="AddNewItem">
		<a id="addProperty"
			class="addNewItemA addRecord vw-btn vw-btn-secondary" href="#"
			data-toggle="modal" data-target="#addPropertyModal"> <span
			class="addWF"><img src="../summary/img/add_16px.png">&nbsp;<fmt:message
					key="property.add" /></span>
		</a>
	</div>
	<!-- Create Property Modal -->
	<div class="modal fade" id="addPropertyModal" tabindex="-1"
		role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="tabbable">

					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
						<h4 class="modal-title">
							<fmt:message key="property.create" />
						</h4>
					</div>
					<div class="modal-body">
						<jsp:include page="./addNewProperty.jsp" />
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Edit Property Modal -->
	<div class="modal fade" id="editPropertyModal" tabindex="-1"
		role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="tabbable">

					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
						<h4 class="modal-title">
							<fmt:message key="property.create" />
						</h4>
					</div>
					<div class="modal-body">
						<jsp:include page="./addNewProperty.jsp" />
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Modal -->
	<div class="modal fade" id="securityModal" tabindex="-1"
		role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
		<div class="modal-dialog" role="document">
			<div class="modal-content">
				<div class="tabbable">

					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal"
							aria-label="Close">
							<span aria-hidden="true">&times;</span>
						</button>
						<h4 class="modal-title">
							<fmt:message key="property.create" />
						</h4>
					</div>
					<div class="modal-body">
					<div class="form-horizontal">
						<div class="form-group">
							<div class="col-lg-12">
								<div class="share-body">
									<div class="invite-people">
										<div class="row">
											<div class="col-lg-12">
												<div class="divForSelectize"  id="divForSelectize">
													<input type="text" class="contacts" id="selectedUsers" data-load-type="callback" placeholder='<fmt:message key="SharePropertyPlaceholder"/>' tabindex="2"/>
												</div>
												<div class="invite-button">
													<button type="button" class="vw-btn" id="js-add-user">
														Add
													</button>
												</div>
											</div>
										</div>
											<div class="row">
												<div class="col-md-12 col-lg-12">
													<table
														class="table table-condensed table-striped dt-responsive nowrap vw-data-table dataTable no-footer dtr-inline"
														id="propertiesPermissionTable">

													</table>
												</div>
											</div>
										</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="vw-btn vw-btn-default"
						data-dismiss="modal">Cancel</button>
					<button type="button" class="vw-btn vw-btn-primary" id="updateSecurity"
						data-dismiss="modal">
						Update
					</button>
				</div>
				</div>
			</div>
		</div>
	</div>
	<!-- Modal -->
	<div id="deletePropModal" class="modal fade" role="dialog">
		<div class="modal-dialog">

			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title"><fmt:message key="DeleteProperties" /></h4>
				</div>
				<div class="modal-body">
					<h5 class="confirmDeleteMsg"></h5>
				</div>
				<div class="modal-footer">
					<button type="button" class="vw-btn vw-btn-default"
						data-dismiss="modal">Cancel</button>
					<button type="button" class="vw-btn btn-danger" id="deleteProperty"
						data-dismiss="modal">
						<fmt:message key="Delete" />
					</button>
				</div>
			</div>

		</div>
	</div>
	<script nonce="${sessionScope.cspNonce}" src="../customproperties/js/propertiesSummary.js" type="test/javascript"></script>
	<script nonce="${sessionScope.cspNonce}" src="../common/smartwizard/js/jquery.smartWizard.js"></script>
	<script nonce="${sessionScope.cspNonce}" src="../customproperties/js/wizardValidation.js"></script>
</fmt:bundle>
<jsp:include page="../common/cvUserSuggest.jsp">
	<jsp:param value="selectedUsers" name="fieldIdToSelectize"/>
	<jsp:param value="auto" name="selectizeHeight"/>
	<jsp:param value="100%" name="selectizeWidth"/>
	<jsp:param value="resetCache" name="callbackAfterAdd"/>
</jsp:include>