<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<fmt:bundle basename="localization.MyPhotosMessages">

    <fmt:message key="Label_Dialog_Title" var="labelDialogTitle"/>
    <fmt:message key="Yes_Button_Text" var="yesButtonText"/>
    <fmt:message key="No_Button_Text" var="noButtonText"/>
    <fmt:message key="Not_Valid_Name" var="notValidName"/>

    <div class="labelDiv vw-start-hidden">
            <div class="labelDialogDiv vw-form-horizontal">
                <div class="line form-group">
                    <label class="infoTitle col-sm-4 control-label" for="location"><fmt:message key="Labe_Person_Text" /></label>
                    <div class="col-sm-8">
                        <input type="text" id="location" class="form-control">
                    </div>
                </div>
                <div id="locationError" class="text-danger"></div>
            </div>
    </div>


<script nonce="${sessionScope.cspNonce}" >
    var labelDialogText = {};
    labelDialogText.okButtonText = '${yesButtonText}';
    labelDialogText.okButtonClass = 'labelOKButton';
    labelDialogText.noButtonText = '${noButtonText}';
    labelDialogText.title = '${labelDialogTitle}'
    labelDialogText.notValidName = '${notValidName}';

$("#location").keyup(function(e){
    if(e.keyCode == 13){
        $("." + labelDialogText.okButtonClass).click();
    }
});

</script>
</fmt:bundle>