var samlToken = '';
var targetUrl = '';
var fadeInTime = 600;
function OpenInNewTab(url) {
	var win = window.open(url, '_blank');
	win.focus();
}

function loadPage() {
	console.log('Loading SSO page');
	$('#targetUrlDiv').hide();
	$('#confirmTargetDiv textArea').hide();
	$('#targetUrlContentDiv').hide();
	$('#initiateSsoBtn').hide();
	$('#tokenDiv').hide();
	$('#confirmTargetDiv').hide();
	$('#genTokenText').hide();
}

function displaySamlToken(tokenContent) {
	console.log('SAML SSO token returned in response.');
	$('#statusStep1').html('<img src="img/tick.png">');

	$('#targetUrlContentDiv').fadeIn(fadeInTime);

	samlToken = tokenContent;
	$('#generateTokenBtn').fadeOut();
	$('#genTokenText').fadeIn(fadeInTime);
	$('#tokenDiv').html(samlToken);
	$('#tokenDiv').fadeIn(fadeInTime);
	$('#confirmTargetDiv').fadeIn(fadeInTime);
	$('#targetUrlPreivewText').hide();
}

function verifyTargetUrl(url) {
	var targetUrlContent = $.trim($('#webSsoTargetUrl').val());
	if (targetUrlContent == null || targetUrlContent == '') {
		$('#targetUrlDiv').html('<br/><span style="color:red;">Please enter a valid target URL</span>');
		$('#targetUrlDiv').fadeIn(fadeInTime);
		return false;
	}
	return true;
}

function showTargetUrl() {
	//Hide SAML token
	$('#tokenDiv').hide();
	$('#generateTokenDiv').hide();

	$('#statusStep2').html('<img src="img/tick.png">');
	var baseUrl = $.trim($('#webSsoTargetUrl').val());
	baseUrl = $('#protocolDD').val() + '://' + baseUrl + '/initWebSamlSSO.do?samlToken=';
	var urlEncodedParamString = encodeURIComponent(samlToken);
	targetUrl = baseUrl + urlEncodedParamString;
	console.log(targetUrl);
	$('#targetUrlDiv').hide();
	$('#targetUrlPreivewText').fadeIn(fadeInTime);
	$('#targetUrlDiv').html(targetUrl);
	$('#targetUrlDiv').fadeIn(fadeInTime);
	$('#initiateSsoBtn').fadeIn(fadeInTime);
	$('#dummyDiv').hide();
}

$(document).ready(function() {
	loadPage();

	$('#generateTokenBtn').click(function(e) {
		console.log('Generate SAML token initiated');

		//Sending Request to generate token
		cvUtil.loadPageWithGET(cvUtil.getContextPath() + '/generateSamlToken.do', null, function(data) {

			if (data != undefined) {
				var errCode = data.errorCode;
				console.log('ErrorCode : ' + data.errorCode);
				if (errCode == 0) {
					displaySamlToken(data.token);
				} else {
					console.log('Failed to get SAML token');
					var errorMessage = data.error;
					$('#tokenDiv').html('Failed to generate token. Error Message from Commcell <br/>' + errorMessage);
				}
			} else {
				console.log('No data received.Please check logs');
			}
		});
	});

	//Display the final URL for user to view before sending the request message.
	$('#confirmSsoUrlBtn').click(function(e) {
		console.log('Confirming Target URL');
		if (verifyTargetUrl() == true) {
			showTargetUrl();
		} else {
			console.log('Invalid Target URL.waiting for user to correct it.');
		}

	});

	//Invoke the final URL request to the peer webconsole
	$('#initiateSsoBtn').click(function(e) {

		$('#statusStep3').html('<img src="img/tick.png">');
		OpenInNewTab(targetUrl);
	});

});