var userPrefs = userPrefs || {};
userPrefs.MAX_FILESIZE = 10240;

//This mapping uses values from (commvault.msgs.web.DM2ContentIndexing) enum DM2ClientType
/*
 * var consoleNameMapping = {}; consoleNameMapping["Unknown"] = "Unknown";
 */
consoleNameMapping["WebClient"] = "Compliance Search Portal";
consoleNameMapping["iOS"] = "Commvault Edge for iOS";
consoleNameMapping["JavaGui"] = "Administrative CommCell Console";
consoleNameMapping["OutlookProvider"] = "Outlook Add-in";
consoleNameMapping["ThirdParty"] = "Web API";
consoleNameMapping["RSSSearch"] = "RSS Search";
consoleNameMapping["CVEdgeDriveAddin"] = "Edge Drive Desktop";
consoleNameMapping["Android"] = "Commvault Edge for Android";
consoleNameMapping["WindowsPhone"] = "Commvault Edge for Windows";
consoleNameMapping["CVExplorerPlugin"] = "Commvault Windows Explorer Plugin";
consoleNameMapping["CommandLine"] = "Commvault Command Line";
consoleNameMapping["JavaApplet"] = "CommCell Console Web Application";
consoleNameMapping["OutlookAddin"] = "Outlook Add-in";
consoleNameMapping["API"] = "API";
consoleNameMapping["LibraryServer"] = "Library Server";
consoleNameMapping["WorkFlow"] = "Commvault Workflow Engine";
consoleNameMapping["WebConsole"] = "Web Console";
consoleNameMapping["CDP"] = "CDP"; // confirm this application's full name
consoleNameMapping["AdminConsole"] = "Admin Console";
consoleNameMapping["SoftwareStore"] = "Software Store";

function getConsoleName(type) {
	if (type in consoleNameMapping) {
		return consoleNameMapping[type];
	} else if (type !== null && type !== "") {
		return type;
	} else {
		return consoleNameMapping["Unknown"];
	}
}

$(".prefList").on("click", function(e) {
	$(".change-logo-error").hide();
	var divUrl = $(e.target).attr("data-div");
	$(".rightDivs").hide();
	$("#" + divUrl).show();
	$(".prefList li").removeClass("vw-selected");
	$(e.target).addClass("vw-selected");
});

// keyboard support across the board. on "space", the checkbox should be toggled
$("ul.prefList li").on("keydown", function(e) {
	if (e.which == 13) { // enter or space will trigger
		$(this).trigger('click');
		e.stopPropagation();
	}
});

/*
 * Code to get account activity.
 */
function getAccountActivityData() {
	$("#recentActivityDiv .activeSessionsHolder").mask("");
	$("#recentActivityDiv .sessionHistoryHolder").mask("");

	cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/getLoggedInSessions.do", null, function(data) {
		// got data
		var data = preprocessSessionsData(data);
		var template = $("#activeSessionsListTemplate").html();
		var html = Mustache.render(template, data);
		$("#activeSessionsList").html(html);

		if ($("#activeSessionsList .activityList .logoutActionJs").length > 0) {
			$("#closeSessions").show();
		}
		$("#recentActivityDiv .activeSessionsHolder").unmask("");
	});

	cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/getSessionHistory.do", null, function(data) {
		// got data
		var data = preprocessSessionsData(data);
		var template = $("#sessionHistoryListTemplate").html();
		var html = Mustache.render(template, data);

		$("#sessionHistoryList").html(html);
		$("#recentActivityDiv .sessionHistoryHolder").unmask("");
	});

}

function preprocessSessionsData(data) {
	var pData = {};
	pData.sessions = data;

	// localization
	pData.activeDevicesMsg = localMsg.activeDevicesMsg;
	pData.deviceType = localMsg.deviceType;
	pData.location = localMsg.location;
	pData.locationContent = localMsg.location;
	pData.loginTimeLabel = localMsg.loginTime;
	pData.logoutTimeLabel = localMsg.logoutTime;
	pData.lastAccessTime = localMsg.lastAccessTime;
	pData.endSession = localMsg.endSession;
	pData.currentDevice = localMsg.currentDevice;

	for (i = 0; i < pData.sessions.length; i++) {
		if (pData.sessions[i].logoutTime == 0) {
			// active sessions
			if (pData.sessions[i].lastAccessedTime == 0) {
				pData.sessions[i].lastAccessedTimeString = localMsg.activeGui;
				pData.sessions[i].lastAccessedTime = localMsg.activeGui;
			} else {
				// making sure difference is not negative
				var now = (new Date().getTime()) / 1000;
				if (pData.sessions[i].lastAccessedTime > now) {
					pData.sessions[i].lastAccessedTime = now;
				}
				pData.sessions[i].lastAccessedTimeString = cvUtil
						.createAgeString(pData.sessions[i].lastAccessedTime * 1000, cvUtil.localizeAgeForNotification);
				pData.sessions[i].lastAccessedTime = getDateString(pData.sessions[i].lastAccessedTime);
			}
		} else {
			// session history
			pData.sessions[i].logoutTime = getDateString(pData.sessions[i].logoutTime);
		}

		pData.sessions[i].loginTime = getDateString(pData.sessions[i].loginTime);

		// commenting hostTitle here to hide deviceID of mobile clients
		//		pData.sessions[i].hostTitle = pData.sessions[i].host;
		// set location if available
		if (pData.sessions[i].location !== "") {
			pData.sessions[i].hostTitle = pData.sessions[i].location;
			pData.sessions[i].host = pData.sessions[i].location;
		}

		//convert consoleType to console names for UI
		pData.sessions[i].consoleName = getConsoleName(pData.sessions[i].consoleType);

		// disable GUI logout option
		if (!(pData.sessions[i].isCurrentSession || pData.sessions[i].consoleType === "JavaGui")) {
			pData.sessions[i].canLogout = true;
		}
		if (pData.sessions[i].consoleType === "JavaGui") {
			pData.sessions[i].isJavaGui = true;
			pData.hasJavaGui = true;
		}
	}
	return pData;
}

function getDateString(timestamp) {
	var date = new Date(timestamp * 1000);
	if (date.getFullYear() == new Date().getFullYear()) {
		return $.datepicker.formatDate("d M, ", date) + date.toLocaleTimeString();
	} else {
		return $.datepicker.formatDate("d M yy, ", date) + date.toLocaleTimeString();
	}
}

function closeAllSessions() {
	cvUtil.loadPage("logoutOtherSessions.do", null, function(res) {
		if (res === "success") {
			$("#activeSessionsList .activityList .li5").each(function() {
				if (this.getAttribute("data-id")) {
					$(this).parents("ul").remove();
				}
			});
		} else {
			cvUtil.errorToast(res);
		}
	});
	$("#closeSessions").hide();
}

function closeSession(event) {
	var paramStr = cvUtil.createParamString("sessionId", event.currentTarget.parentElement.getAttribute("data-id"));
	cvUtil.loadPage("logoutOtherSessions.do", paramStr, function(res) {
		if (res === "success") {
			$(event.currentTarget).parents("ul").remove();
			// check if we need to hide close all button
			if ($("#activeSessionsList .activityList .logoutActionJs").length == 0) {
				$("#closeSessions").hide();
			}
		} else {
			cvUtil.errorToast(res);
		}
	});
}

/*
 * End Code to get account activity.
 */

$(document)
		.ready(function() {
			$("#pwdChangeDone").hide();
			$("#printPrefChangeDone").hide();
			$("#generalDiv").hide();
			if ($(".prefList li").length == 0) {
				$("#leftCols").hide();
				$("#rightCols").hide();
				$("#noCols").show();
			} else {
				$($(".prefList li")[0]).trigger("click");
			}

			$("#changePasswordDiv .textbox").on("keyup", function(evt) {
				if (evt.keyCode == 13) {
					$("#registerBtn").trigger("click");
				}
			});

			$("#oldpassword").trigger("focus");

			/*
			 * Code to get add account activity listener
			 */
			getAccountActivityData();
			$("#recentActivityDiv").on("click", "#closeSessions", closeAllSessions);
			$("#recentActivityDiv").on("click", "#activeSessionsList .logoutActionJs", closeSession);

			/* account activity code end */

			/*
			 * ALERTS JAVASCRIPT HANDLING: Code to handle Alerts in Client Details Page
			 */
			if (typeof isManageAlertsSetForAllClients !== null && isManageAlertsSetForAllClients === "true") {
				var alertsSubArr = new Array();
				$(".alertsOverflowDiv").hide();
				cvUtil
						.loadPage("loadAlerts.do",
								null,
								function(alertsData) {

									console.log("Alert data received " + alertsData);
									obj = JSON.parse(alertsData);
									var allArrays = obj.JSONArray;

									$("#alertsLoader").hide();
									$(".alertsOverflowDiv").show();
									$("#clientAlertsSubs").empty();
									if (allArrays.length > 0) {

										for (var i = 0; i < allArrays.length; i++) {
											var name = allArrays[i].Name;
											var subscribed = allArrays[i].Subscribed;
											var html;

											if (i % 2 == 0) {
												html = '<li class="infodesc enableSave oddClass vw-custom-checkbox-row">';
											} else {
												html = '<li class="infodesc enableSave vw-custom-checkbox-row">';
											}

											alertsSubArr[i] = name;
											if (subscribed == true) {
												html += '<div class="custom-cb checked vw-custom-checkbox" data-state="checked" name="' +
														name.replace(/[\s/]/g, '-_') +
														'Name" id="' +
														name.replace(/[\s/]/g, '-_') +
														'" class="enableSave" data-value=1 aria-checked="true" tabindex="0" role="checkbox" aria-labelledby="' +
														name.replace(/[\s/]/g, '-_') + '-label"></div>';
											} else {
												html += '<div class="custom-cb unchecked vw-custom-checkbox" data-state="unchecked" name="' +
														name.replace(/[\s/]/g, '-_') +
														'Name" id="' +
														name.replace(/[\s/]/g, '-_') +
														'" class="enableSave" data-value=0 aria-checked="false" tabindex="0" role="checkbox" aria-labelledby="' +
														name.replace(/[\s/]/g, '-_') + '-label"></div>';
											}

											html += '<span class="custom-cb-label" id="' +
													name.replace(/[\s/]/g, '-_') + '-label">' + name + '</span></li>';

											$("#clientAlertsSubs").append(html);
										}

									}
								},
								function(evt1) {
									$("#alertsLoader").hide();
								});

				$("body").on("checkedState", function(e) {
					$("#alertsBtn").trigger("click");
				});
				$("body").on("unCheckedState", function(e) {
					$("#alertsBtn").trigger("click");
				});

				$("#alertsBtn").on("click", function() {

					var sendContents = new Array();
					var count1 = 0;

					var isOverride = 0;

					var newDiv = $(document.createElement('div'));
					newDiv.html(overrideLocalAlerts);
					newDiv.dialog({
						resizable : false,
						modal : true,
						title : overrideAlerts,
						width : 350,
						height : 125,
						buttons : {

							noLocalized : {
								text : dialogNo,
								"class" : "buttonContents dialogCancel vw-btn vw-btn-default",
								click : function() {
									newDiv.dialog('close').remove();
									isOverride = 0;
									addAlerts(sendContents, count1, isOverride);
								},
							},
							yesLocalized : {
								text : dialogYes,
								"class" : "buttonContents okSaveClick vw-btn vw-btn-primary",
								click : function() {
									newDiv.dialog('close').remove();
									isOverride = 1;
									addAlerts(sendContents, count1, isOverride);
								},
							}
						}
					});

				});

				function addAlerts(sendContents, count1, isOverride) {
					for (var i = 0; i < alertsSubArr.length; i++) {
						var name = alertsSubArr[i].replace(/[\s/]/g, '-_');
						if ($("#" + name).hasClass("checked")) {
							sendContents[count1] = name;
							count1++;
						}
					}
					arrayAsAString = sendContents.join(";");
					var contentsFinal = "isOverride=" + isOverride + "&alertsList=" + arrayAsAString;
					$(".alertsBtn a#saveButton").addClass('disabledActions disabled');

					cvUtil.loadPage(cvUtil.getContextPath() + '/server/setAlerts.do', contentsFinal, function(data) {
					}, function(data) {
						alert("Add Content failed: " + data);
					});

				}
			}
			/*
			 * END ALERTS JAVASCRIPT HANDLING: Code to handle Alerts in User Prefs Page
			 */

			/*
			 * CHANGE PASSWORD CODE: Code to handle Change Password
			 */
			function matchPwds() {
				var pwd = $("#newPassword").val();
				var confPwd = $("#confirmNewPassword").val();

				if (pwd != confPwd) {
					$("label.error[for=confirmNewPassword]").html($("#confirmNewPassword").data("msg"));
					return false;
				}
				return true;
			}

			function setErrorState(fId) {
				//$(fId).addClass("error");
			}

			function checkValidity() {
				validateAllFields();
				var valid = true;
				$("#loginform .textbox").each(function(e) {
					var txId = $(this).attr("id");
					if ((txId == "oldPassword" || txId == "newPassword" || txId == "confirmNewPassword")) {
						if ($(this).val() == "") {
							valid = false;
						}
					}
				});

				$("label.error").each(function(e) {
					if ($(this).html() != "") {
						valid = false;
					}
				});

				console.debug("Form is valid: " + valid);
				return valid;
			}

			$(".subChangePasswordDiv input[type=password]").on("blur", function(evt) {
				if ($.trim($(this).val()) !== "") {
					$(this).siblings(".control-label").addClass("filled");
				} else {
					$(this).siblings(".control-label").removeClass("filled");
				}
			})

			$("#changePasswordDiv .textbox").on("focusin", function(evt) {

				$("#changePwdBtn").removeClass("disabledActions disabled");
				tx = $(this);
				tx.removeClass("error");
				var txId = tx.attr("id");
				var errMsgLbl = $("label.error[for=" + txId + "]");
				if (errMsgLbl.length > 0) {
					errMsgLbl.html("");
				}
			});

			function validateField(tx) {
				var re = new RegExp(tx.data("validation"));
				var val = tx.val();
				var txId = tx.attr("id");
				var errMsgLbl = $("label.error[for=" + txId + "]");
				var fn = tx.data("validationfn");
				if (fn != null) {
					errMsgLbl.html("");
					eval(fn);
					return;
				}
				if (re.test(val) == false) {
					errMsgLbl.html(tx.data("msg"));
				} else {
					errMsgLbl.html("");
				}
			}

			function validateAllFields() {
				$("#changePasswordDiv .textbox").each(function(x) {
					tx = $(this);
					validateField(tx);
				});
			}

			$("#changePasswordDiv .textbox").on("focusout", function(evt) {
				tx = $(this);
				validateField(tx);
			});

			$("#changePwdBtn").on("click", function(event) {
				$(".changePwdMsg").html("&nbsp;");
				if (!checkValidity()) {
					//			return;
				}
				var dataIsValid = true;
				var missingFields = false;
				$("#changePwdBtn").attr('disabled', true).addClass("loading");

				/*
				 * if( $.trim($("#oldPassword").val()).length <= 0 ) { setErrorState("#oldPassword");
				 * missingFields = true; }
				 */
				/*
				 * if( $.trim($("#newPassword").val()).length <= 0 ) { setErrorState("#newPassword");
				 * missingFields = true; } if( $.trim($("#confirmNewPassword").val()).length <= 0 ) {
				 * setErrorState("#confirmNewPassword"); missingFields = true; }
				 */

				if (missingFields) {
					$(".changePwdMsg").html('<span class="sprite icon-x"></span> ' + Register_fields_mandatory);
					dataIsValid = false;
				}

				passwordContainsSpaces = false;
				//Password cannot contain space
				/*
				 * if( ($("#oldPassword").val()).indexOf(' ') >= 0 ) { setErrorState("#oldPassword");
				 * passwordContainsSpaces = true; }
				 */
				if (($("#newPassword").val()).indexOf(' ') >= 0) {
					setErrorState("#newPassword");
					passwordContainsSpaces = true;
				}
				if (($("#confirmNewPassword").val()).indexOf(' ') >= 0) {
					setErrorState("#confirmNewPassword");
					passwordContainsSpaces = true;
				}
				if (passwordContainsSpaces) {
					$(".changePwdMsg").html('<span class="sprite icon-x"></span> ' + Register_password_spaces);
					$("#oldPassword").val("");
					$("#newPassword").val("");
					$("#confirmNewPassword").val("");
					$("#oldPassword").trigger("focus");
					setErrorState("#confirmNewPassword");
					setErrorState("#newPassword");
					setErrorState("#oldPassword");
					dataIsValid = false;
				}

				//Password & confirm password fields should be same
				if (($.trim($("#newPassword").val()) != $.trim($("#confirmNewPassword").val())) && (!missingFields)) {
					$(".changePwdMsg").html('<span class="sprite icon-x"></span> ' + Register_Password_error);
					$("#newPassword").val("");
					$("#confirmNewPassword").val("");
					$("#newPassword").trigger("focus");
					setErrorState("#confirmNewPassword");
					setErrorState("#newPassword");
					dataIsValid = false;
				}

				var uname = $(".pglinks").find("li")[0].innerHTML;
				if (dataIsValid) {
					$(document).ajaxStart(function() {
						$("#changePwdAjaxBusy").show();
					}).ajaxStop(function() {
						$("#changePwdAjaxBusy").hide();
					});
					cvUtil.loadPage(cvUtil.getContextPath() + '/changePassword.do', {
						username : $.trim(uname),
						oldPassword : Base64.encode($.trim($("#oldPassword").val())),
						newPassword : Base64.encode($.trim($("#newPassword").val())),
						isLogoutAllSessions : $("#isLogoutAllSessions").prop('checked')
					}, function(data) {
						if (data == "") {
							$("#pwdChangeDone").show();
							window.setTimeout(function() {
								window.location.href = cvUtil.getContextPath() + '/doLogout.do?serverLogout=false';
							}, 5000);
						} else {
							$("#oldPassword").trigger("focus");
							$(".changePwdMsg").html('<span class="sprite icon-x"></span> ' + data);
						}
						$("#changePwdBtn").attr('disabled', false).removeClass("loading");
						$("#oldPassword").val("");
						$("#newPassword").val("");
						$("#confirmNewPassword").val("");
						$("#changePwdBtn").addClass("disabledActions disabled");
					});
				} else {
					$("#changePwdBtn").attr('disabled', false).removeClass("loading");
				}
			});

			/*
			 * END CHANGE PASSWORD CODE: Code to handle Change Password
			 */
			//initSettings(); settings.js has been removed in 11.0!!
			$("#changePwdBtn").addClass("disabledActions disabled");

			/*
			 * WEB PRINTING CODE: Code to handle Change Web Printing Preference
			 */
			if (webPrintEnabled == "true") {
				var oWebPrint = new WebPrint();
				oWebPrint.initComponents(true, true);
				oWebPrint.getPrintPrefsForUser(null, function(callBack) {
					//do something.
					populatePrintDialogVals(callBack);
				});
				$("#changePrintPrefBtn").on("click", function(event) {
					$("#printPrefChangeDone").hide();
					$(this).addClass("loading");
					$(".hint").hide();
					var self = this;
					oWebPrint.getWebPrintConfigData(true, function(formData) {
						if (!formData.isValidated) {
							var hintFieldId = "#hint_" + formData.hintField;
							$(hintFieldId).show();
							$(self).removeClass("loading");
						} else {
							oWebPrint.savePrintPrefsForUser(formData, function(callBack) {
								$(self).removeClass("loading");
								$("#printPrefChangeDone").show();
							});
						}
					});
					//options.macMachineName=$.trim($("#macMachineName").val());

				});
			}

			$("#customizeAction").on("click", function() {
				userPrefs.doCustomize();
			});

			$("#attachment").on("change", function() {
				$(".change-logo-error").hide();
				userPrefs.setImageData(this.files[0], function(e) {
					$(".change-logo").text(e.target.filename);
					$("#current-logo img").attr("src", e.target.result);
					userPrefs.imageData = e.target.result.split(/[/](.+)?/, 2)[1]; // accessing the img data after "data:image/"
					$("#customizeAction").removeClass("disabled");
				}, function() {
					$(".change-logo-error").show();
					$("#customizeAction").addClass("disabled");
				});

			});

		});

userPrefs.doCustomize = function() {
	$("#customizeAction").addClass("loading");
	var data = {
		'theme' : JSON.stringify({
			"customLogo" : userPrefs.imageData,
		})
	};
	cvUtil.loadPageWithPOST('theme.do', data, function(res) {
		$("#pglogo").attr("src", "data:image/" + userPrefs.imageData);
		$("#customizeAction").addClass("disabled");
		$("#customizeAction").removeClass("loading");
	}, function(err) {
		cvUtil.errorToast($.trim(err.responseText), null, null, true);
		$("#customizeAction").removeClass("loading");
	});

};

userPrefs.setImageData = function(file, fnCallback, errorFn) {
	var reader = new FileReader();
	reader.onload = fnCallback;
	if (file.name.toLowerCase().match(/\.gif$/) === null && file.name.toLowerCase().match(/\.png$/) === null &&
			file.name.toLowerCase().match(/\.jpg$/) === null) {
		errorFn();
		return;
	}
	if (file.size > userPrefs.MAX_FILESIZE) {
		errorFn();
		return;
	}

	reader.readAsDataURL(file);
};
