<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>

<jsp:include page="../common/headerV3.jsp">
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/css/webprinting.css" name="css"/>
	<jsp:param value="../common/css/custom-cb.css" name="css" />
	<jsp:param value="../common/css/ui.spinner.css" name="css"/>
	<jsp:param value="../common/css/jquery.loadmask.css" name="css"/>
	<jsp:param value="user.preferences" name="title" />
</jsp:include>

	<fmt:message key="Register_Password_error" var="Register_Password_error"/>
	<fmt:message key="Register_fields_mandatory" var="Register_fields_mandatory"/>
	<fmt:message key="Register_password_spaces" var="Register_password_spaces"/>
<fmt:bundle basename="localization.ClientDetailsMessages">

	<fmt:message key="clientDetails.label.dataProtection" var="dataProtectionTitle" />
	<fmt:message key="clientDetails.label.dataRecovery" var="dataRecoveryTitle" />

	<fmt:bundle basename="localization.UserPrefMessages">

	<fmt:message key="userPrefs.dialog.yes" var="dialogYes"/>
	<fmt:message key="userPrefs.dialog.no" var="dialogNo"/>
	<fmt:message key="userPrefs.dialog.overrideLocalAlerts" var="overrideLocalAlerts"/>
	<fmt:message key="userPrefs.dialog.overrideAlerts" var="overrideAlerts"/>
	<fmt:message key="userPrefs.label.webprint" var="webPrintPrefs"/>
	<fmt:message key="userPrefs.label.savedSuccessfully" var="prefSavedSuccessfully"/>

	<fmt:message key="userPrefs.label.activeDevicesMsg" var="activeDevicesMsg"/>
	<fmt:message key="userPrefs.label.deviceType" var="deviceType"/>
	<fmt:message key="userPrefs.label.location" var="location"/>
	<fmt:message key="userPrefs.label.loginTime" var="loginTime"/>
	<fmt:message key="userPrefs.label.logoutTime" var="logoutTime"/>
	<fmt:message key="userPrefs.label.lastAccessTime" var="lastAccessTime"/>
	<fmt:message key="userPrefs.label.endSession" var="endSession"/>
	<fmt:message key="userPrefs.label.activeGui" var="activeGui"/>
	<fmt:message key="userPrefs.label.currentDevice" var="currentDevice"/>

	<fmt:message key="userPrefs.consoleNameMapping.Unknown" var="Unknown"/>

	<c:set var="webPrintEnabled" value="${sessionScope.webprintEnabled}"/>
	<div class="sechead dynamicDropDown row">
	 <span class="sectiontitle vw-page-title vw-page-title_standalone col-sm-12"><fmt:message key="userPref.title.userPreferences" /></span>
	</div>
	<div class="row vw-user-preferences">
		<div id="noCols" class="col-sm-12 vw-start-hidden">
			<fmt:message key="userPrefs.label.noUserPreferencesFound" />
		</div>
		<div id="leftCols" class="col-sm-2 vw-left-column">
			<div class="listOptions vw-vertical-tabs-container">
				<ul class="prefList vw-vertical-tabs" role="navigation">
					<c:if test="${(applicationScope.disableUserPasswordManagement == false) && ((sessionScope.USER_DOMAIN == null || sessionScope.USER_DOMAIN == '')
					|| sessionScope.IS_ORGANIZATION_USER == \"true\")}">
						<li data-div="changePasswordDiv" tabindex="0"><fmt:message key="userPref.tabs.changePassword" />${client.clientName}</li>
					</c:if>
					<c:if test="${requestScope.isManageAlertsSetForAllClients}">
						<li data-div="generalDiv" tabindex="0"><fmt:message key="userPrefs.label.alerts"/></li>
					</c:if>
					<!-- <li data-div="changePasswordDiv">Sync Settings</li> -->
				<cv:ifCapability name="any runReports">
					<cv:secureTag name="Reports" id="4">
						<li id="reportSettingsLink" data-div="reportSettings" tabindex="0">Report Settings</li>
					</cv:secureTag>
				</cv:ifCapability>
					<c:choose>
						<c:when test="${webPrintEnabled eq 'true'}">
							<li data-div="webPrintingDiv" tabindex="0"><fmt:message
									key="userPrefs.label.webprint" /></li>
						</c:when>
					</c:choose>

					<c:if test="${requestScope.CAN_USER_CUSTOMIZE}">
						<li data-div="logo-cust-div" tabindex="0"><fmt:message key="userPrefs.label.customization" /></li>
					</c:if>
						<li data-div="recentActivityDiv" tabindex="0"><fmt:message key="userPrefs.label.recentActivity"/></li>
					</ul>
			</div>
		</div>

		<c:set var="hideLocationPref" value="${cv:getConfigPropertyForKey('hideLocationPref')}"/>
	    <c:if test="${hideLocationPref == 'true'}">
	    	<c:set var="hideLocationClass" value="hideLocation" />
	    </c:if>
		<div id="rightCols" class="col-sm-10 vw-right-column">
			<div class="filledItems vw-column-contents">
				<div id="recentActivityDiv" class="rightDivs">
					<p class="recentActivityTitle vw-data-table_title clearfix"><fmt:message key="userPrefs.label.activeDevices" /><input type="button" id="closeSessions" name="closeSessions" value='<fmt:message key="userPrefs.label.endAllSessions"/>' class="vw-start-hidden vw-btn vw-btn-default pull-right" /></p>
					<div class="activeSessionsHolder vw-list-container">
						<div id="activeSessionsList" class="vw-active-devices-list ${hideLocationClass}"></div>
					</div>
					<p class="recentActivityTitle vw-data-table_title"><fmt:message key="userPrefs.label.loginHistory" /></p>
					<p class="recentActivitySubText vw-subtext"><fmt:message key="userPrefs.label.loginHistoryMsg" /></p>
					<div class="sessionHistoryHolder vw-list-container">
						<div id="sessionHistoryList" class="vw-login-history-list ${hideLocationClass}"></div>
					</div>
				</div>

				<c:if test="${(applicationScope.disableUserPasswordManagement == false) && ((sessionScope.USER_DOMAIN == null || sessionScope.USER_DOMAIN == '')
				|| sessionScope.IS_ORGANIZATION_USER == \"true\")}">
				<div id="changePasswordDiv" class="rightDivs vw-start-hidden">
					<p class="changePasswordTitle vw-page-title"><fmt:message key="userPref.tabs.changePassword" /></p>
					<c:if test="${(applicationScope.ssoUserPasswordManagement == true) && ((sessionScope.USER_DOMAIN == null || sessionScope.USER_DOMAIN == '')
				|| sessionScope.IS_ORGANIZATION_USER == \"true\")}">
						<form method="GET" action="/server/changePassword" class="row">
							<div class="col-sm-6">
								<div class="displayDiv">
									<div class="vw-message alert vw-alert-info">
									<div class="vw-message alert vw-alert-info"><fmt:message key="userPrefs.label.clickToChange">
										<fmt:param value="${(applicationScope.ssoUserPasswordRedirectUrl)}${sessionScope.LOGIN_ID}&returnUrl=https://cloud.commvault.com"/>
										</fmt:message>
									</div>
								</div>
							</div>
						</form>
					</c:if>
					<c:if test="${(applicationScope.ssoUserPasswordManagement == false)}">
						<form method="GET" action="/server/changePassword" class="row">
							<div class="col-sm-6">
								<div class="displayDiv">
									<div class="changePwdMsg">&nbsp;</div>
							   		<div class="subChangePasswordDiv">
								   		<div class="form-group">
											<input type="password" id="oldPassword" name="oldPassword" class="textbox form-control" autocomplete="off"  />
											<label class="label control-label" id="labelOldPassword" for="oldPassword"><fmt:message key="userPref.label.oldPassword" /></label>
											<label class="error error1 alert vw-alert-danger hidden" for="oldPassword">&nbsp;</label>
								   		</div>
										<div class="form-group">
											<input type="password" id="newPassword" name="newPassword" autocomplete="off" class="textbox form-control"  />
											<label class="label control-label" id="labelNewPassword" for="newPassword"><fmt:message key="userPref.label.newPassword" /></label>
											<label class="error alert vw-alert-danger hidden" for="newPassword">&nbsp;</label>
								   		</div>
										<div class="form-group">
											<input type="password" id="confirmNewPassword" name="confirmNewPassword" autocomplete="off" class="textbox form-control" data-msg="${Register_Password_error}" data-validationfn="matchPwds()"  />
											<label class="label control-label" id="labelConfirmNewPassword" for="confirmNewPassword"><fmt:message key="userPref.label.reenterNewPassword" /></label>
											<label class="error alert vw-alert-danger hidden" for="confirmNewPassword">&nbsp;</label>
								   		</div>
										<div class="form-group">
											<input type="checkbox" id="isLogoutAllSessions" class="check" checked="checked" />
											<label class="label" for="isLogoutAllSessions"><fmt:message key="userPrefs.label.logoutAllActiveSessions" /></label>
								   		</div>
									</div>
								</div>

									<fmt:message key="userPref.label.passwordHasBeenSuccessfullyUpdated" var="pwdSaved"/>
									<fmt:bundle basename="localization.messages">
										<fmt:message key="common.action.save" var="save"/>
										<div class="btnsBottom vw-loading-spinner vw-spinner-button">
											<input type="button" id="changePwdBtn" class="mainBtn vw-btn vw-btn-primary" name="submit" value='${save}' />
											 <div class="vw-loading-comp-white"></div>
										</div>
										<div id="pwdChangeDone" class="vw-message alert alert-info">${pwdSaved}</div>
									</fmt:bundle>
							</div>
						</form>
						</c:if>
				</div>
				</c:if>

				<div id="generalDiv" class="rightDivs">

					<p class="generalDivTitle vw-page-title"><fmt:message key="userPrefs.label.alerts"/></p>
					<form method="GET" action="/server/register" >
						<div class="displayDiv">
							<div class="changeGeneralPrefs">&nbsp;</div>
							<div id="alertsDiv" class="subGeneralDiv">
								<p class="subGeneralTitle vw-underline"><fmt:message key="userPref.label.manageAlertsForAllClients" /></p>

								<div id="alertsLoader">
									<svg xmlns="http://www.w3.org/2000/svg" width="23px" height="23px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="vw-loader"><g transform="translate(50 50)"><g transform="rotate(0) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.44167 1.44167)"><animate attributeName="opacity" from="1" to="0.1" begin="0s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(45) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.00167 1.00167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.12s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.12s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(90) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.06667 1.06667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.25s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.25s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(135) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.12667 1.12667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.37s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.37s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(180) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.19167 1.19167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.5s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.5s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(225) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.25167 1.25167)"><animate attributeName="opacity" from="1" to="0.1" begin="0.62s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.62s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(270) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.31667 1.31667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.75s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.75s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g><g transform="rotate(315) translate(34 0)"><circle cx="0" cy="0" r="8" transform="scale(1.37667 1.37667)"><animate attributeName="opacity" from="1" to="0.1" begin="0.87s" dur="1s" repeatCount="indefinite"></animate><animateTransform attributeName="transform" type="scale" from="1.5" to="1" begin="0.87s" dur="1s" repeatCount="indefinite"></animateTransform></circle></g></g></svg>
									&nbsp;<fmt:message key="userPrefs.label.loadingAlerts" />
								</div>

								<div class="alertsOverflowDiv">
									<ul class="blockrows subscribedAlerts fixedWidth" id="clientAlertsSubs" >
									</ul>
								</div>
							</div>
						</div>

						<fmt:bundle basename="localization.messages">
							<fmt:message key="common.action.save" var="save"/>


							<div class="btnsBottom">
							<input type="button" id="alertsBtn" class="mainBtn vw-btn vw-btn-primary vw-start-hidden" name="submit" value='${save}' />
							</div>
						</fmt:bundle>
		 			</form>
				</div>

		<cv:ifCapability name="any runReports">
			<cv:secureTag name="Reports" id="4">
					<div id="reportSettings" class="rightDivs vw-start-hidden">
					<p class="generalDivTitle vw-page-title">Reports Settings</p>
					<div class="dummy"></div>
					<div id="contactArea" class="vw-reports-settings row">
						<div class="col-sm-6">
							<div id="datePref" class="form-group">
								<label class="option-title control-label" for="UserDateFormatGroup">User Date Format</label>
								<div class="radio">
									<label>
										<input type='radio' value='MonthDay' name='UserDateFormatGroup' id='setUserDateFormat1'>
										mm/dd (e.g. 12/31)
									</label>
								</div>
								<div class="radio">
									<label>
										<input type='radio' value='DayMonth' name='UserDateFormatGroup' id='setUserDateFormat2'>
										dd/mm (e.g. 31/12)
									</label>
								</div>
								<div class="radio">
									<label>
										<input type='radio' value='LocalDependent' name='UserDateFormatGroup' id='setUserDateFormat3'>
										Login Local Dependent
									</label>
								</div>
							</div>
							<div id="rowPref" class="form-group">
								<label class="option-title control-label">Rows per Page</label>
								<input type="text" id="rowsPerPage" value="0" class="form-control" />
							</div>
							<div class="form-inline">
								<div id="costPref" class="form-group">
						            <label class="option-title control-label">Cost</label>
						            <input type="text" id="costPerSizeUnit" value="0" class="form-control" />
						            <p class="form-control-static">per</p>
						            <select id="sizeUnit" class="form-control">
										<option value="BYTES">BYTES</option>
										<option value="KB">KB</option>
										<option value="MB">MB</option>
										<option value="GB">GB</option>
										<option value="TB">TB</option>
										<option value="PB">PB</option>
									</select>
								</div>
							</div>
							<div class="vw-custom-checkbox-row form-group">
								<div id="saveOnExit" class="custom-cb vw-custom-checkbox unchecked" data-state="unchecked" aria-checked="false" tabindex="0" role="checkbox" aria-labelledby="save-report-preferences-label"></div>
								<span class="custom-cb-label" id="save-report-preferences-label">Save report preferences when navigating away from the page</span>
							</div>
							<div>
					            <input type="button" id="btnSaveChanges" class="mainBtn vw-btn vw-btn-primary" name="submit" value='Save' />
					            <input type="button" id="btnReset" class="mainBtn otherBtns vw-btn vw-btn-default" name="submit" value='Reset' />
							</div>
						</div>
					</div>
			</cv:secureTag>
		</cv:ifCapability>

			 <!-- include web printing preferences -->
		 <c:choose>
			<c:when	test="${webPrintEnabled eq 'true'}">
					 <div id="webPrintingDiv" class="rightDivs vw-printing-settings">
						<p class="webPrintingTitle vw-page-title">${webPrintPrefs}</p>
						<div id="webprintingContent" class="vw-printing-container">
							<jsp:include page="../common/webprinting.jsp"></jsp:include>
						</div>
						<div class="btnsBottom">
							<input type="button" id="changePrintPrefBtn" class="mainBtn vw-btn vw-btn-primary"
								name="submit" value="Save"> <label id="printPrefChangeDone"> ${prefSavedSuccessfully}</label>

						</div>
					</div>
			</c:when>
		</c:choose>

			<c:if test="${requestScope.CAN_USER_CUSTOMIZE}">
				<div id="logo-cust-div" class="rightDivs vw-start-hidden">
					<p class="generalDivTitle vw-page-title"><fmt:message key="userPrefs.title.customizeLogo" /></p>
						<form class="row">
							<div class="col-sm-6">
								<div class="displayDiv">
									<div>
										<div id="current-logo" class="vw-current-logo">
											<img src="${sessionScope.customTheme}" alt="Current logo">
										</div>
										<div class="change-logo-div vw-change-logo-container"><a class="change-logo vw-change-logo-link"><fmt:message key="userPrefs.label.selectFile" /><input type="file" id="attachment"></a></div>
									</div>
									<div class="change-logo-error vw-message alert alert-danger vw-start-hidden"><fmt:message key="userPrefs.error.logo" /></div>
									<div class="logo-spec vw-logo-requirements">
										<span class="logo-spec-header vw-underline"><fmt:message key="userPrefs.label.logoSpecifications" /></span>
										<ul>
											<li><fmt:message key="userPrefs.label.spec1" /></li>
											<li><fmt:message key="userPrefs.label.spec2" /></li>
											<li><fmt:message key="userPrefs.label.spec3" /></li>
										</ul>
									</div>
								</div>
								<fmt:bundle basename="localization.messages">
									<div class="btnsBottom">
										<input type="button" id="customizeAction" class="mainBtn vw-btn vw-btn-primary disabled" name="submit" value='Upload' />
									</div>
								</fmt:bundle>
							</div>
						</form>
					</div>
				</c:if>
			</div>
		</div><!--  END #rightCols -->
		</div><!--  END .row -->
	</fmt:bundle>
</fmt:bundle>

<script type="text/template" id="activeSessionsListTemplate">
	<div class="listHolder activeSessions vw-data-table clearfix">
		<ul class="activityListHead vw-data-row vw-heading-row clearfix">
			<li class="li1 vw-row_device-type" data-title="{{deviceType}}">{{deviceType}}</li>
			<li class="li2 vw-row_location" data-title="{{location}}">{{location}}</li>
			<li class="li3 vw-row_login-time" data-title="{{loginTimeLabel}}">{{loginTimeLabel}}</li>
			<li class="li4 vw-row_last-access" data-title="{{lastAccessTime}}">{{lastAccessTime}}</li>
			<li class="li5 vw-row_actions" data-title="Actions"></li>
		</ul>
		<div class="vw-data-table_content">
		{{#sessions}}
			<ul class="activityList vw-data-row clearfix">
				<li class="li1 vw-row_device-type" title="{{consoleName}}" data-title="{{deviceType}}">{{consoleName}}{{#isJavaGui}}*{{/isJavaGui}}</li>
				<li class="li2 vw-row_location" title="{{hostTitle}}" data-title="{{locationContent}}">{{#isCurrentSession}}{{currentDevice}} ( {{/isCurrentSession}}{{host}}{{#isCurrentSession}} ){{/isCurrentSession}}</li>
				<li class="li3 vw-row_login-time" title="{{loginTime}}" data-title="{{loginTimeLabel}}">{{loginTime}}</li>
				<li class="li4 vw-row_last-access" title="{{lastAccessedTime}}" data-title="{{lastAccessTime}}">{{lastAccessedTimeString}}</li>
				<li class="li5 vw-row_actions vw-visible-on-hover" data-title="Actions" {{#canLogout}}data-id="{{sessionId}}"{{/canLogout}}>
					{{#canLogout}}
						<span class="logoutAction logoutActionJs vw-logout vw-close-action" title="{{endSession}}">
							<span class="sprite icon-delete_share vw-sprite_action"></span>
						</span>
					{{/canLogout}}
				</li>
			</ul>
		{{/sessions}}
		</div>
		{{#hasJavaGui}}<p class="recentActivitySubText">*{{activeDevicesMsg}}</p>{{/hasJavaGui}}
	</div>
</script>

<script type="text/template" id="sessionHistoryListTemplate">
	<div class="listHolder activeSessions vw-data-table clearfix">
		<ul class="activityListHead vw-data-row vw-heading-row clearfix">
			<li class="li1 vw-row_device-type" data-title="{{deviceType}}">{{deviceType}}</li>
			<li class="li2 vw-row_location" data-title="{{location}}">{{location}}</li>
			<li class="li3 vw-row_login-time" data-title="{{loginTimeLabel}}">{{loginTimeLabel}}</li>
			<li class="li4 vw-row_logout-time" data-title="{{logoutTimeLabel}}">{{logoutTimeLabel}}</li>
		</ul>
		<div class="vw-data-table_content">
		{{#sessions}}
			<ul class="activityList vw-data-row clearfix">
				<li class="li1 vw-row_device-type" data-title="{{deviceType}}" title="{{consoleName}}">{{consoleName}}</li>
				<li class="li2 vw-row_location" data-title="{{locationContent}}" title="{{hostTitle}}">{{host}}</li>
				<li class="li3 vw-row_login-time" data-title="{{loginTimeLabel}}" title="{{loginTime}}">{{loginTime}}</li>
				<li class="li4 vw-row_logout-time" data-title="{{logoutTimeLabel}}" title="{{logoutTime}}">{{logoutTime}}</li>
			</ul>
		{{/sessions}}
		</div>
	</div>
</script>

<script nonce="${sessionScope.cspNonce}" >
var overrideLocalAlerts="${overrideLocalAlerts}";
var dialogYes="${dialogYes}";
var dialogNo="${dialogNo}";
var overrideAlerts="${overrideAlerts}";
var Register_fields_mandatory="${Register_fields_mandatory}";
var Register_Password_error="${Register_Password_error}";
var Register_password_spaces="${Register_password_spaces}";
var webPrintEnabled="${webPrintEnabled}";
var isManageAlertsSetForAllClients = "${requestScope.isManageAlertsSetForAllClients}";

var localMsg = localMsg || {};
localMsg.activeDevicesMsg= "${activeDevicesMsg}";
localMsg.deviceType= "${deviceType}";
localMsg.location= "${location}";
localMsg.loginTime= "${loginTime}";
localMsg.logoutTime= "${logoutTime}";
localMsg.lastAccessTime= "${lastAccessTime}";
localMsg.endSession= "${endSession}";
localMsg.activeGui= "${activeGui}";
localMsg.currentDevice= "${currentDevice}";

var consoleNameMapping = {};

consoleNameMapping["Unknown"] = "${Unknown}";


</script>

<jsp:include page="../common/footerV3.jsp" >
	<jsp:param value="true" name="bootstrapped" />
	<jsp:param value="../common/js/custom-cb.js" name="js" />
	<jsp:param value="../settings/settings.js" name="js"/>
	<jsp:param value="../userPrefs/js/userPref.js" name="js" />
	<jsp:param value="../common/js/ui.spinner.min.js" name="js"/>
	<jsp:param value="../common/js/webprinting.js" name="js"/>
	<jsp:param value="../common/js/jquery.loadmask.min.js" name="js"/>
	<jsp:param value="../common/js/encoder.js" name="js"/>
</jsp:include>
