var settingsString = new Object();
var tableDetails = new Object();
var reportSettingsLoaded = false;

function initSettings() {
	reportSettingsLoaded = false;
	$("#settingsButton").on("click", function(e) {
		$("#popupContact").show();

		e.stopPropagation();

		if (reportSettingsLoaded === false) {
			loadSettings();
		}
	});

	//$('#rowsPerPage').spinner({ min: 1, max: 200 });

	$("#btnReset").click(function(e) {
		loadSettings();
	});
	$("#btnSaveChanges").click(function(e) {
		saveChanges();
	});
	$(".report-settingsbox").click(function(e) {
		e.stopPropagation();
		return;
	});
}

function saveChanges() {
	if ($("#setUserDateFormat1").attr("checked")) {
		settingsString["dateFormat"] = "MMDD";
	} else if ($("#setUserDateFormat2").attr("checked")) {
		settingsString["dateFormat"] = "DDMM";
	} else if ($("#setUserDateFormat3").attr("checked")) {
		settingsString["dateFormat"] = "DEFAULT";
	} else {
		settingsString["dateFormat"] = "MMDD";
	}
	var element = $('#rowsPerPage');
	if (!validate(element, $(element).val())) {
		return;
	}
	settingsString["rowsPerPage"] = $('#rowsPerPage').val();
	//settingsString["costPerSizeUnit"] = $('#costPerSizeUnit').val();
	//settingsString["sizeUnit"] = $('#sizeUnit').val();
	//var visible = $("#saveOnExit").attr("data-state").toLowerCase() == "checked"?'true':'false';
	//console.log('save on exit while saving  ' +visible);
	settingsString["saveOnExit"] = false;

	var returnValue = $.post(cvUtil.getContextPath() + '/server/UserPreferences?jsonSaveSettings=' +
			window.encodeURIComponent(JSON.stringify(settingsString)), "", function(returnData) {

	});
	closeSettingsDialog();
	return returnValue;
}

function loadSettings() {
	$.post(cvUtil.getContextPath() + '/server/UserPreferences?jsonLoadSettings=' +
			window.encodeURIComponent(JSON.stringify(settingsString)), "", function(returnData) {

		reportSettingsLoaded = true;

		if (returnData.dateFormat == "MMDD") {
			$('#setUserDateFormat1').attr("checked", true);
		} else if (returnData.dateFormat == "DDMM") {
			$('#setUserDateFormat2').attr("checked", true);
		} else if (returnData.dateFormat == "DEFAULT") {
			$('#setUserDateFormat3').attr("checked", true);
		}
		$('#rowsPerPage').val(returnData.rowsPerPage);
		//$('#costPerSizeUnit').val(returnData.costPerSizeUnit);
		//$('#sizeUnit').val(returnData.sizeUnit);
		/*
		 * if(returnData.saveOnExit=='true')
		 * $('#saveOnExit').removeClass("unchecked").removeClass("indeterminate").addClass("checked").attr("data-state",
		 * "checked"); else
		 * $('#saveOnExit').removeClass("checked").removeClass("indeterminate").addClass("unchecked").attr("data-state","unchecked");
		 */
	});

}

function closeSettingsDialog() {
	if ($("body").find(".report-settingsbox").length != 0) {
		$(".report-settingsbox").hide();
	}
	return;
}
function validate(element, pageSize) {
	if (parseInt(pageSize, 10) > 0 && parseInt(pageSize, 10).toString() === pageSize) {
		return true;
	} else {
		$('#validateTips').text(cvUtil.cvLocalize('Rows_per_Page_tips'));
		element.addClass("ui-state-error");
		setTimeout(function() {
			element.removeClass("ui-state-error", 3500);
		}, 500);
		return false;
	}
}
