<jsp:useBean id="sandbox" class="commvault.web.sandbox.Sandbox" scope="session" />
<% response.setContentType("application/javascript"); %>
/**
 * @author Ryan Cebulko
 */
var staticTree = {
  "__self__": {
    "key": ""
  },
  "Login": {
    "__self__": {
      "key": "Login",
      "post": {
        "snippet": "Get authorization token",
        "description": "Post login credentials to receive an authorization token. The password attribute contains a base64-encoded version of the login password.",
        "sample": [
          {
            "label": "Get authorization token",
            "input": "<DM2ContentIndexing_CheckCredentialReq mode=\"Webconsole\" username=\"\" password=\"\" />"
          }
        ]
      }
    }
  },
  "WhoAmI": {
    "__self__": {
      "key": "WhoAmI",
      "post": {
        "snippet": "Get your own credentials",
        "description": "Get information about your own credentials."
      }
    }
  },
  "GetId": {
    "__self__": {
      "key": "GetId",
      "get": {
        "snippet": "Filter client machines",
        "description": "Filter client machines by name, agent, instance, backupset, and/or subclient.",
        "params": [
          "clientName",
          "agent",
          "instanceName",
          "backupset",
          "subclient"
        ]
      }
    }
  },
  "Client": {
    "__self__": {
      "key": "Client",
      "get": {
        "snippet": "Get a listing of all client machines",
        "description": "Get a listing of all client machines."
      }
    },
    "{clientId}": {
      "__self__": {
        "key": "{clientId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the client with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the client with the provided ID.",
          "sample": [
            {
              "label": "Client Properties",
              "input": "<%= sandbox.pull("features/rest_api/xml/update_client_template.xml") %>"
            },
            {
              "label": "Client Deduplication",
              "input": "<%= sandbox.pull("features/user_admin/xml/client_deduplication.xml") %>"
            },
            {
              "label": "Modify Owners List",
              "input": "<%= sandbox.pull("features/user_admin/xml/modify_owners_list.xml") %>"
            },
            {
              "label": "Additional Settings",
              "input": "<%= sandbox.pull("features/user_admin/xml/additional_settings.xml") %>"
            },
            {
              "label": "Deconfigure Cluster Group",
              "input": "<%= sandbox.pull("features/clustering/command_line_xml/deconfigure_cluster_group_template.xml") %>"
            },
            {
              "label": "Deconfigure VCS Cluster Group",
              "input": "<%= sandbox.pull("features/clustering/command_line_xml/deconfigure_vcs_cluster_group_template.xml") %>"
            },
            {
              "label": "Usergroup to Client",
              "input": "<%= sandbox.pull("products/laptop_backup/xml/ug_to_client.xml") %>"
            },
            {
              "label": "Usergroup to Clientgroup",
              "input": "<%= sandbox.pull("products/laptop_backup/xml/ug_to_clientgroup.xml") %>"
            },
            {
              "label": "User to Client",
              "input": "<%= sandbox.pull("products/laptop_backup/xml/user_to_client.xml") %>"
            },
            {
              "label": "User to Clientgroup",
              "input": "<%= sandbox.pull("products/laptop_backup/xml/user_to_clientgroup.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the client",
          "description": "Delete the client with the provided ID."
        }
      },
      "ActivityControl": {
        "__self__": {
          "key": "ActivityControl",
          "get": {
            "snippet": "Enable/disable activities",
            "description": "Used for enabling/disabling activities like backup and restore."
          }
        },
        "{activityType}": {
          "__self__": {
            "key": "{activityType}"
          },
          "Action": {
            "__self__": {
              "key": "Action"
            },
            "Enable": {
              "__self__": {
                "key": "Enable",
                "post": {
                  "snippet": "Enable activities",
                  "description": "Enable activities."
                }
              }
            },
            "Disable": {
              "__self__": {
                "key": "Disable",
                "post": {
                  "snippet": "Disable activities",
                  "description": "Disable activities."
                }
              }
            }
          }
        }
      }
    }
  },
  "ClientGroup": {
    "__self__": {
      "key": "ClientGroup",
      "get": {
        "snippet": "Get a listing of all clientgroups",
        "description": "Get a listing of all clientgroups."
      },
      "post": {
        "snippet": "Create a new clientgroup",
        "description": "Create a new clientgroup.",
        "sample": [
          {
            "label": "Create ClientGroup",
            "input": "<%= sandbox.pull("features/rest_api/xml/create_client_computer_group_template.xml") %>"
          }
        ]
      }
    },
    "{clientGroupId}": {
      "__self__": {
        "key": "{clientGroupId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the clientgroup with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the clientgroup with the provided ID.",
          "sample": [
            {
              "label": "Update ClientGroup Properties",
              "input": "<%= sandbox.pull("features/rest_api/xml/update_client_computer_group_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the clientgroup",
          "description": "Delete the clientgroup with the provided ID."
        }
      }
    }
  },
  "Agent": {
    "__self__": {
      "key": "Agent",
      "get": {
        "snippet": "Returns a list of agents for a client",
        "description": "Returns a list of agents for a client",
        "params": [
          "clientId"
        ]
      },
      "post": {
        "snippet": "Updates the properties associated with an agent",
        "description": "Updates the properties associated with an agent",
        "sample": [
          {
            "label": "Update Agent",
            "input": "<%= sandbox.pull("features/rest_api/xml/update_agent_template.xml") %>"
          }
        ]
      }
    }
  },
  "Backupset": {
    "__self__": {
      "key": "Backupset",
      "get": {
        "snippet": "Get properties",
        "description": "Get the properties of the backupset on the machine with the provided ID.",
        "params": [
          "clientId"
        ]
      },
      "post": {
        "snippet": "Create Backupset",
        "description": "Creates a backup set",
        "sample": [
          {
            "label": "Create Backupset",
            "input": "<%= sandbox.pull("products/db2/command_line_xml/createBackupSet.xml") %>"
          }
        ]
      }
    },
    "{backupsetId}": {
      "__self__": {
        "key": "{backupsetId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the backupset with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the backupset with the provided ID.",
          "sample": [
            {
              "label": "Update Backupset",
              "input": "<%= sandbox.pull("features/rest_api/xml/update_backupset_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the backupset",
          "description": "Delete the backupset with the provided ID."
        }
      },
      "action": {
        "__self__": {
          "key": "action"
        },
        "backup": {
          "__self__": {
            "key": "backup",
            "post": {
              "snippet": "Start backup job",
              "description": "Start a backup job on the backup set."
            }
          }
        }
      }
    }
  },
  "Subclient": {
    "__self__": {
      "key": "Subclient",
      "get": {
        "snippet": "Get a listing of the subclients",
        "description": "Get a listing of the subclients on the machine with the provided ID.",
        "params": [
          "clientId"
        ]
      },
      "post": {
        "snippet": "Create a subclient",
        "description": "Create a subclient on the machine with the provided ID.",
        "sample": [
          {
            "label": "Create Subclient",
            "input": "<%= sandbox.pull("features/rest_api/xml/create_subclient_template.xml") %>"
          }
        ]
      }
    },
    "{subclientId}": {
      "__self__": {
        "key": "{subclientId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the subclient with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the subclient with the provided ID.",
          "sample": [
            {
              "label": "Subclient Deduplication",
              "input": "<%= sandbox.pull("features/user_admin/xml/subclient_deduplication.xml") %>"
            },
            {
              "label": "Update Subclient",
              "input": "<%= sandbox.pull("features/rest_api/xml/update_subclient_template.xml") %>"
            },
            {
              "label": "Update Snap Subclient",
              "input": "<%= sandbox.pull("products/vs_vmware/command_line_xml/update_snap_subclient_template.xml") %>"
            },
            {
              "label": "Update Subclient Filters",
              "input": "<%= sandbox.pull("products/vs_vmware/command_line_xml/update_subclient_filters_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the subclient",
          "description": "Delete the subclient with the providid ID."
        }
      },
      "action": {
        "__self__": {
          "key": "action"
        },
        "backup": {
          "__self__": {
            "key": "backup",
            "post": {
              "snippet": "Start backup job",
              "description": "Start a backup job on the subclient."
            }
          }
        }
      }
    }
  },
  "Job": {
    "__self__": {
      "key": "Job",
      "get": {
        "snippet": "Get a listing of the backup jobs",
        "description": "Get a listing of the backup jobs on the machine with the provided ID.",
        "params": [
          "clientId"
        ]
      }
    },
    "{jobId}": {
      "__self__": {
        "key": "{jobId}",
        "get": {
          "description": "Get the properties of the backup job with the provided ID.",
          "snippet": "Get properties"
        }
      },
      "Action": {
        "__self__": {
          "key": "Action"
        },
        "pause": {
          "__self__": {
            "key": "pause",
            "post": {
              "snippet": "Suspends a job",
              "description": "This operation suspends a job"
            }
          }
        },
        "kill": {
          "__self__": {
            "key": "kill",
            "post": {
              "snippet": "Kills a job",
              "description": "This operation Kills a job"
            }
          }
        }
      }
    }
  },
  "RetrieveToClient": {
    "__self__": {
      "key": "RetrieveToClient",
      "post": {
        "snippet": "Restores data obtained through a backup",
        "description": "Restores data obtained through a backup",
        "sample": [
          {
            "label": "Restore Data",
            "input": "<%= sandbox.pull("features/rest_api/xml/retrievetoclient_template.xml") %>"
          }
        ]
      }
    }
  },
  "DoBrowse": {
    "__self__": {
      "key": "DoBrowse",
      "post": {
        "snippet": "Browses data obtained through a backup",
        "description": "Browses data obtained through a backup",
        "sample": [
          {
            "label": "Browse Data",
            "input": "<%= sandbox.pull("features/rest_api/xml/browse_template.xml") %>"
          }
        ]
      }
    }
  },
  "Recall": {
    "__self__": {
      "key": "Recall",
      "post": {
        "snippet": "Initiates a download of data",
        "description": "This operation initiates a download of data obtained through a backup.",
        "params": [
          "at",
          "si",
          "op",
          "appId",
          "ec"
        ]
      }
    }
  },
  "MediaAgent": {
    "__self__": {
      "key": "MediaAgent",
      "get": {
        "snippet": "Returns a list of Media Agents",
        "description": "Returns a list of Media Agents"
      }
    }
  },
  "Library": {
    "__self__": {
      "key": "Library",
      "get": {
        "snippet": "Returns the list of Disk Libraries",
        "description": "Returns the list of Disk Libraries"
      },
      "post": {
        "snippet": "Creates a disk library",
        "description": "Creates a disk library",
        "sample": [
          {
            "label": "New disk library",
            "input": "<%= sandbox.pull("features/rest_api/xml/create_disk_library_template.xml") %>"
          }
        ]
      }
    }
  },
  "Role": {
    "__self__": {
      "key": "Role",
      "get": {
        "snippet": "Get a list of all Roles",
        "description": "Get a list of all Roles.",
        "params": [
        	"propertyLevel"
      ],
      },
      "post": {
        "snippet": "Create a new Role",
        "description": "Create a new user.",
        "sample": [
          {
            "label": "Create Role",
            "input": "<%= sandbox.pull("features/rest_api/xml/create_role_template.xml") %>"
          }
        ]
      }
    },
    "{roleId}": {
      "__self__": {
        "key": "{roleId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get properties of a Role with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of a Role with the provided ID.",
          "sample": [
            {
              "label": "Modify Role",
              "input": "<%= sandbox.pull("features/rest_api/xml/update_role_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the Role",
          "description": "Delete Role with the provided ID."
        }
      }
    }
  },
  "SchedulePolicy": {
    "__self__": {
      "key": "SchedulePolicy",
      "get": {
        "snippet": "Get a listing of all schedule policies.",
        "description": "When multiple clients or tasks require similar operations to be scheduled, you can create a schedule policy as a template and attach it to each of these clients (or client groups) and tasks in a CommCell."
      }
    },
    "{schedulePolicyId}": {
      "__self__": {
        "key": "{schedulePolicyId}",
        "get": {
          "snippet": "Get schedule policy info",
          "description": "Get schedule policy info"
        },
        "del": {
          "snippet": "Update schedule policy info",
          "description": "Update schedule policy info"
        }
      }
    }
  },
  "StoragePolicy": {
    "__self__": {
      "key": "StoragePolicy",
      "get": {
        "snippet": "Get a listing of all storage policies",
        "description": "Get a listing of all storage policies."
      },
      "post": {
        "snippet": "Creates a storage policy",
        "description": "This operation creates a storage policy",
        "sample": [
          {
            "label": "Create S.P.",
            "input": "<%= sandbox.pull("features/rest_api/xml/create_storage_policy.xml") %>"
          }
        ]
      },
      "put": {
        "snippet": "Create a new storage policy",
        "description": "Create a new storage policy",
        "params": [
          "storagepolicy",
          "mediaagent",
          "library",
          "drivepool",
          "scratchpool",
          "incstoragepolicy",
          "deduppath"
        ],
        "sample": [
          {
            "label": "Create S.P.",
            "input": "<%= sandbox.pull("features/storage_policies/xml/SP_creation.xml") %>"
          },
          {
            "label": "Create S.P. Copy",
            "input": "<%= sandbox.pull("features/storage_policies/xml/sp_copycreation.xml") %>"
          }
        ]
      }
    },
    "{spId}": {
      "__self__": {
        "key": "{spId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the storage policy with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the storage policy with the provided ID."
        },
        "del": {
          "snippet": "Delete the storage policy",
          "description": "Delete the storage policy with the provided ID."
        }
      }
    },
    "{spName}": {
      "__self__": {
        "key": "{spName}",
        "del": {
          "snippet": "Delete the storage policy",
          "description": "Delete the storage policy with the provided name."
        }
      }
    }
  },
  "AlertRule": {
    "__self__": {
      "key": "AlertRule",
      "get": {
        "snippet": "Returns a list of alerts",
        "description": "Returns a list of alerts"
      },
      "post": {
        "snippet": "Creates an alert",
        "description": "Creates an alert",
        "sample": [
          {
            "label": "Create Alert",
            "input": "<%= sandbox.pull("features/rest_api/xml/create_alert.xml") %>"
          }
        ]
      }
    },
    "{alertId}": {
      "__self__": {
        "key": "{alertId}",
        "get": {
          "snippet": "Get the details associated with an alert",
          "description": "Returns the details associated with an alert"
        },
        "del": {
          "snippet": "Delete the Alert",
          "description": "Delete the Alert with the provided ID"
        }
      },
      "Action": {
        "__self__": {
          "key": "Action"
        },
        "Modify": {
          "__self__": {
            "key": "Modify",
            "post": {
              "snippet": "Updates the Alert",
              "description": "Used for updating the alert",
              "sample": [
                {
                  "label": "Modify Alert",
                  "input": "<%= sandbox.pull("features/rest_api/xml/modify_alert.xml") %>"
                }
              ]
            }
          }
        },
        "Enable": {
          "__self__": {
            "key": "Enable",
            "post": {
              "snippet": "Enables the alert",
              "description": "Used for enabling the alert"
            }
          }
        },
        "Disable": {
          "__self__": {
            "key": "Disable",
            "post": {
              "snippet": "Disables the alert",
              "description": "Used for Disabling the alert"
            }
          }
        }
      }
    }
  },
  "User": {
    "__self__": {
      "key": "User",
      "get": {
        "snippet": "Get a listing of all users",
        "description": "Get a listing of all users."
      },
      "post": {
        "snippet": "Create a new user",
        "description": "Create a new user.",
        "sample": [
          {
            "label": "Create User",
            "input": "<%= sandbox.pull("features/user_admin/xml/create_user_template.xml") %>"
          }
        ]
      }
    },
    "{userId}": {
      "__self__": {
        "key": "{userId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the user with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the user with the provided ID.",
          "sample": [
            {
              "label": "Modify User",
              "input": "<%= sandbox.pull("features/user_admin/xml/modify_user_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the user",
          "description": "Delete the user with the provided ID."
        }
      }
    }
  },
  "UserGroup": {
    "__self__": {
      "key": "UserGroup",
      "get": {
        "snippet": "Get a listing of all usergroups",
        "description": "Get a listing of all usergroups."
      },
      "post": {
        "snippet": "Create a new usergroup",
        "description": "Create a new usergroup",
        "sample": [
          {
            "label": "Create Usergroup",
            "input": "<%= sandbox.pull("features/user_admin/xml/create_usergroup_template.xml") %>"
          }
        ]
      }
    },
    "{userGroupId}": {
      "__self__": {
        "key": "{userGroupId}",
        "get": {
          "snippet": "Get properties",
          "description": "Get the properties of the usergroup with the provided ID."
        },
        "post": {
          "snippet": "Update properties",
          "description": "Update the properties of the usergroup with the provided ID.",
          "sample": [
            {
              "label": "Modify Usergroup",
              "input": "<%= sandbox.pull("features/user_admin/xml/modify_usergroup_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Delete the usergroup",
          "description": "Delete the usergroup with the provided ID."
        }
      }
    }
  },
  "Workflow": {
    "__self__": {
      "key": "Workflow",
      "get": {
        "snippet": "Returns the list of Workflows",
        "description": "Returns the list of Workflows"
      }
    },
    "{workflowName}": {
      "__self__": {
        "key": "{workflowName}"
      },
      "Action": {
        "__self__": {
          "key": "Action"
        },
        "Execute": {
          "__self__": {
            "key": "Execute",
            "post": {
              "snippet": "Executes a workflow",
              "description": "This operation executes a workflow.",
              "params": [
                "outputOnly"
              ],
              "sample": [
                {
                  "label": "Execute workflow",
                  "input": "<%= sandbox.pull("features/rest_api/xml/execute_workflow_template.xml") %>"
                }
              ]
            }
          }
        }
      }
    }
  },
  "ContentStore": {
    "__self__": {
      "key": "ContentStore",
      "put": {
        "snippet": "Create a ContentStore",
        "description": "Use this operation to create a ContentStore.\nEach authorized user can create one ContentStore.",
        "params": [
          "type"
        ]
      }
    },
    "File": {
      "__self__": {
        "key": "File"
      },
      "{fileOrFolderId}": {
        "__self__": {
          "key": "{fileOrFolderId}",
          "get": {
            "snippet": "View File/Folder Properties",
            "description": "This operation returns the properties associated with a file or folder in a ContentStore based on the file or folder GUID."
          },
          "post": {
            "snippet": "Creates a new folder in the ContentStore",
            "description": "This operation creates a new folder in the ContentStore based on the GUID of the parent folder.",
            "sample": [
              {
                "label": "Creates a folder by GUID",
                "input": "<App_FileResourceInfo name=\"\" />"
              }
            ]
          },
          "del": {
            "snippet": "Deletes a file or a folder by GUID in a ContentStore",
            "description": "This operation deletes a file or a folder by GUID in a ContentStore."
          }
        },
        "Action": {
          "__self__": {
            "key": "Action"
          },
          "Move": {
            "__self__": {
              "key": "Move",
              "put": {
                "snippet": "Moves a file or folder, based on the file or folder GUID",
                "description": "This operation moves a file or folder, based on the file or folder GUID, to another folder within the ContentStore.",
                "sample": [
                  {
                    "label": "Moves a folder by GUID",
                    "input": "<App_FileResourceInfo parentGuid=\"\" />"
                  }
                ]
              }
            }
          },
          "Rename": {
            "__self__": {
              "key": "Rename",
              "put": {
                "snippet": "Renames file or folder, based on the file or folder GUID",
                "description": "This operation renames a file or folder, based on the file or folder GUID, to another folder within the ContentStore.",
                "sample": [
                  {
                    "label": "Renames a folder by GUID",
                    "input": "<App_FileResourceInfo name=\"\" />"
                  }
                ]
              }
            }
          },
          "Download": {
            "__self__": {
              "key": "Download",
              "get": {
                "snippet": "Downloads a file based on the file GUID",
                "description": "This operation downloads a file in a ContentStore based on the GUID of the file.\nNote: Downloading a folder is currently not supported using this operation."
              }
            }
          },
          "Share": {
            "__self__": {
              "key": "Share",
              "post": {
                "snippet": "share a specific file or folder in a ContentStore based on the file GUID",
                "description": "Use this operation to share a specific file or folder in a ContentStore based on the GUID of the file or folder.",
                "sample": [
                  {
                    "label": "Shares a folder by GUID",
                    "input": "<App_ShareInfo sharedToOperationType=\"2\" status=\"0\">\n    <browseInfo> \n        <emailInfo dontSendEmail=\"1\" /> \n    </browseInfo>\n    <shareFolder syncWebFolderName=\"fromlaptop\"/>\n    <sharedTo permission=\"1\" userType=\"1\"> \n        <user userName=\"user1\"/> \n    </sharedTo>  \n</App_ShareInfo>"
                  }
                ]
              }
            }
          }
        }
      },
      "Action": {
        "__self__": {
          "key": "Action"
        },
        "Upload": {
          "__self__": {
            "key": "Upload",
            "post": {
              "snippet": "Uploads a single file",
              "description": "This operation uploads a single file to the ContentStore",
              "params": [
                "uploadType",
                "requestId",
                "forceRestart"
              ]
            }
          }
        }
      }
    },
    "Action": {
      "__self__": {
        "key": "Action"
      },
      "Createfolder": {
        "__self__": {
          "key": "Createfolder",
          "post": {
            "snippet": "Creates a new folder in the ContentStore",
            "description": "This operation creates a new folder in the ContentStore based on the path of the parent folder.",
            "sample": [
              {
                "label": "Creates a folder by Path",
                "input": "<App_FileResourceInfo name=\"\" parentPath=\"\" />"
              }
            ]
          }
        }
      },
      "Metadata": {
        "__self__": {
          "key": "Metadata",
          "get": {
            "snippet": "View the properties of a file/folder by Path in the ContentStore",
            "description": "This operation returns the properties associated with a file or folder in a ContentStore based on the file or folder path.",
            "params": [
              "path"
            ]
          }
        }
      },
      "Download": {
        "__self__": {
          "key": "Download",
          "get": {
            "snippet": "Download a file/folder by Path in the ContentStore",
            "description": "This operation downloads a file in a ContentStore based on the file path.\nNote: Downloading a folder is currently not supported using this operation.",
            "params": [
              "path"
            ]
          }
        }
      },
      "Move": {
        "__self__": {
          "key": "Move",
          "post": {
            "snippet": "Move a folder in the ContentStore based on path",
            "description": "This operation moves a file or folder, based on the file/folder path, to another folder within the ContentStore.",
            "sample": [
              {
                "label": "Moves a folder by Path",
                "input": "<App_FileResourceInfo path=\"\" parentPath=\"\" />"
              }
            ]
          }
        }
      },
      "Share": {
        "__self__": {
          "key": "Share",
          "post": {
            "snippet": "Share a specific file or folder in a ContentStore based on the file path",
            "description": "Use this operation to share a specific file or folder in a ContentStore based on the path of the file or folder.",
            "sample": [
              {
                "label": "Shares a folder by Path",
                "input": "<App_ShareInfo sharedToOperationType=\"2\" status=\"0\">\n    <browseInfo> \n        <paths path=\"\" /> \n<emailInfo dontSendEmail=\"1\" /> \n    </browseInfo>\n    <shareFolder syncWebFolderName=\"fromlaptop\"/>\n    <sharedTo permission=\"1\" userType=\"1\"> \n        <user userName=\"user1\"/> \n    </sharedTo>  \n</App_ShareInfo>"
              }
            ]
          }
        }
      },
      "Rename": {
        "__self__": {
          "key": "Rename",
          "post": {
            "snippet": "Rename a folder in the ContentStore based on path",
            "description": "This operation renames a file or folder, based on the file/folder path",
            "sample": [
              {
                "label": "Renames a folder by Path",
                "input": "<App_FileResourceInfo path=\"\" name=\"\" />"
              }
            ]
          }
        }
      },
      "Delete": {
        "__self__": {
          "key": "Delete",
          "del": {
            "snippet": "Delete a folder in the ContentStore based on path",
            "description": "This operation Deletes a file or folder, based on the file/folder path",
            "sample": [
              {
                "label": "Deletes a folder by Path",
                "input": "<App_FileResourceInfo path=\"\" />"
              }
            ]
          }
        }
      }
    },
    "Share": {
      "__self__": {
        "key": "Share",
        "get": {
          "snippet": "View the list of shared files and folders in one or more ContentStores",
          "description": "Use this operation to view the list of shared files and folders in one or more ContentStores. You can also use the REST API to view the share details of a specific file or folder.",
          "params": [
            "shareId",
            "contentStoreType"
          ]
        }
      },
      "{shareId}": {
        "__self__": {
          "key": "{shareId}"
        },
        "File": {
          "__self__": {
            "key": "File"
          },
          "{fileOrFolderId}": {
            "__self__": {
              "key": "{fileOrFolderId}",
              "get": {
                "snippet": "View File/Folder Properties in Share",
                "description": "This operation returns the properties associated with a file or folder within a shared folder in a ContentStore based on the file or folder GUID."
              },
              "post": {
                "snippet": "Creates a new folder in the ContentStore",
                "description": "This operation creates a new folder within a shared folder in the ContentStore based on the GUID of the parent folder.",
                "sample": [
                  {
                    "label": "Creates a folder by GUID",
                    "input": "<App_FileResourceInfo name=\"\" />"
                  }
                ]
              },
              "del": {
                "snippet": "Deletes a file or a folder by GUID in a ContentStore",
                "description": "This operation deletes a file or a folder within a shared folder in a ContentStore."
              }
            },
            "Action": {
              "__self__": {
                "key": "Action"
              },
              "Move": {
                "__self__": {
                  "key": "Move",
                  "put": {
                    "snippet": "Moves a file or folder, based on the file or folder GUID",
                    "description": "This operation moves a file or folder, based on the file or folder GUID, to another folder within a shared folder in the ContentStore.",
                    "sample": [
                      {
                        "label": "Moves a folder by GUID",
                        "input": "<App_FileResourceInfo parentGuid=\"\" />"
                      }
                    ]
                  }
                }
              },
              "Rename": {
                "__self__": {
                  "key": "Rename",
                  "put": {
                    "snippet": "Renames file or folder, based on the file or folder GUID",
                    "description": "This operation renames a file or folder, based on the file or folder GUID, to another folder within a shared folder in the ContentStore.",
                    "sample": [
                      {
                        "label": "Renames a folder by GUID",
                        "input": "<App_FileResourceInfo parentGuid=\"\" />"
                      }
                    ]
                  }
                }
              },
              "Download": {
                "__self__": {
                  "key": "Download",
                  "get": {
                    "snippet": "Downloads a file based on the file GUID",
                    "description": "This operation downloads a file within a shared folder in a ContentStore based on the GUID of the file.\nNote: Downloading a folder is currently not supported using this operation."
                  }
                }
              }
            }
          },
          "Action": {
            "__self__": {
              "key": "Action"
            },
            "Upload": {
              "__self__": {
                "key": "Upload",
                "post": {
                  "snippet": "Uploads a single file",
                  "description": "This operation uploads a single file to a shared folder in the ContentStore",
                  "params": [
                    "uploadType",
                    "requestId",
                    "forceRestart"
                  ]
                }
              }
            }
          }
        },
        "Action": {
          "__self__": {
            "key": "Action"
          },
          "Createfolder": {
            "__self__": {
              "key": "Createfolder",
              "post": {
                "snippet": "Creates a new folder within a shared folder in the ContentStore",
                "description": "This operation creates a new folder within a shared folder in the ContentStore based on the path of the parent folder.",
                "sample": [
                  {
                    "label": "Creates a folder by Path",
                    "input": "<App_FileResourceInfo name=\"\" parentPath=\"\" />"
                  }
                ]
              }
            }
          },
          "Metadata": {
            "__self__": {
              "key": "Metadata",
              "get": {
                "snippet": "View the properties of a file/folder by Path within a shared folder in the ContentStore",
                "description": "This operation returns the properties associated with a file or folder in a ContentStore based on the file or folder path.",
                "params": [
                  "path"
                ]
              }
            }
          },
          "Download": {
            "__self__": {
              "key": "Download",
              "get": {
                "snippet": "Download a file/folder by Path within a shared folder in the ContentStore",
                "description": "This operation downloads a file within a shared folder in a ContentStore based on the file path.\nNote: Downloading a folder is currently not supported using this operation.",
                "params": [
                  "path"
                ]
              }
            }
          },
          "Move": {
            "__self__": {
              "key": "Move",
              "post": {
                "snippet": "Move a folder in the ContentStore within a shared folder based on path",
                "description": "This operation moves a file or folder, based on the file/folder path, to another folder  within a shared folder in the ContentStore.",
                "sample": [
                  {
                    "label": "Moves a folder by Path",
                    "input": "<App_FileResourceInfo path=\"\" parentPath=\"\" />"
                  }
                ]
              }
            }
          },
          "Share": {
            "__self__": {
              "key": "Share",
              "post": {
                "snippet": "Share a specific file or folder within a shared folder in a ContentStore based on the file path",
                "description": "Use this operation to share a specific file or folder within a shared folder in a ContentStore based on the path of the file or folder.",
                "sample": [
                  {
                    "label": "Shares a folder by Path",
                    "input": "<App_ShareInfo sharedToOperationType=\"2\" status=\"0\">\n    <browseInfo> \n        <paths path=\"\" /> \n<emailInfo dontSendEmail=\"1\" /> \n    </browseInfo>\n    <shareFolder syncWebFolderName=\"fromlaptop\"/>\n    <sharedTo permission=\"1\" userType=\"1\"> \n        <user userName=\"user1\"/> \n    </sharedTo>  \n</App_ShareInfo>"
                  }
                ]
              }
            }
          },
          "Rename": {
            "__self__": {
              "key": "Rename",
              "post": {
                "snippet": "Rename a folder in the ContentStore based on path",
                "description": "This operation renames a file or folder, based on the file/folder path",
                "sample": [
                  {
                    "label": "Renames a folder by Path",
                    "input": "<App_FileResourceInfo path=\"\" name=\"\" />"
                  }
                ]
              }
            }
          },
          "Delete": {
            "__self__": {
              "key": "Delete",
              "del": {
                "snippet": "Delete a folder within a shared folder in the ContentStore based on path",
                "description": "This operation Deletes a file or folder, based on the file/folder path within a shared folder",
                "sample": [
                  {
                    "label": "Deletes a folder by Path",
                    "input": "<App_FileResourceInfo path=\"\" />"
                  }
                ]
              }
            }
          }
        }
      }
    }
  },
  "Drive": {
    "__self__": {
      "key": "Drive",
      "get": {
        "snippet": "View details for your Edge Drive account",
        "description": "Use this operation to view details, such as root GUID, user capabilities, etc,. for your Edge Drive account."
      }
    },
    "File": {
      "__self__": {
        "key": "File"
      },
      "{fileOrFolderId}": {
        "__self__": {
          "key": "{fileOrFolderId}",
          "get": {
            "snippet": "View File/Folder Properties",
            "description": "This operation returns the properties associated with a file or folder in Edge Drive based on the file or folder GUID."
          },
          "post": {
            "snippet": "Creates a new folder in the Edge Drive",
            "description": "This operation creates a new folder in the Edge Drive based on the GUID of the parent folder.",
            "sample": [
              {
                "label": "Creates a folder by GUID",
                "input": "<App_FileResourceInfo name=\"\" />"
              }
            ]
          },
          "del": {
            "snippet": "Deletes a file or a folder by GUID in a Edge Drive",
            "description": "This operation deletes a file or a folder by GUID in a Edge Drive."
          }
        },
        "Action": {
          "__self__": {
            "key": "Action"
          },
          "Move": {
            "__self__": {
              "key": "Move",
              "put": {
                "snippet": "Moves a file or folder, based on the file or folder GUID",
                "description": "This operation moves a file or folder, based on the file or folder GUID, to another folder within the Edge Drive.",
                "sample": [
                  {
                    "label": "Moves a folder by GUID",
                    "input": "<App_FileResourceInfo parentGuid=\"\" />"
                  }
                ]
              }
            }
          },
          "Rename": {
            "__self__": {
              "key": "Rename",
              "put": {
                "snippet": "Renames file or folder, based on the file or folder GUID",
                "description": "This operation renames a file or folder, based on the file or folder GUID, to another folder within the Edge Drive.",
                "sample": [
                  {
                    "label": "Renames a folder by GUID",
                    "input": "<App_FileResourceInfo name=\"\" />"
                  }
                ]
              }
            }
          },
          "Download": {
            "__self__": {
              "key": "Download",
              "get": {
                "snippet": "Downloads a file based on the file GUID",
                "description": "This operation downloads a file in a Edge Drive based on the GUID of the file.\nNote: Downloading a folder is currently not supported using this operation."
              }
            }
          },
          "Share": {
            "__self__": {
              "key": "Share",
              "post": {
                "snippet": "share a specific file or folder in a Edge Drive based on the file GUID",
                "description": "Use this operation to share a specific file or folder in a Edge Drive based on the GUID of the file or folder.",
                "sample": [
                  {
                    "label": "Shares a folder by GUID",
                    "input": "<App_ShareInfo sharedToOperationType=\"2\" status=\"0\">\n    <browseInfo> \n        <emailInfo dontSendEmail=\"1\" /> \n    </browseInfo>\n    <shareFolder syncWebFolderName=\"fromlaptop\"/>\n    <sharedTo permission=\"1\" userType=\"1\"> \n        <user userName=\"user1\"/> \n    </sharedTo>  \n</App_ShareInfo>"
                  }
                ]
              }
            }
          }
        }
      },
      "Action": {
        "__self__": {
          "key": "Action"
        },
        "Upload": {
          "__self__": {
            "key": "Upload",
            "post": {
              "snippet": "Uploads a single file",
              "description": "This operation uploads a single file to the Edge Drive",
              "params": [
                "uploadType",
                "requestId",
                "forceRestart"
              ]
            }
          }
        }
      }
    },
    "Action": {
      "__self__": {
        "key": "Action"
      },
      "Createfolder": {
        "__self__": {
          "key": "Createfolder",
          "post": {
            "snippet": "Creates a new folder in the Edge Drive",
            "description": "This operation creates a new folder in the Edge Drive based on the path of the parent folder.",
            "sample": [
              {
                "label": "Creates a folder by Path",
                "input": "<App_FileResourceInfo name=\"\" parentPath=\"\" />"
              }
            ]
          }
        }
      },
      "Metadata": {
        "__self__": {
          "key": "Metadata",
          "get": {
            "snippet": "View the properties of a file/folder by Path in the Edge Drive",
            "description": "This operation returns the properties associated with a file or folder in a Edge Drive based on the file or folder path.",
            "params": [
              "path"
            ]
          }
        }
      },
      "Download": {
        "__self__": {
          "key": "Download",
          "get": {
            "snippet": "Download a file/folder by Path in the Edge Drive",
            "description": "This operation downloads a file in a Edge Drive based on the file path.\nNote: Downloading a folder is currently not supported using this operation.",
            "params": [
              "path"
            ]
          }
        }
      },
      "Move": {
        "__self__": {
          "key": "Move",
          "post": {
            "snippet": "Move a folder in the Edge Drive based on path",
            "description": "This operation moves a file or folder, based on the file/folder path, to another folder within the Edge Drive.",
            "sample": [
              {
                "label": "Moves a folder by Path",
                "input": "<App_FileResourceInfo path=\"\" parentPath=\"\" />"
              }
            ]
          }
        }
      },
      "Share": {
        "__self__": {
          "key": "Share",
          "post": {
            "snippet": "Share a specific file or folder in a Edge Drive based on the file path",
            "description": "Use this operation to share a specific file or folder in a Edge Drive based on the path of the file or folder.",
            "sample": [
              {
                "label": "Shares a folder by Path",
                "input": "<App_ShareInfo sharedToOperationType=\"2\" status=\"0\">\n    <browseInfo> \n        <paths path=\"\" /> \n<emailInfo dontSendEmail=\"1\" /> \n    </browseInfo>\n    <shareFolder syncWebFolderName=\"fromlaptop\"/>\n    <sharedTo permission=\"1\" userType=\"1\"> \n        <user userName=\"user1\"/> \n    </sharedTo>  \n</App_ShareInfo>"
              }
            ]
          }
        }
      },
      "Rename": {
        "__self__": {
          "key": "Rename",
          "post": {
            "snippet": "Rename a folder in the Edge Drive based on path",
            "description": "This operation renames a file or folder, based on the file/folder path",
            "sample": [
              {
                "label": "Renames a folder by Path",
                "input": "<App_FileResourceInfo path=\"\" name=\"\" />"
              }
            ]
          }
        }
      },
      "Delete": {
        "__self__": {
          "key": "Delete",
          "del": {
            "snippet": "Delete a folder in the Edge Drive based on path",
            "description": "This operation Deletes a file or folder, based on the file/folder path",
            "sample": [
              {
                "label": "Deletes a folder by Path",
                "input": "<App_FileResourceInfo path=\"\" />"
              }
            ]
          }
        }
      }
    },
    "Share": {
      "__self__": {
        "key": "Share",
        "get": {
          "snippet": "View the list of shared files and folders in Edge Drive",
          "description": "Use this operation to view the list of shared files and folders in Edge Drive. You can also use the REST API to view the share details of a specific file or folder.",
          "params": [
            "shareId",
            "contentStoreType"
          ]
        }
      },
      "{shareId}": {
        "__self__": {
          "key": "{shareId}"
        },
        "File": {
          "__self__": {
            "key": "File"
          },
          "{fileOrFolderId}": {
            "__self__": {
              "key": "{fileOrFolderId}",
              "get": {
                "snippet": "View File/Folder Properties in Share",
                "description": "This operation returns the properties associated with a file or folder within a shared folder in a Edge Drive based on the file or folder GUID."
              },
              "post": {
                "snippet": "Creates a new folder in the Edge Drive",
                "description": "This operation creates a new folder within a shared folder in the Edge Drive based on the GUID of the parent folder.",
                "sample": [
                  {
                    "label": "Creates a folder by GUID",
                    "input": "<App_FileResourceInfo name=\"\" />"
                  }
                ]
              },
              "del": {
                "snippet": "Deletes a file or a folder by GUID in a Edge Drive",
                "description": "This operation deletes a file or a folder by GUID within a shared folder in a Edge Drive."
              }
            },
            "Action": {
              "__self__": {
                "key": "Action"
              },
              "Move": {
                "__self__": {
                  "key": "Move",
                  "put": {
                    "snippet": "Moves a file or folder, based on the file or folder GUID",
                    "description": "This operation moves a file or folder, based on the file or folder GUID, to another folder within a shared folder in the Edge Drive.",
                    "sample": [
                      {
                        "label": "Moves a folder by GUID",
                        "input": "<App_FileResourceInfo parentGuid=\"\" />"
                      }
                    ]
                  }
                }
              },
              "Rename": {
                "__self__": {
                  "key": "Rename",
                  "put": {
                    "snippet": "Renames file or folder, based on the file or folder GUID",
                    "description": "This operation renames a file or folder, based on the file or folder GUID, to another folder within a shared folder in the Edge Drive.",
                    "sample": [
                      {
                        "label": "Renames a folder by GUID",
                        "input": "<App_FileResourceInfo parentGuid=\"\" />"
                      }
                    ]
                  }
                }
              },
              "Download": {
                "__self__": {
                  "key": "Download",
                  "get": {
                    "snippet": "Downloads a file based on the file GUID",
                    "description": "This operation downloads a file within a shared folder in a Edge Drive based on the GUID of the file.\nNote: Downloading a folder is currently not supported using this operation.Yep\n"
                  }
                }
              }
            }
          },
          "Action": {
            "__self__": {
              "key": "Action"
            },
            "Upload": {
              "__self__": {
                "key": "Upload",
                "post": {
                  "snippet": "Uploads a single file",
                  "description": "This operation uploads a single file to a shared folder in the Edge Drive",
                  "params": [
                    "uploadType",
                    "requestId",
                    "forceRestart"
                  ]
                }
              }
            }
          }
        },
        "Action": {
          "__self__": {
            "key": "Action"
          },
          "Createfolder": {
            "__self__": {
              "key": "Createfolder",
              "post": {
                "snippet": "Creates a new folder within a shared folder in the Edge Drive",
                "description": "This operation creates a new folder within a shared folder in the Edge Drive based on the path of the parent folder.",
                "sample": [
                  {
                    "label": "Creates a folder by Path",
                    "input": "<App_FileResourceInfo name=\"\" parentPath=\"\" />"
                  }
                ]
              }
            }
          },
          "Metadata": {
            "__self__": {
              "key": "Metadata",
              "get": {
                "snippet": "View the properties of a file/folder by Path within a shared folder in the Edge Drive",
                "description": "This operation returns the properties associated with a file or folder in a Edge Drive based on the file or folder path.",
                "params": [
                  "path"
                ]
              }
            }
          },
          "Download": {
            "__self__": {
              "key": "Download",
              "get": {
                "snippet": "Download a file/folder by Path within a shared folder in the Edge Drive",
                "description": "This operation downloads a file within a shared folder in a Edge Drive based on the file path.\nNote: Downloading a folder is currently not supported using this operation.",
                "params": [
                  "path"
                ]
              }
            }
          },
          "Move": {
            "__self__": {
              "key": "Move",
              "post": {
                "snippet": "Move a folder in the Edge Drive within a shared folder based on path",
                "description": "This operation moves a file or folder, based on the file/folder path, to another folder  within a shared folder in the Edge Drive.",
                "sample": [
                  {
                    "label": "Moves a folder by Path",
                    "input": "<App_FileResourceInfo path=\"\" parentPath=\"\" />"
                  }
                ]
              }
            }
          },
          "Share": {
            "__self__": {
              "key": "Share",
              "post": {
                "snippet": "Share a specific file or folder within a shared folder in a Edge Drive based on the file path",
                "description": "Use this operation to share a specific file or folder within a shared folder in a Edge Drive based on the path of the file or folder.",
                "sample": [
                  {
                    "label": "Shares a folder by Path",
                    "input": "<App_ShareInfo sharedToOperationType=\"2\" status=\"0\">\n    <browseInfo> \n        <paths path=\"\" /> \n<emailInfo dontSendEmail=\"1\" /> \n    </browseInfo>\n    <shareFolder syncWebFolderName=\"fromlaptop\"/>\n    <sharedTo permission=\"1\" userType=\"1\"> \n        <user userName=\"user1\"/> \n    </sharedTo>  \n</App_ShareInfo>"
                  }
                ]
              }
            }
          },
          "Rename": {
            "__self__": {
              "key": "Rename",
              "post": {
                "snippet": "Rename a folder in the Edge Drive based on path",
                "description": "This operation renames a file or folder, based on the file/folder path",
                "sample": [
                  {
                    "label": "Renames a folder by Path",
                    "input": "<App_FileResourceInfo path=\"\" name=\"\" />"
                  }
                ]
              }
            }
          },
          "Delete": {
            "__self__": {
              "key": "Delete",
              "del": {
                "snippet": "Delete a folder within a shared folder in the Edge Drive based on path",
                "description": "This operation Deletes a file or folder, based on the file/folder path within a shared folder",
                "sample": [
                  {
                    "label": "Deletes a folder by Path",
                    "input": "<App_FileResourceInfo path=\"\" />"
                  }
                ]
              }
            }
          }
        }
      }
    }
  },
  "ShareFolder": {
    "__self__": {
      "key": "ShareFolder"
    },
    "{shareId}": {
      "__self__": {
        "key": "{shareId}",
        "put": {
          "snippet": "Change Share settings",
          "description": "Use this operation to add, modify or delete users or change the share and user permissions on a shared file or folder.",
          "sample": [
            {
              "label": "Modify Share",
              "input": "<%= sandbox.pull("features/rest_api/xml/update_share_template.xml") %>"
            }
          ]
        },
        "del": {
          "snippet": "Remove the sharing on a file or folder",
          "description": "Use this operation to remove the sharing on a file or folder"
        }
      }
    }
  },
  "EmailServer": {
    "__self__": {
      "key": "EmailServer",
      "get": {
        "snippet": "Returns the configuration for the email server",
        "description": "Returns the configuration for the email server"
      },
      "post": {
        "snippet": "Updates the configuration for the email server",
        "description": "Updates the configuration for the email server",
        "sample": [
          {
            "label": "Update Email Server",
            "input": "<%= sandbox.pull("features/rest_api/xml/update_email_server_template.xml") %>"
          }
        ]
      }
    }
  },
  "QCommand": {
    "__self__": {
      "key": "QCommand"
    },
    "{qcommand}": {
      "__self__": {
        "key": "{qcommand}",
        "post": {
          "snippet": "Execute any qcommand",
          "description": "This is the generic API to execute any qcommand. The POST body may contain XML for commands like qoperation."
        }
      }
    }
  },
  "Logout": {
    "__self__": {
      "key": "Logout",
      "post": {
        "snippet": "Do logout",
        "description": "Deactivate authorization token from login."
      }
    }
  }
};