# Commvault changelog for Swagger

Swagger UI Version | Commvault Release date
--- | --- |
3.19 | 02-10-2019 |
3.36.2 | 09-11-2020 |

Latest official swagger version released can be checked [here](https://github.com/swagger-api/swagger-ui/releases).

We use [swagger-ui-dist](https://www.npmjs.com/package/swagger-ui-dist) in Commvault.

## Check for Swagger Version

- Open your browser's console
- Type and execute ```versions.swaggerUi.version``` in the console
- The version taken from that example would be ```"3.36.2"```

## Commvault code changes

swagger-ui-standalone-preset.js
------

- Find ```topbar-wrapper``` in this file and replace accordingly with this code:

```javascript
y.a.createElement(
o,
null,
y.a.createElement("img", { height: "30", width: "30", src: "../../common/thirdParty/swagger/css/cvlt-b.png", alt: "Commvault Api" }),
y.a.createElement("span", null, "Commvault API Explorer")
),
```

- Replace ```Select a definition``` with ```Select Version```

swagger-ui.css
------

- Change topbar color and background:

```css
.swagger-ui .topbar {
  padding: 8px 0;
  background: #0073b1 url(pattern-commvault.png);
}
```

- Replace ![#62a03f](https://via.placeholder.com/15/62a03f/000000?text=+) `#62a03f` with ![#00384f](https://via.placeholder.com/15/00384f/000000?text=+) `#00384f` everywhere

- Remove ```max-width: 300px;``` from
  ```css
  swagger-ui .topbar a {}
  ```

## How to expand minified files

Use online tool like  [UnMinify](https://unminify.com/)

Copy paste the minified file contents and clikc on unminify button

Download this file as: <some_name>-expanded.js

## How to minify files

Install uglify-js using ```npm i uglify-js```

Open cmd and type:

```uglifyjs swagger-ui-standalone-preset-expanded.js --source-map --output swagger-ui-standalone-preset.js```

This will also generate the map file along with the minified file
