<jsp:useBean id="sandbox" class="commvault.web.sandbox.Sandbox" scope="session" />
<!DOCTYPE HTML>
<!-- @author Ryan Cebulko -->
<html>
  <head>
	<jsp:include page="/common/search-engine.jsp" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <meta charset="UTF-8">

    <title>REST Webservice API Sandbox</title>

    <!-- References local favicon. Should be updated when integrated. -->
    <link rel="shortcut icon" href="util/favicon.png">

    <!-- JQuery library -->
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="../common/js/jquery.min.js"></script>

    <!-- JQuery plugin to enhance user interface -->
    <!-- <link rel="stylesheet" type="text/css" href="../common/qtip/jquery.qtip.min.css"> -->
    <!-- <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="../common/qtip/jquery.qtip.min.js"></script> -->

    <!-- JQuery plugin to enhance appearance of input fields -->
    <link rel="stylesheet" type="text/css" href="util/uniform/themes/default/css/uniform.default.min.css">
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="util/uniform/jquery.uniform.min.js"></script>

    <!-- JQuery plugins to manage tree view -->
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="util/jstree/jquery.jstree.js"></script>
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="util/jquery.scrollTo.js"></script>

    <!-- Script to display loader during AJAX requests -->
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="util/ajaxLoader.js"></script>

    <!-- A base64 encoding function for browsers that don't support window.btoa("string") (IE8)) -->
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="util/base64_encode.js"></script>

    <!-- Styles and scripts for page operation -->
    <link rel="stylesheet" type="text/css" href="style.css">
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="script.js"></script>

    <!-- Script to load API data from server into sandboxObj prototype -->
    <script type="text/javascript" nonce="${sessionScope.cspNonce}" >
      /**
       * Base URI for webservice to be passed to Javascript sandboxObj
       *
       * @constant {String}
       */
      sandboxObj.prototype.webserviceUri = "<%= sandbox.getBaseUri() %>";
    </script>
    <script nonce="${sessionScope.cspNonce}" type="text/javascript" src="apiVars.js"></script>
  </head>

  <body>
   	<% if (request.getParameter("all") != null)	{ %>
   			<script type="text/javascript" nonce="${sessionScope.cspNonce}" ><%= sandbox.getHelpPageHtml() %></script>
   			<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="dynamicTree.js"></script>
   			<script type="text/javascript" nonce="${sessionScope.cspNonce}" >sandboxObj.prototype.apis = dynamicTree;</script>
   	<% } else { %>
   			<script nonce="${sessionScope.cspNonce}" type="text/javascript" src="staticTree.jsp"></script>
   			<script type="text/javascript" nonce="${sessionScope.cspNonce}" >sandboxObj.prototype.apis = staticTree;</script>
   	<% } %>

    <div id="header">
      <h1>REST Webservice API Sandbox</h1>
      <p>
        For more information regarding specific commands, visit
        <a target="_blank" href="http://documentation.commvault.com/commvault/v11/article?p=features/rest_api/test_environment_sandbox.htm">our documentation page</a>.
      </p>
      <hr><hr>
    </div>

    <div id="apiTreeContainer">
      <h3 class="divHeader">Webservice APIs</h3><hr>
      <input type="text" id="searchbar" placeholder="Search..." autofocus>

      <div id="apiListDiv"><ul></ul></div>
    </div>

    <div id="requestAndResponse">
      <table id="headerTable">
        <tr>
          <td class="align-left" id="headersAndFormatContainer">
            <input type="checkbox" id="headersOn" checked><label for="headersOn">Show headers</label><br>
            <span id="requestRadio">
              <input type="radio" name="requestRadio" id="xmlRequestRadio" checked><label for="xmlRequestRadio">XML</label>
              <input type="radio" name="requestRadio" id="jsonRequestRadio"><label for="jsonRequestRadio">JSON</label>
            </span>
          </td>
          <td class="align-center" id="uriContainer"><input type="text" id="apiUriInput" readonly value="INIT"></td>
          <td id="buttonContainer">
            <button id="invokeButton">&nbsp;&nbsp;&nbsp;Invoke&nbsp;&nbsp;&nbsp;</button>
          </td>
        </tr>
      </table>

      <div id="requestDiv">
        <a class="textareaHeader">Request Body</a> <span class="hideShowLink">(<a href="javascript:void(0)">hide</a>)</span>
        <textarea id="requestContent" placeholder="API request content"></textarea>
      </div>

      <div id="responseDiv">
        <a class="textareaHeader">Response Body</a> <span class="hideShowLink">(<a href="javascript:void(0)">hide</a>)</span>
        <textarea id="responseContent" placeholder="API response content"></textarea>
      </div>
    </div>

    <div id="detailsAndParams">
      <div id="scrollbarFrame">
        <h3 class="divHeader">Variables/Request Parameters</h3>
        <hr>

        <div id="reqParams">
          <span id="apiParamsSpan"></span>
        </div>

        <h3 class="divHeader">Description</h3>
        <hr>
        <br>
        <span id="apiDescriptionSpan">INIT</span>
      </div>
    </div>
  </body>
</html>