/**
 * @author Ryan Cebulko
 */

/**
 * API tree to be built by parsing the "*.svc/help" page
 *
 * @type {API_OBJECT}
 * @global
 */
var dynamicTree = { "__self__": { "key": "" } };

/**
 * Traverses the API tree following the path and adds appends the method
 * object, creating children when necessary
 *
 * @param  {Array<String>} path An array of strings in order of depth in the API tree
 * @param  {String} method A string extracted from the help page (GET|POST|PUT|DELETE)
 * @param  {METHOD_OBJECT} methodObj An object with an API's description, snippet, and any parameters
*/
function addToTree(path, method, methodObj) {
  // Current node on the tree
  var self = dynamicTree;

  // Climb down the tree, creating children when necessary
  for (var i = 0; i < path.length; ++i) {
    if (typeof self[path[i]] === "undefined") self[path[i]] = { "__self__": { "key": path[i] } };
    self = self[path[i]];
  }

  // Append the method object with the method string as the key
  self["__self__"][method] = methodObj;
}

// Backreference for rows with no URI column
var tempPath;

// Lookup table to convert the page's method strings to the strings the sandbox is expecting
var methodLookup = {
  "GET":    "get",
  "POST":   "post",
  "PUT":    "put",
  "DELETE": "del"
};

// Iterate over each row, not including the header or the web service by itself
$("table > tbody > tr:not(:first-child, :nth-child(2))", $(helppageHtml)).each(function() {
  // Counter to handle cases where <tr> elements have 2 instead of 3 <td> children
  var count = $("td", this).length - 1;

  // When there is a URI, split it into a path array and cache it
  if (count == 2) {
    tempPath = $("td:nth-child(1)", this).html().split("/");
    if (tempPath[0] === "") tempPath.shift();
    if (tempPath[tempPath.length - 1] === "") tempPath.pop();
  }

  // Full method string
  var meth = $("td:nth-child(" + count + ") > a", this).html();

  // [[METHOD_OBJECT]] to add to API tree
  var methObj = {
    "description": $("td:nth-child(" + (count + 1) + ")", this).html(),
    "snippet": meth
  };

  // Array of all GET parameters
  var params = $("td:nth-child(" + count + ")", this).attr("title").split("?")[1];

  // If there are parameters on the URI include them in the method object
  if (typeof params !== "undefined") {
    params = params.split("&");
    for (var i = 0; i < params.length; ++i) params[i] = params[i].split("=")[0];
    methObj.params = params;
  }

  // Add the API from the row to the tree
  addToTree(tempPath, methodLookup[meth], methObj);
});