<%
 	String HOST = "{webserver_host_name}";
	String PORT = ":{webserver_port}";
	String PATH = "/SearchSvc/CVWebService.svc";
	String USER = "username";
	String PASS = "password";
	String PASS64 = "cGFzc3dvcmQ=";
%>
<!DOCTYPE HTML>
<!-- @author Ryan Cebulko -->
<html>
  <head>
	<jsp:include page="/common/search-engine.jsp" />
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <meta charset="UTF-8">

    <title>REST Webservice API - Getting Started</title>

    <!-- References local favicon. Should be updated when integrated. -->
    <link rel="shortcut icon" href="../util/favicon.png">

    <!-- Stylesheet to use for testing outside of documentation.commvault.com; should be removed if integrated into docs. -->
    <link rel="stylesheet" type="text/css" href="install.css">

    <style type="text/css">
      .code {
        width: 800px;
        margin: 10px 0 10px 10px;
        padding: 10px;
        background-color: #EEE;
        border: solid black 2px;
        font-family: "Lucida Console";
        font-size: 10pt;
        word-wrap: break-word;
      }

      .breakall { word-break: break-all; }

      .highlight { background-color: #EE8; }

      td.tipgif { background-image: url("tip.gif"); }
    </style>
  </head>

  <body>
    <h1>Getting Started</h1>
    <i>
      The REST Webservice API allows third-party applications to integrate with Commvault software and data.
      <br>This documentation provides a brief overview of the authorization and invocation process for making these API calls.
    </i>

    <h3>Authorizing a Request</h3>

    <h4>Requesting an authorization token</h4>
    <p>In order to utilize the functionality provided by the REST Webservice API, you need an authorization token.</p>
    <p>Use the following steps to request a login token and use it to make API calls.</p>
    <p>Note: In the example requests and responses, the italicized text represents the message headers.</p>
    <ol>
      <li>
        <p>
          To log into the Web Console and get a token, you will need to form an XML
          snippet containing your username and a base-64 encoded version of your
          password.
        </p>
        <p>
          Using the
          username "<%= USER %>" and the password "<%= PASS %>" (base-64 encoding "<%= PASS %>"
          returns the string "<%= PASS64 %>") yields the following:
        </p>
        <div class="code">
          &lt;DM2ContentIndexing_CheckCredentialReq mode="Webconsole" username="<%= USER %>" password="<%= PASS64 %>" /&gt;
        </div>

        <table class="tip" height="45">
          <tbody>
            <tr>
              <td class="tipgif">&nbsp;</td>
              <td class="tiptext">
                <p>Some programming languages offer native support for base-64 encocding; in others, you have to implement it on your own.</p>
                <p>See the documentation of your target language for more information.</p>
              </td>
            </tr>
          </tbody>
        </table>
      </li>

      <li>
        <p>This XML must be sent via a POST request to the Login API at <b>http://<%= HOST + PORT + PATH %>/Login</b>.</p>
        <p>The implementation details of making an HTTP request vary depending upon the development environment.
        <p>The full request, with headers, looks like this:</p>
        <div class="code">
          <i>
            POST <%= PATH %>/Login HTTP/1.1
            <br>Host: <%= HOST + PORT %>
            <br>Content-Length: 96
          </i>
          <br>
          <br>&lt;DM2ContentIndexing_CheckCredentialReq mode="Webconsole" username="<%= USER %>" password="<%= PASS64 %>" /&gt;
        </div>
      </li>

      <li>
        <p>The next step is to extract the token from the server response.</p>
        <p>If the credentials are valid, you will get a response resembling the following:</p>
        <div class="code breakall">
          <i>
            HTTP/1.1 200 OK
            <br>Content-Length: 688
            <br>Content-Type: application/xml; charset=utf-8
            <br>Server: Microsoft-IIS/7.5
            <br>X-Powered-By: ASP.NET
            <br>Date: Mon, 15 Jul 2013 17:00:00 GMT
          </i>
          <br>
          <br>&lt;DM2ContentIndexing_CheckCredentialResp aliasName="1" userGUID="8DDB1E31-53B0-46B0-AE2D-A5E5EC5916DE" token="<span class="highlight"><!--
         -->QSDK 3da1d6319fa55ce391685827bd8f1c2da180e7638555fdf674945699d63b853b8e053080fde33c38693352e26a72becc4d3684e3c53b2d5b66bded9bfeb823fd275221de82231627aeb2eeb4e997e60f86b545b86e512dc9f0aadfb947cdf89ddd662eb8bf8e933153a0dd4c73b2e62b61d889a0838e4d454ee3d4e5454ada2651aeb74f7da554199db9f6a77b05916c825e0e8bf04aa1c0f4b75dee1b89fe5d7f6912605c3598db125d37e5bc4a23a0803ea28eb20235554a4e34c8b24b7c026bf9e243b98c0ce37b93c7ee6c20c98e995b3b3ed8a20ccf6a53ca7c66090d2a3a23b408aaf1a523c298d90a6f95e27cec3fec2bf4431ae1d47db261c3a2b5fbc5f950f6e3f75aa972512e837c542b049<!--
       --></span>" ccn="0" userName="<%= USER %>" /&gt;
        </div>
        <p>The highlighted region shows the full token; note that it starts with "QSDK", followed by a space, followed by a 545-character alphanumeric string.</p>
      </li>
    </ol>

    <h4>Using the authorization token</h4>
    <p>The full token received from the server must be included in the request header for all future API calls.</p>
    <p>A header should be added to the request with <i>Cookie2</i> as the key and the authorization token as the value.</p>
    <p>For example, the <b>/Client</b> API can be called to retrieve a listing of all client machines.</p>
    <p>The full request, with headers, looks like this:</p>
    <div class="code breakall">
      <i>
        GET <%= PATH %>/Client HTTP/1.1
        <br>Host: <%= HOST + PORT %>
        <br>Accept: application/xml
        <br>Cookie2: QSDK 3da1d6319fa55ce391685827bd8f1c2da180e7638555fdf674945699d63b853b8e053080fde33c38693352e26a72becc4d3684e3c53b2d5b66bded9bfeb823fd275221de82231627aeb2eeb4e997e60f86b545b86e512dc9f0aadfb947cdf89ddd662eb8bf8e933153a0dd4c73b2e62b61d889a0838e4d454ee3d4e5454ada2651aeb74f7da554199db9f6a77b05916c825e0e8bf04aa1c0f4b75dee1b89fe5d7f6912605c3598db125d37e5bc4a23a0803ea28eb20235554a4e34c8b24b7c026bf9e243b98c0ce37b93c7ee6c20c98e995b3b3ed8a20ccf6a53ca7c66090d2a3a23b408aaf1a523c298d90a6f95e27cec3fec2bf4431ae1d47db261c3a2b5fbc5f950f6e3f75aa972512e837c542b049
      </i>
    </div>
    <p>The server will respond an XML structure listing the clients.</p>

    <h3>Making API Calls</h3>

    <h4>Chaining API calls</h4>
    <p>
      To request the properties of a specific client, you can invoke the
      <b>/Client/{clientId}</b>
      API and replace
      <b>{clientId}</b>
      with the ID of the desired client machine.
    </p>
    <p>
      For example, to get the properties of client machine 2, you would make a GET request to
      <b>/Client/2</b> as shown below.
    </p>
    <p>The full request, with headers, looks like this:</p>
    <div class="code">
      <i>
        GET <%= PATH %>/Client/2 HTTP/1.1
        <br>Host: <%= HOST + PORT %>
        <br>Accept: application/xml
        <br>Cookie2: QSDK 3da1d6319f3f75a[...]a972512e837c542
      </i>
    </div>
    <p>The response will contain XML describing the properties of the requested client, as shown below.</p>
    <p>The response, with headers, looks like this:</p>
    <div class="code">
      <i>
        HTTP/1.1 200 OK
        <br>Content-Length: 13397
        <br>Content-Type: application/xml; charset=utf-8
        <br>Server: Microsoft-IIS/7.5
        <br>X-Powered-By: ASP.NET
        <br>Date: Mon, 15 Jul 2013 17:00:00 GMT
      </i>
      <br>
      <br>&lt;?xml version="1.0" encoding="UTF-8" standalone="no" ?&gt;
      <br>&lt;App_GetClientPropertiesResponse&gt;
      <br>
      <br>&nbsp;&nbsp;&lt;clientProperties&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;ActivePhysicalNode clientId="2" clientName="devsrv" hostName="<%= HOST %>"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;AdvancedFeatures LicenseId="1" LicenseName="Server File System"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;AdvancedFeatures LicenseId="11" LicenseName="MediaAgent"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;AdvancedFeatures LicenseId="63" LicenseName="File System Archiving"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;client ClockSkewInSeconds="-1" clientDescription="Test_Client" cvdPort="8400" evmgrcPort="8402" installDirectory="E:\Simpana"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;TimeZone TimeZoneName="(UTC-05:00) Eastern Time (US &amp; Canada)"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;clientEntity clientId="2" clientName="devsrv" commCellName="<%= HOST %>" hostName="<%= HOST %>"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;origCommCell commCellId="0"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;osInfo SubType="Server" Type="Windows" osId="210"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;OsDisplayInfo OSName="Windows Server 2008 R2 Standard" ProcessorType="WinX64"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/osInfo&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;versionInfo UpdateStatus="UP_TO_DATE" version="ServicePack:3,AdditionalUpdates:,SRMDeletedSubclientSumandAntivirusCountissue(1919),TomcatManagerFix(2183),DLPFSA(4490),sCASServerNameRegistryFix(4491),FixForMailboxArchiverSubclient(4493),SystemStateDCBackupFail(4494),SPDBForiegnLangSupport(4495),RemoveObsoleteJars(4496)"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;GalaxyRelease ReleaseString="10"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;PatchStatus BaselineStatus="UP_TO_DATE" BaselineUpdates=""&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;packageInfo packageName="File System Core"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/PatchStatus&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;PatchStatus BaselineStatus="UP_TO_DATE" BaselineUpdates=""&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;packageInfo packageName="CommServe"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/PatchStatus&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;PatchStatus BaselineStatus="UP_TO_DATE" BaselineUpdates=""&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;packageInfo packageName="WorkFlow Engine"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/PatchStatus&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/versionInfo&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;/client&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.<br>
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.<br>
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.<br>
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;clusterClientProperties configureClusterClient="false" showAllAgents="false"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;pseudoClientInfo&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;openVMSProperties cvdPort="8400"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;userAccount password="" userName=""/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/openVMSProperties&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;/pseudoClientInfo&gt;
      <br>&nbsp;&nbsp;&lt;/clientProperties&gt;
      <br>
      <br>&lt;/App_GetClientPropertiesResponse&gt;
    </div>

    <h4>Updating the properties of an entity</h4>
    <p>Updating properties of clients, subclients, backupsets, etc. is accomplished with a POST request to the appropriate API.</p>
    <p>Your POST body must contain the tags of the entities you are altering, nested within their parent tags.</p>
    <p>The following changes the description (in the <b>&lt;client&gt;</b> tag) of the above client from "Test_Client" to "Example_Client"</p>
    <div class="code">
      <i>
        POST <%= PATH %>/Client/2 HTTP/1.1
        <br>Host: <%= HOST + PORT %>
        <br>Accept: application/xml
        <br>Cookie2: QSDK 3da1d6319f3f75a[...]a972512e837c542
        <br>Content-Type: application/xml
        <br>Content-Length: 317
      </i>
      <br>
      <br>&lt;?xml version="1.0" encoding="UTF-8" standalone="no" ?&gt;
      <br>&lt;App_UpdateClientPropertiesRequest&gt;
      <br>
      <br>&nbsp;&nbsp;&lt;clientProperties&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;client clientDescription="Example_Client"&gt;&lt;/client&gt;
      <br>&nbsp;&nbsp;&lt;/clientProperties&gt;
      <br>
      <br>&lt;/App_UpdateClientPropertiesRequest&gt;
    </div>

    <p>
      If the property update is successful, the
      <b>&lt;response&gt;</b>
      tag in the web service reply will have a "0" value for its
      <b>errorCode</b> and <b>warningMessage</b> attributes.
    </p>
    <p>This can be seen in the response XML below:</p>
    <div class="code">
      <i>
        HTTP/1.1 200 OK
        <br>Content-Length: 366
        <br>Content-Type: application/xml; charset=utf-8
        <br>Server: Microsoft-IIS/7.5
        <br>X-Powered-By: ASP.NET
        <br>Date: Mon, 15 Jul 2013 17:00:00 GMT
      </i>
      <br>
      <br>&lt;?xml version="1.0" encoding="UTF-8" standalone="no" ?&gt;
      <br>&lt;App_SetClientPropertiesResponse&gt;
      <br>
      <br>&nbsp;&nbsp;&lt;response
      <span class="highlight">errorCode="0"</span>
      <span class="highlight">warningCode="0"</span> warningMessage=""&gt;
      &nbsp;&nbsp;&nbsp;&nbsp;&lt;entity _type_="ROOT_ENTITY" clientId="2" clientName="devsrv" clientSidePackage="true" consumeLicense="true" <br>srmReportSet="0" srmReportType="0" type="GALAXY"/&gt;
      <br>&nbsp;&nbsp;&lt;/response&gt;
      <br>
      <br>&lt;/App_SetClientPropertiesResponse&gt;
    </div>

    <p>The updated description can be seen by making another GET request to <b>/Client/2</b>:</p>
    <div class="code">
      <i>
        HTTP/1.1 200 OK
        <br>Content-Length: 13397
        <br>Content-Type: application/xml; charset=utf-8
        <br>Server: Microsoft-IIS/7.5
        <br>X-Powered-By: ASP.NET
        <br>Date: Mon, 15 Jul 2013 17:00:00 GMT
      </i>
      <br>
      <br>&lt;?xml version="1.0" encoding="UTF-8" standalone="no" ?&gt;
      <br>&lt;App_GetClientPropertiesResponse&gt;
      <br>
      <br>&nbsp;&nbsp;&lt;clientProperties&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;ActivePhysicalNode clientId="2" clientName="devsrv" hostName="<%= HOST %>"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;AdvancedFeatures LicenseId="1" LicenseName="Server File System"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;AdvancedFeatures LicenseId="11" LicenseName="MediaAgent"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;AdvancedFeatures LicenseId="63" LicenseName="File System Archiving"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;client ClockSkewInSeconds="-1" <span class="highlight">clientDescription="Test_Client"</span> cvdPort="8400" evmgrcPort="8402" installDirectory="E:\Simpana"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;TimeZone TimeZoneName="(UTC-05:00) Eastern Time (US &amp; Canada)"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;clientEntity clientId="2" clientName="devsrv" commCellName="<%= HOST %>" hostName="<%= HOST %>"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;origCommCell commCellId="0"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;osInfo SubType="Server" Type="Windows" osId="210"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;OsDisplayInfo OSName="Windows Server 2008 R2 Standard" ProcessorType="WinX64"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/osInfo&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;versionInfo UpdateStatus="UP_TO_DATE" version="ServicePack:3,AdditionalUpdates:,SRMDeletedSubclientSumandAntivirusCountissue(1919),TomcatManagerFix(2183),DLPFSA(4490),sCASServerNameRegistryFix(4491),FixForMailboxArchiverSubclient(4493),SystemStateDCBackupFail(4494),SPDBForiegnLangSupport(4495),RemoveObsoleteJars(4496)"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;GalaxyRelease ReleaseString="10"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;PatchStatus BaselineStatus="UP_TO_DATE" BaselineUpdates=""&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;packageInfo packageName="File System Core"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/PatchStatus&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;PatchStatus BaselineStatus="UP_TO_DATE" BaselineUpdates=""&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;packageInfo packageName="CommServe"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/PatchStatus&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;PatchStatus BaselineStatus="UP_TO_DATE" BaselineUpdates=""&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;packageInfo packageName="WorkFlow Engine"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/PatchStatus&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/versionInfo&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;/client&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.<br>
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.<br>
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;.<br>
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;clusterClientProperties configureClusterClient="false" showAllAgents="false"/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;pseudoClientInfo&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;openVMSProperties cvdPort="8400"&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;userAccount password="" userName=""/&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/openVMSProperties&gt;
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;/pseudoClientInfo&gt;
      <br>&nbsp;&nbsp;&lt;/clientProperties&gt;
      <br>
      <br>&lt;/App_GetClientPropertiesResponse&gt;
    </div>

    <h4>Selecting a request format</h4>
    <p>You can also POST updates in JSON format.</p>
    <p>When making the API call, be sure to set the appropriate <i>Content-type</i> header.</p>
    <p>To perform the operation shown above 7 using the JSON format, the following request would be made:</p>
    <div class="code">
      <i>
        POST <%= PATH %>/Client/2 HTTP/1.1
        <br>Host: <%= HOST + PORT %>
        <br>Accept: application/json
        <br>Cookie2: QSDK 3da1d6319f3f75a[...]a972512e837c542
        <br>Content-Type: <span class="highlight">application/json</span>
        <br>Content-Length: 172
      </i>
      <br>
      <br>{
      <br>&nbsp;&nbsp;"App_GetClientPropertiesResponse": {
      <br>&nbsp;&nbsp;&nbsp;&nbsp;"clientProperties": {
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"client": {
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"@clientDescription": "Example_Client"
      <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;}
      <br>&nbsp;&nbsp;&nbsp;&nbsp;}
      <br>&nbsp;&nbsp;}
      <br>}
    </div>
    <table class="tip" height="45">
      <tbody>
        <tr>
          <td class="tipgif">&nbsp;</td>
          <td class="tiptext">
            <p>When dealing with a JSON object, it should have the same structure as the XML.</p>
            <p>XML attributes will be keys starting with the "@" symbol in the corresponding JSON object.</p>
          </td>
        </tr>
      </tbody>
    </table>

    <h4>Selecting a response format</h4>
    <p>
      If you would prefer the response for any API call (except
      <b>Login</b>) in JSON format, you can request JSON in the <i>Accept</i> request header:
    </p>
    <div class="code">
      <i>
        GET <%= PATH %>/Client HTTP/1.1
        <br>Host: <%= HOST + PORT %>
        <br><span class="highlight">Accept: application/json</span>
        <br>Cookie2: QSDK 3da1d6319f3f75a[...]a972512e837c542
      </i>
    </div>
    <p>The web service will reply with a JSON object that follows the same structure as the XML.</p>
  </body>
</html>