<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!-- HTML for static distribution bundle build -->
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8">
    <title>Commvault API Explorer</title>
    <link rel="stylesheet" type="text/css" href="../lib/swagger/css/swagger-ui.css" >
    <link rel="shortcut icon" href="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/favicon.png" />

    <style>
      html
      {
        box-sizing: border-box;
        overflow: -moz-scrollbars-vertical;
        overflow-y: scroll;
      }

      *,
      *:before,
      *:after
      {
        box-sizing: inherit;
      }

      body
      {
        margin:0;
        background: #fafafa;
      }
    </style>
  </head>

  <body>
    <div id="swagger-ui"></div>

    <script nonce="${sessionScope.cspNonce}" src="../lib/swagger/swagger-ui-bundle.js" charset="UTF-8"> </script>
    <script nonce="${sessionScope.cspNonce}" src="../lib/swagger/swagger-ui-standalone-preset.js" charset="UTF-8"> </script>
    <script nonce="${sessionScope.cspNonce}">
    window.onload = function() {

      // Build a system
      const ui = SwaggerUIBundle({
		urls: [
      {url: "apiJson/v2_all.json", name: "ALL"},
      {url: "apiJson/v2.json", name: "v2"},
      {url: "apiJson/OpenAPI3.yaml", name: "AG"}
    ],
        dom_id: '#swagger-ui',
        deepLinking: true,
        defaultModelsExpandDepth: 0,  // Collapse the schemas section by default so that the page is not too long
		requestInterceptor: function(request) {
			return request;
		},
        presets: [
          SwaggerUIBundle.presets.apis,
          SwaggerUIStandalonePreset
        ],
        plugins: [
          SwaggerUIBundle.plugins.DownloadUrl
        ],
        layout: "StandaloneLayout",
		validatorUrl: null
      })

      window.ui = ui
    }
  </script>
  </body>
</html>
