<!DOCTYPE html>
<html lang="en">
<head>
	<jsp:include page="/common/search-engine.jsp" />
	<title>Protocol Test</title>
	<style>
		textarea{
			width:800px;
			height:150px;
		}
		input[type=text]{
			width:200px;
		}
	</style>
<jsp:include page="../common/jquery.jsp" >
	<jsp:param value="false" name="includeExtras" />
</jsp:include>
	<script nonce="${sessionScope.cspNonce}" src="prettyprint.js"></script>
	<script nonce="${sessionScope.cspNonce}" >
		/* $(document).ready(function(evt){
			$.post("/server/protocolTest", {username:$("#username").val(),password:$("#password").val(),api:$("#api").val(),req:$("#req").val()}, function(data){
				$("#resp").val(data);
			});
		}); */
		$(document).ready(function(evt){
			$("#testBtn").click(function(){
				$("#detail").empty();
				$("#resp").val("");
				if($.trim($("#api").val()).length == 0) {
					alert("API is required");
					return;
				}
				$("#testBtn").attr("value","Processing...");
				$("#testBtn").attr("disabled","true");
				$.post("/" + window.location.pathname.split("/")[1] + "/server/protocolTest", {headers: $("#headers").val(), accept: $("#accept").val(), method:$("#method").val(), api:$("#api").val(),req:$("#req").val(),contentType:$("#contentType").val()}, function(data){
					$("#testBtn").attr("value","Test");
					$("#testBtn").removeAttr("disabled");
					$("#resp").val(data);
					$("#detail").append((prettyPrint($.parseJSON( data ), {
					    maxArray: 100,
					    expanded: false,
					    maxDepth: 100
					})));
				}).error(function(){
					alert("There was an error processing request. Check logs.");
					$("#testBtn").attr("value","Test");
					$("#testBtn").removeAttr("disabled");
				});
			});
			function readCookie(name) {
				var nameEQ = name + "=";
				var ca = document.cookie.split(';');
				for ( var i = 0; i < ca.length; i++) {
					var c = ca[i];
					while (c.charAt(0) == ' ')
						c = c.substring(1, c.length);
					if (c.indexOf(nameEQ) == 0)
						return c.substring(nameEQ.length, c.length);
				}
				return null;
			};

			$(document).bind("ajaxSend", function(elm, xhr, s) {
				if (s.type == "POST") {
					var csrfParam = readCookie('csrf');
					if(s.data != null && s.data != '' && s.data instanceof FormData) {
						s.data.append("csrf", csrfParam);
						s.url += "?csrf=" + csrfParam;
					} else if(s.data != null && s.data != ''){
						s.data = s.data + "&csrf=" + csrfParam;
					} else {
						s.data = "csrf=" + csrfParam;
					}
					xhr.setRequestHeader('X-CSRF-Token', readCookie("cv.web.CSRF_AJAX"));
					xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
				}
			});
		});
	</script>
</head>
<body>
	<form>
		<table>
			<!-- <tr>
				<td>Username: </td>
				<td><input type="text" id="username" value="admin"/></td>
			</tr>
			<tr>
				<td>Password: </td>
				<td><input type="password" id="pwd" value="admin"/></td>
			</tr>
			<tr>
				<td>Host: </td>
				<td><input type="text" id="host" value=""/></td>
			</tr> -->
			<tr>
				<td>Content Type: </td>
				<td><input type="text" id="contentType" value="application/xml"/></td>
			</tr>
			<tr>
				<td>Accept: </td>
				<td><input type="text" id="accept" value="application/json"/></td>
			</tr>
			<tr>
				<td>Custom Headers: </td>
				<td>
					<textarea id="headers"></textarea>
				</td>
			</tr>
			<tr>
				<td>API: </td>
				<td><input type="text" id="api" value=""/></td>
			</tr>
			<tr>
				<td>Method: </td>
				<td>
					<select id="method">
						<option value="post">POST</option>
						<option value="get">GET</option>
						<option value="put">PUT</option>
						<option value="delete">DELETE</option>
					</select>
				</td>
			</tr>
			<tr>
				<td>Request: </td>
				<td>
					<textarea id="req"></textarea>
				</td>
			</tr>
			<tr>
				<td>Response: </td>
				<td>
					<textarea id="resp"></textarea>
				</td>
			</tr>
			<tr>
				<td colspan="2"><input id="testBtn" type="button" value="Test"/></td>
			</tr>
		</table>
	</form>
	<br/>
	<a href="${pageContext.request.contextPath}/doLogout.do">Logout</a>
	<div id="detail"></div>
</body>
</html>