<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<!-- Only the page and header titles are localized for this sample -->
<fmt:bundle basename="commvault.web.cookbook.cookbookMessages">
	<fmt:message key="sampleDataTable.title.page" var="pageTitle" />
	<fmt:message key="sampleDataTable.title.header" var="headerTitle" />
</fmt:bundle>

<jsp:include page="../../common/header.jsp">
	<jsp:param value="css/style.css" name="css" />
	<jsp:param value="../../common/css/templatestyles.css" name="css" />
	<jsp:param value="../../common/css/headerstyles.css" name="css" />
	<jsp:param value="css/browsestyles.css" name="css" />

	<jsp:param value="true" name="includeJqueryUI" />
	<jsp:param value="../../common/js/jquery.dataTables.min.js" name="js" />

	<jsp:param value="${pageTitle}" name="titleLocalized" />
	<jsp:param value="${headerTitle}" name="headerTitleLocalized" />
	<jsp:param value="true" name="includeSecHeader" />
</jsp:include>

<div id="datatable_wrapper" class="dataTables_wrapper">
	<table id="sampletable" class="tablesorter">
		<col width='5%'>
		<col width='15%'>
		<col width='20%'>
		<col width='20%'>
		<col width='20%'>
		<col width='20%'>
		<thead>
			<tr>
				<th>Inv No</th>
				<th>Date</th>
				<th>Client</th>
				<th>Tax</th>
				<th>Total</th>
				<th>Notes</th>
			</tr>
		</thead>
		<tbody id="sampletablebody"></tbody>
	</table>
</div>

<script nonce="${sessionScope.cspNonce}" >
	sampleTable = $('#sampletable').dataTable(
			{ "bProcessing" : false, "bServerSide" : true, "bFilter" : false, "bPaginate" : false,
				"sAjaxSource" : cvUtil.getContextPath() + "/cookbook/dataTables/sampleDataTableLoadData.do" });
</script>

<jsp:include page="../../common/footer.jsp" />