(function() {
	'use strict';

	angular.module('cvLocalization', []).filter('i18n', [ 'localMsg', 'cvLoc', function(localMsg, cvLoc) {
		return cvLoc;
	} ]);

	// this can be in a separate file, but should load after the filter is loaded
	angular.module('cvLocalization').value('localMsg', localMsg);

	angular.module('cvLocalization').factory('cvLoc', function(localMsg) {
		return function(text) {
			var result = '';
			if (localMsg.hasOwnProperty(text)) {
				result = localMsg[text];
			} else {
				result = '???' + text + '???';
			}

			if (arguments.length > 1) {
				for (var i = 0; i < arguments.length - 1; i++) {
					result = result.replace('{' + i + '}', arguments[i + 1]);
				}
			}
			return result;
		};
	});

	//for ngGrid - these strings are defined in common messagesJs.properties
	window.ngGrid.i18n['en'] = {
		/*
		 * ngAggregateLabel : 'items', ngGroupPanelDescription : 'Drag a column header here and drop it to group
		 * by that column.', ngSearchPlaceHolder : 'Search...', ngMenuText : 'Choose Columns:',
		 * ngShowingItemsLabel : 'Showing Items:',
		 */
		ngTotalItemsLabel : localMsg['ngTotalItemsLabel'],
		ngSelectedItemsLabel : localMsg['ngSelectedItemsLabel'],
		ngPageSizeLabel : localMsg['ngPageSizeLabel'],
		ngPagerFirstTitle : localMsg['ngPagerFirstTitle'],
		ngPagerNextTitle : localMsg['ngPagerNextTitle'],
		ngPagerPrevTitle : localMsg['ngPagerPrevTitle'],
		ngPagerLastTitle : localMsg['ngPagerLastTitle']
	};
})();