(function() {
	'use strict';

	var cvCommon = angular.module('cvCommon');

	/*
	 * Directive used to create Modal
	 */
	cvCommon.directive('cvComponent', [ '$modal', '$http', '$compile', '$log', function($modal, $http, $compile, $log) {
		return {
			restrict : 'A',
			compile : function(ele, attrs) {
				$log.debug('Compiling now: ' + attrs.cvComponent);
				if (!service.isVisible(attrs.cvComponent)) {
					ele.html('');
					return null;
				}
			}
		};
	} ]);

	/*
	 * Directive used to create Modal
	 */
	cvCommon
			.directive(
					'cvModal',
					[
							'$modal',
							'$http',
							'$compile',
							function($modal, $http, $compile) {
								return {
									restrict : 'AE',
									scope : true,
									conroller : function($scope, $element) {

									},
									link : function(scope, ele, attrs) {
										// On click of the cv-modal assign a event for opening the model
										ele
												.on(
														"click",
														function() {
															// Get the HTML template user has defined for the modal 
															$http
																	.get(scope.modalInfo.templateUrl)
																	.success(
																			function(data) {

																				// Add header and footer section to the title

																				var templateData = null;
																				var headerText = "{{modalInfo.headerText()}}";
																				var headerHTML = "<div class='setup-title'><h1>"
																						+ headerText + "</h1></div>";
																				var footerSaveText = scope.modalInfo
																						.okButtonText();
																				var footerCancelText = scope.modalInfo
																						.cancelButtonText();
																				var footerHTML = "<div class='button-container'><button type='button' class='btn btn-default' ng-click='cancel()'>"
																						+ footerCancelText
																						+ "</button><button class='btn btn-primary' ng-click='save()'>"
																						+ footerSaveText
																						+ "</button></div>";

																				templateData = angular.element(data);

																				templateData.find(".setup-content")
																						.before(headerHTML);

																				templateData.find('form').append(
																						footerHTML);

																				// Define the actual modal here
																				$modal
																						.open({
																							template : templateData,
																							windowClass : scope.modalInfo.windowClass,
																							backdrop : scope.modalInfo.backdrop,
																							controller : function(
																									$scope,
																									$modalInstance,
																									$rootElement,
																									$compile, $http) {

																								// Call the init function of the modalInfo to initialize any values needed in the modal.
																								scope.modalInfo
																										.init($scope);

																								// Add cancel handler for the modal
																								$scope.cancel = function() {
																									$modalInstance
																											.dismiss('cancel');
																								};

																								// Add save handler for the modal
																								$scope.save = function() {

																									/*
																									 * Inject
																									 * all the
																									 * services
																									 * and
																									 * variables
																									 * required
																									 * for the
																									 * save
																									 * handler
																									 * along
																									 * with
																									 * modalInstance
																									 * service
																									 * which
																									 * will
																									 * help to
																									 * do
																									 * operation
																									 * with
																									 * the
																									 * modal
																									 */
																									var $injector = $rootElement
																											.injector();
																									$injector
																											.invoke(
																													scope.modalInfo.saveAction,
																													this,
																													angular
																															.extend(
																																	scope.modalInfo.resolve,
																																	{
																																		'$modalInstance' : $modalInstance,
																																		'modalScope' : $scope
																																	}))
																								};

																							},
																							resolve : scope.modalInfo.resolve
																						});
																			});
														});

									}
								};
							} ]);

	/*
	 * Directive for bread crumbs
	 */
	cvCommon.directive('cvBreadcrumb', function() {
		return {
			restrict : 'AE',
			scope : {
				breadcrumbModel : '=ngModel',
				itemTemplate : '=itemTemplate'
			},
			templateUrl : appUtil.appRoot + 'common/partials/breadcrumbs.html'
		};
	});

	//	-----------remove this block-----------
	//	SEE how the tile-directive works, 
	//	example commented in serverDetails.jsp 
	//	and servers.ctrl.js
	//	--------------------------------------

	// Tile Object
	//	{	
	//		name	:'title of the tile',
	//		actions	:[ { actionName:'name of action',
	//				  	actionClick:'added to ng-click'}],
	//		switches:[{	switchName:'name of switch',
	//					switchState:'on or off'}],
	//		summaryProperties:[{ summaryProperty:'summary of a property'}],
	//		}

	cvCommon.directive('cvTileComponent', function() {
		return {
			restrict : 'E',
			transclude : true,
			scope : {
				tileObj : '='
			},
			templateUrl : 'common/partials/tileComponent.jsp'

		};
	});

	cvCommon.directive('cvGlobalBreadcrumb', [ 'cvBreadcrumbsTabsFactory', function(cvBreadcrumbsTabsFactory) {
		return {
			restrict : 'AE',
			templateUrl : appUtil.appRoot + 'common/partials/globalBreadcrumbs.html',
			controller : [ '$scope', function($scope) {
				cvBreadcrumbsTabsFactory.registerBcDataChangeObserver(function(newData) {
					$scope.bcData = newData;
				});
				cvBreadcrumbsTabsFactory.registerTabDataChangeObserver(function(newData) {
					$scope.tabData = newData;
				});
			} ],
			link : function(scope, ele, attrs) {
				scope.bcData = cvBreadcrumbsTabsFactory.bcData;
				scope.tabData = cvBreadcrumbsTabsFactory.tabData;
			}
		};
	} ]);

	cvCommon.factory('ajaxButtonFactory', function() {
		var ajaxButton = {};
		ajaxButton.currentButton = '';
		return ajaxButton;
	});

	cvCommon.directive('cvBusyOnAjax', [ 'ajaxButtonFactory', function(ajaxButton) {
		return {
			restrict : 'C',
			link : function(scope, ele, attrs) {
				ele.on("click", function() {
					ajaxButton.currentButton = ele;
				});
			}
		};
	} ]);

	/*
	 * Directive for commonly style checkbox.
	 * 
	 * Sample use:<cv-checkbox class="myClass" cbid="myId" label="MyLabel"></cv-checkbox>
	 */
	cvCommon.directive('cvCheckbox', function() {
		return {
			restrict : 'AE',
			replace : true,
			scope : {
				id : '@cbid',
				label : '@label',
				'class' : '@class'
			},
			template : '<span><input id="{{id}}"/><label for="{{id}}">{{label}}</label></span>'
		};
	});

	/*
	 * Directive used to validate fields that must equal each other (such as password / confirm-password).
	 * 
	 * Based on a stackoverflow post by Jan Laussmann:
	 * http://stackoverflow.com/questions/14012239/password-check-directive-in-angularjs *
	 */
	cvCommon.directive('cvEquals', [ '$parse', function($parse) {
		return {
			restrict : 'A',
			require : '?ngModel',
			link : function(scope, elem, attrs, ngModel) {
				if (!ngModel) {
					return;
				}

				// Re-validate if own value changes:
				scope.$watch(attrs.ngModel, function() {
					validate();
				});

				// Re-validate if other value changes:
				attrs.$observe('cvEquals', function(val) {
					validate();
				});

				var validate = function() {
					var val1 = ngModel.$viewValue;
					var val2 = attrs.cvEquals;

					if (val1 || val2) {
						ngModel.$setValidity('cvEquals', val1 === val2);
					}
				};
			}
		};
	} ]);

	/*
	 * Directive used to access the formController from parent scope
	 */
	cvCommon.directive('referenceFormController', [ '$rootScope', function($rootScope) {
		return {
			restrict : "A",
			require : '^form', // require FormController
			link : function(scope, element, attrs, ctrl) {
				// broadcast existence of new FormController
				$rootScope.$broadcast('referenceFormController', ctrl);
			}
		};
	} ]);

	/*
	 * Custom directive which intercepts submits to perform validation checks, so validation errors are shown
	 * to a user only once a field is interacted with or an attempt is made to submit the form.
	 * 
	 * This is based on code from: http://plnkr.co/edit/DdawkKnuSAl4Hv4t9Liq?p=preview
	 */
	cvCommon.directive('cvSubmit', [ '$parse', function($parse) {
		return {
			restrict : 'A',
			require : [ 'cvSubmit', '?form' ],
			controller : [ '$scope', function($scope) {
				this.attempted = false;
				var formController = null;

				this.setAttempted = function(tried) {
					this.attempted = tried;
				};

				this.getAttempted = function() {
					return this.attempted;
				};

				this.setFormController = function(controller) {
					formController = controller;
				};

				this.needsAttention = function(fieldModelController) {
					if (!formController) {
						return false;
					}

					if (fieldModelController) {
						return fieldModelController.$invalid && (fieldModelController.$dirty || this.attempted);
					} else {
						return formController && formController.$invalid && (formController.$dirty || this.attempted);
					}
				};
			} ],
			compile : function(cElement, cAttributes, transclude) {
				return {
					pre : function(scope, formElement, attributes, controllers) {

						var submitController = controllers[0];
						var formController = (controllers.length > 1) ? controllers[1] : null;

						submitController.setFormController(formController);

						scope.cv = scope.cv || {};
						scope.cv[attributes.name] = submitController;
					},
					post : function(scope, formElement, attributes, controllers) {

						var submitController = controllers[0];
						var formController = (controllers.length > 1) ? controllers[1] : null;
						var fn = $parse(attributes.cvSubmit);

						formElement.bind('submit', function() {
							submitController.setAttempted(true);
							if (!scope.$$phase) {
								scope.$apply();
							}

							if (!formController.$valid) {
								return false;
							}

							scope.$apply(function(event) {
								fn(scope, {
									$event : event
								});
							});
						});
					}
				};
			}
		};
	} ]);

	cvCommon.directive('time', function() {
		return {
			restrict : 'CA',
			replace : true,
			transclude : true,
			controller : function($scope, $filter) {
				$scope.format = function(time) {
					if (time <= 0) {
						return '';
					}
					return $filter('date')(time * 1000, 'yyyy-MM-dd HH:mm:ss');
				}
			},
			scope : {
				time : '@val'
			},
			template : "<div class='etime' title='{{format(time)}}'>{{format(time)}}</div>"
		};
	});
})();