//
//  Usage:
//  
//  	<cvtree tree-root="treeParent" selected-items="selectedItems" multi-select='false' load-children="loadChildren(entity)"></cvtree>
//  
//  		$scope.treeParent = {
//				'label' : 'root',
//			'children' : [ {
//				'label' : 'child1'
//			}, {
//				'label' : 'child2'
//			} ]
//		};
//		$scope.selectedItems = [];
//		$scope.loadChildren = function(entity) {
//		
//			return $http.get('children.do?parent='+entity.id); //must return array of children
//			
//		}; 

//	Parameters:
//			treeRoot : '=',
//			customTemplate : '=', //optional
//			loadChildren : '&',		//optional function to load children lazily
//			multiSelect : '@',	//default false
//			selectedItems : '=',
//			triState : '=?', //default true if multiselect is true
//			labelField : '@', //default 'label'
//			childrenField : '@' //default 'children'

(function() {
	var cvCommon = angular.module('cvCommon');

	cvCommon.directive('cvnode', function(RecursionHelper) {
		return {
			restrict : "AE",
			scope : {
				item : '=',
				treeScope : '='
			},
			templateUrl : function(element, attrs) {
				if (attrs.customTemplate) {
					return attrs.customTemplate;
				}
				return 'common/partials/cvtree.html';
			},
			//			templateUrl : 'common/partials/cvtree.html',
			compile : function(element) {
				// Use the compile function from the RecursionHelper,
				// And return the linking function(s) which it returns
				return RecursionHelper.compile(element, function(scope, elem, attrs) {
				});
			}
		};
	});

	cvCommon
			.directive(
					'cvtree',
					function() {
						return {
							restrict : "AE",
							scope : {
								treeRoot : '=',
								customTemplate : '=',
								loadChildren : '&', //optional function to load children lazily
								multiSelect : '@', //default false
								selectedItems : '=',
								triState : '=?', //default true if multiselect is true
								labelField : '@', //default 'label'
								childrenField : '@' //default 'children'
							},
							template : function(element, attrs) {
								var customTemplate = '';
								if (attrs.customTemplate) {
									customTemplate = 'custom-template="' + attrs.customTemplate + '"';
								}
								return '<div class="cvtree" ng-class="{\'multiSelect\': multiSelect==true, \'singleSelect\': isMultiSelect==false}"><cvnode '
										+ customTemplate
										+ ' tree-scope="treeScope" ng-repeat="rootItem in rootItems" tri-state="{{triState}}" item="rootItem" load-children="loadChildren()" selected-items="selectedItems"></cvnode></div>';
							},
							link : function(scope, elem, attrs) {
								scope.treeScope = scope;
								scope.isMultiSelect = scope.multiSelect == 'true'; //convert string to boolean
								scope.checkboxEnabled = scope.isMultiSelect;
								scope.labelField1 = 'label';
								if (scope.labelField) {
									scope.labelField1 = scope.labelField;
								}
								scope.childrenField1 = 'children';
								if (scope.childrenField) {
									scope.childrenField1 = scope.childrenField;
								}
								scope.wrapEntity = function(entity) {
									return {
										'entity' : entity,
										'label' : entity[scope.labelField1],
										'state' : 'collapsed',
										'children' : entity[scope.childrenField1],
										'selectedState' : '',
										'loaded' : false
									};
								}
								if (scope.isMultiSelect && (scope.triState == undefined)) {
									scope.triState = "true";
								}
								scope.isTriState = scope.triState == "true";
								scope.rootItems = [];
								if (typeof scope.treeRoot === 'object') {
									scope.rootItems.push(scope.wrapEntity(scope.treeRoot));
								} else {
									for (var i = 0; i < scope.treeRoot.length; i++) {
										scope.rootItems.push(scope.wrapEntity(treeRoot[i]));
									}
								}

								scope.toggleSelectedState = function(item) {
									if (item.selectedState == 'selected') {
										scope.deselectNode(item);
									} else {
										scope.selectNode(item);
									}
								};
								scope.deselectNode = function(item, updateParents, updateChildren) {
									delete item.selectedState;
									if (!scope.isMultiSelect) {
										scope.selectedItems.splice(0, 1);
									} else {
										var index = scope.selectedItems.indexOf(item);
										scope.selectedItems.splice(index, 1);
										if (scope.isTriState) {
											//deselect all children
											if (updateChildren !== false && item.children) {
												for (var i = 0; i < item.children.length; i++) {
													scope.deselectNode(item.children[i]);
												}
											}

											//unset partial on all parents
											if (updateParents !== false && item.parent) {
												scope.setPartial(item.parent);
											}
										}
									}
								};
								scope.selectNode = function(item, updateParents, updateChildren) {
									if (scope.isMultiSelect) {
										item.selectedState = 'selected';
										scope.selectedItems.push(item);
										if (scope.isTriState) {
											//select all children
											if (updateChildren !== false && item.children) {
												for (var i = 0; i < item.children.length; i++) {
													scope.selectNode(item.children[i], false, true);
												}
											}
											//set partial on all parents
											if (updateParents !== false && item.parent) {
												scope.setPartial(item.parent);
											}
										}
									} else {
										if (scope.selectedItems[0]) {
											delete scope.selectedItems[0].selectedState;
										}
										item.selectedState = 'selected';
										scope.selectedItems[0] = item;
									}
								};
								scope.setPartial = function(item, partialOnly) {
									//if any child unselected/selected
									var unselected = false;
									var selected = false;
									if (partialOnly) {
										item.selectedState = 'partial';
									} else if (item.children) {
										for (var i = 0; i < item.children.length; i++) {
											var child = item.children[i];
											if (child.selectedState == 'selected') {
												selected = true;
											}
											if (child.selectedState != 'selected') {
												unselected = true;
											}
											if ((child.selectedState == 'partial') || (selected && unselected)) {
												item.selectedState = 'partial';
												partialOnly = true;
												break;
											}
										}
										if (!partialOnly && selected && !unselected) {
											scope.selectNode(item, true, false);
										} else if (!partialOnly && !selected && unselected) {
											scope.deselectNode(item, true, false);
										}
									}
									if (partialOnly && item.parent) {
										scope.setPartial(item.parent, partialOnly);
									}
								};
								scope.toggleState = function(item) {
									if (item.state == 'expanded') {
										item.state = 'collapsed';
									} else {
										scope.expand(item);
									}
								};
								scope.expand = function(item) {
									if (!item.loaded) {
										if (scope.loadChildren && !item.entity.children) {
											scope.loadChildren({
												entity : item.entity
											}).then(function(children) { //if children are being loaded lazily that means we should expect a promise
												item.loading = false;
												if (children) {
													item.entity.children = children;
												}
												scope.wrapChildren(item);
												item.loaded = true;
											}, function(error) {
												item.loading = false;
												if (error && error.msg) {
													alert(error.msg); //todo
												}
											});
											item.loading = true;
										} else {
											scope.wrapChildren(item);
										}
									}
									item.state = 'expanded';
								};
								scope.wrapChildren = function(item) {
									item.children = [];
									if (item.entity.children) {
										for (var i = 0; i < item.entity.children.length; i++) {
											var child = scope.treeScope.wrapEntity(item.entity.children[i]);
											item.children.push(child);
											child.parent = item;
											if ((item.selectedState == 'selected') && scope.isMultiSelect
													&& scope.isTriState) {
												child.selectedState = item.selectedState;
												scope.selectedItems.push(child);
											}
										}
									}
								}
							}
						};
					});

	/**
	 * Based on http://stackoverflow.com/questions/14430655/recursion-in-angular-directives
	 * 
	 */
	cvCommon.factory('RecursionHelper', [ '$compile', function($compile) {
		return {
			/**
			 * Manually compiles the element, fixing the recursion loop.
			 * 
			 * @param element
			 * @param [link]
			 *            A post-link function, or an object with function(s) registered via pre and post
			 *            properties.
			 * @returns An object containing the linking functions.
			 */
			compile : function(element, link) {
				// Normalize the link parameter
				if (angular.isFunction(link)) {
					link = {
						post : link
					};
				}

				// Break the recursion loop by removing the contents
				var contents = element.contents().remove();
				var compiledContents;
				return {
					pre : (link && link.pre) ? link.pre : null,
					/**
					 * Compiles and re-adds the contents
					 */
					post : function(scope, element) {
						// Compile the contents
						if (!compiledContents) {
							compiledContents = $compile(contents);
						}
						// Re-add the compiled contents to the element
						compiledContents(scope, function(clone) {
							element.append(clone);
						});

						// Call the post-linking function, if any
						if (link && link.post) {
							link.post.apply(null, arguments);
						}
					}
				};
			}
		};
	} ]);

})();