(function() {
	'use strict';

	String.prototype.endsWith = function(suffix) {
		if (!suffix || (this.length < suffix.length)) {
			return false;
		}
		return this.indexOf(suffix, this.length - suffix.length) !== -1;
	};

	var cvCommon = angular.module('cvCommon', [ 'cvLocalization', 'notifications', 'angular-growl' ]);

	cvCommon.config([ 'growlProvider', function(growlProvider) {
		growlProvider.globalEnableHtml(true);
	} ]);

	cvCommon.readCookie = function(name) {
		var nameEQ = name + "=";
		var ca = document.cookie.split(';');
		for (var i = 0; i < ca.length; i++) {
			var c = ca[i];
			while (c.charAt(0) == ' ') {
				c = c.substring(1, c.length);
			}
			if (c.indexOf(nameEQ) == 0) {
				return c.substring(nameEQ.length, c.length);
			}
		}
		return null;
	};

	cvCommon.config(function() {
		$("form").on("submit", function() {
			var csrfParam = cvCommon.readCookie('csrf');
			$("<input type='hidden' id='csrf' name='csrf' value='" + csrfParam + "'>").appendTo($(this));
			if ($(this).attr("enctype") == "multipart/form-data") {
				var action = $(this).attr("action") + "?csrf=" + csrfParam;
				$(this).attr("action", action);
			}
			return true;
		});
	});

	/*
	 * The cvUtil service contains utility functions to be used throughout the AdminConsole application.
	 * 
	 * DO NOT ADD FUNCTIONS TO THIS SERVICE UNLESS THEY ARE GENERIC AND USEFUL TO MULTIPLE MODULES.
	 * 
	 * DO NOT ADD FUNCTIONS TO THIS SERVICE WITHOUT DOCUMENTING THEM.
	 */
	cvCommon.service('cvUtil', function($injector) {

		this.readCookie = function(name) {
			return cvCommon.readCookie(name);
		};

		/*
		 * Utility method to create a blank info message object for display in a serverMessage.message field
		 * in a jsp.
		 */
		this.emptyMsg = function() {
			return {
				message : '',
				type : 'ok'
			};
		};

		/*
		 * Utility method to create a info message object for display in a serverMessage.message field in a
		 * jsp. All strings passed into this function should be localized!
		 */
		this.infoMsg = function(message) {
			return {
				message : message.trim(),
				type : 'ok'
			};
		};

		/*
		 * Utility method to create an error message object for display in a serverMessage.message field in a
		 * jsp. All strings passed into this function should be localized!
		 */
		this.errMsg = function(message) {
			return {
				message : message.trim(),
				type : 'error'
			};
		};

		/*
		 * Utility method to create a localized info message object for display in a serverMessage.message
		 * field in a jsp. This method accepts a key for the cvLoc factory.
		 */
		this.infoMsgLoc = function(key) {
			var cvLoc = $injector.get("cvLoc");
			return {
				message : cvLoc(key),
				type : 'ok'
			};
		};

		/*
		 * Utility method to create a localized error message object for display in a serverMessage.message
		 * field in a jsp. This method accepts a key for the cvLoc factory.
		 */
		this.errMsgLoc = function(key) {
			var cvLoc = $injector.get("cvLoc");
			return {
				message : cvLoc(key),
				type : 'error'
			};
		};

		this.getDateTimeValue = function(datePickerValue, timePickerValue) {
			var toDateTime = datePickerValue;
			toDateTime.setHours(timePickerValue.getHours());
			toDateTime.setMinutes(timePickerValue.getMinutes());
			return toDateTime;
		};

		this.getUTCDateValue = function(toDateTime) {
			return new Date(toDateTime.getUTCFullYear(), toDateTime.getUTCMonth(), toDateTime.getUTCDate(), toDateTime
					.getUTCHours(), toDateTime.getUTCMinutes());
		};

		/*
		 * Creates a string for a single parameter for use in a URL. The parameter's value, if any, is
		 * escaped. Example: given "name" and "my value", returns "name=my%20val".
		 */
		this.createSingleParamString = function(name, value) {
			if (typeof value === "undefined") {
				return name;
			} else {
				return name + "=" + encodeURIComponent(value);
			}
		};

		/*
		 * Takes a target path and a parameter object and converts it to a properly-encoded URL string. For
		 * example, the input urlPath='something.do', paramObj={param1: 'value 1', param2: 'value 2'} would be
		 * converted to this output: something.do?param1=value%201&param2=value%202.
		 */
		this.createUrlParamString = function(urlPath, paramObj) {
			var that = this;
			var str = urlPath;
			if (paramObj) {
				str += '?';
				var first = true;
				_.forOwn(paramObj, function(val, key) {
					if (first) {
						first = false;
					} else {
						str += "&";
					}
					str += that.createSingleParamString(key, val);
				});
			}
			return str;
		};

	});

	/**
	 * 
	 */
	cvCommon.factory('cvToaster', [ 'growl', function(growl) {
		var toaster = {};

		var showMessage = function(message, msgType, ttl) {
			var fn = null;
			switch (msgType) {
			case 'warn':
				fn = growl.addWarnMessage;
				break;
			case 'error':
				fn = growl.addErrorMessage;
				break;
			case 'info':
				fn = growl.addInfoMessage;
				break;
			case 'success':
			default:
				fn = growl.addSuccessMessage;
			}

			if (ttl && (ttl > 0)) {
				fn(message, {
					ttl : ttl
				});
			} else {
				fn(message);
			}
		};

		toaster.showWarnMessage = function(ops) {
			showMessage(ops.message, 'warn', '3000');
		};

		toaster.showErrorMessage = function(ops) {
			showMessage(ops.message, 'error', ops.ttl);
		};

		toaster.showInfoMessage = function(ops) {
			showMessage(ops.message, 'info', ops.ttl || '3000');
		};

		toaster.showSuccessMessage = function(ops) {
			showMessage(ops.message, 'success', '3000');
		};

		return toaster;
	} ]);

	/**
	 * 
	 */
	cvCommon.factory('cvBreadcrumbsTabsFactory', [ '$rootScope', function($rootScope) {
		var bc = {};

		var bcData = [];
		var tabData = [];

		var bcCallbacks = [];
		var tabCallbacks = [];

		bc.getBreadCrumbs = function() {
			return bcData;
		};

		bc.getTabData = function() {
			return tabData;
		};

		bc.addBreadCrumbs = function(newItem) {
			if (newItem instanceof Array) {
				angular.forEach(newItem, function(item) {
					bcData.push(item);
				});
			} else {
				bcData.push(newItem);
			}

			angular.forEach(bcCallbacks, function(fn) {
				fn(bcData);
			});
		};

		bc.addTabs = function(newItem) {
			if (newItem instanceof Array) {
				angular.forEach(newItem, function(item) {
					tabData.push(item);
				});
			} else {
				tabData.push(newItem);
			}

			angular.forEach(tabCallbacks, function(fn) {
				fn(tabData);
			});
		};

		bc.registerBcDataChangeObserver = function(callback) {
			bcCallbacks.push(callback);
		};

		bc.registerTabDataChangeObserver = function(callback) {
			tabCallbacks.push(callback);
		};

		bc.clearBc = function() {
			bcData = [];
		};

		bc.clearTabs = function() {
			tabData = [];
		};

		$rootScope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, fromParams) {
			bc.clearBc();
			bc.clearTabs();
			angular.forEach(bcCallbacks, function(fn) {
				fn(bcData);
			});
			angular.forEach(tabCallbacks, function(fn) {
				fn(tabData);
			});
		});

		return bc;
	} ]);

	/*
	 * Adding a close button to all modals This is achieved by extending the modalWindow directive part of the
	 * bootstrap modal module
	 */

	var uiBt = angular.module('ui.bootstrap.modal');

	uiBt.config(function($provide, $injector) {
		$provide.decorator('modalWindowDirective', function($delegate, $controller, $injector) {
			var directive = $delegate[0];

			var compile = directive.compile;
			var modal = $injector.get('$modalStack');
			directive.compile = function(tElement, tAttrs) {
				var link = compile.apply(this, arguments);

				return function(scope, elem, attrs) {
					link.apply(this, arguments);
					var closeAnchor = $('<a class="modal__close-btn" href=""></a>');
					elem.find('.modal-content').append(closeAnchor);
					closeAnchor.bind("click", function(e) {
						e.preventDefault();
						modal.dismiss(modal.getTop().key, 'close');
					});
					console.debug('new directive');
				};
			};

			return $delegate;
		});
	});

	cvCommon.filter('capacity', function() {
		var format=function(number, unit){
			if(number.toFixed(2)==Math.floor(number.toFixed(2))) //if its a whole number then remove decimal places
				return Math.floor(number.toFixed(2)) + unit;	//in case of 3.999 .toFixed(2) makes it 4.00 - so important to retain .toFixed
			return number.toFixed(2) + unit;
		};
		return function(x) {
			var value=Number(x);
			if (isNaN(value)) {
				return x;
			}
			if (value <= 1024) {
				return format(value, ' B');
			}
			value = value / 1024;
			if (value.toFixed(2) < 1024) {
				return format(value, ' KB');
			}
			value = value / 1024;
			if (value.toFixed(2) < 1024) {
				return format(value, ' MB');
			}
			value = value / 1024;
			if (value.toFixed(2) < 1024) {
				return format(value, ' GB');
			}
			value = value / 1024;
			if (value.toFixed(2) < 1024) {
				return format(value, ' TB');
			}
			value = value / 1024;
			return format(value, ' PB');
		};
	});

	cvCommon.controller('paginationController', function($scope, $log, serverService, jobService, cvLoc, cvUtil) {
		$scope.pageNext = function() {
			var maxPages = Math.ceil($scope.totalServerItems / $scope.pagingOptions.pageSize);
			var t = parseInt($scope.pagingOptions.currentPage) + 1;
			$scope.pagingOptions.currentPage = Math.min(t, maxPages);
		};
	});

})();