var appUtil = appUtil || {};

appUtil.setupApp = function(app) {
	app.config([ 'cfpLoadingBarProvider', function(cfpLoadingBarProvider) {
		cfpLoadingBarProvider.includeSpinner = false;
	} ]);

	app.config([ '$provide', function($provide) {
		$provide.decorator('$state', [ '$delegate', '$stateParams', function($delegate, $stateParams) {
			$delegate.forceReload = function() {
				return $delegate.go($delegate.current, $stateParams, {
					reload : true,
					inherit : false,
					notify : true
				});
			};
			return $delegate;
		} ]);
	} ]);

	app.run([ '$http', function($http) {
		$http.defaults.headers.common["X-Requested-With"] = 'XMLHttpRequest';
	} ]);

	app
			.config([
					'$httpProvider',
					function($httpProvider) {
						$httpProvider.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=utf-8';

						// Override $http service's default transformRequest
						$httpProvider.defaults.transformRequest = [ function(data) {
							/**
							 * The workhorse; converts an object to x-www-form-urlencoded serialization.
							 * 
							 * @param {Object}
							 *            obj
							 * @return {String}
							 */
							var param = function(obj) {
								var query = '';
								var name, value, fullSubName, subName, subValue, innerObj, i;

								for (name in obj) {
									value = obj[name];

									if (value instanceof Array) {
										for (i = 0; i < value.length; ++i) {
											subValue = value[i];
											fullSubName = name + '[' + i + ']';
											innerObj = {};
											innerObj[fullSubName] = subValue;
											query += param(innerObj) + '&';
										}
									} else if (value instanceof Object) {
										for (subName in value) {
											subValue = value[subName];
											fullSubName = name + '[' + subName + ']';
											innerObj = {};
											innerObj[fullSubName] = subValue;
											query += param(innerObj) + '&';
										}
									} else if (value !== undefined && value !== null) {
										query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
									}
								}

								return query.length ? query.substr(0, query.length - 1) : query;
							};

							return angular.isObject(data) && String(data) !== '[object File]' ? param(data) : data;
						} ];

						$httpProvider.interceptors.push([
								'$q',
								'$location',
								'cvUtil',
								'ajaxButtonFactory',
								function($q, $location, cvUtil, ajaxButtonFactory) {
									var enableAjaxBtn = function() {
										if ((ajaxButtonFactory.currentButton != null)
												&& (ajaxButtonFactory.currentButton != '')) {
											ajaxButtonFactory.currentButton.removeClass('disabled');
											ajaxButtonFactory.currentButton = null;
										}
									};
									return {
										'response' : function(response) {
											enableAjaxBtn();
											return response;
										},
										'responseError' : function(response) {
											enableAjaxBtn();
											if (response.status === 401 || response.status === 400) {
												response.data = {
													status : false,
													description : 'Authentication required!'
												};
												window.location = window.location.origin + "/"
														+ window.location.pathname + "/login";
												return response;
											}
											return $q.reject(response);
										},
										request : function(config) {
											if ((ajaxButtonFactory.currentButton != null)
													&& (ajaxButtonFactory.currentButton != '')) {
												ajaxButtonFactory.currentButton.addClass('disabled');
											}
											var csrfParam = cvUtil.readCookie('csrf');
											config.headers['csrf'] = csrfParam;
											return config;
										}
									};
								} ]);

					} ]);

	app.factory('Constants', function() {
		return {
			ContextPath : '/AdminConsole'
		};
	});

	app.run([ '$rootScope', '$state', function($rootScope, $state) {
		$rootScope.$state = $state;
	} ]);
};
