<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<meta name="description" content="" />
<meta name="author" content="CommVault">
<jsp:include page="../common/jqueryV3.jsp">
	<jsp:param value="true" name="includeLatestJquery" />
</jsp:include>
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/customTheme.do?${applicationScope.BUILD_TS}">
<link rel="shortcut icon" href="${pageContext.request.contextPath}/${applicationScope.OEM_PATH}/favicon.png" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/notificationHistory.css?${applicationScope.BUILD_TS}" />
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/sprites.css?${applicationScope.BUILD_TS}" />
<script nonce="${sessionScope.cspNonce}" src="${pageContext.request.contextPath}/common/thirdPartyV3/bootstrap-4.4.1/js/bootstrap.bundle.min.js?${applicationScope.BUILD_TS}"></script>
<link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/template-bootstrap.css?${applicationScope.BUILD_TS}" />

<title><fmt:message key="common.label.loading" /></title>

<style>
html {
	height: 100%;
}

body {
	background: #0B2E44;
	margin: 0;
	padding: 0;
	overflow: visible;
	height: 100%;
}

.vw-center-container {
	display: table;
	width: 100%;
	height: 100%;
}

.vw-center-container .vw-vertical-center {
	display: table-cell;
	vertical-align: middle;
}

.vw-center-container .vw-horizontal-center {
	margin: 0 auto;
	text-align: center;
	width: auto;
}

body.vw-fullscreen-mode .loading-text .vw-logo-lock-up {
	color: #fff;
	font-family: "Segoe UI", "Open Sans", "Helvetica Neue", Helvetica, Arial,
		sans-serif;
	font-size: 24px;
	font-weight: 600;
	letter-spacing: 0.00547rem;
	margin: 10px 0 0 0;
	text-align: center;
}

#initial-loading-screen {
    width: 100%;
    left: 0;
    top: 0;
    z-index: 10;

}
.loading-spinner {
	color: #fff;
    font-size: 100%;
    border-radius: 100%;
    box-shadow: inset 0 0 0 1em;
    transform: translateZ(0);
    -webkit-transform: translateZ(0);
    margin: 4em auto;
    width: 10em;
    height: 10em;
 }
    .loading-spinner:before, .loading-spinner:after {
    content: "";
    background: #0B2E44;
    width: 5.2em;
    height: 10.2em;
    position: absolute;
    top: -0.1em;
    left: -0.1em;
    animation: rotateBox 1.4s infinite ease;
    -webkit-animation: rotateBox 1.4s infinite ease;
 }
    .loading-spinner:before {
    transform-origin: 5.2em 5.1em;
    -webkit-transform-origin: 5.2em 5.1em;
 }
   .loading-spinner:after {
    left: 5.1em;
    transform-origin: 0 5.1em;
    -webkit-transform-origin: 0 5.1em;
    animation-delay: -1.1s;
    -webkit-animation-delay: -1.1s;
 }
.loading-text {
	color: #fff;
    font-size: 36px;
}
.loader-logout-link {
	color: #fff;
	position: absolute;
    right: 0;
    top: 2%;
	text-decoration: none;
	font-family: "Segoe UI", "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif;
	margin-right: 2em;
	font-weight: normal;
}
.loader-logout-link:hover {
	text-decoration: underline;
}
@keyframes rotateBox {
	100% {
	    transform: rotate(360deg);
	    -webkit-transform: rotate(360deg);
	}
}
@-webkit-keyframes rotateBox {
	100% {
	    transform: rotate(360deg);
	    -webkit-transform: rotate(360deg);
	}
}
@-moz-keyframes rotateBox {
    100% {
    	transform: rotate(360deg);
    	-webkit-transform: rotate(360deg);
  	}
}
@-o-keyframes rotateBox {
    100% {
    	transform: rotate(360deg);
    	-webkit-transform: rotate(360deg);
    }
   }

#lockedSessionModal .lockedLogin {
	width:inherit;
	padding: 4px 14px;
	border-color: transparent;
}
#lockedSessionModal .lockedLogin.loading {
	color:transparent;
}
#lockedSessionModal .modal-body {
	color : #000;
}

#lockedSessionModal #lockedPassword {
	border-color: #ccc;
}
</style>
</head>
<body class="vw-fullscreen-mode vw-body_not-logged-in">
	<div id="loginform" class="vw-login-container vw-center-container">
		<div class="vw-vertical-center">
			<div class="vw-horizontal-center">
				<c:if test="${sessionScope.ACCOUNT_SESSION_LOCKED != true}">
					<div id="initial-loading-screen" >
						<div class="center-loading-screen">
							<div class="loading-spinner"></div>
						    <div class="loading-text">
						    <c:choose>
						    	<c:when test="${requestScope.isStoreRequest}">
						    		<fmt:bundle basename="localization.SoftwareStoreMessages">
						    			<p class="logintitle vw-logo-lock-up"><fmt:message key="store.label.loadingMsg" /></p>
						    		</fmt:bundle>
						    	</c:when>
						    	<c:otherwise>
									<p class="logintitle vw-logo-lock-up"><fmt:message key="common.label.loadingMsg" /></p>
						    	</c:otherwise>
						    </c:choose>
						    </div>
					 	</div>
						<a class="loader-logout-link" href="doLogout.do"><fmt:message key="Logout" /></a>
					</div>
				</c:if>
			</div>
		</div>
	</div>

	<div id="notificationContainer" style="display:none; z-index:9999;">
		<div id="notificationTemplateInfo">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
			    <span class="sprite icon-notif-info" alt="Information" title="Information"></span>
			</div>
			<p><%="#"%>{text}</p>

		</div>
		<div id="notificationTemplateError">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
			    <span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><%="#"%>{text}</p>
		</div>
		<div id="notificationTemplateServerError">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p>${exceptionText}</p>
			<p><span style="font-size: 0.8em;"><%="#"%>{text}</span></p>
		</div>

		<div id="notificationTemplateErrorWithDetails">
			<a class="ui-notify-cross ui-notify-close" href="#">x</a>
			<div style="float:left;margin:0 10px 0 0">
				<span class="sprite icon-notif-error" alt="Error" title="Error"></span>
			</div>
			<p><span style="font-size: 0.8em;"><%="#"%>{text}</span></p>
			<a id="errorMoreLink" href="#" style="font-size: 12px"><%="#"%>{moreLabel}</a>
			<p style="display:none; background-color: #555555; border: 1px solid #666666; border-radius: 8px 8px 8px 8px; max-height: 200px; overflow-y: auto; padding: 5px; word-wrap: break-word; font-size: 12px;"><%="#"%>{exceptionText}</p>
		</div>

		<div class="uploadProgress">
		</div>
	</div>


<!-- Locked session modal -->
<div class="modal fade vw-dialog" id="lockedSessionModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="display:none;" data-backdrop="false" data-keyboard="false" >
  <div class="modal-dialog" role="document" style="width:400px;" >
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title vw-dialog_subheader" id="myModalLabel"><fmt:message key="session_locked_title" /></h4>
      </div>
      <div class="modal-body">
		<fmt:message key="session_locked" /><br><fmt:message key="enter_password" /><br/>
		<input type="password" id="lockedPassword" autocomplete="off" placeholder="Password" name="password" class="textbox form-control" style="margin: 10px 0;">
		<div class="passError" style="display:none;color: #ff1133;"><fmt:message key="msg.incorrect_password" /></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="vw-btn vw-btn-default lockedLogout"><fmt:message key="Logout" />
        </button>
        <button type="button" class="vw-btn vw-btn-primary lockedLogin" data-dismiss="modal"><fmt:message key="unlock_session" /></button>
      </div>
    </div>
  </div>
</div>

</body>
<script nonce="${sessionScope.cspNonce}" >
var isStoreRequest = "${requestScope.isStoreRequest}" === 'true' ? true : false;
	$(document).ready(
			function() {
				if (isStoreRequest) {
					cvUtil.loadPage(cvUtil.getContextPath() + '/softwarestore/loginframe/appstoreLogin.do', {
						autoLogin: true
					}, function(resp) {
						window.parent.location.reload();
					}, function(err) {
						<fmt:bundle basename="localization.SoftwareStoreMessages">
							<cv:localMsg name="store.label.loadingError"><fmt:message key="store.label.loadingError" /></cv:localMsg>
						</fmt:bundle>
						cvUtil.errorToast(localMsg['store.label.loadingError'], 0, true);
					});
				} else {
					cvUtil.loadPageWithGET(cvUtil.getContextPath() + "/getLandingPage.do", null,
							function(data) {
								var resp = data.data;
								//SHOULD NEVER HAPPEN
								if (typeof resp !== 'undefined' && "redirect" in resp) {
									window.location = resp.redirect
										+ window.location.hash; //to support redirection from 9.0 link
								} else {
									window.location = cvUtil.getContextPath() + "/applications"
										+ window.location.hash; //to support redirection from 9.0 link
								}
							}, function() {
								<cv:localMsg name="common.label.loadingError"><fmt:message key="common.label.loadingError" /></cv:localMsg>
								cvUtil.errorToast(localMsg['common.label.loadingError'], 0, true);
							});
				}

			});
</script>
</html>