    <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
    <%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
    <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

    <c:if test="${param.minDisplay != null && param.minDisplay == 'true'}">
        <c:set var="css" value="${pageContext.request.contextPath}/applications/css/apps.css" />
    </c:if>

    <jsp:include page="../common/headerV3.jsp">
	    <jsp:param value="true" name="bootstrapped" />
        <jsp:param value="${css}" name="css"/>
        <jsp:param value="Applications" name="title" />
    </jsp:include>
    <script type="text/javascript" nonce="${sessionScope.cspNonce}" >
        var hash = window.location.hash.toLowerCase();
        if(hash.indexOf("app=laptopbackup")==1){
            window.location.replace("<%=(request.getContextPath())%>/summary");
        }
        if(hash.indexOf("app=vmprovisioning")==1){
            window.location.replace("<%=(request.getContextPath())%>/vmprovisioning");
        }
    </script>
    <div class="row">
        <span class="group vw-page-title vw-page-title_standalone col-sm-12"><fmt:message key="My_Apps_Header" /></span>
        <div class="cvApps col-sm-12">

            <div class="secureGroups">
                <ul class="apps licenseApps vw-apps-list">
                    <cv:secureTag name="My Backup" id="1">
                    <li class="vw-app-block">
                        <a href="../summary/index.do" class="vw-tile clearfix">
                                <span class="sprite app-laptop vw-app-sprite"></span>
                                <label class="showBackups"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="My_Backups" /></span>
                                <p><fmt:message key="My_Backups_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Reports" id="4">
                    	<cv:secureTag name="Survey" id="14">
                        	<c:set var="surveyEnabled" value="true" />
                        </cv:secureTag>

                        <c:if test="${surveyEnabled == 'true' and applicationScope.METRICS_INSTALLED eq 'true'}">
                        	<li class="vw-app-block">
							<c:set var="DashboardLink" value="${pageContext.request.contextPath}/reports/index.jsp?source=appPage"/>
                        	<c:choose>
								<c:when test="${sessionScope.SurveySingleCommcellUser != null}">
									<c:set var="DashboardLink" value="${pageContext.request.contextPath}/reports/index.jsp?commUniId=${sessionScope.SurveySingleCommcellUser}"/>
								</c:when>
								<c:when test="${sessionScope.CvUserDefaultDashboardGroupId != null}">
									<c:set var="DashboardLink" value="${pageContext.request.contextPath}/survey/reports/dashboard.jsp?companyId=${sessionScope.CvUserDefaultDashboardGroupId}"/>
								</c:when>
								<c:when test="${sessionScope.SurveySingleCompanyUser != null}">
									<c:set var="DashboardLink" value="${pageContext.request.contextPath}/survey/reports/dashboard.jsp?companyId=${sessionScope.SurveySingleCompanyUser}"/>
								</c:when>
							</c:choose>
	                        <a class="vw-tile clearfix" href="${DashboardLink}">
	                            <span class="sprite app-dashboard vw-app-sprite"></span>
	                            <label class="showReports"></label>
	                            <div class="displayText vw-app-text">
	                                <span><fmt:message key="CommCells_Dashboard" /></span>
	                                <p><fmt:message key="CommCells_Dashboard_Text" /></p>
	                         	</div>
	                            <div class="vw-message-privileges">
	                                <p><fmt:message key="Application_Privileges_Message" /></p>
	                            </div>
	                        </a>
		                    </li>
                        </c:if>
	                    <li class="vw-app-block">
	                    	<c:set var="ReportsLink" value="${pageContext.request.contextPath}/reports/index.jsp?page=Reports&source=appPage"/>
	                    	<c:set var="metricsInstalled" value="${applicationScope.METRICS_INSTALLED}" />
	                    	<c:choose>
	                        	<c:when test="${sessionScope.SurveySingleCommcellUser != null and metricsInstalled eq 'true'}">
	                        		<c:set var="ReportsLink" value="${pageContext.request.contextPath}/survey/reports/commcellmonitoring.jsp?commUniId=${sessionScope.SurveySingleCommcellUser}"/>
	                        	</c:when>
	                        	<c:when test="${sessionScope.CvUserDefaultDashboardGroupId != null}">
									<c:set var="ReportsLink" value="${pageContext.request.contextPath}/survey/reports/commcellmonitoring.jsp?companyId=${sessionScope.CvUserDefaultDashboardGroupId}"/>
								</c:when>
							</c:choose>
	                    	<a class="vw-tile clearfix" href="${ReportsLink}">
	                            <span class="sprite app-reports-new vw-app-sprite"></span>
	                            <label class="showReports"></label>
	                            <div class="displayText vw-app-text">
	                                <span><fmt:message key="Reports" /></span>
	                                <p><fmt:message key="Reports_Text" /></p>
	                         	</div>
	                            <div class="vw-message-privileges">
	                                <p><fmt:message key="Application_Privileges_Message" /></p>
	                            </div>
	                        </a>
	                    </li>
	                    <c:if test="${applicationScope.showMicrosoftReports eq 'true'}">
		                    <li class="vw-app-block">
		                        <a class="vw-tile clearfix" href="../reports/index.jsp?page=Reports#0">
		                            <!-- <span class="sprite app-report vw-app-sprite"></span> -->
		                            <span class="sprite app-ms-reports vw-app-sprite"></span>
		                            <label class="showReports"></label>
		                            <div class="displayText vw-app-text">
		                                <span><fmt:message key="MS_Reports" /></span>
		                                <p><fmt:message key="MS_Reports_Text" /></p>
		                            </div>
		                            <div class="vw-message-privileges">
		                                <p><fmt:message key="Application_Privileges_Message" /></p>
		                            </div>
		                        </a>
		                    </li>
	                        </c:if>
                        </cv:secureTag>
                        <%-- <li>
                            <span class="sprite app-dashboard vw-app-sprite"></span>
                            <cv:secureTag name="Reports" id="4">
                                <cv:reportsTag name="CustomReports" id="8">
                                    <label class="showReports"></label>
                                </cv:reportsTag>
                            </cv:secureTag>
                            <div class="displayText vw-app-text">
                                <a href="../customreports/dashboard.jsp"><fmt:message key="Dashboard" /></a>
                                <p><fmt:message key="DashboardText" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </div>
                    </li> --%>

                    <cv:secureTag name="Download Center" id="2">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix"<c:choose><c:when test="${sessionScope.useNewDownloadCenter eq 'false'}"> href="../download/downloadcenter.do"</c:when><c:otherwise> href="../downloadcenter/dc.do"</c:otherwise></c:choose>>
                            <span class="sprite app-download vw-app-sprite"></span>
                            <label class="showDownloads"></label>
                            <div class="displayText vw-app-text">
                        		<span><fmt:message key="Download_Center" /></span>
                        		<p><fmt:message key="Download_Center_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

        <!--        <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="#">
                            <span class="sprite app-software vw-app-sprite"></span>
                            <cv:secureTag name="Software Deployment" id="5">
                                <label class="showDeployment"></label>
                            </cv:secureTag>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Software_Deployment" /></span>
                                <p><fmt:message key="Software_Deployment_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
         -->
                    <cv:secureTag name="Commcell Console" id="9">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../samlWcToGuiSso.do">
                            <span class="sprite app-commcell vw-app-sprite"></span>

                                <label class="showCommcellConsole"></label>

                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Commcell_Console_GUI" /></span>
                                <p><fmt:message key="Commcell_Console_GUI_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="Compliance Search" id="7">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="${sessionScope.ComplianceSearchURL}"  target="_blank">
                            <span class="sprite app-compliance vw-app-sprite"></span>
                            <label class="showCompliance"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Compliance_Search" /></span>
                                <p><fmt:message key="Compliance_Search_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="Documentation" id="8">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="${applicationScope.DOCUMENTATION_LINK}" target="_blank">
                            <span class="sprite app-documentation vw-app-sprite"></span>
							<label class="showDocumentation"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Documentation" /></span>
                                <p><fmt:message key="Documentation_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Cloud Apps" id="10">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="cloudApps.jsp">
                            <span class="sprite app-cloud vw-app-sprite"></span>
                            <label class="showCloudApps"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Cloud_Apps_Header" /></span>
                                <p><fmt:message key="Cloud_Apps_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>
            <!--    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../workflows">
                            <label class="showWorkflow"></label>
                            <img src="img/cloud.png" alt="workflow" />
                            <span><fmt:message key="Workflow_Header" /></span>
                            <p><fmt:message key="Workflow_Text" /></p>
                        </a>
                    </li>
                    -->

                    <cv:secureTag name="VM Management" id="3">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../vmprovisioning">
                            <span class="sprite app-vm vw-app-sprite"></span>

                                <label class="showVirtualMachines"></label>

                            <div class="displayText vw-app-text">
                                <span><fmt:message key="VM_Management" /></span>
                                <p><fmt:message key="VM_Management_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Virtual Machine Labs" id="38">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../vmlabs">
                            <span class="sprite app-vm vw-app-sprite"></span>

                                <label class="showVirtualMachines"></label>

                            <div class="displayText vw-app-text">
                                <span><fmt:message key="vmlabs" /></span>
                                <p><fmt:message key="VM_Lab_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>
            <%--    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../clientregistration">
                            <span class="sprite app-clientregistration vw-app-sprite"></span>
                        <cv:secureTag name="Client Registration" id="12">
                            <label class="showClientRegistrationApps"></label>
                        </cv:secureTag>
                        <div class="displayText vw-app-text">
                            <span><fmt:message key="Client_Registration_Header" /></span>
                            <p><fmt:message key="Client_Registration_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li> --%>
                    <cv:secureTag name="For Administrators" id="12">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../foradministrators">
                            <span class="sprite app-administrator vw-app-sprite"></span>
                            <label class="showAdministratorApps"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="For_Administrators_Header" /></span>
                                <p><fmt:message key="For_Administrators_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Events Organizer" id="18">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../cvevents">
                            <span class="sprite app-events vw-app-sprite"></span>
                            <label class="showCvEvents"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="CvEvents_Header" /></span>
                                <p><fmt:message key="CvEvents_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Workflow" id="20">
                    <li class="workflow_app vw-app-block">
                        <a class="vw-tile clearfix" href="../forms">
                            <span class="sprite app-workflow-blue vw-app-sprite"></span>
                            <label class="showWorkflowApps"></label>
                            <div class="displayText vw-app-text">
                                <fmt:bundle basename="localization.formsMessages">
                                    <span><fmt:message key="Workflow" /></span>
                                    <p><fmt:message key="Workflow_Text" /></p>
                                </fmt:bundle>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Monitoring" id="19">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../monitoring">
                            <span class="sprite app-log-monitoring vw-app-sprite"></span>
                            <label class="showLMApps"></label>
                            <div class="displayText vw-app-text">
                                <fmt:bundle basename="localization.logMonitoringMessages">
                                <span><fmt:message key="Monitoring_Header" /></span>
                                <p><fmt:message key="Monitoring_Text" /></p>
                                </fmt:bundle>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>
                    <c:if test="${applicationScope.bEnableTroubleShooting eq 'true'}">
                     <cv:secureTag name="Reports" id="4">
                    	<cv:secureTag name="Survey" id="14">
                        	<li class="vw-app-block">
							<c:set var="troubleShootingLink" value="${pageContext.request.contextPath}/survey/reports/gatherlogsinfo.jsp"/>
	                        <a class="vw-tile clearfix" href="${troubleShootingLink}">
	                            <span class="sprite app-troubleshooting vw-app-sprite"></span>
	                            <label class="showReports"></label>
	                            <div class="displayText vw-app-text">
	                                <span><fmt:message key="Troubleshooting"/></span>
	                                <p><fmt:message key="TroubleshootingText" /></p>
	                         	</div>
	                        </a>
		                    </li>
		               </cv:secureTag>
                     </cv:secureTag>
                     </c:if>

                    <cv:secureTag name="" id="22">
                    <li class="cloudConnector_app vw-app-block">
                        <a class="vw-tile clearfix" href="../cloudConnector">
                           <label class="showCloudConnectorApp"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="CloudConnector" /></span>
                                <p><fmt:message key="CloudConnector_Text" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="DataBase Management" id="23">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="/adminconsole/#/instances">
                            <span class="sprite app-storage vw-app-sprite"></span>
                                <label class="showDatabaseClients"></label>

                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Databases" /></span>
                                <p><fmt:message key="Database_text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="Mobile Device Management" id="27">
                    <li class="mdm_app vw-app-block">
                        <a class="vw-tile clearfix" href="../mdm">
                            <label class="showAdministratorApps"></label>
                            <div class="displayText vw-app-text">
                                <fmt:bundle basename="localization.mdmMessages">
                                    <span><fmt:message key="MDM_Application_Name" /></span>
                                    <p><fmt:message key="MDM_Application_Description" /></p>
                                </fmt:bundle>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Data Monitoring" id="28">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../dataMonitoring">
                            <span class="sprite app-datamonitoring vw-app-sprite"></span>
                            <label class="ShowDataMonitoring"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="DataMonitoring_Header" /></span>
                                <p><fmt:message key="DataMonitoring_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Storage Replication" id="32">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../storagereplication">
                            <span class="sprite app-client-registration vw-app-sprite"></span>
                            <label class="showStorageReplications"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Storage_Replication" /></span>
                                <p><fmt:message key="StorageReplication_text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Analytics" id="33">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../dcube.do">
                            <span class="sprite app-analytics vw-app-sprite"></span>
                            <label class="showAnalytics"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Analytics_Header" /></span>
                                <p><fmt:message key="Analytics_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Storage Management" id="31">

	                    <c:if test="${applicationScope.bShowStorageProvisioning eq 'true'}">
		                    <li class="storageprovisioning_app vw-app-block">
		                        <a class="vw-tile clearfix" href="../storageprovisioning/validateUserFeatures.do">
		                            <span class="sprite app-storageprovisioning vw-app-sprite"></span>
		                            <label class="showStorageProvApps"></label>
		                            <div class="displayText vw-app-text">
		                                <fmt:bundle basename="localization.StorageProvisioningMessages">
		                                    <span><fmt:message key="Storage_Provisioning_Head" /></span>
		                                    <p><fmt:message key="Storage_Provisioning_Description" /></p>
		                                </fmt:bundle>
		                            </div>
		                        </a>
		                    </li>
						</c:if>
                    </cv:secureTag>

                    <cv:secureTag name="TimeSheets" id="52">
                    <li class="storageprovisioning_app vw-app-block">
                        <a class="vw-tile clearfix" href="../timesheets">
                         	<span class="sprite app-timesheet vw-app-sprite"></span>
                            <label class="showStorageProvApps"></label>
                            <div class="displayText vw-app-text">
                              	 <span><fmt:message key="TimeSheet_Header" /></span>
                                <p><fmt:message key="TimeSheet_Text" /></p>
                            </div>
                        </a>
                    </li>
                  </cv:secureTag>

                 <cv:secureTag name="Time Off" id="40">
                    <li class="vw-app-block">
                        <a class="vw-tile clearfix" href="../timeoff">
                            <span class="sprite app-timeoff vw-app-sprite"></span>
                            <label class="showStorageProvApps"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="TimeOff_Header" /></span>
                                <p><fmt:message key="TimeOff_Text" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Records Management" id="35">
                    <li class="recordmanager_app vw-app-block">
                        <a class="vw-tile clearfix" href="../records/records.do">
                            <span class='sprite app-recordmanager vw-app-sprite'></span>
                            <label class="showRecordsManagement"></label>
                            <div class="displayText vw-app-text">
                                <fmt:bundle basename="localization.recordsMessages">
                                    <span><fmt:message key="Records_Management_Head" /></span>
                                    <p><fmt:message key="Records_Management_Description" /></p>
                                </fmt:bundle>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

                    <cv:secureTag name="Webconsole SSO" id="39">
                    <li class="webSSO_app vw-app-block">
                        <a class="vw-tile clearfix" href="../webconsoleSSO">
                            <label class="showWebSsoApp"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Webconsole_SSO" /></span>
                                <p><fmt:message key="WebconsoleSSO_Text" /></p>
                            </div>
                        </a>
                    </li>
                    </cv:secureTag>

<%--                <cv:cmTag name="Contract Management" id="48"> --%>
<!--                <li class="contractManagement_app vw-app-block"> -->
<!--                    <a class="vw-tile clearfix" href="../cloud/contract/contractManagement.jsp">
<!--                        <span class="sprite app-contract-management vw-app-sprite"></span> -->
<!--                        <label></label> -->
<!--                        <div class="displayText vw-app-text">    -->
<%--                            <span><fmt:message key="CM.app.name"/></span> --%>
<%--                            <p><fmt:message key="CM.app.desc"/></p>     --%>
<!--                        </div> -->
<!--                    </a>
                    </li> -->
<%--                </cv:cmTag> --%>

					<c:if test="${sessionScope.commcellConsoleAppSetAlreadyInValidApps eq 'false'  && (sessionScope.showGuiConsoleForSSO eq 'true' || applicationScope.showGuiConsoleForSSO eq 'true')}">
						<li class="webSSO_app vw-app-block">
							<a href="../samlWcToGuiSso.do" class="vw-tile clearfix">
                                <span class="sprite app-commcell vw-app-sprite"></span>
                                <label class="showWebSsoApp"></label>
	                            <div class="displayText vw-app-text">
	                                <span><fmt:message key="Commcell_Console_GUI" /></span>
	                                <p><fmt:message key="label.login.sso.saml.webconsoleToGUISSO" /></p>
	                            </div>
	                        </a>
	                    </li>
                    </c:if>
                    <cv:secureTag name="App Builder" id="53">
						<li class="app-builder_app vw-app-block">
							<a id="app-builder-link-target" href="../appbuilder/" class="vw-tile clearfix">
									<span class="sprite app-appbuilder vw-app-sprite"></span>
									<label class="app-builder"></label>
								<div class="displayText vw-app-text">
									<fmt:bundle basename="localization.AppBuilderMessages">
										<span><fmt:message key="AppBuilder" /></span>
										<p><fmt:message key="AppBuilder_Hint_Text" /></p>
									</fmt:bundle>
								</div>
							</a>
						</li>
					</cv:secureTag>
					<c:set var="softwareStoreClassList" value="software-store_app vw-app-block" />
					<c:if test="${applicationScope.SWStoreIsCVStore ne true}">
						<c:set var="softwareStoreClassList" value="software-store_app vw-start-hidden vw-app-block"></c:set>
					</c:if>
					<c:if test="${empty cvConfig.getWebconsoleRequestWhiteList()}">
						<cv:blockApplicationsTag alias="software-store">
							<li class="${softwareStoreClassList}">
								<a id="store-link-target" href="../softwarestore/store.do" class="vw-tile clearfix">
										<span class="sprite app-store_app app-software-store vw-app-sprite"></span>
										<label class="software-store"></label>
									<div class="displayText vw-app-text">
										<span><fmt:message key="Software_Store_App" /></span>
										<p><fmt:message key="Software_Store_App_Text" /></p>
									</div>
								</a>
							</li>
						</cv:blockApplicationsTag>
					</c:if>


					<li class="adminconsole_app vw-app-block vw-start-hidden">
						<a href="/adminconsole/wcSSO.do" target="_blank" class="vw-tile clearfix">
                                <span class="sprite app-adminconsole_app vw-app-sprite"></span>
                                <label class="adminconsole"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="AdminConsole_Title" /></span>
                                <p><fmt:message key="adminConsoleApp_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    <cv:secureTag name="CvLegal App" id="50">
		                    <li class="cvlegal_app vw-app-block">
		                        <a class="vw-tile clearfix" href="../browse/MyDrive.do?shareFolderId=${applicationScope.CvLegalAppShareId}&n=rec">
		                            <span class="sprite app-contract-management vw-app-sprite"></span>
		                            <label class="showRecordsManagement"></label>
		                            <div class="displayText vw-app-text">
		                                <fmt:bundle basename="localization.recordsMessages">
		                                    <span><fmt:message key="CvLegal_Head" /></span>
		                                    <p><fmt:message key="CvLegal_Description" /></p>
		                                </fmt:bundle>
		                            </div>
		                            <div class="vw-message-privileges">
		                                <p><fmt:message key="Application_Privileges_Message" /></p>
		                            </div>
		                        </a>
		                    </li>
                    </cv:secureTag>

             		<c:if test="${applicationScope.sEnableEdgeFaceDetection eq true}">
                    <li class="photos_app vw-app-block">
                        <a class="vw-tile clearfix" href="../myPhotos.do">
                            <span class="sprite app-photos vw-app-sprite"></span>
                            <label class="showAnalytics"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="My_Photos" /></span>
                                <p><fmt:message key="Photos_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </c:if>
                    <c:if test="${applicationScope.enableVideoSearch eq 'true'}">
                    <li class="videosearch_app vw-app-block">
                        <a class="vw-tile clearfix" href="../videosearch.do">
                            <span class="sprite app-videosearch vw-app-sprite"></span>
                            <label class="showAnalytics"></label>
                            <div class="displayText vw-app-text">
                                <span><fmt:message key="Video_Search_Header" /></span>
                                <p><fmt:message key="Video_Search_Text" /></p>
                            </div>
                            <div class="vw-message-privileges">
                                <p><fmt:message key="Application_Privileges_Message" /></p>
                            </div>
                        </a>
                    </li>
                    </c:if>

                    <!-- This is an empty list item added at the end. -->
                    <!-- Because the ul use flex box and justify-content is set to space-between, if there're only 2 apps they space out and fill the row leaving the middle column empty -->
                    <!-- The empty app block below (visibility hidden) will make sure that it takes up the 3rd column in case there're only 2 apps -->
                    <li class="vw-app-block vw-invisible">
                       &nbsp;
                   </li>

                </ul>
            </div>
            <div id="noapps" class="hidden col-sm-12">
                <div class="vw-tile clearfix"><fmt:message key="No_Applications_Text" /></div>
            </div>
            <div class="clrfloat"></div>
            </div>
    </div>

<script nonce="${sessionScope.cspNonce}" >
/* Primarily IE9 & IE10 - for resizing the application blocks so when the window is resized, any height change won't affect the wrapping flow of the elements */
(function($, window, document, undefined) {
    'use strict';

    var s = document.body || document.documentElement, s = s.style;
    if (s.webkitFlexWrap == '' || s.msFlexWrap == '' || s.flexWrap == '') return true;

    var $list       = $('.vw-apps-list'),
        $items      = $list.find('.vw-app-block'),
        setHeights  = function() {
            $items.css({'height': 'auto', 'float': 'left'}).filter(":even").css({'margin-right': '30px'});
			$list.css('clear','both');

            var perRow = Math.floor($list.width() / $items.width());
            if (perRow == null || perRow < 2) return true;

            for (var i = 0, j = $items.length; i < j; i += perRow) {
                var maxHeight   = 0,
                    $row        = $items.slice( i, i + perRow );

                $row.each(function() {
                    var itemHeight = parseInt($( this ).outerHeight());
                    if (itemHeight > maxHeight) maxHeight = itemHeight;
                });
                $row.css('height', maxHeight);
            }
        };

    setHeights();
    $(window).on('resize', setHeights);

})(jQuery, window, document);
</script>

       <jsp:include page="../common/footerV3.jsp">
            <jsp:param value="true" name="bootstrapped" />
            <jsp:param value="${pageContext.request.contextPath}/applications/js/applications.js" name="js"/>
       </jsp:include>
