    <%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
    <%@  taglib uri="../WEB-INF/cvtaglib.tld" prefix="cv" %>
    <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

    <c:set var="css" value="css/applicationstyles.css" />
    <c:if test="${param.minDisplay != null && param.minDisplay == 'true'}">
        <c:set var="css" value="css/apps.css" />
    </c:if>

    <jsp:include page="../common/headerV3.jsp">
        <jsp:param value="${css}" name="css"/>
        <jsp:param value="Applications" name="title" />
    </jsp:include>
    <script type="text/javascript" nonce="${sessionScope.cspNonce}" >
        var hash = window.location.hash.toLowerCase();
        if(hash.indexOf("app=laptopbackup")==1){
            window.location.replace("<%=(request.getContextPath())%>/summary");
        }
        if(hash.indexOf("app=vmprovisioning")==1){
            window.location.replace("<%=(request.getContextPath())%>/vmprovisioning");
        }
    </script>
        <h2 class="group"><fmt:message key="My_Apps_Header" /></h2>
        <div class="cvApps">

            <div class="secureGroups">
                <ul class="apps licenseApps">
                    <cv:secureTag name="My Backup" id="1">
                    <li>
                        <span class="sprite app-laptop"></span>
                        <label class="showBackups"></label>
		    			
                        <div class="displayText">
                            <a href="../summary/index.do"><fmt:message key="My_Backups" /></a>
                            <p><fmt:message key="My_Backups_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>
		    		
                    <cv:secureTag name="Reports" id="4">
                    <li>
                        <span class="sprite app-report"></span>
                        <label class="showReports"></label>
		    			
                        <div class="displayText">
                        <cv:secureTag name="Survey" id="14">
                            <c:set var="surveyEnabled" value="true" />
                        </cv:secureTag>
                        <c:choose>
                        <c:when test="${surveyEnabled == 'true'}">
                            <a href="../survey/reports/dashboard.jsp"><fmt:message key="Reports" /></a>
                            <p><fmt:message key="Reports_Text" /></p>
                        </c:when>
                        <c:otherwise>
                            <a href="../reports"><fmt:message key="Reports" /></a>
                            <p><fmt:message key="Reports_Text" /></p>
                            </c:otherwise> 
                        </c:choose> 
				    		
				    		
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    <c:if test="${applicationScope.showMicrosoftReports eq 'true'}"> 
	                     <li>
	                        <!-- <span class="sprite app-report"></span> -->
	                        <span class="ms-reports"></span>
	                        <label class="showReports"></label>
	                        <div class="displayText">
	                            <a href="../reports/msbackupstats.jsp"><fmt:message key="MS_Reports" /></a>
	                            <p><fmt:message key="MS_Reports_Text" /></p>
	                        </div>
	                        <div class="tooltip" style="display:none">
	                            <p><fmt:message key="Application_Privileges_Message" /></p>
	                        </div>
	                    </li>
                    </c:if>
                    </cv:secureTag>
                    <%-- <li>
                        <span class="sprite app-dashboard"></span>
                        <cv:secureTag name="Reports" id="4">
                            <cv:reportsTag name="CustomReports" id="8"> 
                                <label class="showReports"></label>
                            </cv:reportsTag>
                        </cv:secureTag>
                        <div class="displayText">
                            <a href="../customreports/dashboard.jsp"><fmt:message key="Dashboard" /></a>
                            <p><fmt:message key="DashboardText" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li> --%>

                    <cv:secureTag name="Download Center" id="2">
                    <li>
                        <span class="sprite app-download"></span>
                            <label class="showDownloads"></label>
                            <div class="displayText">
                    <c:choose>
                        <c:when test="${sessionScope.useNewDownloadCenter eq 'false'}"> 
                        <a href="../download/downloadcenter.do"><fmt:message key="Download_Center" /></a>
                        </c:when>
                    <c:otherwise>
                         <a href="../downloadcenter/dc.do"><fmt:message key="Download_Center" /></a>
                    </c:otherwise>
                    </c:choose>
                    <p><fmt:message key="Download_Center_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>

            <!--        <li>
                <span class="sprite app-software"></span>
                        <cv:secureTag name="Software Deployment" id="5">
                            <label class="showDeployment"></label>
                        </cv:secureTag>
                        <div class="displayText">
                            <a href="#"><fmt:message key="Software_Deployment" /></a>
                            <p><fmt:message key="Software_Deployment_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
         -->
                    <cv:secureTag name="Commcell Console" id="9">
                    <li>
                        <span class="sprite app-commcell"></span>
                        
                            <label class="showCommcellConsole"></label>
                    
                        <div class="displayText">
                            <a href="${applicationScope.CommcellConsoleUrl}" target="_blank"><fmt:message key="Commcell_Console_GUI" /></a>
                            <p><fmt:message key="Commcell_Console_GUI_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="Compliance Search" id="7">
                    <li>
                        <span class="sprite app-compliance"></span>
                            <label class="showCompliance"></label>
                        <div class="displayText">
                            <a href="${sessionScope.ComplianceSearchURL}"  target="_blank"><fmt:message key="Compliance_Search" /></a>
                            <p><fmt:message key="Compliance_Search_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="Documentation" id="8">
                    <li>
                        <span class="sprite app-documentation"></span>
                            <label class="showDocumentation"></label>
                        <div class="displayText">
                            <a href="${applicationScope.DOCUMENTATION_LINK}" target="_blank"><fmt:message key="Documentation" /></a>
                            <p><fmt:message key="Documentation_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>
			    	<!-- 	<li class="cloud_app">			    		
                    <cv:secureTag name="Cloud Apps" id="10">
                    <li>
                        <span class="sprite app-cloud"></span>
                            <label class="showCloudApps"></label>
		    			</cv:secureTag>
                        <div class="displayText">

                        <a href="cloudApps.jsp"><fmt:message key="Cloud_Apps_Header" /> </a>
                        <p><fmt:message key="Cloud_Apps_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
			    		 -->
		    	<!-- 	<li>
		    			<label class="showWorkflow"></label>
			    		<img src="img/cloud.png" alt="workflow" />
			    		<a href="../workflows"><fmt:message key="Workflow_Header" />	</a>
			    		<p><fmt:message key="Workflow_Text" /></p>
		    		</li>
		    		 -->

                    <cv:secureTag name="VM Management" id="3">
                    <li>
                        <span class="sprite app-vm"></span>
                        
                            <label class="showVirtualMachines"></label>
                    
                        <div class="displayText">
                            <a href="../vmprovisioning"><fmt:message key="VM_Management" /></a>
                            <p><fmt:message key="VM_Management_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>
                    <%-- <li>
                        <span class="sprite app-clientregistration"></span>
                    <cv:secureTag name="Client Registration" id="12">
                        <label class="showClientRegistrationApps"></label>
                    </cv:secureTag>
                    <div class="displayText">
                        <a href="../clientregistration"><fmt:message key="Client_Registration_Header" />    </a>
                        <p><fmt:message key="Client_Registration_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li> --%>
                    <cv:secureTag name="For Administrators" id="12">
                    <li>
                        <span class="sprite app-administrator"></span>
                              <label class="showAdministratorApps"></label>
                          <div class="displayText">
                              <a href="../foradministrators"><fmt:message key="For_Administrators_Header" />    </a>
                              <p><fmt:message key="For_Administrators_Text" /></p>
                          </div>
                          <div class="tooltip" style="display:none">
                              <p><fmt:message key="Application_Privileges_Message" /></p>
                          </div>
                      </li>
                      </cv:secureTag>
                      <cv:secureTag name="Events Organizer" id="18">
                        <li>
                            <span class="sprite app-event"></span>
                          <label class="showCvEvents"></label>
						
                        <div class="displayText">
                            <a href="../cvevents"><fmt:message key="CvEvents_Header" /></a>
                            <p><fmt:message key="CvEvents_Text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>                       
                    </cv:secureTag>
					<cv:secureTag name="Workflow" id="20">			    		
					<li class="workflow_app">                             
                              
                                    <label class="showWorkflowApps"></label>
                              
                              <div class="displayText">
    	                            <fmt:bundle basename="localization.formsMessages">
                                    <a href="../forms"><fmt:message key="Workflow" /> </a>
                                    <p><fmt:message key="Workflow_Text" /></p>      
									</p>
									</fmt:bundle>
							</div>
                     </li>      
					</cv:secureTag>
                    <cv:secureTag name="logMonitoring" id="19">
                    <li>
                        <span class="sprite app-log-monitoring"></span>
                          <label class="showLMApps"></label>
                         
                         <div class="displayText">   
                                <fmt:bundle basename="localization.logMonitoringMessages">
                                <a href="../logMonitoring.do"><fmt:message key="LM_Header" />   </a>
                                <p>
                                <fmt:message key="LM_Text" />
                                </p>    
                                </fmt:bundle>
                            </div>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="Workflow" id="20">
                    <li>               
                        <span class="sprite app-workflow-blue"></span>
                             <div class="activeActionsCount"></div>                  
                                    <label class="showWorkflowApps"></label>
                    
                                    <label class="showCloudConnectorApp"></label>
                              
                              <div class="displayText">
				    						<a href="../cloudConnector"><fmt:message key="CloudConnector" />	</a>
				    						<p><fmt:message key="CloudConnector_Text" /></p>	
				    		  </div>
			       	</li>  					
			       	</cv:secureTag>
			       	<cv:secureTag name="webAnalytics" id="24">
			       	<li class="webAnalytics_app">						
							  <label class="showWebAnalytics"></label>						  
						  <div class="displayText" >
							  <a href="../webanalytics"><fmt:message key="WebAnalytics_Header" /></a>
							  <p><fmt:message key="WebAnalytics_Text" /></p>
                            </div>
                    </li>
                    </cv:secureTag>
                    <cv:secureTag name="DataBase Management" id="23">   
                    <li>
                        <span class="sprite app-storage"></span>
                            <label class="showDatabaseClients"></label>
                        
                        <div class="displayText">
                            <a href="../database"><fmt:message key="Databases" /></a>
                            <p><fmt:message key="Database_text" /></p>
                        </div>
                        <div class="tooltip" style="display:none">
                            <p><fmt:message key="Application_Privileges_Message" /></p>
                        </div>
                    </li>
                    </cv:secureTag>
                   <cv:secureTag name="Storage Replication" id="25">
	                    <li>
	                    <span class="sprite replication_app"></span>
		    				<label class="showStorageReplications"></label>
		    			
			    		<div class="displayText">
				    		<a href="../storagereplication"><fmt:message key="Storage_Replication" /></a>
				    		<p><fmt:message key="StorageReplication_text" /></p>
				    	</div>
			    		<div class="tooltip" style="display:none">
						    <p><fmt:message key="Application_Privileges_Message" /></p>
						</div>
		    			</li>
	    			</cv:secureTag>
					<cv:secureTag name="Mobile Device Management" id="27">
			    		<li class="mdm_app">
							<label class="showAdministratorApps"></label>
							<div class="displayText">
							    <fmt:bundle basename="localization.mdmMessages">
								    <a href="../mdm"><fmt:message key="MDM_Application_Name" />    </a>
									<p><fmt:message key="MDM_Application_Description" /></p>
								  </fmt:bundle>
							</div>
						</li>
				    </cv:secureTag>
					<cv:secureTag name="Data Monitoring" id="28">
                        <li>
                            <span class="sprite app-datamonitoring"></span>
						  <label class="ShowDataMonitoring"></label>
						
		    			<div class="displayText">
		    								    	<a href="../dataMonitoring"><fmt:message key="DataMonitoring_Header" /></a>
					    	<p><fmt:message key="DataMonitoring_Text" /></p>
					    </div>
				    	<div class="tooltip" style="display:none">
						    <p><fmt:message key="Application_Privileges_Message" /></p>
						</div>
			    	</li>	
					</cv:secureTag>
                </ul>
            </div>
            <div id="noapps" style="display:none"><fmt:message key="No_Applications_Text" /></div>
            <div class="clrfloat"></div>
            </div>


       <jsp:include page="../common/footerV3.jsp">
            <jsp:param value="js/applications.js" name="js"/>
       </jsp:include>
